/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhg;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgd
public final class zzgg {
    private static final SimpleDateFormat zzDJ = new SimpleDateFormat("yyyyMMdd");

    public static JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, zzgk zzgk2, Location location, zzbr zzbr2, String string2, String string3, List<String> list) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzCl != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzCl);
            }
            zzgg.zza(hashMap, adRequestInfoParcel.zzCm);
            hashMap.put("format", adRequestInfoParcel.zzpN.zzsm);
            if (adRequestInfoParcel.zzpN.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzpN.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzpN.zzso != null) {
                charSequence = new StringBuilder();
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzpN.zzso) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzgk2.zzCy) : adSizeParcel.width);
                    charSequence.append("x");
                    charSequence.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzgk2.zzCy) : adSizeParcel.height);
                }
                hashMap.put("sz", charSequence);
            }
            if (adRequestInfoParcel.zzCs != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzCs);
                hashMap.put("native_templates", adRequestInfoParcel.zzqd);
                hashMap.put("native_image_orientation", zzgg.zzc(adRequestInfoParcel.zzqb));
                if (!adRequestInfoParcel.zzCG.isEmpty()) {
                    hashMap.put("native_custom_templates", adRequestInfoParcel.zzCG);
                }
            }
            hashMap.put("slotname", adRequestInfoParcel.zzpG);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzCn != null) {
                hashMap.put("vc", adRequestInfoParcel.zzCn.versionCode);
            }
            hashMap.put("ms", string3);
            hashMap.put("seq_num", adRequestInfoParcel.zzCp);
            hashMap.put("session_id", adRequestInfoParcel.zzCq);
            hashMap.put("js", adRequestInfoParcel.zzpJ.zzGG);
            zzgg.zza(hashMap, zzgk2);
            hashMap.put("fdz", new Integer(zzbr2.zzcX()));
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (adRequestInfoParcel.zzCm.versionCode >= 2 && adRequestInfoParcel.zzCm.zzsf != null) {
                zzgg.zza(hashMap, adRequestInfoParcel.zzCm.zzsf);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzCr);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzCu) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzCu);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzCt != null) {
                hashMap.put("content_info", adRequestInfoParcel.zzCt);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzCy));
                hashMap.put("sh", adRequestInfoParcel.zzCx);
                hashMap.put("sw", adRequestInfoParcel.zzCw);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzgk2.zzCy));
                hashMap.put("sh", zzgk2.zzCx);
                hashMap.put("sw", zzgk2.zzCw);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzCz)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzCz));
                    }
                    catch (JSONException jSONException) {
                        zzb.zzd("Problem serializing view hierarchy to JSON", jSONException);
                    }
                }
                if (zzbz.zzun.get().booleanValue() && adRequestInfoParcel.zzCA) {
                    hashMap.put("ga_hid", adRequestInfoParcel.zzCB);
                    hashMap.put("ga_cid", adRequestInfoParcel.zzCC);
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzCD);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzCE);
            }
            zzgg.zza(hashMap, string2);
            if (zzb.zzL(2)) {
                charSequence = zzo.zzbv().zzy(hashMap).toString(2);
                zzb.zzaB("Ad Request JSON: " + (String)charSequence);
            }
            return zzo.zzbv().zzy(hashMap);
        }
        catch (JSONException jSONException) {
            zzb.zzaC("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        if (string2 != null) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("token", string2);
            hashMap.put("pan", hashMap2);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzhg.zzgh();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzrX != -1L) {
            hashMap.put("cust_age", zzDJ.format(new Date(adRequestParcel.zzrX)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzrY != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzrY);
        }
        if (adRequestParcel.zzrZ != null) {
            hashMap.put("kw", adRequestParcel.zzrZ);
        }
        if (adRequestParcel.zzsb != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzsb);
        }
        if (adRequestParcel.zzsa) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzsc) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzsd)) {
                hashMap.put("ppid", adRequestParcel.zzsd);
            }
            if (adRequestParcel.zzse != null) {
                zzgg.zza(hashMap, adRequestParcel.zzse);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzsg != null) {
            hashMap.put("url", adRequestParcel.zzsg);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzsi != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzsi);
            }
            if (adRequestParcel.zzsj != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzsj);
            }
            if (adRequestParcel.zzsk != null) {
                hashMap.put("request_agent", adRequestParcel.zzsk);
            }
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzgk zzgk2) {
        hashMap.put("am", zzgk2.zzEn);
        hashMap.put("cog", zzgg.zzx(zzgk2.zzEo));
        hashMap.put("coh", zzgg.zzx(zzgk2.zzEp));
        if (!TextUtils.isEmpty((CharSequence)zzgk2.zzEq)) {
            hashMap.put("carrier", zzgk2.zzEq);
        }
        hashMap.put("gl", zzgk2.zzEr);
        if (zzgk2.zzEs) {
            hashMap.put("simulator", 1);
        }
        hashMap.put("ma", zzgg.zzx(zzgk2.zzEt));
        hashMap.put("sp", zzgg.zzx(zzgk2.zzEu));
        hashMap.put("hl", zzgk2.zzEv);
        if (!TextUtils.isEmpty((CharSequence)zzgk2.zzEw)) {
            hashMap.put("mv", zzgk2.zzEw);
        }
        hashMap.put("muv", zzgk2.zzEx);
        if (zzgk2.zzEy != -2) {
            hashMap.put("cnt", zzgk2.zzEy);
        }
        hashMap.put("gnt", zzgk2.zzEz);
        hashMap.put("pt", zzgk2.zzEA);
        hashMap.put("rm", zzgk2.zzEB);
        hashMap.put("riv", zzgk2.zzEC);
        Bundle bundle = new Bundle();
        bundle.putInt("active_network_state", zzgk2.zzEG);
        bundle.putBoolean("active_network_metered", zzgk2.zzEF);
        hashMap.put("connectivity", bundle);
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("is_charging", zzgk2.zzEE);
        bundle2.putDouble("battery_level", zzgk2.zzED);
        hashMap.put("battery", bundle2);
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzth) != 0) {
            hashMap.put("acolor", zzgg.zzG(searchAdRequestParcel.zzth));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzgg.zzG(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzti) != 0 && Color.alpha((int)searchAdRequestParcel.zztj) != 0) {
            hashMap.put("gradientto", zzgg.zzG(searchAdRequestParcel.zzti));
            hashMap.put("gradientfrom", zzgg.zzG(searchAdRequestParcel.zztj));
        }
        if (Color.alpha((int)searchAdRequestParcel.zztk) != 0) {
            hashMap.put("bcolor", zzgg.zzG(searchAdRequestParcel.zztk));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zztl));
        switch (searchAdRequestParcel.zztm) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zztn) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzto != null) {
            hashMap.put("channel", searchAdRequestParcel.zzto);
        }
        if (Color.alpha((int)searchAdRequestParcel.zztp) != 0) {
            hashMap.put("dcolor", zzgg.zzG(searchAdRequestParcel.zztp));
        }
        if (searchAdRequestParcel.zztq != null) {
            hashMap.put("font", searchAdRequestParcel.zztq);
        }
        if (Color.alpha((int)searchAdRequestParcel.zztr) != 0) {
            hashMap.put("hcolor", zzgg.zzG(searchAdRequestParcel.zztr));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzts));
        if (searchAdRequestParcel.zztt != null) {
            hashMap.put("q", searchAdRequestParcel.zztt);
        }
    }

    private static Integer zzx(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzG(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzvD : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_html", null);
            long l = -1L;
            String string7 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string8 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string8)) {
                n = zzo.zzbx().zzgr();
            } else if ("landscape".equals(string8)) {
                n = zzo.zzbx().zzgq();
            }
            AdResponseParcel adResponseParcel = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzb.zzaC("Could not parse the mediation config: Missing required ad_base_url field");
                    return new AdResponseParcel(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzgf.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzpJ.zzGG, string4, null, null, null);
                string3 = adResponseParcel.zzzG;
                string6 = adResponseParcel.zzCI;
                l = adResponseParcel.zzCO;
            } else {
                zzb.zzaC("Could not parse the mediation config: Missing required ad_html or ad_url field.");
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzxF;
            if (jSONArray != null) {
                if (list3 == null) {
                    list3 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    list3.add(jSONArray.getString(i));
                }
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzxG;
            if (jSONArray2 != null) {
                if (list2 == null) {
                    list2 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    list2.add(jSONArray2.getString(i));
                }
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzCM;
            if (jSONArray3 != null) {
                if (list == null) {
                    list = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray3.length(); ++i) {
                    list.add(jSONArray3.getString(i));
                }
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzCJ > 0L) {
                    l2 = adResponseParcel.zzCJ;
                }
            }
            String string9 = jSONObject.optString("active_view");
            String string10 = null;
            boolean bl = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl) {
                string10 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl2 = jSONObject.optBoolean("mediation", false);
            boolean bl3 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl4 = jSONObject.optBoolean("native", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            int n2 = jSONObject.optInt("oauth2_token_status", 0);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            return new AdResponseParcel(adRequestInfoParcel, string3, string6, list3, list2, l2, bl2, l4, list, l3, n, string5, l, string7, bl, string10, string9, bl3, bl4, adRequestInfoParcel.zzCu, bl5, bl6, n2);
        }
        catch (JSONException jSONException) {
            zzb.zzaC("Could not parse the mediation config: " + jSONException.getMessage());
            return new AdResponseParcel(0);
        }
    }
}

