/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzd;

public final class LatLngBounds
implements SafeParcelable {
    public static final zzd CREATOR = new zzd();
    private final int zzCY;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        zzu.zzb(southwest, (Object)"null southwest");
        zzu.zzb(northeast, (Object)"null northeast");
        zzu.zzb(northeast.latitude >= southwest.latitude, "southern latitude exceeds northern latitude (%s > %s)", southwest.latitude, northeast.latitude);
        this.zzCY = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.zzf(latLng.latitude) && this.zzg(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d = Math.min(this.southwest.latitude, latLng.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng.longitude;
        if (!this.zzg(d5)) {
            if (LatLngBounds.zzb(d4, d5) < LatLngBounds.zzc(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public LatLng getCenter() {
        double d = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d2 = this.southwest.longitude;
        double d3 = this.northeast.longitude;
        double d4 = d2 <= d3 ? (d3 + d2) / 2.0 : (d3 + 360.0 + d2) / 2.0;
        return new LatLng(d, d4);
    }

    private static double zzb(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzc(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private boolean zzf(double d) {
        return this.southwest.latitude <= d && d <= this.northeast.latitude;
    }

    private boolean zzg(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public int hashCode() {
        return zzt.hashCode(this.southwest, this.northeast);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return zzt.zzt(this).zzg("southwest", this.southwest).zzg("northeast", this.northeast).toString();
    }

    public static final class Builder {
        private double zzaDn = Double.POSITIVE_INFINITY;
        private double zzaDo = Double.NEGATIVE_INFINITY;
        private double zzaDp = Double.NaN;
        private double zzaDq = Double.NaN;

        public Builder include(LatLng point) {
            this.zzaDn = Math.min(this.zzaDn, point.latitude);
            this.zzaDo = Math.max(this.zzaDo, point.latitude);
            double d = point.longitude;
            if (Double.isNaN(this.zzaDp)) {
                this.zzaDp = d;
                this.zzaDq = d;
            } else if (!this.zzg(d)) {
                if (LatLngBounds.zzb(this.zzaDp, d) < LatLngBounds.zzc(this.zzaDq, d)) {
                    this.zzaDp = d;
                } else {
                    this.zzaDq = d;
                }
            }
            return this;
        }

        private boolean zzg(double d) {
            if (this.zzaDp <= this.zzaDq) {
                return this.zzaDp <= d && d <= this.zzaDq;
            }
            return this.zzaDp <= d || d <= this.zzaDq;
        }

        public LatLngBounds build() {
            zzu.zza(!Double.isNaN(this.zzaDp), (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zzaDn, this.zzaDp), new LatLng(this.zzaDo, this.zzaDq));
        }
    }
}

