/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrc;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataMap;
import java.util.ArrayList;

public class DataMapItem {
    private final Uri mUri;
    private final DataMap zzaSV;

    public static DataMapItem fromDataItem(DataItem dataItem) {
        if (dataItem == null) {
            throw new IllegalStateException("provided dataItem is null");
        }
        return new DataMapItem(dataItem);
    }

    private DataMapItem(DataItem source) {
        this.mUri = source.getUri();
        this.zzaSV = this.zza((DataItem)source.freeze());
    }

    public Uri getUri() {
        return this.mUri;
    }

    public DataMap getDataMap() {
        return this.zzaSV;
    }

    private DataMap zza(DataItem dataItem) {
        if (dataItem.getData() == null && dataItem.getAssets().size() > 0) {
            throw new IllegalArgumentException("Cannot create DataMapItem from a DataItem  that wasn't made with DataMapItem.");
        }
        if (dataItem.getData() == null) {
            return new DataMap();
        }
        try {
            Object object;
            ArrayList<Asset> arrayList = new ArrayList<Asset>();
            int n = dataItem.getAssets().size();
            for (int i = 0; i < n; ++i) {
                object = dataItem.getAssets().get(Integer.toString(i));
                if (object == null) {
                    throw new IllegalStateException("Cannot find DataItemAsset referenced in data at " + i + " for " + dataItem);
                }
                Asset asset = Asset.createFromRef(object.getId());
                arrayList.add(asset);
            }
            zzrc zzrc2 = zzrc.zzw(dataItem.getData());
            object = new zzrb.zza(zzrc2, arrayList);
            return zzrb.zza((zzrb.zza)object);
        }
        catch (zzrm | NullPointerException exception) {
            Log.w((String)"DataItem", (String)("Unable to parse datamap from dataItem. uri=" + dataItem.getUri() + ", data=" + Base64.encodeToString((byte[])dataItem.getData(), (int)0)));
            throw new IllegalStateException("Unable to parse datamap from dataItem.  uri=" + dataItem.getUri(), exception);
        }
    }
}

