# MaterialX Project Governance

MaterialX is a project of the
[Academy Software Foundation](https://www.aswf.io/) and relies on the ASWF
governance policies, supported by the Linux Foundation.

The MaterialX project maintains a Technical Steering Committee (TSC), which
has final authority over the project.  As defined in the project charter,
TSC responsibilities include, but are not limited to:

- Discussions, seeking consensus, and where necessary, voting on technical
  matters relating to MaterialX that affect multiple projects.
- Maintenance and administration of the MaterialX GitHub repository.
- Coordinating technical direction of the project.
- Coordinating marketing, events, and communications regarding MaterialX.

Within the TSC there are two key subgroups: **Voting Members**, who take on
formal responsibilities for maintaining the MaterialX project and vote when
decisions are required; and **Stakeholders**, who represent specific teams and
companies in the industry and speak on their behalf in MaterialX discussions.

### Voting Members

These committee members are responsible for contributing actively to the
MaterialX project, whether it's in the form of developing code, improving the
specification and documentation, reviewing pull requests on GitHub, or
assisting teams with their MaterialX integrations.  Although we expect most
decisions to be unanimous across the MaterialX TSC, for decisions where a
formal vote is required, a majority of voting members is required to move
forward with a change.

Within the voting members of the TSC are two elected leadership roles.  Any
voting TSC member can express interest in serving in a role, or nominate
another member to serve.  There are no term limits, and one person may hold
multiple roles simultaneously.  Should a TSC member resign from a leadership
role before their term is complete, a successor shall be elected through the
standard nomination and voting process to complete the remainder of the term.
The leadership roles are:

- **Chair**: This position acts as the project manager, organizing meetings and
providing oversight to project administration.
- **TAC Representative**: This position represents the MaterialX project in meetings
of the Technical Advisory Council of the ASWF.

The current Voting Members of the MaterialX TSC are:

- Jonathan Stone - Lucasfilm ADG **(Chair and TAC Representative)**
- Doug Smythe - Industrial Light & Magic
- Niklas Harrysson - Lumiere Software
- Orn Gunnarsson - Autodesk
- Andréa Machizaud - Adobe

### Stakeholders

These committee members represent teams or companies that are closely aligned
with the MaterialX project, and have a strong interest in how it evolves going
forward.  Stakeholders speak on behalf of their team or company in MaterialX
discussions, providing the breadth of perspectives that is required to guide
the project.  Most new committee members start in this category, and it
doesn't require a commitment on their part to contribute to or maintain the
MaterialX project, though they are encouraged to do so.

The current Stakeholders of the MaterialX TSC are:

- Henrik Edstrom - Autodesk
- Fran González García - Pixar RenderMan
- Ole Gulbrandsen - Sony Pictures Imageworks
- Rafal Jaroszkiewicz - SideFX
- Lee Kerley - Apple
- Lutz Kettner - NVIDIA
- Chris Kulla - Epic Games
- Bernard Kwok - Khronos Group
- André Mazzone - ILM
- Magnus Pettersson - IKEA
- Dimitar Toshev - Chaos

### TSC Nomination and Succession

Any proposal for additional members of the TSC may be submitted by reaching
out to a current TSC member on Slack or raising the issue at a TSC meeting.
New TSC members are accepted or rejected by majority vote of the TSC.

If a TSC member is for an extended period not regularly participating or
performing the responsibilities expected of TSC members, the TSC may by
majority vote request an alternate TSC member be submitted by that
organization, or remove the inactive member from the TSC.

A member of the TSC may nominate a successor in the event that such member
decides to leave the TSC, and the TSC shall confirm or reject such nomination
by a vote.  In the event that the departing member's nomination for successor
is rejected by vote of the TSC, the departing member shall be entitled to
continue nominating successors until one such successor is confirmed by vote
of the TSC.  If the departing member fails or is unable to nominate a
successor, the TSC may nominate one on the departing member's behalf.

Voting TSC membership is presumed to be retained by the individual even if
they change employers.  The TSC may take action to ensure that organizational
stakeholder representation not become severely disproportionate, for example by
urging an organization that loses its sole TSC representative to nominate a
new member, or to limit the total number of members from any one organization
if too many members all move to the same organization.

### TSC Meetings

All meetings of the TSC are intended to be open to the public, except where
there is a reasonable need for privacy.  The TSC meets regularly in a video
conference call, at a cadence deemed appropriate by the TSC.  The TSC Chair
moderates the meeting, or appoints another TSC member to moderate in his or
her absence.  Scheduling and connection details may be found in the public
[ASWF Meeting Calendar](https://www.aswf.io/meeting-calendar/).

Prior to each TSC meeting, the meeting chair will share the agenda with
the TSC members and broader community on the MaterialX channel of the ASWF
Slack.  TSC members can also add items to this agenda before the start of
each meeting.  The meeting chair is responsible for ensuring that minutes
are taken and posted on Slack.
