#include "dxftoqet_mainwindow.h"
#include "ui_dxftoqet_mainwindow.h"


/* init extern variable */

struct ALG Max_alg;
struct BLOCK Max_block;
struct ENTITIE Max_entitie;

struct DXF_header DXF_input_header[DXF_L_HEADER];
struct DXF_classes DXF_input_classes[DXF_L_CLASSES];
struct DXF_tables DXF_input_tables[DXF_L_TABLES];
struct DXF_table_appid DXF_input_table_appid[DXF_LT_APPID];
struct DXF_table_block_record DXF_input_table_block_record[DXF_LT_BLOCK_RECORD];
struct DXF_table_dimstyle DXF_input_table_dimstyle[DXF_LT_DIMSTYLE];
struct DXF_table_layer DXF_input_table_layer[DXF_LT_LAYER];
struct DXF_table_ltype DXF_input_table_ltype[DXF_LT_LTYPE];
struct DXF_table_style DXF_input_table_style[DXF_LT_STYLE];
struct DXF_table_ucs DXF_input_table_ucs[DXF_LT_UCS];
struct DXF_table_view DXF_input_table_view[DXF_LT_VIEW];
struct DXF_table_vport DXF_input_table_vport[DXF_LT_VPORT];
struct DXF_block DXF_input_block[DXF_L_BLOCK];
struct DXF_end_block DXF_input_end_block[DXF_L_BLOCK];

struct DXF_block_3dface DXF_input_block_3dface[DXF_L_BLOCK][DXF_LB_3DFACE];
struct DXF_block_3dsolid DXF_input_block_3dsolid[DXF_L_BLOCK][DXF_LB_3DSOLID];
struct DXF_block_acad_proxy_entity DXF_input_block_proxy_entity[DXF_L_BLOCK][DXF_LB_PROXY_ENTITY];
struct DXF_block_arc DXF_input_block_arc[DXF_L_BLOCK][DXF_LB_ARC];
struct DXF_block_attdef DXF_input_block_attdef[DXF_L_BLOCK][DXF_LB_ATTDEF];
struct DXF_block_attrib DXF_input_block_attrib[DXF_L_BLOCK][DXF_LB_ATTRIB];
struct DXF_block_body DXF_input_block_body[DXF_L_BLOCK][DXF_LB_BODY];
struct DXF_block_circle DXF_input_block_circle[DXF_L_BLOCK][DXF_LB_CIRCLE];
struct DXF_block_dimension DXF_input_block_dimension[DXF_L_BLOCK][DXF_LB_DIMENSION];
struct DXF_block_ellipse DXF_input_block_ellipse[DXF_L_BLOCK][DXF_LB_ELLIPSE];
struct DXF_block_hatch DXF_input_block_hatch[DXF_L_BLOCK][DXF_LB_HATCH];
struct DXF_block_helix DXF_input_block_helix[DXF_L_BLOCK][DXF_LB_HELIX];
struct DXF_block_image DXF_input_block_image[DXF_L_BLOCK][DXF_LB_IMAGE];
struct DXF_block_insert DXF_input_block_insert[DXF_L_BLOCK][DXF_LB_INSERT];
struct DXF_block_leader DXF_input_block_leader[DXF_L_BLOCK][DXF_LB_LEADER];
struct DXF_block_light DXF_input_block_light[DXF_L_BLOCK][DXF_LB_LIGHT];
struct DXF_block_line DXF_input_block_line[DXF_L_BLOCK][DXF_LB_LINE];
struct DXF_block_lwpolyline DXF_input_block_lwpolyline[DXF_L_BLOCK][DXF_LB_LWPOLYLINE];
struct DXF_block_mesh DXF_input_block_mesh[DXF_L_BLOCK][DXF_LB_MESH ];
struct DXF_block_mline DXF_input_block_mline[DXF_L_BLOCK][DXF_LB_MLINE];
struct DXF_block_mleaderstyle DXF_input_block_mleaderstyle[DXF_L_BLOCK][DXF_LB_MLEADERSTYLE];
struct DXF_block_mleader DXF_input_block_mleader[DXF_L_BLOCK][DXF_LB_MLEADER];
struct DXF_block_mtext DXF_input_block_mtext[DXF_L_BLOCK][DXF_LB_MTEXT];
struct DXF_block_oleframe DXF_input_DXF_block_oleframe[DXF_L_BLOCK][DXF_LB_OLEFRAME];
struct DXF_block_ole2frame DXF_input_block_ole2frame[DXF_L_BLOCK][DXF_LB_OLE2FRAME];
struct DXF_block_point DXF_input_block_point[DXF_L_BLOCK][DXF_LB_POINT];
struct DXF_block_polyline DXF_input_block_polyline[DXF_L_BLOCK][DXF_LB_POLYLINE];
struct DXF_block_ray DXF_input_block_ray[DXF_L_BLOCK][DXF_LB_RAY];
struct DXF_block_region DXF_input_block_region[DXF_L_BLOCK][DXF_LB_REGION];
struct DXF_block_section DXF_input_block_section[DXF_L_BLOCK][DXF_LB_SECTION];
struct DXF_block_seqend DXF_input_block_seqend[DXF_L_BLOCK][DXF_LB_SEQEND];
struct DXF_block_shape DXF_input_block_shape[DXF_L_BLOCK][DXF_LB_SHAPE];
struct DXF_block_solid DXF_input_block_solid[DXF_L_BLOCK][DXF_LB_SOLID];
struct DXF_block_spline DXF_input_block_spline[DXF_L_BLOCK][DXF_LB_SPLINE];
struct DXF_block_sun DXF_input_block_sun[DXF_L_BLOCK][DXF_LB_SUN];
struct DXF_block_surface DXF_input_block_surface[DXF_L_BLOCK][DXF_LB_SURFACE];
struct DXF_block_table DXF_input_block_table[DXF_L_BLOCK][DXF_LB_TABLE];
struct DXF_block_text DXF_input_block_text[DXF_L_BLOCK][DXF_LB_TEXT];
struct DXF_block_tolerance DXF_input_block_tolerance[DXF_L_BLOCK][DXF_LB_TOLERANCE];
struct DXF_block_trace DXF_input_block_trace[DXF_L_BLOCK][DXF_LB_TRACE];
struct DXF_block_underlay DXF_input_block_underlay[DXF_L_BLOCK][DXF_LB_UNDERLAY];
struct DXF_block_vertex DXF_input_block_vertex[DXF_L_BLOCK][DXF_LB_VERTEX];
struct DXF_block_viewport DXF_input_block_viewport[DXF_L_BLOCK][DXF_LB_VIEWPORT];
struct DXF_block_wipeout DXF_input_block_wipeout[DXF_L_BLOCK][DXF_LB_WIPEOUT];
struct DXF_block_xline DXF_input_block_xline[DXF_L_BLOCK][DXF_LB_XLINE];

struct DXF_entities_3dface DXF_input_entities_3dface[DXF_LE_3DFACE];
struct DXF_entities_3dsolid DXF_input_entities_3dsolid[DXF_LE_3DSOLID];
struct DXF_entities_acad_proxy_entity DXF_input_entities_acad_proxy_entity[DXF_LE_PROXY_ENTITY];
struct DXF_entities_arc DXF_input_entities_arc[DXF_LE_ARC];
struct DXF_entities_attdef DXF_input_entities_attdef[DXF_LE_ATTDEF];
struct DXF_entities_attrib DXF_input_entities_attrib[DXF_LE_ATTRIB];
struct DXF_entities_body DXF_input_entities_body[DXF_LE_BODY];
struct DXF_entities_circle DXF_input_entities_circle[DXF_LE_CIRCLE];
struct DXF_entities_dimension DXF_input_entities_dimension[DXF_LE_DIMENSION];
struct DXF_entities_ellipse DXF_input_entities_ellipse[DXF_LE_ELLIPSE];
struct DXF_entities_hatch DXF_input_entities_hatch[DXF_LE_HATCH];
struct DXF_entities_helix DXF_input_entities_helix[DXF_LE_HELIX];
struct DXF_entities_image DXF_input_entities_image[DXF_LE_IMAGE];
struct DXF_entities_insert DXF_input_entities_insert[DXF_LE_INSERT];
struct DXF_entities_leader DXF_input_entities_leader[DXF_LE_LEADER];
struct DXF_entities_light DXF_input_entities_light[DXF_LE_LIGHT];
struct DXF_entities_line DXF_input_entities_line[DXF_LE_LINE];
struct DXF_entities_lwpolyline DXF_input_entities_lwpolyline[DXF_LE_LWPOLYLINE];
struct DXF_entities_mesh DXF_input_entities_mesh[DXF_LE_MESH];
struct DXF_entities_mline DXF_input_entities_mline[DXF_LE_MLINE];
struct DXF_entities_mleaderstyle DXF_input_entities_mleaderstyle[DXF_LE_MLEADERSTYLE];
struct DXF_entities_mleader DXF_input_entities_mleader[DXF_LE_MLEADER];
struct DXF_entities_mtext DXF_input_entities_mtext[DXF_LE_MTEXT];
struct DXF_entities_oleframe DXF_input_entities_oleframe[DXF_LE_OLEFRAME];
struct DXF_entities_ole2frame DXF_input_entities_ole2frame[DXF_LE_OLE2FRAME];
struct DXF_entities_point DXF_input_entities_point[DXF_LE_POINT];
struct DXF_entities_polyline DXF_input_entities_polyline[DXF_LE_POLYLINE];
struct DXF_entities_ray DXF_input_entities_ray[DXF_LE_RAY];
struct DXF_entities_region DXF_input_entities_region[DXF_LE_REGION];
struct DXF_entities_section DXF_input_entities_section[DXF_LE_SECTION];
struct DXF_entities_seqend DXF_input_entities_seqend[DXF_LE_SEQEND];
struct DXF_entities_shape DXF_input_entities_shape[DXF_LE_SHAPE];
struct DXF_entities_solid DXF_input_entities_solid[DXF_LE_SOLID];
struct DXF_entities_spline DXF_input_entities_spline[DXF_LE_SPLINE];
struct DXF_entities_sun DXF_input_entities_sun[DXF_LE_SUN];
struct DXF_entities_surface DXF_input_entities_surface[DXF_LE_SURFACE];
struct DXF_entities_table DXF_input_entities_table[DXF_LE_TABLE];
struct DXF_entities_text DXF_input_entities_text[DXF_LE_TEXT];
struct DXF_entities_tolerance DXF_input_entities_tolerance[DXF_LE_TOLERANCE];
struct DXF_entities_trace DXF_input_entities_trace[DXF_LE_TRACE];
struct DXF_entities_underlay DXF_input_entities_underlay[DXF_LE_UNDERLAY];
struct DXF_entities_vertex DXF_input_entities_vertex[DXF_LE_VERTEX];
struct DXF_entities_viewport DXF_input_entities_viewport[DXF_LE_VIEWPORT];
struct DXF_entities_wipeout DXF_input_entities_wipeout[DXF_LE_WIPEOUT];
struct DXF_entities_xline DXF_input_entities_xline[DXF_LE_XLINE];



//extern struct DXF_file_input DXF_input_entities[100];
//extern struct DXF_file_input DXF_input_thumbnailimage[100];
struct DXF_base DXF_main_base[1];


DXFtoQET_MainWindow::DXFtoQET_MainWindow(QWidget *parent) :
	QWidget(parent),
	ui(new Ui::DXFtoQET_MainWindow)
{
	ui->setupUi(this);

	//on_Open_config_file_clicked();

	ui->csv_header_bask_color->addItem("none");
	ui->csv_header_bask_color->addItem("black");
	ui->csv_header_bask_color->addItem("white");
	ui->csv_header_bask_color->addItem("red");
	ui->csv_header_bask_color->addItem("green");
	ui->csv_header_bask_color->addItem("blue");
	ui->csv_header_bask_color->addItem("gray");
	ui->csv_header_bask_color->addItem("cyan");
	ui->csv_header_bask_color->addItem("orange");
	ui->csv_header_bask_color->addItem("purple");
	ui->csv_header_bask_color->addItem("magenta");
	ui->csv_header_bask_color->addItem("brun");
	ui->csv_header_bask_color->addItem("yello");
	ui->csv_header_bask_color->addItem("lightgray");

	ui->Block_color->addItem("none");
	ui->Block_color->addItem("black");
	ui->Block_color->addItem("white");
	ui->Block_color->addItem("red");
	ui->Block_color->addItem("green");
	ui->Block_color->addItem("blue");
	ui->Block_color->addItem("gray");
	ui->Block_color->addItem("cyan");
	ui->Block_color->addItem("orange");
	ui->Block_color->addItem("purple");
	ui->Block_color->addItem("magenta");
	ui->Block_color->addItem("brun");
	ui->Block_color->addItem("yello");
	ui->Block_color->addItem("lightgray");

	ui->Entitie_color->addItem("none");
	ui->Entitie_color->addItem("black");
	ui->Entitie_color->addItem("white");
	ui->Entitie_color->addItem("red");
	ui->Entitie_color->addItem("green");
	ui->Entitie_color->addItem("blue");
	ui->Entitie_color->addItem("gray");
	ui->Entitie_color->addItem("cyan");
	ui->Entitie_color->addItem("orange");
	ui->Entitie_color->addItem("purple");
	ui->Entitie_color->addItem("magenta");
	ui->Entitie_color->addItem("brun");
	ui->Entitie_color->addItem("yello");
	ui->Entitie_color->addItem("lightgray");

	//Insert_block_color

	ui->Insert_block_color->addItem("none");
	ui->Insert_block_color->addItem("black");
	ui->Insert_block_color->addItem("white");
	ui->Insert_block_color->addItem("red");
	ui->Insert_block_color->addItem("green");
	ui->Insert_block_color->addItem("blue");
	ui->Insert_block_color->addItem("gray");
	ui->Insert_block_color->addItem("cyan");
	ui->Insert_block_color->addItem("orange");
	ui->Insert_block_color->addItem("purple");
	ui->Insert_block_color->addItem("magenta");
	ui->Insert_block_color->addItem("brun");
	ui->Insert_block_color->addItem("yello");
	ui->Insert_block_color->addItem("lightgray");

	on_Open_config_file_clicked();

	Max_entitie.DXF_entities_3dface=1000;
	Max_entitie.DXF_entities_3dsolid=1000;
	Max_entitie.DXF_entities_acad_proxy_entity=1000;
	Max_entitie.DXF_entities_arc=1000;
	Max_entitie.DXF_entities_attdef=1000;
	Max_entitie.DXF_entities_attrib=1000;
	Max_entitie.DXF_entities_body=1000;
	Max_entitie.DXF_entities_circle=1000;
	Max_entitie.DXF_entities_dimension=1000;
	Max_entitie.DXF_entities_ellipse=1000;
	Max_entitie.DXF_entities_hatch=1000;
	Max_entitie.DXF_entities_helix=1000;
	Max_entitie.DXF_entities_image=1000;
	Max_entitie.DXF_entities_insert=1000;
	Max_entitie.DXF_entities_leader=1000;
	Max_entitie.DXF_entities_light=1000;
	Max_entitie.DXF_entities_line=100000;
	Max_entitie.DXF_entities_lwpolyline=1000;
	Max_entitie.DXF_entities_mesh=1000;
	Max_entitie.DXF_entities_mline=1000;
	Max_entitie.DXF_entities_mleaderstyle=1000;
	Max_entitie.DXF_entities_mleader=1000;
	Max_entitie.DXF_entities_mtext=1000;
	Max_entitie.DXF_entities_oleframe=1000;
	Max_entitie.DXF_entities_ole2frame=1000;
	Max_entitie.DXF_entities_point=1000;
	Max_entitie.DXF_entities_polyline=1000;
	Max_entitie.DXF_entities_ray=1000;
	Max_entitie.DXF_entities_region=1000;
	Max_entitie.DXF_entities_section=100;
	Max_entitie.DXF_entities_seqend=1000;
	Max_entitie.DXF_entities_shape=1000;
	Max_entitie.DXF_entities_solid=1000;
	Max_entitie.DXF_entities_spline=1000;
	Max_entitie.DXF_entities_sun=1000;
	Max_entitie.DXF_entities_surface=1000;
	Max_entitie.DXF_entities_table=1000;
	Max_entitie.DXF_entities_text=1000;
	Max_entitie.DXF_entities_tolerance=1000;
	Max_entitie.DXF_entities_trace=1000;
	Max_entitie.DXF_entities_underlay=1000;
	Max_entitie.DXF_entities_vertex=50000;
	Max_entitie.DXF_entities_viewport=1000;
	Max_entitie.DXF_entities_wipeout=1000;
	Max_entitie.DXF_entities_xline=1000;

	Max_block.DXF_block_3dface=100;
	Max_block.DXF_block_3dsolid=100;
	Max_block.DXF_block_acad_proxy_entity=100;
	Max_block.DXF_block_arc=100;
	Max_block.DXF_block_attdef=100;
	Max_block.DXF_block_attrib=100;
	Max_block.DXF_block_body=100;
	Max_block.DXF_block_circle=100;
	Max_block.DXF_block_dimension=100;
	Max_block.DXF_block_ellipse=100;
	Max_block.DXF_block_hatch=100;
	Max_block.DXF_block_helix=100;
	Max_block.DXF_block_image=100;
	Max_block.DXF_block_insert=100;
	Max_block.DXF_block_leader=100;
	Max_block.DXF_block_light=100;
	Max_block.DXF_block_line=5000;
	Max_block.DXF_block_lwpolyline=100;
	Max_block.DXF_block_mesh=100;
	Max_block.DXF_block_mline=100;
	Max_block.DXF_block_mleaderstyle=100;
	Max_block.DXF_block_mleader=100;
	Max_block.DXF_block_mtext=100;
	Max_block.DXF_block_oleframe=100;
	Max_block.DXF_block_ole2frame=100;
	Max_block.DXF_block_point=100;
	Max_block.DXF_block_polyline=100;
	Max_block.DXF_block_ray=100;
	Max_block.DXF_block_region=100;
	Max_block.DXF_block_section=100;
	Max_block.DXF_block_seqend=100;
	Max_block.DXF_block_shape=100;
	Max_block.DXF_block_solid=100;
	Max_block.DXF_block_spline=100;
	Max_block.DXF_block_sun=100;
	Max_block.DXF_block_surface=100;
	Max_block.DXF_block_table=100;
	Max_block.DXF_block_text=100;
	Max_block.DXF_block_tolerance=100;
	Max_block.DXF_block_trace=100;
	Max_block.DXF_block_underlay=100;
	Max_block.DXF_block_vertex=500;
	Max_block.DXF_block_viewport=100;
	Max_block.DXF_block_wipeout=100;
	Max_block.DXF_block_xline=100;

	Max_alg.DXF_header=500;
	Max_alg.DXF_classes=1000;
	Max_alg.DXF_tables=20;
	Max_alg.DXF_table_appid=100;
	Max_alg.DXF_table_block_record=500;
	Max_alg.DXF_table_dimstyle=500;
	Max_alg.DXF_table_layer=100;
	Max_alg.DXF_table_ltype=100;
	Max_alg.DXF_table_style=100;
	Max_alg.DXF_table_ucs=100;
	Max_alg.DXF_table_view=100;
	Max_alg.DXF_table_vport=100;
	Max_alg.DXF_input_block=200;
	Max_alg.DXF_input_end_block=200;
	Max_alg.DXF_entities=DXF_L_ENTITIES;
}

DXFtoQET_MainWindow::~DXFtoQET_MainWindow()
{
	delete ui;
}

void DXFtoQET_MainWindow::changeEvent(QEvent *e)
{
	QWidget::changeEvent(e);
	switch (e->type())
	{
		case QEvent::LanguageChange:
			ui->retranslateUi(this);
			break;
		default:
			break;
	}
}

void DXFtoQET_MainWindow::on_actionOpen_triggered()
{

	Clear_view();

	main_sw1=0;
	main_sw2=0;
	main_sw3=0;

		DXF_main_base[0].DXF_file_loaded_into_table=-1;

	// open file dialog
	log_file="Open file ";
	ui->dxf_log->setPlainText(log_file);

	QFileDialog dialog(this);
	dialog.setNameFilter(tr("DXF files (*.dxf *.DXF *.csv *.CSV)"));
	dialog.setFileMode(QFileDialog::ExistingFile);
	dialog.setViewMode(QFileDialog::Detail);


	if (dialog.exec() == QDialog::Accepted)
	{
		DXF_main_base[0].dxf_filepath = dialog.selectedFiles().first();
		DXF_main_base[0].dxf_dir = dialog.directory().absolutePath();
		DXF_main_base[0].dxf_openfile=DXF_main_base[0].dxf_filepath.split("/").last();
		DXF_main_base[0].dxf_savepath=Config_QET_User_Symbols;//"../.qet/elements"; //DXF_main_base[0].dxf_dir;

		ui->dxf_file_path_save->setText(DXF_main_base[0].dxf_savepath);


		FileType=DXF_main_base[0].dxf_openfile.split(".").last();
		FileName=DXF_main_base[0].dxf_openfile.split(".").first().toLower();

		Filename2=FileName.remove(QRegExp("[+-/#_=<>]"));

		DXF_main_base[0].dxf_openfile=Filename2.toLower();
		DXF_main_base[0].dxf_filetype=FileType;


		log_file.append (DXF_main_base[0].dxf_openfile);
		DXF_main_base[0].DXF_ELMT_Name_text_en=FileName;
		DXF_main_base[0].DXF_ELMT_Name_text_fr=FileName;

		ui->elmt_lang_en->setText(FileName);
		ui->elmt_lang_fr->setText(FileName);

		log_file.append("\n");
		ui->dxf_log->setPlainText(log_file);

		QFile file(DXF_main_base[0].dxf_filepath);
		if (!file.open(QFile::ReadOnly | QFile::Text))
		{
			QMessageBox::warning(this, tr("Application"),
					  tr("Cannot read file %1:\n%2.").arg(DXF_main_base[0].dxf_filepath).arg("binary or other non standard dxf file"));

		}

		ui->dxf_file_path->setPlaceholderText(DXF_main_base[0].dxf_dir);
		ui->dxf_open_file->setPlaceholderText(DXF_main_base[0].dxf_openfile);

		log_file.append("file read into program \n");
		ui->dxf_log->setPlainText(log_file);

		status1="file read ";
		status1.append(FileName);
		status1.append(" into program");
		ui->statusBar->showMessage(status1);

		QTextStream in(&file);
		DXF_main_base[0].dxf_text_all = in.readAll();

		file.close();

		ui->dxf_file_loaded->setPlainText(DXF_main_base[0].dxf_text_all);
		ui->dxf_file_loaded->show();
		ui->dxf_file_loaded->repaint();

		int32_t dxf_line_count1=DXF_main_base[0].dxf_text_all.count();
		ui->dxf_line_count->setText(QString::number(dxf_line_count1,'f',0));

		log_file.append("split and check file for correct type of file \n");
		ui->dxf_log->setPlainText(log_file);

		dxf_load dxf_lf(this);

		dxf_lf.dxf_header_split();
		//dxf_lf.dxf_header_split();

		main_sw1=dxf_lf.dxf_check_file();

		if (FileType=="csv" or FileType=="CSV")
		{
			main_sw2=1;
			main_sw3=0;
			log_file.append("file of type CSV \n");

			dxf_lf.dxf_csv_split();

			int32_t dxf_line_count2=DXF_main_base[0].dxf_csv_line_count;
			ui->dxf_line_count->setText(QString::number(dxf_line_count2,'f',0));
		}
		else
		{
			main_sw2=0;
		}

		if (FileType=="dxf" or FileType=="DXF")
		{

			main_sw3=1;
			main_sw2=0;
			log_file.append("file of type DXF \n");
		}
		else
		{
			main_sw3=0;
		}

		if (main_sw1==1 and main_sw2==0)
		{
			log_file.append("file of type ASCII DXF \n");
		}

		if (main_sw1==0 and main_sw2==0)
		{
			log_file.append("file of type BINARY DXF \n");
		}




	}

	return;

}

void DXFtoQET_MainWindow::on_actionSave_as_elmt_triggered()
{

	//DXF_main_base[0].dxf_openfile=ui->dxf_open_file->text();
	if (main_sw3==1)
	{
		QFile file(DXF_main_base[0].dxf_savepath + "/" + DXF_main_base[0].dxf_openfile + ".elmt");

		if (!file.open(QFile::WriteOnly | QFile::Text)) {
			QMessageBox::warning(this, tr("Application"),
								 tr("Cannot write file %1:\n%2.")
								 .arg(DXF_main_base[0].dxf_dir)
								 .arg(file.errorString()));
			return;
		}

		QTextStream out(&file);
		out << ui->ELMT_result->toPlainText();

		file.close();
		QMessageBox::information(this, tr("Export as elmt file"), tr("L'element %1 a bien ete enregistre").arg(ui->dxf_open_file->text()));
	}

	if (main_sw2==1)
	{
		for (csv_elmt_count=0;csv_elmt_count<DXF_main_base[0].csv_count_elmt;csv_elmt_count++)
		{

			QFile file(DXF_main_base[0].dxf_savepath + "/" + DXF_main_base[0].dxf_openfile +"-"+QString::number(csv_elmt_count,'f',0)+ ".elmt");

			if (!file.open(QFile::WriteOnly | QFile::Text)) {
				QMessageBox::warning(this, tr("Application"),
									 tr("Cannot write file %1:\n%2.")
									 .arg(DXF_main_base[0].dxf_dir)
									 .arg(file.errorString()));
				return;
			}

			QTextStream out(&file);
			out << DXF_main_base[0].Elmt_list[csv_elmt_count];

			file.close();
			// QMessageBox::information(this, tr("Export as elmt file"), tr("L'element %1 a bien ete enregistre").arg(ui->dxf_open_file->text()));
		}

		QMessageBox::information(this, tr("Export as elmt file"), tr("L'element %1 a bien ete enregistre").arg(ui->dxf_open_file->text()));
	}

}

void DXFtoQET_MainWindow::on_actionSave_as_qet_triggered()
{

}

void DXFtoQET_MainWindow::on_load_into_tables_clicked()
{
	//Clear_view();

	DXF_main_base[0].DXF_file_loaded_into_table=1;

	if (main_sw1==0)
	{
		QMessageBox::warning(this, tr("Application"),
			tr("Cannot convert this file %1:\n%2.").arg(DXF_main_base[0].dxf_filepath).arg("error"));
	}
	else
	{

		if (main_sw3==1)
		{

			//ui->progressBar->setMaximum(DXF_main_base[0].dxf_line_count);
			//ui->progressBar->setMinimum(0);

			//counter * counting = new counter(this);

			dxf_split *dxf_spf=new dxf_split(this);

			//QObject::connect(dxf_spf, SIGNAL(ValueChanged(int)), ui->progressBar, SLOT(setValue(int)));

			log_file.append("load dxf sections into specific table \n");
			ui->dxf_log->setPlainText(log_file);

			log_trans=dxf_spf->dxf_split_section();
			log_file.append(log_trans);
			ui->dxf_log->setPlainText(log_file);

			ui->dxf_line_count->setText(QString::number(DXF_main_base[0].dxf_line_count));

			ui->header_line_count->setText(QString::number(DXF_main_base[0].dxf_header_item_count));
			ui->Classes_line_count->setText(QString::number(DXF_main_base[0].dxf_classes_item_count));

			ui->tables_line_count->setText(QString::number(DXF_main_base[0].dxf_tables_item_count));
			ui->table_appid_count->setText(QString::number(DXF_main_base[0].DXF_table_appid_count));
			ui->table_block_record_count->setText(QString::number(DXF_main_base[0].DXF_table_block_record_count));
			ui->table_dimstyle_count->setText(QString::number(DXF_main_base[0].DXF_table_dimstyle_count));
			ui->table_layer_count->setText(QString::number(DXF_main_base[0].DXF_table_layer_count));
			ui->table_ltype_count->setText(QString::number(DXF_main_base[0].DXF_table_ltype_count));
			ui->table_style_count->setText(QString::number(DXF_main_base[0].DXF_table_style_count));
			ui->table_ucs_count->setText(QString::number(DXF_main_base[0].DXF_table_ucs_count));
			ui->table_view_count->setText(QString::number(DXF_main_base[0].DXF_table_view_count));
			ui->table_vport_count->setText(QString::number(DXF_main_base[0].DXF_table_vport_count));



			ui->block_line_count->setText(QString::number(DXF_main_base[0].dxf_block_item_count));
			ui->entites_line_count->setText(QString::number(DXF_main_base[0].dxf_entites_item_count));
			ui->objecs_line_count->setText(QString::number(DXF_main_base[0].dxf_objects_item_count));
			ui->thumbnailimage_line_count->setText(QString::number(DXF_main_base[0].dxf_thumbnailimage_item_count));

			ui->DXF_3DFACE->setText(QString::number(DXF_main_base[0].DXF_entities_3dface_count));

			if (DXF_main_base[0].DXF_entities_3dface_count>(DXF_LE_3DFACE-1))
			{

				ui->DXF_3DFACE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_3DFACE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_3DSOLID->setText(QString::number(DXF_main_base[0].DXF_entities_3dsolid_count));

			if (DXF_main_base[0].DXF_entities_3dsolid_count>(DXF_LE_3DSOLID-1))
			{

				ui->DXF_3DSOLID->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_3DSOLID->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_ACAD_PROXY_ENTITY->setText(QString::number(DXF_main_base[0].DXF_entities_acad_proxy_entity_count));

			if (DXF_main_base[0].DXF_entities_acad_proxy_entity_count>(DXF_LE_PROXY_ENTITY-1))
			{

				ui->DXF_ACAD_PROXY_ENTITY->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_ACAD_PROXY_ENTITY->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_ARC->setText(QString::number(DXF_main_base[0].DXF_entities_arc_count));

			if (DXF_main_base[0].DXF_entities_arc_count>(DXF_LE_ARC-1))
			{

				ui->DXF_ARC->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_ARC->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_ATTDEF->setText(QString::number(DXF_main_base[0].DXF_entities_attdef_count));

			if (DXF_main_base[0].DXF_entities_attdef_count>(DXF_LE_ATTDEF-1))
			{

				ui->DXF_ATTDEF->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_ATTDEF->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_ATTRIB->setText(QString::number(DXF_main_base[0].DXF_entities_attrib_count));

			if (DXF_main_base[0].DXF_entities_attrib_count>(DXF_LE_ATTRIB-1))
			{

				ui->DXF_ATTRIB->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_ATTRIB->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_BODY->setText(QString::number(DXF_main_base[0].DXF_entities_body_count));

			if (DXF_main_base[0].DXF_entities_body_count>(DXF_LE_BODY-1))
			{

				ui->DXF_BODY->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_BODY->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_CIRCLE->setText(QString::number(DXF_main_base[0].DXF_entities_circle_count));


			if (DXF_main_base[0].DXF_entities_circle_count>(DXF_LE_CIRCLE-1))
			{

				ui->DXF_CIRCLE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_CIRCLE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_DIMENSIONS->setText(QString::number(DXF_main_base[0].DXF_entities_dimension_count));


			if (DXF_main_base[0].DXF_entities_dimension_count>(DXF_LE_DIMENSION-1))
			{

				ui->DXF_DIMENSIONS->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_DIMENSIONS->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_ELLIPSE->setText(QString::number(DXF_main_base[0].DXF_entities_ellipse_count));


			if (DXF_main_base[0].DXF_entities_ellipse_count>(DXF_LE_ELLIPSE-1))
			{

				ui->DXF_ELLIPSE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_ELLIPSE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_HATCH->setText(QString::number(DXF_main_base[0].DXF_entities_hatch_count));


			if (DXF_main_base[0].DXF_entities_hatch_count>(DXF_LE_HATCH-1))
			{

				ui->DXF_HATCH->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_HATCH->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_HELIX->setText(QString::number(DXF_main_base[0].DXF_entities_helix_count));


			if (DXF_main_base[0].DXF_entities_helix_count>(DXF_LE_HELIX-1))
			{

				ui->DXF_HELIX->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_HELIX->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_IMAGE->setText(QString::number(DXF_main_base[0].DXF_entities_image_count));


			if (DXF_main_base[0].DXF_entities_image_count>(DXF_LE_IMAGE-1))
			{

				ui->DXF_IMAGE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_IMAGE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_INSERT->setText(QString::number(DXF_main_base[0].DXF_entities_insert_count));


			if (DXF_main_base[0].DXF_entities_insert_count>(DXF_LE_INSERT-1))
			{

				ui->DXF_INSERT->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_INSERT->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_LEADER->setText(QString::number(DXF_main_base[0].DXF_entities_leader_count));


			if (DXF_main_base[0].DXF_entities_leader_count>(DXF_LE_LEADER-1))
			{

				ui->DXF_LEADER->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_LEADER->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_LIGHT->setText(QString::number(DXF_main_base[0].DXF_entities_light_count));


			if (DXF_main_base[0].DXF_entities_light_count>(DXF_LE_LIGHT-1))
			{

				ui->DXF_LIGHT->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_LIGHT->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_LINE->setText(QString::number(DXF_main_base[0].DXF_entities_line_count));

			if (DXF_main_base[0].DXF_entities_line_count>(DXF_LE_LINE-1))
			{

				ui->DXF_LINE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_LINE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_LWPOLYLINE->setText(QString::number(DXF_main_base[0].DXF_entities_lwpolyline_count));

			if (DXF_main_base[0].DXF_entities_lwpolyline_count>(DXF_LE_LWPOLYLINE-1))
			{

				ui->DXF_LWPOLYLINE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_LWPOLYLINE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_MESH->setText(QString::number(DXF_main_base[0].DXF_entities_mesh_count));

			if (DXF_main_base[0].DXF_entities_mesh_count>(DXF_LE_MESH-1))
			{

				ui->DXF_MESH->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_MESH->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_MLINE->setText(QString::number(DXF_main_base[0].DXF_entities_mline_count));

			if (DXF_main_base[0].DXF_entities_mline_count>(DXF_LE_MLINE-1))
			{

				ui->DXF_MLINE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_MLINE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_MLEADER->setText(QString::number(DXF_main_base[0].DXF_entities_mleader_count));

			if (DXF_main_base[0].DXF_entities_mleader_count>(DXF_LE_MLEADER-1))
			{

				ui->DXF_MLEADER->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_MLEADER->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_MLEADERSTYLE->setText(QString::number(DXF_main_base[0].DXF_entities_mleaderstyle_count));

			if (DXF_main_base[0].DXF_entities_mleaderstyle_count>(DXF_LE_MLEADERSTYLE-1))
			{

				ui->DXF_MLEADERSTYLE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_MLEADERSTYLE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_MTEXT->setText(QString::number(DXF_main_base[0].DXF_entities_mtext_count));

			if (DXF_main_base[0].DXF_entities_mtext_count>(DXF_LE_MTEXT-1))
			{

				ui->DXF_MTEXT->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_MTEXT->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_OLEFRAME->setText(QString::number(DXF_main_base[0].DXF_entities_oleframe_count));

			if (DXF_main_base[0].DXF_entities_oleframe_count>(DXF_LE_OLEFRAME-1))
			{

				ui->DXF_OLEFRAME->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_OLEFRAME->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_OLE2FRAME->setText(QString::number(DXF_main_base[0].DXF_entities_ole2frame_count));

			if (DXF_main_base[0].DXF_entities_ole2frame_count>(DXF_LE_OLE2FRAME-1))
			{

				ui->DXF_OLE2FRAME->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_OLE2FRAME->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_POINT->setText(QString::number(DXF_main_base[0].DXF_entities_point_count));

			if (DXF_main_base[0].DXF_entities_point_count>(DXF_LE_POINT-1))
			{

				ui->DXF_POINT->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_POINT->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_POLYLINE->setText(QString::number(DXF_main_base[0].DXF_entities_polyline_count));

			if (DXF_main_base[0].DXF_entities_polyline_count>(DXF_LE_POLYLINE-1))
			{

				ui->DXF_POLYLINE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_POLYLINE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_RAY->setText(QString::number(DXF_main_base[0].DXF_entities_ray_count));

			if (DXF_main_base[0].DXF_entities_ray_count>(DXF_LE_RAY-1))
			{

				ui->DXF_RAY->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_RAY->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_REGION->setText(QString::number(DXF_main_base[0].DXF_entities_region_count));

			if (DXF_main_base[0].DXF_entities_region_count>(DXF_LE_REGION-1))
			{

				ui->DXF_REGION->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_REGION->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_SECTION->setText(QString::number(DXF_main_base[0].DXF_entities_section_count));

			if (DXF_main_base[0].DXF_entities_section_count>(DXF_LE_SECTION-1))
			{

				ui->DXF_SECTION->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_SECTION->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_SEQEND->setText(QString::number(DXF_main_base[0].DXF_entities_seqend_count));

			if (DXF_main_base[0].DXF_entities_seqend_count>(DXF_LE_SEQEND-1))
			{

				ui->DXF_SEQEND->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_SEQEND->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_SHAPE->setText(QString::number(DXF_main_base[0].DXF_entities_shape_count));

			if (DXF_main_base[0].DXF_entities_shape_count>(DXF_LE_SHAPE-1))
			{

				ui->DXF_SHAPE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_SHAPE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_SOLID->setText(QString::number(DXF_main_base[0].DXF_entities_solid_count));

			if (DXF_main_base[0].DXF_entities_solid_count>(DXF_LE_SOLID-1))
			{

				ui->DXF_SOLID->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_SOLID->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_SPLINE->setText(QString::number(DXF_main_base[0].DXF_entities_spline_count));

			if (DXF_main_base[0].DXF_entities_spline_count>(DXF_LE_SPLINE-1))
			{

				ui->DXF_SPLINE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_SPLINE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_SUN->setText(QString::number(DXF_main_base[0].DXF_entities_sun_count));

			if (DXF_main_base[0].DXF_entities_sun_count>(DXF_LE_SUN-1))
			{

				ui->DXF_SUN->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_SUN->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_SURFACE->setText(QString::number(DXF_main_base[0].DXF_entities_surface_count));

			if (DXF_main_base[0].DXF_entities_surface_count>(DXF_LE_SURFACE-1))
			{

				ui->DXF_SURFACE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_SURFACE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_TABLE->setText(QString::number(DXF_main_base[0].DXF_entities_table_count));

			if (DXF_main_base[0].DXF_entities_table_count>(DXF_LE_TABLE-1))
			{

				ui->DXF_TABLE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_TABLE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_TEXT->setText(QString::number(DXF_main_base[0].DXF_entities_text_count));

			if (DXF_main_base[0].DXF_entities_text_count>(DXF_LE_TEXT-1))
			{

				ui->DXF_TEXT->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_TEXT->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_TOLERANCE->setText(QString::number(DXF_main_base[0].DXF_entities_tolerance_count));

			if (DXF_main_base[0].DXF_entities_tolerance_count>(DXF_LE_TOLERANCE-1))
			{

				ui->DXF_TOLERANCE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_TOLERANCE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_TRACE->setText(QString::number(DXF_main_base[0].DXF_entities_trace_count));

			if (DXF_main_base[0].DXF_entities_trace_count>(DXF_LE_TRACE-1))
			{

				ui->DXF_TRACE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_TRACE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_UNDERLAY->setText(QString::number(DXF_main_base[0].DXF_entities_underlay_count));

			if (DXF_main_base[0].DXF_entities_underlay_count>(DXF_LE_UNDERLAY-1))
			{

				ui->DXF_UNDERLAY->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_UNDERLAY->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_VERTEX->setText(QString::number(DXF_main_base[0].DXF_entities_vertex_count));

			if (DXF_main_base[0].DXF_entities_vertex_count>(DXF_LE_VERTEX-1))
			{

				ui->DXF_VERTEX->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_VERTEX->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_VIEWPORT->setText(QString::number(DXF_main_base[0].DXF_entities_viewport_count));

			if (DXF_main_base[0].DXF_entities_viewport_count>(DXF_LE_VIEWPORT-1))
			{

				ui->DXF_VIEWPORT->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_VIEWPORT->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_WIPEOUT->setText(QString::number(DXF_main_base[0].DXF_entities_wipeout_count));

			if (DXF_main_base[0].DXF_entities_wipeout_count>(DXF_LE_WIPEOUT-1))
			{

				ui->DXF_WIPEOUT->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_WIPEOUT->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}

			ui->DXF_XLINE->setText(QString::number(DXF_main_base[0].DXF_entities_xline_count));

			if (DXF_main_base[0].DXF_entities_xline_count>(DXF_LE_XLINE-1))
			{

				ui->DXF_XLINE->setStyleSheet("QLineEdit { background-color:rgb(255,0,0)}");
			}
			else
			{
				ui->DXF_XLINE->setStyleSheet("QLineEdit { background-color:rgb(7,200,4)}");
			}



		}
		else
		{
			log_file.append("not a DXF file, load other file or try a other option \n");
		}

	}
	ui->dxf_log->setPlainText(log_file);

	status1="file ";
	status1.append(FileName);
	status1.append(" into table");
	ui->statusBar->showMessage(status1);

	DXF_Block_table();

}

void DXFtoQET_MainWindow::on_cload_cvs_into_tables_clicked()
{
	split_csv CSV_splt(this);


	if (main_sw2==1)
	{
		log_file.append("load CSV file into specific table \n");

		log_split=CSV_splt.split_CSV_table();

		log_file.append(log_split);

		ui->dxf_log->setPlainText(log_file);

		CSV_Load_QTable();

		status1="CSV file ";
		status1.append(FileName);
		status1.append(" into table");
		ui->statusBar->showMessage(status1);


	}
	else
	{
		log_file.append("not a CSV file, load other file or try a other option \n");
	}

}

void DXFtoQET_MainWindow::CSV_Load_QTable()
{

	//extern DXF_base DXF_main_base[1];

	ui->CSV_header_row->setText("1");
	ui->CSV_split_at_line->setText("30");
	ui->CSV_start_at_line->setText("2");


	ui->csv_header_bask_color->addItem("none");
	ui->csv_header_bask_color->addItem("black");
	ui->csv_header_bask_color->addItem("white");
	ui->csv_header_bask_color->addItem("red");
	ui->csv_header_bask_color->addItem("green");
	ui->csv_header_bask_color->addItem("blue");
	ui->csv_header_bask_color->addItem("gray");
	ui->csv_header_bask_color->addItem("cyan");
	ui->csv_header_bask_color->addItem("orange");
	ui->csv_header_bask_color->addItem("purple");
	ui->csv_header_bask_color->addItem("magenta");
	ui->csv_header_bask_color->addItem("brun");
	ui->csv_header_bask_color->addItem("yello");
	ui->csv_header_bask_color->addItem("lightgray");


	CSV_line_count=DXF_main_base[0].dxf_csv_line_count;

	model = new QStandardItemModel(CSV_line_count,20,this);

	ui->CSV_tableView->setModel(model);

	for (int row=0 ; row < CSV_line_count; row++)
	{

		for (int col=0; col< 20; col++)
		{
			QModelIndex index = model->index(row,col,QModelIndex());

			model->setData(index,DXF_main_base[0].dxf_csv_split[row][col]);

			ui->CSV_tableView->show();

		}

	}

	// laad lege settings in CSV_Tablesettings

	model2 = new QStandardItemModel(6,21,this);

	ui->CSV_Tablesettings->setModel(model2);

	List2.append("index");
	for (int xcol=1;xcol<21;xcol++)
	{
		List2.append(QString::number(xcol));

	}

	model2->setHorizontalHeaderLabels(List2);


		for (int col=1; col< 21; col++)
		{
			QModelIndex index = model2->index(0,col,QModelIndex());
			model2->setData(index,"100");

			index = model2->index(1,col,QModelIndex());
			model2->setData(index,"20");

			index = model2->index(2,col,QModelIndex());
			model2->setData(index,"6");

			index = model2->index(3,col,QModelIndex());
			model2->setData(index,"1");

			index = model2->index(4,col,QModelIndex());
			model2->setData(index,"0");

			index = model2->index(5,col,QModelIndex());
			model2->setData(index,"none");

			ui->CSV_Tablesettings->show();

		}






	QModelIndex index = model2->index(0,0,QModelIndex());
	model2->setData(index,"Colum width");

	index = model2->index(1,0,QModelIndex());
	model2->setData(index,"Row height");

	index = model2->index(2,0,QModelIndex());
	model2->setData(index,"Text height");

	index = model2->index(3,0,QModelIndex());
	model2->setData(index,"Use colum");

	index = model2->index(4,0,QModelIndex());
	model2->setData(index,"Text rotation");

	index = model2->index(5,0,QModelIndex());
	model2->setData(index,"Background color");


	ui->CSV_Tablesettings->resizeColumnsToContents();

	ui->CSV_Tablesettings->show();

}

void DXFtoQET_MainWindow::on_CSV_create_elmt_clicked()
{

	Result4="";

	csv_create_elmt NewCSV;

	for (CSV_row=0; CSV_row<6;CSV_row++)
	{

		for(CSV_col=0;CSV_col<20;CSV_col++)
		{

			model4 = ui->CSV_Tablesettings->model();
			QModelIndex idx2 = model4->index(CSV_row, CSV_col);
			DXF_main_base[0].csv_table_settings[CSV_row][CSV_col]= model4->data(idx2).toString();

		}

		DXF_main_base[0].csv_header=ui->CSV_header_row->text().toInt();

		DXF_main_base[0].csv_start=ui->CSV_start_at_line->text().toInt();

		DXF_main_base[0].csv_split=ui->CSV_split_at_line->text().toInt();

		DXF_main_base[0].csv_header_background=ui->csv_header_bask_color->currentText();

	}

	Result4=NewCSV.Make_ELMT();

	ui->ELMT_result->setPlainText(Result4);

	status1="CSV file ";
	status1.append(FileName);
	status1.append(" created as ELMT");
	ui->statusBar->showMessage(status1);


}

void DXFtoQET_MainWindow::on_CSV_create_qet_clicked()
{

}

void DXFtoQET_MainWindow::on_create_elmt_clicked()
{
	Result ="";


		if (DXF_main_base[0].DXF_file_loaded_into_table==1)
		{
			log_file.append("DXF file coverting to ELMT \n");
			ui->dxf_log->setPlainText(log_file);

			DXF_create_elmt make_new_ELMT;

			Result = make_new_ELMT.Make_ELMT();

			ui->ELMT_result->setPlainText(Result);

			status1="file ";
			status1.append(FileName);
			status1.append(" created as ELMT");
			ui->statusBar->showMessage(status1);
		}
		else
		{
			log_file.append("DXF file NOT loaded into tables \n");
			log_file.append("click on load DXF into tables \n");
			ui->dxf_log->setPlainText(log_file);

		}

}

void DXFtoQET_MainWindow::on_pushButton_clicked()
{
	DXF_main_base[0].DXF_ELMT_Name_text_ar=ui->elmt_lang_ar->text();
	DXF_main_base[0].DXF_ELMT_Name_text_be_nl=ui->elmt_lang_be_nl->text();
	DXF_main_base[0].DXF_ELMT_Name_text_cs=ui->elmt_lang_cs->text();
	DXF_main_base[0].DXF_ELMT_Name_text_de=ui->elmt_lang_de->text();
	DXF_main_base[0].DXF_ELMT_Name_text_en=ui->elmt_lang_en->text();
	DXF_main_base[0].DXF_ELMT_Name_text_es=ui->elmt_lang_es->text();
	DXF_main_base[0].DXF_ELMT_Name_text_fr=ui->elmt_lang_fr->text();
	DXF_main_base[0].DXF_ELMT_Name_text_it=ui->elmt_lang_it->text();
	DXF_main_base[0].DXF_ELMT_Name_text_nl=ui->elmt_lang_nl->text();
	DXF_main_base[0].DXF_ELMT_Name_text_pl=ui->elmt_lang_pl->text();

}

void DXFtoQET_MainWindow::on_savepath_clicked()
{
	DXF_main_base[0].dxf_savepath = QFileDialog::getExistingDirectory(this, tr("Open Directory"),DXF_main_base[0].dxf_dir ,QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);

	ui->dxf_file_path_save->setText(DXF_main_base[0].dxf_savepath);




}

void DXFtoQET_MainWindow::DXF_Block_table()
{

	model3=new QStandardItemModel(200,46,this);
	ui->Block_Items_2->setModel(model3);

	QModelIndex index3;
	for(int row= 0; row < 200; row++)
	{
		for(int col= 0; col < 46; col++)
		{
			index3 = model3->index(row,col,QModelIndex());
			model3->setData(index3,QString(" "));

		}
	}

	ui->Block_Items_2->show();

	List3.append("Block n°");

	List3.append("3dface");
	List3.append("3dsolid");
	List3.append("acad_proxy_entity");
	List3.append("arc");
	List3.append("attdef");
	List3.append("attr");
	List3.append("body");
	List3.append("circle");
	List3.append("dimension");
	List3.append("ellipse");
	List3.append("hatch");
	List3.append("helix");
	List3.append("image");
	List3.append("insert");
	List3.append("leader");
	List3.append("light");
	List3.append("line");
	List3.append("lwpolyline");
	List3.append("mesh");
	List3.append("mline");
	List3.append("mleaderstyle");
	List3.append("mleader");
	List3.append("mtext");
	List3.append("oleframe");
	List3.append("oleframe2");
	List3.append("point");
	List3.append("polyline");
	List3.append("ray");
	List3.append("region");
	List3.append("section");
	List3.append("seqend");
	List3.append("shape");
	List3.append("solid");
	List3.append("spline");
	List3.append("sun");
	List3.append("surface");
	List3.append("table");
	List3.append("text");
	List3.append("tolerance");
	List3.append("trace");
	List3.append("underlay");
	List3.append("vertex");
	List3.append("viewport");
	List3.append("wipeout");
	List3.append("xline");


	/*for (int xcol=1;xcol<46;xcol++)
	{
		List3.append(QString::number(xcol));

	}*/

	model3->setHorizontalHeaderLabels(List3);


	int blockcount =0;

	for (int row2=0; row2<199;row2++)
	{

			QModelIndex index = model3->index(row2,0,QModelIndex());
			model3->setData(index,DXF_input_table_block_record[row2].dxf_table_block_record_code_2);//.remove(QRegExp("[$*+-_=#<>]")));

			//blockcount=blockcount+1;

			index = model3->index(row2,1,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_3dface_count[row2]));

			index = model3->index(row2,2,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_3dsolid_count[row2]));

			index = model3->index(row2,3,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_acad_proxy_entity_count[row2]));

			index = model3->index(row2,4,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_arc_count[row2]));

			index = model3->index(row2,5,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_attdef_count[row2]));

			index = model3->index(row2,6,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_attrib_count[row2]));

			index = model3->index(row2,7,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_body_count[row2]));

			index = model3->index(row2,8,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_circle_count[row2]));

			index = model3->index(row2,9,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_dimension_count[row2]));

			index = model3->index(row2,10,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_ellipse_count[row2]));

			index = model3->index(row2,11,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_hatch_count[row2]));

			index = model3->index(row2,12,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_helix_count[row2]));

			index = model3->index(row2,13,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_image_count[row2]));

			index = model3->index(row2,14,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_insert_count[row2]));

			index = model3->index(row2,15,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_leader_count[row2]));

			index = model3->index(row2,16,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_light_count[row2]));

			index = model3->index(row2,17,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_line_count[row2]));

			index = model3->index(row2,18,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_lwpolyline_count[row2]));

			index = model3->index(row2,19,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_mesh_count[row2]));

			index = model3->index(row2,20,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_mleaderstyle_count[row2]));

			index = model3->index(row2,21,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_mleader_count[row2]));

			index = model3->index(row2,22,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_mline_count[row2]));

			index = model3->index(row2,23,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_mtext_count[row2]));

			index = model3->index(row2,24,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_ole2frame_count[row2]));

			index = model3->index(row2,25,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_oleframe_count[row2]));

			index = model3->index(row2,26,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_point_count[row2]));

			index = model3->index(row2,27,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_polyline_count[row2]));

			index = model3->index(row2,28,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_ray_count[row2]));

			index = model3->index(row2,29,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_region_count[row2]));



			index = model3->index(row2,30,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_section_count[row2]));

			index = model3->index(row2,31,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_seqend_count[row2]));

			index = model3->index(row2,32,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_shape_count[row2]));

			index = model3->index(row2,33,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_solid_count[row2]));

			index = model3->index(row2,34,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_spline_count[row2]));

			index = model3->index(row2,35,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_sun_count[row2]));

			index = model3->index(row2,36,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_surface_count[row2]));

			index = model3->index(row2,37,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_table_count[row2]));

			index = model3->index(row2,38,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_text_count[row2]));

			index = model3->index(row2,39,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_tolerance_count[row2]));

			index = model3->index(row2,40,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_trace_count[row2]));

			index = model3->index(row2,41,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_underlay_count[row2]));

			index = model3->index(row2,42,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_vertex_count[row2]));

			index = model3->index(row2,43,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_viewport_count[row2]));

			index = model3->index(row2,44,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_wipeout_count[row2]));

			index = model3->index(row2,45,QModelIndex());
			model3->setData(index,QString::number(DXF_main_base[0].DXF_block_xline_count[row2]));

			blockcount=blockcount+1;
	}

	ui->Block_Items_2->resizeColumnsToContents();



	ui->Block_Items_2->show();




}

void DXFtoQET_MainWindow::on_savepath_2_clicked()
{
	Config_QET_User_Symbols = QFileDialog::getExistingDirectory(this, tr("Open Directory"),DXF_main_base[0].dxf_dir ,QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);

	ui->QET_user_symbole_path_save->setText(Config_QET_User_Symbols);

	DXF_main_base[0].dxf_savepath=Config_QET_User_Symbols;


}

void DXFtoQET_MainWindow::on_Save_config_file_clicked()
{
	Config_save_to_file="";

	Config_save_to_file.append("path=");
	Config_save_to_file.append(Config_QET_User_Symbols);
	Config_save_to_file.append("\n");
	Config_save_to_file.append("block_color=");
	Config_save_to_file.append(ui->Block_color->currentText());
	Config_save_to_file.append("\n");
	Config_save_to_file.append("entitie_color=");
	Config_save_to_file.append(ui->Entitie_color->currentText());
	Config_save_to_file.append("\n");
	Config_save_to_file.append("block_insert_color=");
	Config_save_to_file.append(ui->Insert_block_color->currentText());
	Config_save_to_file.append("\n");
	Config_save_to_file.append("x_factor_elmt=");
	Config_save_to_file.append(QString::number(ui->X_factor_elmt->value()));
	Config_save_to_file.append("\n");
	Config_save_to_file.append("y_factor_elmt=");
	Config_save_to_file.append(QString::number(ui->Y_factor_elmt->value()));
	Config_save_to_file.append("\n");


	QFile file( "..//DXFtoQET.cfg");

	if (!file.open(QFile::WriteOnly | QFile::Text)) {
		QMessageBox::warning(this, tr("Application"),
							 tr("Cannot write file %1:\n%2.")
							 .arg("DXFtoQET.cfg")
							 .arg(file.errorString()));
		return;
	}

	QTextStream out(&file);
	out << Config_save_to_file;

	file.close();

	DXF_main_base[0].dxf_savepath=Config_QET_User_Symbols;
	DXF_main_base[0].dxf_block_color=ui->Block_color->currentText();
	DXF_main_base[0].dxf_entitie_color=ui->Entitie_color->currentText();
	DXF_main_base[0].dxf_X_factor=ui->X_factor_elmt->value();
	DXF_main_base[0].dxf_Y_factor=ui->Y_factor_elmt->value();
	DXF_main_base[0].dxf_insert_block_color=ui->Insert_block_color->currentText();


	ui->dxf_file_path_save->setText(DXF_main_base[0].dxf_savepath);
	ui->dxf_file_path_save->show();

	ui->Block_color->setCurrentText(DXF_main_base[0].dxf_block_color);
	ui->Block_color->show();

	ui->Entitie_color->setCurrentText(DXF_main_base[0].dxf_entitie_color);
	ui->Entitie_color->show();

	ui->Insert_block_color->setCurrentText(DXF_main_base[0].dxf_insert_block_color);
	ui->Entitie_color->show();

	ui->X_factor_elmt->setValue(DXF_main_base[0].dxf_X_factor);
	ui->X_factor_elmt->show();

	ui->Y_factor_elmt->setValue(DXF_main_base[0].dxf_Y_factor);
	ui->Y_factor_elmt->show();

}

void DXFtoQET_MainWindow::on_Open_config_file_clicked()
{
	QFile file( "..//DXFtoQET.cfg");

	if (!file.open(QFile::ReadOnly | QFile::Text))
	{
		QMessageBox::warning(this, tr("Application"),
							 tr("Cannot read file %1:\n%2.")
							 .arg("DXFtoQET.cfg")
							 .arg(file.errorString()));

		on_Save_config_file_clicked();
	}

	QTextStream in(&file);

	Config_in_read_all=in.readAll();

	file.close();


	Config_list=Config_in_read_all.split("\n");

	split_lenght=Config_list.length();

	for (counter_Split=0;counter_Split<split_lenght-1;counter_Split++)
	{
		Config_List_Split=Config_list[counter_Split].split("=");

		if (Config_List_Split[0]=="path")
		{

			Config_save_to_file=Config_List_Split[1];
			Config_QET_User_Symbols=Config_List_Split[1];
			DXF_main_base[0].dxf_savepath=Config_List_Split[1];
		}

		if (Config_List_Split[0]=="block_color")
		{
			DXF_main_base[0].dxf_block_color=Config_List_Split[1];

		}

		if (Config_List_Split[0]=="entitie_color")
		{

			DXF_main_base[0].dxf_entitie_color=Config_List_Split[1];
		}

		if (Config_List_Split[0]=="block_insert_color")
		{
			DXF_main_base[0].dxf_insert_block_color=Config_List_Split[1];

		}

		if (Config_List_Split[0]=="x_factor_elmt")
		{
			DXF_main_base[0].dxf_X_factor=Config_List_Split[1].toInt();

		}

		if (Config_List_Split[0]=="y_factor_elmt")
		{
			DXF_main_base[0].dxf_Y_factor=Config_List_Split[1].toInt();


		}

	}





	ui->QET_user_symbole_path_save->setText(Config_QET_User_Symbols);
	ui->dxf_file_path_save->setText(Config_save_to_file);
	ui->dxf_file_path_save->show();
	ui->QET_user_symbole_path_save->show();

	if(Config_list.length()>4)
	{



		ui->Block_color->setCurrentText(DXF_main_base[0].dxf_block_color);
		ui->Block_color->show();

		ui->Entitie_color->setCurrentText(DXF_main_base[0].dxf_entitie_color);
		ui->Entitie_color->show();

		ui->Insert_block_color->setCurrentText(DXF_main_base[0].dxf_insert_block_color);
		ui->Insert_block_color->show();

		ui->X_factor_elmt->setValue(DXF_main_base[0].dxf_X_factor);
		ui->X_factor_elmt->show();

		ui->Y_factor_elmt->setValue(DXF_main_base[0].dxf_Y_factor);
		ui->Y_factor_elmt->show();
	}
	else
	{
		on_Save_config_file_clicked();
	}






}

void DXFtoQET_MainWindow::Clear_view()
{

	model5=new QStandardItemModel(200,46,this);
	ui->Block_Items_2->setModel(model5);



	QModelIndex index5;
	for(int row= 0; row < 200; row++)
	{
		for(int col= 0; col < 46; col++)
		{
			index5 = model5->index(row,col,QModelIndex());
			model5->setData(index5,QString(" "));

		}
	}

	//ui->Block_Items_2->QTableView.reset();

	ui->Block_Items_2->show();

	ui->ELMT_result->clear();

	ui->dxf_file_loaded->clear();

}

void DXFtoQET_MainWindow::Clear_struct()
{

	//DXF_input_table_block_record[].
}
