#ifndef DXF_DATA_H
#define DXF_DATA_H

#include <QtCore>
#include <QWidget>

// Array lenght constants
// this is the only place where the are defined
// to use them in the program

#define DXF_L_HEADER 500
#define DXF_L_CLASSES 1000
#define DXF_L_TABLES 20
#define DXF_L_BLOCK 200
#define DXF_L_ENTITIES 100000
#define DXF_L_OBJECTS 10000
#define DXF_L_THUMBNAILIMAGE 10000

#define DXF_LT_APPID 100
#define DXF_LT_BLOCK_RECORD 500
#define DXF_LT_DIMSTYLE 500
#define DXF_LT_LAYER 100
#define DXF_LT_LTYPE 100
#define DXF_LT_STYLE 100
#define DXF_LT_UCS 100
#define DXF_LT_VIEW 100
#define DXF_LT_VPORT 100

#define DXF_LB_3DFACE 100
#define DXF_LB_3DSOLID 100
#define DXF_LB_PROXY_ENTITY 100
#define DXF_LB_ARC 100
#define DXF_LB_ATTDEF 100
#define DXF_LB_ATTRIB 100
#define DXF_LB_BODY 100
#define DXF_LB_CIRCLE 100
#define DXF_LB_DIMENSION 100
#define DXF_LB_ELLIPSE 100
#define DXF_LB_HATCH 100
#define DXF_LB_HELIX 100
#define DXF_LB_IMAGE 100
#define DXF_LB_INSERT 100
#define DXF_LB_LEADER 100
#define DXF_LB_LIGHT 100
#define DXF_LB_LINE 5000
#define DXF_LB_LWPOLYLINE 100
#define DXF_LB_MESH 100
#define DXF_LB_MLINE 100
#define DXF_LB_MLEADERSTYLE 100
#define DXF_LB_MLEADER 100
#define DXF_LB_MTEXT 100
#define DXF_LB_OLEFRAME 100
#define DXF_LB_OLE2FRAME 100
#define DXF_LB_POINT 100
#define DXF_LB_POLYLINE 100
#define DXF_LB_RAY 100
#define DXF_LB_REGION 100
#define DXF_LB_SECTION 100
#define DXF_LB_SEQEND 100
#define DXF_LB_SHAPE 100
#define DXF_LB_SOLID 100
#define DXF_LB_SPLINE 100
#define DXF_LB_SUN 100
#define DXF_LB_SURFACE 100
#define DXF_LB_TABLE 100
#define DXF_LB_TEXT 100
#define DXF_LB_TOLERANCE 100
#define DXF_LB_TRACE 100
#define DXF_LB_UNDERLAY 100
#define DXF_LB_VERTEX 500
#define DXF_LB_VIEWPORT 100
#define DXF_LB_WIPEOUT 100
#define DXF_LB_XLINE 100

#define DXF_LE_3DFACE 1000
#define DXF_LE_3DSOLID 1000
#define DXF_LE_PROXY_ENTITY 1000
#define DXF_LE_ARC 1000
#define DXF_LE_ATTDEF 1000
#define DXF_LE_ATTRIB 1000
#define DXF_LE_BODY 1000
#define DXF_LE_CIRCLE 1000
#define DXF_LE_DIMENSION 1000
#define DXF_LE_ELLIPSE 1000
#define DXF_LE_HATCH 1000
#define DXF_LE_HELIX 1000
#define DXF_LE_IMAGE 1000
#define DXF_LE_INSERT 1000
#define DXF_LE_LEADER 1000
#define DXF_LE_LIGHT 1000
#define DXF_LE_LINE 100000
#define DXF_LE_LWPOLYLINE 1000
#define DXF_LE_MESH 1000
#define DXF_LE_MLINE 1000
#define DXF_LE_MLEADERSTYLE 1000
#define DXF_LE_MLEADER 1000
#define DXF_LE_MTEXT 1000
#define DXF_LE_OLEFRAME 1000
#define DXF_LE_OLE2FRAME 1000
#define DXF_LE_POINT 1000
#define DXF_LE_POLYLINE 1000
#define DXF_LE_RAY 1000
#define DXF_LE_REGION 1000
#define DXF_LE_SECTION 1000
#define DXF_LE_SEQEND 1000
#define DXF_LE_SHAPE 1000
#define DXF_LE_SOLID 1000
#define DXF_LE_SPLINE 1000
#define DXF_LE_SUN 1000
#define DXF_LE_SURFACE 1000
#define DXF_LE_TABLE 1000
#define DXF_LE_TEXT 1000
#define DXF_LE_TOLERANCE 1000
#define DXF_LE_TRACE 1000
#define DXF_LE_UNDERLAY 1000
#define DXF_LE_VERTEX 50000
#define DXF_LE_VIEWPORT 1000
#define DXF_LE_WIPEOUT 1000
#define DXF_LE_XLINE 1000



//#include <QtWidgets>


	struct DXF_file_input
	{
		QString dxf_code1;
		QString dxf_code2;

	};


	struct DXF_header
	{
		QString dxf_setvar_naam;
		QString dxf_setvar_code_1;
		QString dxf_setvar_code_2;
		QString dxf_setvar_code_3;
		QString dxf_setvar_code_5;
		QString dxf_setvar_code_6;
		QString dxf_setvar_code_7;
		QString dxf_setvar_code_8;

		double dxf_setvar_code_10;
		double dxf_setvar_code_20;
		double dxf_setvar_code_30;
		double dxf_setvar_code_40;
		double dxf_setvar_code_50;

		int16_t dxf_setvar_code_62;
		int16_t dxf_setvar_code_70;

		int64_t dxf_setvar_code_160;

		int16_t dxf_setvar_code_280;

		QString dxf_setvar_code_290;

		QString dxf_setvar_code_345;
		QString dxf_setvar_code_346;
		QString dxf_setvar_code_347;
		QString dxf_setvar_code_349;

		int16_t dxf_setvar_code_370;
		int16_t dxf_setvar_code_380;

		QString dxf_setvar_code_390;


	};

	struct DXF_classes
	{
		QString dxf_class_code_1;
		QString dxf_class_code_2;
		QString dxf_class_code_3;

		int32_t dxf_class_code_90;
		int32_t dxf_class_code_91;

		int16_t dxf_class_code_280;
		int16_t dxf_class_code_281;


	};

	struct DXF_tables
	{
		QString dxf_tables_code_5;

		int16_t dxf_tables_code_70;
		int16_t dxf_tables_code_71;

		QString dxf_tables_code_100[2];
		QString dxf_tables_code_102[2];

		QString dxf_tables_code_330;
		QString dxf_tables_code_340[2];

		QString dxf_tables_code_360;


	};

	struct DXF_table_appid
	{

		QString dxf_table_appid_code_2;
		QString dxf_table_appid_code_5;

		int16_t dxf_table_appid_code_70;

		QString dxf_table_appid_code_100[2];

		QString dxf_table_appid_code_330;
		QString dxf_table_appid_code_340;
		QString dxf_table_appid_code_360;


	};

	struct DXF_table_block_record
	{

		QString dxf_table_block_record_code_2;
		QString dxf_table_block_record_code_5;

		int16_t dxf_table_block_record_code_70;

		QString dxf_table_block_record_code_100[2];
		QString dxf_table_block_record_code_102[2];

		int16_t dxf_table_block_record_code_280;
		int16_t dxf_table_block_record_code_281;

		QString dxf_table_block_record_code_330;
		QString dxf_table_block_record_code_331[20];

		QString dxf_table_block_record_code_340;
		QString dxf_table_block_record_code_360;

	};

	struct DXF_table_dimstyle
	{

		QString dxf_table_dimstyle_2;
		QString dxf_table_dimstyle_3;
		QString dxf_table_dimstyle_4;
		QString dxf_table_dimstyle_5;
		QString dxf_table_dimstyle_6;
		QString dxf_table_dimstyle_7;

		double dxf_table_dimstyle_40;
		double dxf_table_dimstyle_41;
		double dxf_table_dimstyle_42;
		double dxf_table_dimstyle_43;
		double dxf_table_dimstyle_44;
		double dxf_table_dimstyle_45;
		double dxf_table_dimstyle_46;
		double dxf_table_dimstyle_47;
		double dxf_table_dimstyle_48;

		int16_t dxf_table_dimstyle_70;
		int16_t dxf_table_dimstyle_71;
		int16_t dxf_table_dimstyle_72;
		int16_t dxf_table_dimstyle_73;
		int16_t dxf_table_dimstyle_74;
		int16_t dxf_table_dimstyle_75;
		int16_t dxf_table_dimstyle_76;
		int16_t dxf_table_dimstyle_77;
		int16_t dxf_table_dimstyle_78;

		QString dxf_table_dimstyle_100[2];

		QString dxf_table_dimstyle_105;

		double dxf_table_dimstyle_140;
		double dxf_table_dimstyle_141;
		double dxf_table_dimstyle_142;
		double dxf_table_dimstyle_143;
		double dxf_table_dimstyle_144;
		double dxf_table_dimstyle_145;
		double dxf_table_dimstyle_146;
		double dxf_table_dimstyle_147;

		int16_t dxf_table_dimstyle_170;
		int16_t dxf_table_dimstyle_171;
		int16_t dxf_table_dimstyle_172;
		int16_t dxf_table_dimstyle_173;
		int16_t dxf_table_dimstyle_174;
		int16_t dxf_table_dimstyle_175;
		int16_t dxf_table_dimstyle_176;
		int16_t dxf_table_dimstyle_177;
		int16_t dxf_table_dimstyle_178;

		int16_t dxf_table_dimstyle_270;
		int16_t dxf_table_dimstyle_271;
		int16_t dxf_table_dimstyle_272;
		int16_t dxf_table_dimstyle_273;
		int16_t dxf_table_dimstyle_274;
		int16_t dxf_table_dimstyle_275;
		int16_t dxf_table_dimstyle_278;

		int16_t dxf_table_dimstyle_280;
		int16_t dxf_table_dimstyle_281;
		int16_t dxf_table_dimstyle_282;
		int16_t dxf_table_dimstyle_283;
		int16_t dxf_table_dimstyle_284;
		int16_t dxf_table_dimstyle_285;
		int16_t dxf_table_dimstyle_286;
		int16_t dxf_table_dimstyle_287;
		int16_t dxf_table_dimstyle_288;

		QString dxf_table_dimstyle_330;
		QString dxf_table_dimstyle_340;

		QString dxf_table_dimstyle_1000;
		QString dxf_table_dimstyle_1001[3];
		QString dxf_table_dimstyle_1002[2];

		double dxf_table_dimstyle_1040;

		int16_t dxf_table_dimstyle_1070[5];


	};

	struct DXF_table_layer
	{

		QString dxf_table_layer_code_2;
		QString dxf_table_layer_code_5;
		QString dxf_table_layer_code_6;

		int16_t dxf_table_layer_code_62;
		int16_t dxf_table_layer_code_70;

		QString dxf_table_layer_code_100[2];
		QString dxf_table_layer_code_102[2];

		bool dxf_table_layer_code_290;

		QString dxf_table_layer_code_330;

		QString dxf_table_layer_code_347;
		QString dxf_table_layer_code_348;

		QString dxf_table_layer_code_360;

		int16_t dxf_table_layer_code_370;

		QString dxf_table_layer_code_390;

		QString dxf_table_layer_code_1000[2];
		QString dxf_table_layer_code_1001;


	};

	struct DXF_table_ltype
	{

		QString dxf_table_ltype_code_2;
		QString dxf_table_ltype_code_3;
		QString dxf_table_ltype_code_5;

		double dxf_table_ltype_code_40;
		double dxf_table_ltype_code_49[4];

		int16_t dxf_table_ltype_code_70;
		int16_t dxf_table_ltype_code_72;
		int16_t dxf_table_ltype_code_73;
		int16_t dxf_table_ltype_code_74[5];

		QString dxf_table_ltype_code_100[4];

		QString dxf_table_ltype_code_330;


	};

	struct DXF_table_style
	{

		QString dxf_table_style_code_2;
		QString dxf_table_style_code_3;
		QString dxf_table_style_code_4;
		QString dxf_table_style_code_5;

		double dxf_table_style_code_40;
		double dxf_table_style_code_41;
		double dxf_table_style_code_42;

		double dxf_table_style_code_50;

		int16_t dxf_table_style_code_70;
		int16_t dxf_table_style_code_71;

		QString dxf_table_style_code_100[2];

		QString dxf_table_style_code_330;

		QString dxf_table_style_code_1000[2];
		QString dxf_table_style_code_1001[2];
		QString dxf_table_style_code_1002[2];

		int16_t dxf_table_style_code_1070[2];

		int32_t dxf_table_style_code_1071;


	};

	struct DXF_table_ucs
	{
		QString dxf_table_ucs_code_5;

		int16_t dxf_table_ucs_code_70;

		QString dxf_table_ucs_code_100[2];

		QString dxf_table_ucs_code_330;


	};

	struct DXF_table_view
	{

		QString dxf_table_view_code_2;
		QString dxf_table_view_code_5;

		double dxf_table_view_code_11;
		double dxf_table_view_code_12;
		double dxf_table_view_code_13;
		double dxf_table_view_code_14;
		double dxf_table_view_code_15;
		double dxf_table_view_code_16;
		double dxf_table_view_code_17;

		double dxf_table_view_code_21;
		double dxf_table_view_code_22;
		double dxf_table_view_code_23;
		double dxf_table_view_code_24;
		double dxf_table_view_code_25;
		double dxf_table_view_code_26;
		double dxf_table_view_code_27;

		int16_t dxf_table_view_code_70;

		QString dxf_table_view_code_100[2];

		QString dxf_table_view_code_330;


	};

	struct DXF_table_vport
	{
		QString dxf_table_vport_code_0;
		QString dxf_table_vport_code_2;
		QString dxf_table_vport_code_5;


		double dxf_table_vport_code_10;
		double dxf_table_vport_code_11;
		double dxf_table_vport_code_12;
		double dxf_table_vport_code_13;
		double dxf_table_vport_code_14;
		double dxf_table_vport_code_15;
		double dxf_table_vport_code_16;
		double dxf_table_vport_code_17;

		double dxf_table_vport_code_20;
		double dxf_table_vport_code_21;
		double dxf_table_vport_code_22;
		double dxf_table_vport_code_23;
		double dxf_table_vport_code_24;
		double dxf_table_vport_code_25;
		double dxf_table_vport_code_26;
		double dxf_table_vport_code_27;

		double dxf_table_vport_code_30;
		double dxf_table_vport_code_31;
		double dxf_table_vport_code_32;
		double dxf_table_vport_code_33;
		double dxf_table_vport_code_34;
		double dxf_table_vport_code_35;
		double dxf_table_vport_code_36;
		double dxf_table_vport_code_37;

		double dxf_table_vport_code_40;
		double dxf_table_vport_code_41;
		double dxf_table_vport_code_42;
		double dxf_table_vport_code_43;
		double dxf_table_vport_code_44;

		double dxf_table_vport_code_50;
		double dxf_table_vport_code_51;

		int16_t dxf_table_vport_code_60;
		int16_t dxf_table_vport_code_61;
		int16_t dxf_table_vport_code_62;
		int16_t dxf_table_vport_code_63;
		int16_t dxf_table_vport_code_64;
		int16_t dxf_table_vport_code_65;

		int16_t dxf_table_vport_code_70;
		int16_t dxf_table_vport_code_71;
		int16_t dxf_table_vport_code_72;
		int16_t dxf_table_vport_code_73;
		int16_t dxf_table_vport_code_74;
		int16_t dxf_table_vport_code_75;
		int16_t dxf_table_vport_code_76;
		int16_t dxf_table_vport_code_77;
		int16_t dxf_table_vport_code_78;
		int16_t dxf_table_vport_code_79;

		QString dxf_table_vport_code_100[2];
		QString dxf_table_vport_code_102[2];

		double dxf_table_vport_code_110;
		double dxf_table_vport_code_111;
		double dxf_table_vport_code_112;

		double dxf_table_vport_code_120;
		double dxf_table_vport_code_121;
		double dxf_table_vport_code_122;

		double dxf_table_vport_code_130;
		double dxf_table_vport_code_131;
		double dxf_table_vport_code_132;

		double dxf_table_vport_code_141;
		double dxf_table_vport_code_142;
		double dxf_table_vport_code_143;
		double dxf_table_vport_code_144;
		double dxf_table_vport_code_145;
		double dxf_table_vport_code_146;


		double dxf_table_vport_code_281;
		double dxf_table_vport_code_282;

		bool dxf_table_vport_code_292;

		QString dxf_table_vport_code_330;
		QString dxf_table_vport_code_360;

		QString dxf_table_vport_code_348;

		int32_t dxf_table_vport_code_421;

		QString dxf_table_vport_code_1001;

		int16_t dxf_table_vport_code_1070;

	};

	struct DXF_block
	{

		QString DXF_block_code_1;
		QString DXF_block_code_2;
		QString DXF_block_code_3;
		QString DXF_block_code_4;
		QString DXF_block_code_5;
		QString DXF_block_code_6;
		QString DXF_block_code_8;

		double DXF_block_code_10;
		double DXF_block_code_20;
		double DXF_block_code_30;

		int DXF_block_code_62;
		int DXF_block_code_67;
		int DXF_block_code_70;

		QString DXF_block_code_100[2];
		QString DXF_block_code_102[2];

		QString DXF_block_code_330;



	};

	struct DXF_end_block
	{

		QString DXF_end_block_code_1;
		QString DXF_end_block_code_2;
		QString DXF_end_block_code_3;
		QString DXF_end_block_code_4;
		QString DXF_end_block_code_5;
		QString DXF_end_block_code_8;

		double DXF_end_block_code_10;
		double DXF_end_block_code_20;
		double DXF_end_block_code_30;

		int16_t DXF_end_block_code_67;
		int16_t DXF_end_block_code_70;

		QString DXF_end_block_code_100[2];
		QString DXF_end_block_code_102[2];

		QString DXF_end_block_code_330;



	};

	struct DXF_entities
	{

	};

	struct DXF_objects
	{

	};

	struct DXF_thumbnailimage
	{

	};

	struct DXF_base
	{
		QString Color_entitie;
		QString Color_block;
		QString Color_insert_block;


		QString dxf_openfile;
		QString dxf_dir;
		QString dxf_filepath;
		QString dxf_text_all;
		QString dxf_filetype;
		QString dxf_savepath;
		QString dxf_block_color;
		QString dxf_element_color;
		QString dxf_insert_block_color;

		//QString dxf_block_color;
		QString dxf_entitie_color;
		int dxf_X_factor;
		int dxf_Y_factor;



		QStringList dxf_input;

		QString dxf_csv_split[10000][20];
		int dxf_csv_line_count;
		QString csv_table_settings[6][20];
		QString Elmt_list[500];
		QString csv_header_background;

		int csv_header;
		int csv_start;
		int csv_split;

		int csv_count_elmt;

		int32_t dxf_line_count;

		int dxf_header_item_count;
		int dxf_classes_item_count;
		int dxf_tables_item_count;
		int dxf_block_item_count;
		int dxf_entites_item_count;
		int dxf_objects_item_count;
		int dxf_thumbnailimage_item_count;

		int DXF_table_appid_count;
		int DXF_table_block_record_count;
		int DXF_table_dimstyle_count;
		int DXF_table_layer_count;
		int DXF_table_ltype_count;
		int DXF_table_style_count;
		int DXF_table_ucs_count;
		int DXF_table_view_count;
		int DXF_table_vport_count;

		int32_t DXF_block_3dface_count[100];
		int32_t DXF_block_3dsolid_count[100];
		int32_t DXF_block_acad_proxy_entity_count[100];
		int32_t DXF_block_arc_count[100];
		int32_t DXF_block_attdef_count[100];
		int32_t DXF_block_attrib_count[100];
		int32_t DXF_block_body_count[100];
		int32_t DXF_block_circle_count[100];
		int32_t DXF_block_dimension_count[100];
		int32_t DXF_block_ellipse_count[100];
		int32_t DXF_block_hatch_count[100];
		int32_t DXF_block_helix_count[100];
		int32_t DXF_block_image_count[100];
		int32_t DXF_block_insert_count[100];
		int32_t DXF_block_leader_count[100];
		int32_t DXF_block_light_count[100];
		int32_t DXF_block_line_count[100];
		int32_t DXF_block_lwpolyline_count[100];
		int32_t DXF_block_mesh_count[100];
		int32_t DXF_block_mline_count[100];
		int32_t DXF_block_mleaderstyle_count[100];
		int32_t DXF_block_mleader_count[100];
		int32_t DXF_block_mtext_count[100];
		int32_t DXF_block_oleframe_count[100];
		int32_t DXF_block_ole2frame_count[100];
		int32_t DXF_block_point_count[100];
		int32_t DXF_block_polyline_count[100];
		int32_t DXF_block_ray_count[100];
		int32_t DXF_block_region_count[100];
		int32_t DXF_block_section_count[100];
		int32_t DXF_block_seqend_count[100];
		int32_t DXF_block_shape_count[100];
		int32_t DXF_block_solid_count[100];
		int32_t DXF_block_spline_count[100];
		int32_t DXF_block_sun_count[100];
		int32_t DXF_block_surface_count[100];
		int32_t DXF_block_table_count[100];
		int32_t DXF_block_text_count[100];
		int32_t DXF_block_tolerance_count[100];
		int32_t DXF_block_trace_count[100];
		int32_t DXF_block_underlay_count[100];
		int32_t DXF_block_vertex_count[100];
		int32_t DXF_block_viewport_count[100];
		int32_t DXF_block_wipeout_count[100];
		int32_t DXF_block_xline_count[100];

		int32_t DXF_entities_3dface_count ;
		int32_t DXF_entities_3dsolid_count ;
		int32_t DXF_entities_acad_proxy_entity_count ;
		int32_t DXF_entities_arc_count ;
		int32_t DXF_entities_attdef_count ;
		int32_t DXF_entities_attrib_count ;
		int32_t DXF_entities_body_count ;
		int32_t DXF_entities_circle_count ;
		int32_t DXF_entities_dimension_count ;
		int32_t DXF_entities_ellipse_count ;
		int32_t DXF_entities_hatch_count ;
		int32_t DXF_entities_helix_count ;
		int32_t DXF_entities_image_count ;
		int32_t DXF_entities_insert_count ;
		int32_t DXF_entities_leader_count ;
		int32_t DXF_entities_light_count ;
		int32_t DXF_entities_line_count ;
		int32_t DXF_entities_lwpolyline_count ;
		int32_t DXF_entities_mesh_count ;
		int32_t DXF_entities_mline_count ;
		int32_t DXF_entities_mleaderstyle_count ;
		int32_t DXF_entities_mleader_count ;
		int32_t DXF_entities_mtext_count ;
		int32_t DXF_entities_oleframe_count ;
		int32_t DXF_entities_ole2frame_count ;
		int32_t DXF_entities_point_count ;
		int32_t DXF_entities_polyline_count ;
		int32_t DXF_entities_ray_count ;
		int32_t DXF_entities_region_count ;
		int32_t DXF_entities_section_count ;
		int32_t DXF_entities_seqend_count ;
		int32_t DXF_entities_shape_count ;
		int32_t DXF_entities_solid_count ;
		int32_t DXF_entities_spline_count ;
		int32_t DXF_entities_sun_count ;
		int32_t DXF_entities_surface_count ;
		int32_t DXF_entities_table_count ;
		int32_t DXF_entities_text_count ;
		int32_t DXF_entities_tolerance_count ;
		int32_t DXF_entities_trace_count ;
		int32_t DXF_entities_underlay_count ;
		int32_t DXF_entities_vertex_count ;
		int32_t DXF_entities_viewport_count ;
		int32_t DXF_entities_wipeout_count ;
		int32_t DXF_entities_xline_count ;

		QString DXF_ELMT_Name_text_en;
		QString DXF_ELMT_Name_text_fr;
		QString DXF_ELMT_Name_text_de;
		QString DXF_ELMT_Name_text_ar;
		QString DXF_ELMT_Name_text_it;
		QString DXF_ELMT_Name_text_pl;
		QString DXF_ELMT_Name_text_nl;
		QString DXF_ELMT_Name_text_be_nl;
		QString DXF_ELMT_Name_text_es;
		QString DXF_ELMT_Name_text_cs;

		int DXF_file_loaded_into_table;

	} ;


	struct DXF_block_3dface
	{
		QString DXF_block_3dface_code_5;
		QString DXF_block_3dface_code_6;
		QString DXF_block_3dface_code_8;

		double DXF_block_3dface_code_10;
		double DXF_block_3dface_code_11;
		double DXF_block_3dface_code_12;
		double DXF_block_3dface_code_13;
		double DXF_block_3dface_code_14[5];


		double DXF_block_3dface_code_20;
		double DXF_block_3dface_code_21;
		double DXF_block_3dface_code_22;
		double DXF_block_3dface_code_23;
		double DXF_block_3dface_code_24[5];

		double DXF_block_3dface_code_30;
		double DXF_block_3dface_code_31;
		double DXF_block_3dface_code_32;


		int16_t DXF_block_3dface_code_62;

		int16_t DXF_block_3dface_code_70;
		int16_t DXF_block_3dface_code_71;

		int32_t DXF_block_3dface_code_90;
		int32_t DXF_block_3dface_code_91;
		int32_t DXF_block_3dface_code_92;

		QString DXF_block_3dface_code_100[2];


		int16_t DXF_block_3dface_code_280;
		int16_t DXF_block_3dface_code_281;
		int16_t DXF_block_3dface_code_282;
		int16_t DXF_block_3dface_code_283;

		QString DXF_block_3dface_code_310;
		QString DXF_block_3dface_code_330;
		QString DXF_block_3dface_code_340;
		QString DXF_block_3dface_code_360;
	};

	struct DXF_block_3dsolid
	{
		QString DXF_block_3dsolid_code_5;
		QString DXF_block_3dsolid_code_6;
		QString DXF_block_3dsolid_code_8;

		double DXF_block_3dsolid_code_10;
		double DXF_block_3dsolid_code_11;
		double DXF_block_3dsolid_code_12;
		double DXF_block_3dsolid_code_13;
		double DXF_block_3dsolid_code_14[5];


		double DXF_block_3dsolid_code_20;
		double DXF_block_3dsolid_code_21;
		double DXF_block_3dsolid_code_22;
		double DXF_block_3dsolid_code_23;
		double DXF_block_3dsolid_code_24[5];

		double DXF_block_3dsolid_code_30;
		double DXF_block_3dsolid_code_31;
		double DXF_block_3dsolid_code_32;


		int16_t DXF_block_3dsolid_code_62;

		int16_t DXF_block_3dsolid_code_70;
		int16_t DXF_block_3dsolid_code_71;

		int32_t DXF_block_3dsolid_code_90;
		int32_t DXF_block_3dsolid_code_91;
		int32_t DXF_block_3dsolid_code_92;

		QString DXF_block_3dsolid_code_100[2];


		int16_t DXF_block_3dsolid_code_280;
		int16_t DXF_block_3dsolid_code_281;
		int16_t DXF_block_3dsolid_code_282;
		int16_t DXF_block_3dsolid_code_283;

		QString DXF_block_3dsolid_code_310;
		QString DXF_block_3dsolid_code_330;
		QString DXF_block_3dsolid_code_340;
		QString DXF_block_3dsolid_code_360;
	};

	struct DXF_block_acad_proxy_entity
	{
		QString DXF_block_acad_proxy_entity_code_5;
		QString DXF_block_acad_proxy_entity_code_6;
		QString DXF_block_acad_proxy_entity_code_8;

		double DXF_block_acad_proxy_entity_code_10;
		double DXF_block_acad_proxy_entity_code_11;
		double DXF_block_acad_proxy_entity_code_12;
		double DXF_block_acad_proxy_entity_code_13;
		double DXF_block_acad_proxy_entity_code_14[5];


		double DXF_block_acad_proxy_entity_code_20;
		double DXF_block_acad_proxy_entity_code_21;
		double DXF_block_acad_proxy_entity_code_22;
		double DXF_block_acad_proxy_entity_code_23;
		double DXF_block_acad_proxy_entity_code_24[5];

		double DXF_block_acad_proxy_entity_code_30;
		double DXF_block_acad_proxy_entity_code_31;
		double DXF_block_acad_proxy_entity_code_32;


		int16_t DXF_block_acad_proxy_entity_code_62;

		int16_t DXF_block_acad_proxy_entity_code_70;
		int16_t DXF_block_acad_proxy_entity_code_71;

		int32_t DXF_block_acad_proxy_entity_code_90;
		int32_t DXF_block_acad_proxy_entity_code_91;
		int32_t DXF_block_acad_proxy_entity_code_92;

		QString DXF_block_acad_proxy_entity_code_100[2];


		int16_t DXF_block_acad_proxy_entity_code_280;
		int16_t DXF_block_acad_proxy_entity_code_281;
		int16_t DXF_block_acad_proxy_entity_code_282;
		int16_t DXF_block_acad_proxy_entity_code_283;

		QString DXF_block_acad_proxy_entity_code_310;
		QString DXF_block_acad_proxy_entity_code_330;
		QString DXF_block_acad_proxy_entity_code_340;
		QString DXF_block_acad_proxy_entity_code_360;
	};

	struct DXF_block_arc
	{
		QString DXF_block_arc_code_1;
		QString DXF_block_arc_code_2;
		QString DXF_block_arc_code_5;
		QString DXF_block_arc_code_6;
		QString DXF_block_arc_code_8;

		double DXF_block_arc_code_10;
		double DXF_block_arc_code_11;
		double DXF_block_arc_code_12;
		double DXF_block_arc_code_13;
		double DXF_block_arc_code_14[5];


		double DXF_block_arc_code_20;
		double DXF_block_arc_code_21;
		double DXF_block_arc_code_22;
		double DXF_block_arc_code_23;
		double DXF_block_arc_code_24[5];

		double DXF_block_arc_code_30;
		double DXF_block_arc_code_31;
		double DXF_block_arc_code_32;

		double DXF_block_arc_code_50;
		double DXF_block_arc_code_51;

		double DXF_block_arc_code_40;
		double DXF_block_arc_code_48;

		int16_t DXF_block_arc_code_62;

		int16_t DXF_block_arc_code_70;
		int16_t DXF_block_arc_code_71;

		int32_t DXF_block_arc_code_90;
		int32_t DXF_block_arc_code_91;
		int32_t DXF_block_arc_code_92;

		QString DXF_block_arc_code_100[4];
		QString DXF_block_arc_code_102[2];


		int16_t DXF_block_arc_code_280;
		int16_t DXF_block_arc_code_281;
		int16_t DXF_block_arc_code_282;
		int16_t DXF_block_arc_code_283;

		QString DXF_block_arc_code_310;
		QString DXF_block_arc_code_330[2];
		QString DXF_block_arc_code_340;
		QString DXF_block_arc_code_360;

		int16_t DXF_block_arc_code_370;
	};

	struct DXF_block_attdef
	{
		QString DXF_block_attdef_code_1;
		QString DXF_block_attdef_code_2;
		QString DXF_block_attdef_code_3;
		QString DXF_block_attdef_code_5;
		QString DXF_block_attdef_code_6;
		QString DXF_block_attdef_code_8;

		double DXF_block_attdef_code_10;
		double DXF_block_attdef_code_11;
		double DXF_block_attdef_code_12;
		double DXF_block_attdef_code_13;
		double DXF_block_attdef_code_14[5];


		double DXF_block_attdef_code_20;
		double DXF_block_attdef_code_21;
		double DXF_block_attdef_code_22;
		double DXF_block_attdef_code_23;
		double DXF_block_attdef_code_24[5];

		double DXF_block_attdef_code_30;
		double DXF_block_attdef_code_31;
		double DXF_block_attdef_code_32;

		double DXF_block_attdef_code_40;
		double DXF_block_attdef_code_50;
		double DXF_block_attdef_code_53;

		int16_t DXF_block_attdef_code_62;

		int16_t DXF_block_attdef_code_70;
		int16_t DXF_block_attdef_code_71;
		int16_t DXF_block_attdef_code_72;
		int16_t DXF_block_attdef_code_74;

		int32_t DXF_block_attdef_code_90;

		int32_t DXF_block_attdef_code_91;
		int32_t DXF_block_attdef_code_92;

		QString DXF_block_attdef_code_100[5];


		int16_t DXF_block_attdef_code_280;
		int16_t DXF_block_attdef_code_281;
		int16_t DXF_block_attdef_code_282;
		int16_t DXF_block_attdef_code_283;

		QString DXF_block_attdef_code_310;
		QString DXF_block_attdef_code_330;
		QString DXF_block_attdef_code_340;
		QString DXF_block_attdef_code_360;
	};

	struct DXF_block_attrib
	{
		QString DXF_block_attrib_code_1;
		QString DXF_block_attrib_code_2;
		QString DXF_block_attrib_code_3;
		QString DXF_block_attrib_code_5;
		QString DXF_block_attrib_code_6;
		QString DXF_block_attrib_code_8;

		double DXF_block_attrib_code_10;
		double DXF_block_attrib_code_11;
		double DXF_block_attrib_code_12;
		double DXF_block_attrib_code_13;
		double DXF_block_attrib_code_14[5];


		double DXF_block_attrib_code_20;
		double DXF_block_attrib_code_21;
		double DXF_block_attrib_code_22;
		double DXF_block_attrib_code_23;
		double DXF_block_attrib_code_24[5];

		double DXF_block_attrib_code_30;
		double DXF_block_attrib_code_31;
		double DXF_block_attrib_code_32;

		double DXF_block_attrib_code_40;
		double DXF_block_attrib_code_50;
		double DXF_block_attrib_code_53;

		int16_t DXF_block_attrib_code_62;

		int16_t DXF_block_attrib_code_70;
		int16_t DXF_block_attrib_code_71;
		int16_t DXF_block_attrib_code_72;
		int16_t DXF_block_attrib_code_73;
		int16_t DXF_block_attrib_code_74;

		int32_t DXF_block_attrib_code_90;
		int32_t DXF_block_attrib_code_91;
		int32_t DXF_block_attrib_code_92;

		QString DXF_block_attrib_code_100[2];


		int16_t DXF_block_attrib_code_280;
		int16_t DXF_block_attrib_code_281;
		int16_t DXF_block_attrib_code_282;
		int16_t DXF_block_attrib_code_283;

		QString DXF_block_attrib_code_310;
		QString DXF_block_attrib_code_330;
		QString DXF_block_attrib_code_340;
		QString DXF_block_attrib_code_360;
	};

	struct DXF_block_body
	{
		QString DXF_block_body_code_5;
		QString DXF_block_body_code_6;
		QString DXF_block_body_code_8;

		double DXF_block_body_code_10;
		double DXF_block_body_code_11;
		double DXF_block_body_code_12;
		double DXF_block_body_code_13;
		double DXF_block_body_code_14[5];


		double DXF_block_body_code_20;
		double DXF_block_body_code_21;
		double DXF_block_body_code_22;
		double DXF_block_body_code_23;
		double DXF_block_body_code_24[5];

		double DXF_block_body_code_30;
		double DXF_block_body_code_31;
		double DXF_block_body_code_32;


		int16_t DXF_block_body_code_62;

		int16_t DXF_block_body_code_70;
		int16_t DXF_block_body_code_71;

		int32_t DXF_block_body_code_90;
		int32_t DXF_block_body_code_91;
		int32_t DXF_block_body_code_92;

		QString DXF_block_body_code_100[2];


		int16_t DXF_block_body_code_280;
		int16_t DXF_block_body_code_281;
		int16_t DXF_block_body_code_282;
		int16_t DXF_block_body_code_283;

		QString DXF_block_body_code_310;
		QString DXF_block_body_code_330;
		QString DXF_block_body_code_340;
		QString DXF_block_body_code_360;
	};

	struct DXF_block_circle
	{
		QString DXF_block_circle_code_1;
		QString DXF_block_circle_code_2;
		QString DXF_block_circle_code_3;
		QString DXF_block_circle_code_5;
		QString DXF_block_circle_code_6;
		QString DXF_block_circle_code_8;

		double DXF_block_circle_code_10;
		double DXF_block_circle_code_11;
		double DXF_block_circle_code_12;
		double DXF_block_circle_code_13;
		double DXF_block_circle_code_14[5];


		double DXF_block_circle_code_20;
		double DXF_block_circle_code_21;
		double DXF_block_circle_code_22;
		double DXF_block_circle_code_23;
		double DXF_block_circle_code_24[5];

		double DXF_block_circle_code_30;
		double DXF_block_circle_code_31;
		double DXF_block_circle_code_32;

		double DXF_block_circle_code_40;
		double DXF_block_circle_code_48;

		int16_t DXF_block_circle_code_62;

		int16_t DXF_block_circle_code_70;
		int16_t DXF_block_circle_code_71;
		int16_t DXF_block_circle_code_72;
		int16_t DXF_block_circle_code_74;

		int32_t DXF_block_circle_code_90;
		int32_t DXF_block_circle_code_91;
		int32_t DXF_block_circle_code_92;

		QString DXF_block_circle_code_100[2];
		QString DXF_block_circle_code_102[2];


		int16_t DXF_block_circle_code_280;
		int16_t DXF_block_circle_code_281;
		int16_t DXF_block_circle_code_282;
		int16_t DXF_block_circle_code_283;

		QString DXF_block_circle_code_310;
		QString DXF_block_circle_code_330[20];
		QString DXF_block_circle_code_340;
		QString DXF_block_circle_code_360;

		int16_t DXF_block_circle_code_370;

	};

	struct DXF_block_dimension
	{
		QString DXF_block_dimension_code_5;
		QString DXF_block_dimension_code_6;
		QString DXF_block_dimension_code_8;

		double DXF_block_dimension_code_10;
		double DXF_block_dimension_code_11;
		double DXF_block_dimension_code_12;
		double DXF_block_dimension_code_13;
		double DXF_block_dimension_code_14[5];


		double DXF_block_dimension_code_20;
		double DXF_block_dimension_code_21;
		double DXF_block_dimension_code_22;
		double DXF_block_dimension_code_23;
		double DXF_block_dimension_code_24[5];

		double DXF_block_dimension_code_30;
		double DXF_block_dimension_code_31;
		double DXF_block_dimension_code_32;


		int16_t DXF_block_dimension_code_62;

		int16_t DXF_block_dimension_code_70;
		int16_t DXF_block_dimension_code_71;

		int32_t DXF_block_dimension_code_90;
		int32_t DXF_block_dimension_code_91;
		int32_t DXF_block_dimension_code_92;

		QString DXF_block_dimension_code_100[2];


		int16_t DXF_block_dimension_code_280;
		int16_t DXF_block_dimension_code_281;
		int16_t DXF_block_dimension_code_282;
		int16_t DXF_block_dimension_code_283;

		QString DXF_block_dimension_code_310;
		QString DXF_block_dimension_code_330;
		QString DXF_block_dimension_code_340;
		QString DXF_block_dimension_code_360;
	};

	struct DXF_block_ellipse
	{
		QString DXF_block_ellipse_code_1;
		QString DXF_block_ellipse_code_2;
		QString DXF_block_ellipse_code_3;
		QString DXF_block_ellipse_code_5;
		QString DXF_block_ellipse_code_6;
		QString DXF_block_ellipse_code_8;

		double DXF_block_ellipse_code_10;
		double DXF_block_ellipse_code_11;
		double DXF_block_ellipse_code_12;
		double DXF_block_ellipse_code_13;
		double DXF_block_ellipse_code_14[5];


		double DXF_block_ellipse_code_20;
		double DXF_block_ellipse_code_21;
		double DXF_block_ellipse_code_22;
		double DXF_block_ellipse_code_23;
		double DXF_block_ellipse_code_24[5];

		double DXF_block_ellipse_code_30;
		double DXF_block_ellipse_code_31;
		double DXF_block_ellipse_code_32;

		double DXF_block_ellipse_code_40;
		double DXF_block_ellipse_code_41;
		double DXF_block_ellipse_code_42;
		double DXF_block_ellipse_code_48;


		int16_t DXF_block_ellipse_code_62;

		int16_t DXF_block_ellipse_code_70;
		int16_t DXF_block_ellipse_code_71;
		int16_t DXF_block_ellipse_code_72;
		int16_t DXF_block_ellipse_code_74;

		int32_t DXF_block_ellipse_code_90;
		int32_t DXF_block_ellipse_code_91;
		int32_t DXF_block_ellipse_code_92;

		QString DXF_block_ellipse_code_100[2];
		QString DXF_block_ellipse_code_102[2];


		int16_t DXF_block_ellipse_code_280;
		int16_t DXF_block_ellipse_code_281;
		int16_t DXF_block_ellipse_code_282;
		int16_t DXF_block_ellipse_code_283;

		QString DXF_block_ellipse_code_310;
		QString DXF_block_ellipse_code_330[2];
		QString DXF_block_ellipse_code_340;
		QString DXF_block_ellipse_code_360;

		int16_t DXF_block_ellipse_code_370;
	};

	struct DXF_block_hatch
	{
		QString DXF_block_hatch_code_5;
		QString DXF_block_hatch_code_6;
		QString DXF_block_hatch_code_8;

		double DXF_block_hatch_code_10[200];
		double DXF_block_hatch_code_11;
		double DXF_block_hatch_code_12;
		double DXF_block_hatch_code_13;
		double DXF_block_hatch_code_14[5];


		double DXF_block_hatch_code_20[200];
		double DXF_block_hatch_code_21;
		double DXF_block_hatch_code_22;
		double DXF_block_hatch_code_23;
		double DXF_block_hatch_code_24[5];

		double DXF_block_hatch_code_30[200];
		double DXF_block_hatch_code_31;
		double DXF_block_hatch_code_32;

		double DXF_block_hatch_code_40[200];
		double DXF_block_hatch_code_41;
		double DXF_block_hatch_code_42;
		double DXF_block_hatch_code_43;
		double DXF_block_hatch_code_44;
		double DXF_block_hatch_code_45;

		double DXF_block_hatch_code_48;

		double DXF_block_hatch_code_50;
		double DXF_block_hatch_code_51;

		int16_t DXF_block_hatch_code_62;

		int16_t DXF_block_hatch_code_70;
		int16_t DXF_block_hatch_code_71;
		int16_t DXF_block_hatch_code_72;
		int16_t DXF_block_hatch_code_73;
		int16_t DXF_block_hatch_code_74;
		int16_t DXF_block_hatch_code_75;

		int32_t DXF_block_hatch_code_90;
		int32_t DXF_block_hatch_code_91;
		int32_t DXF_block_hatch_code_92;

		QString DXF_block_hatch_code_100[2];

		double DXF_block_hatch_code_210;

		double DXF_block_hatch_code_220;

		double DXF_block_hatch_code_230;

		int16_t DXF_block_hatch_code_280;
		int16_t DXF_block_hatch_code_281;
		int16_t DXF_block_hatch_code_282;
		int16_t DXF_block_hatch_code_283;

		QString DXF_block_hatch_code_310;
		QString DXF_block_hatch_code_330[2];
		QString DXF_block_hatch_code_340;
		QString DXF_block_hatch_code_360;

		int16_t DXF_block_hatch_code_370;
	};

	struct DXF_block_helix
	{
		QString DXF_block_helix_code_5;
		QString DXF_block_helix_code_6;
		QString DXF_block_helix_code_8;

		double DXF_block_helix_code_10;
		double DXF_block_helix_code_11;
		double DXF_block_helix_code_12;
		double DXF_block_helix_code_13;
		double DXF_block_helix_code_14[5];


		double DXF_block_helix_code_20;
		double DXF_block_helix_code_21;
		double DXF_block_helix_code_22;
		double DXF_block_helix_code_23;
		double DXF_block_helix_code_24[5];

		double DXF_block_helix_code_30;
		double DXF_block_helix_code_31;
		double DXF_block_helix_code_32;


		int16_t DXF_block_helix_code_62;

		int16_t DXF_block_helix_code_70;
		int16_t DXF_block_helix_code_71;

		int32_t DXF_block_helix_code_90;
		int32_t DXF_block_helix_code_91;
		int32_t DXF_block_helix_code_92;

		QString DXF_block_helix_code_100[2];


		int16_t DXF_block_helix_code_280;
		int16_t DXF_block_helix_code_281;
		int16_t DXF_block_helix_code_282;
		int16_t DXF_block_helix_code_283;

		QString DXF_block_helix_code_310;
		QString DXF_block_helix_code_330;
		QString DXF_block_helix_code_340;
		QString DXF_block_helix_code_360;
	};

	struct DXF_block_image
	{
		QString DXF_block_image_code_5;
		QString DXF_block_image_code_6;
		QString DXF_block_image_code_8;

		double DXF_block_image_code_10;
		double DXF_block_image_code_11;
		double DXF_block_image_code_12;
		double DXF_block_image_code_13;
		double DXF_block_image_code_14[5];


		double DXF_block_image_code_20;
		double DXF_block_image_code_21;
		double DXF_block_image_code_22;
		double DXF_block_image_code_23;
		double DXF_block_image_code_24[5];

		double DXF_block_image_code_30;
		double DXF_block_image_code_31;
		double DXF_block_image_code_32;


		int16_t DXF_block_image_code_62;

		int16_t DXF_block_image_code_70;
		int16_t DXF_block_image_code_71;

		int32_t DXF_block_image_code_90;
		int32_t DXF_block_image_code_91;
		int32_t DXF_block_image_code_92;

		QString DXF_block_image_code_100[2];


		int16_t DXF_block_image_code_280;
		int16_t DXF_block_image_code_281;
		int16_t DXF_block_image_code_282;
		int16_t DXF_block_image_code_283;

		QString DXF_block_image_code_310;
		QString DXF_block_image_code_330;
		QString DXF_block_image_code_340;
		QString DXF_block_image_code_360;
	};

	struct DXF_block_insert
	{
		QString DXF_block_insert_code_1;
		QString DXF_block_insert_code_2;
		QString DXF_block_insert_code_3;
		QString DXF_block_insert_code_5;
		QString DXF_block_insert_code_6;
		QString DXF_block_insert_code_8;

		double DXF_block_insert_code_10[4];
		double DXF_block_insert_code_11;
		double DXF_block_insert_code_12;
		double DXF_block_insert_code_13;
		double DXF_block_insert_code_14[5];


		double DXF_block_insert_code_20[4];
		double DXF_block_insert_code_21;
		double DXF_block_insert_code_22;
		double DXF_block_insert_code_23;
		double DXF_block_insert_code_24[5];

		double DXF_block_insert_code_30;
		double DXF_block_insert_code_31;
		double DXF_block_insert_code_32;


		int16_t DXF_block_insert_code_62;

		int16_t DXF_block_insert_code_70;
		int16_t DXF_block_insert_code_71;

		int32_t DXF_block_insert_code_90;
		int32_t DXF_block_insert_code_91;
		int32_t DXF_block_insert_code_92;

		QString DXF_block_insert_code_100[2];


		int16_t DXF_block_insert_code_280;
		int16_t DXF_block_insert_code_281;
		int16_t DXF_block_insert_code_282;
		int16_t DXF_block_insert_code_283;

		QString DXF_block_insert_code_310;
		QString DXF_block_insert_code_330[2];
		QString DXF_block_insert_code_340;
		QString DXF_block_insert_code_360;

		QString DXF_block_insert_code_1000[30];
		QString DXF_block_insert_code_1001[30];
		QString DXF_block_insert_code_1002[10];

		double DXF_block_insert_code_1010[10];
		double DXF_block_insert_code_1011[10];
		double DXF_block_insert_code_1020[10];
		double DXF_block_insert_code_1021[10];
		double DXF_block_insert_code_1030[10];
		double DXF_block_insert_code_1031[10];
		double DXF_block_insert_code_1040[10];
		int16_t DXF_block_insert_code_1070[10];
		int16_t DXF_block_insert_code_1071[10];
	};

	struct DXF_block_leader
	{
		QString DXF_block_leader_code_5;
		QString DXF_block_leader_code_6;
		QString DXF_block_leader_code_8;

		double DXF_block_leader_code_10;
		double DXF_block_leader_code_11;
		double DXF_block_leader_code_12;
		double DXF_block_leader_code_13;
		double DXF_block_leader_code_14[5];


		double DXF_block_leader_code_20;
		double DXF_block_leader_code_21;
		double DXF_block_leader_code_22;
		double DXF_block_leader_code_23;
		double DXF_block_leader_code_24[5];

		double DXF_block_leader_code_30;
		double DXF_block_leader_code_31;
		double DXF_block_leader_code_32;


		int16_t DXF_block_leader_code_62;

		int16_t DXF_block_leader_code_70;
		int16_t DXF_block_leader_code_71;

		int32_t DXF_block_leader_code_90;
		int32_t DXF_block_leader_code_91;
		int32_t DXF_block_leader_code_92;

		QString DXF_block_leader_code_100[2];


		int16_t DXF_block_leader_code_280;
		int16_t DXF_block_leader_code_281;
		int16_t DXF_block_leader_code_282;
		int16_t DXF_block_leader_code_283;

		QString DXF_block_leader_code_310;
		QString DXF_block_leader_code_330;
		QString DXF_block_leader_code_340;
		QString DXF_block_leader_code_360;
	};

	struct DXF_block_light
	{
		QString DXF_block_light_code_5;
		QString DXF_block_light_code_6;
		QString DXF_block_light_code_8;

		double DXF_block_light_code_10;
		double DXF_block_light_code_11;
		double DXF_block_light_code_12;
		double DXF_block_light_code_13;
		double DXF_block_light_code_14[5];


		double DXF_block_light_code_20;
		double DXF_block_light_code_21;
		double DXF_block_light_code_22;
		double DXF_block_light_code_23;
		double DXF_block_light_code_24[5];

		double DXF_block_light_code_30;
		double DXF_block_light_code_31;
		double DXF_block_light_code_32;


		int16_t DXF_block_light_code_62;

		int16_t DXF_block_light_code_70;
		int16_t DXF_block_light_code_71;

		int32_t DXF_block_light_code_90;
		int32_t DXF_block_light_code_91;
		int32_t DXF_block_light_code_92;

		QString DXF_block_light_code_100[2];


		int16_t DXF_block_light_code_280;
		int16_t DXF_block_light_code_281;
		int16_t DXF_block_light_code_282;
		int16_t DXF_block_light_code_283;

		QString DXF_block_light_code_310;
		QString DXF_block_light_code_330;
		QString DXF_block_light_code_340;
		QString DXF_block_light_code_360;
	};

	struct DXF_block_line
	{

		QString DXF_block_line_code_5;
		QString DXF_block_line_code_6;
		QString DXF_block_line_code_8;

		double DXF_block_line_code_10;
		double DXF_block_line_code_11;

		double DXF_block_line_code_20;
		double DXF_block_line_code_21;

		double DXF_block_line_code_30;
		double DXF_block_line_code_31;

		double DXF_block_line_code_48;

		int16_t DXF_block_line_code_62;
		int16_t DXF_block_line_code_73;

		QString DXF_block_line_code_100[5];
		QString DXF_block_line_code_102[2];

		QString DXF_block_line_code_330[5];

		bool DXF_block_line_code_370;

	};

	struct DXF_block_lwpolyline
	{
		QString DXF_block_lwpolyline_code_1;
		QString DXF_block_lwpolyline_code_2;
		QString DXF_block_lwpolyline_code_3;
		QString DXF_block_lwpolyline_code_5;
		QString DXF_block_lwpolyline_code_6;
		QString DXF_block_lwpolyline_code_8;

		double DXF_block_lwpolyline_code_10[4];
		double DXF_block_lwpolyline_code_11;

		double DXF_block_lwpolyline_code_20[4];
		double DXF_block_lwpolyline_code_21;

		double DXF_block_lwpolyline_code_30;
		double DXF_block_lwpolyline_code_31;

		double DXF_block_lwpolyline_code_43;
		double DXF_block_lwpolyline_code_48;

		int16_t DXF_block_lwpolyline_code_62;
		int16_t DXF_block_lwpolyline_code_70;

		int32_t DXF_block_lwpolyline_code_90;

		QString DXF_block_lwpolyline_code_100[2];
		QString DXF_block_lwpolyline_code_102[2];

		QString DXF_block_lwpolyline_code_330[2];
		int16_t DXF_block_lwpolyline_code_370;
	};

	struct DXF_block_mesh
	{
		QString DXF_block_mesh_code_5;
		QString DXF_block_mesh_code_6;
		QString DXF_block_mesh_code_8;

		double DXF_block_mesh_code_10;
		double DXF_block_mesh_code_11;
		double DXF_block_mesh_code_12;
		double DXF_block_mesh_code_13;
		double DXF_block_mesh_code_14[5];


		double DXF_block_mesh_code_20;
		double DXF_block_mesh_code_21;
		double DXF_block_mesh_code_22;
		double DXF_block_mesh_code_23;
		double DXF_block_mesh_code_24[5];

		double DXF_block_mesh_code_30;
		double DXF_block_mesh_code_31;
		double DXF_block_mesh_code_32;


		int16_t DXF_block_mesh_code_62;

		int16_t DXF_block_mesh_code_70;
		int16_t DXF_block_mesh_code_71;

		int32_t DXF_block_mesh_code_90;
		int32_t DXF_block_mesh_code_91;
		int32_t DXF_block_mesh_code_92;

		QString DXF_block_mesh_code_100[2];


		int16_t DXF_block_mesh_code_280;
		int16_t DXF_block_mesh_code_281;
		int16_t DXF_block_mesh_code_282;
		int16_t DXF_block_mesh_code_283;

		QString DXF_block_mesh_code_310;
		QString DXF_block_mesh_code_330;
		QString DXF_block_mesh_code_340;
		QString DXF_block_mesh_code_360;
	};

	struct DXF_block_mline
	{
		QString DXF_block_mline_code_5;
		QString DXF_block_mline_code_6;
		QString DXF_block_mline_code_8;

		double DXF_block_mline_code_10;
		double DXF_block_mline_code_11;
		double DXF_block_mline_code_12;
		double DXF_block_mline_code_13;
		double DXF_block_mline_code_14[5];


		double DXF_block_mline_code_20;
		double DXF_block_mline_code_21;
		double DXF_block_mline_code_22;
		double DXF_block_mline_code_23;
		double DXF_block_mline_code_24[5];

		double DXF_block_mline_code_30;
		double DXF_block_mline_code_31;
		double DXF_block_mline_code_32;


		int16_t DXF_block_mline_code_62;

		int16_t DXF_block_mline_code_70;
		int16_t DXF_block_mline_code_71;

		int32_t DXF_block_mline_code_90;
		int32_t DXF_block_mline_code_91;
		int32_t DXF_block_mline_code_92;

		QString DXF_block_mline_code_100[2];


		int16_t DXF_block_mline_code_280;
		int16_t DXF_block_mline_code_281;
		int16_t DXF_block_mline_code_282;
		int16_t DXF_block_mline_code_283;

		QString DXF_block_mline_code_310;
		QString DXF_block_mline_code_330;
		QString DXF_block_mline_code_340;
		QString DXF_block_mline_code_360;
	};

	struct DXF_block_mleaderstyle
	{
		QString DXF_block_mleaderstyle_code_5;
		QString DXF_block_mleaderstyle_code_6;
		QString DXF_block_mleaderstyle_code_8;

		double DXF_block_mleaderstyle_code_10;
		double DXF_block_mleaderstyle_code_11;
		double DXF_block_mleaderstyle_code_12;
		double DXF_block_mleaderstyle_code_13;
		double DXF_block_mleaderstyle_code_14[5];


		double DXF_block_mleaderstyle_code_20;
		double DXF_block_mleaderstyle_code_21;
		double DXF_block_mleaderstyle_code_22;
		double DXF_block_mleaderstyle_code_23;
		double DXF_block_mleaderstyle_code_24[5];

		double DXF_block_mleaderstyle_code_30;
		double DXF_block_mleaderstyle_code_31;
		double DXF_block_mleaderstyle_code_32;


		int16_t DXF_block_mleaderstyle_code_62;

		int16_t DXF_block_mleaderstyle_code_70;
		int16_t DXF_block_mleaderstyle_code_71;

		int32_t DXF_block_mleaderstyle_code_90;
		int32_t DXF_block_mleaderstyle_code_91;
		int32_t DXF_block_mleaderstyle_code_92;

		QString DXF_block_mleaderstyle_code_100[2];


		int16_t DXF_block_mleaderstyle_code_280;
		int16_t DXF_block_mleaderstyle_code_281;
		int16_t DXF_block_mleaderstyle_code_282;
		int16_t DXF_block_mleaderstyle_code_283;

		QString DXF_block_mleaderstyle_code_310;
		QString DXF_block_mleaderstyle_code_330;
		QString DXF_block_mleaderstyle_code_340;
		QString DXF_block_mleaderstyle_code_360;
	};

	struct DXF_block_mleader
	{
		QString DXF_block_mleader_code_5;
		QString DXF_block_mleader_code_6;
		QString DXF_block_mleader_code_8;

		double DXF_block_mleader_code_10;
		double DXF_block_mleader_code_11;
		double DXF_block_mleader_code_12;
		double DXF_block_mleader_code_13;
		double DXF_block_mleader_code_14[5];


		double DXF_block_mleader_code_20;
		double DXF_block_mleader_code_21;
		double DXF_block_mleader_code_22;
		double DXF_block_mleader_code_23;
		double DXF_block_mleader_code_24[5];

		double DXF_block_mleader_code_30;
		double DXF_block_mleader_code_31;
		double DXF_block_mleader_code_32;


		int16_t DXF_block_mleader_code_62;

		int16_t DXF_block_mleader_code_70;
		int16_t DXF_block_mleader_code_71;

		int32_t DXF_block_mleader_code_90;
		int32_t DXF_block_mleader_code_91;
		int32_t DXF_block_mleader_code_92;

		QString DXF_block_mleader_code_100[2];


		int16_t DXF_block_mleader_code_280;
		int16_t DXF_block_mleader_code_281;
		int16_t DXF_block_mleader_code_282;
		int16_t DXF_block_mleader_code_283;

		QString DXF_block_mleader_code_310;
		QString DXF_block_mleader_code_330;
		QString DXF_block_mleader_code_340;
		QString DXF_block_mleader_code_360;
	};

	struct DXF_block_mtext
	{
		QString DXF_block_mtext_code_1;
		QString DXF_block_mtext_code_2;
		QString DXF_block_mtext_code_3;
		QString DXF_block_mtext_code_5;
		QString DXF_block_mtext_code_6;
		QString DXF_block_mtext_code_8;

		double DXF_block_mtext_code_10;
		double DXF_block_mtext_code_11;
		double DXF_block_mtext_code_12;
		double DXF_block_mtext_code_13;
		double DXF_block_mtext_code_14[5];


		double DXF_block_mtext_code_20;
		double DXF_block_mtext_code_21;
		double DXF_block_mtext_code_22;
		double DXF_block_mtext_code_23;
		double DXF_block_mtext_code_24[5];

		double DXF_block_mtext_code_30;
		double DXF_block_mtext_code_31;
		double DXF_block_mtext_code_32;


		int16_t DXF_block_mtext_code_62;

		int16_t DXF_block_mtext_code_70;
		int16_t DXF_block_mtext_code_71;

		int32_t DXF_block_mtext_code_90;
		int32_t DXF_block_mtext_code_91;
		int32_t DXF_block_mtext_code_92;

		QString DXF_block_mtext_code_100[2];


		int16_t DXF_block_mtext_code_280;
		int16_t DXF_block_mtext_code_281;
		int16_t DXF_block_mtext_code_282;
		int16_t DXF_block_mtext_code_283;

		QString DXF_block_mtext_code_310;
		QString DXF_block_mtext_code_330;
		QString DXF_block_mtext_code_340;
		QString DXF_block_mtext_code_360;
	};

	struct DXF_block_oleframe
	{
		QString DXF_block_oleframe_code_5;
		QString DXF_block_oleframe_code_6;
		QString DXF_block_oleframe_code_8;

		double DXF_block_oleframe_code_10;
		double DXF_block_oleframe_code_11;
		double DXF_block_oleframe_code_12;
		double DXF_block_oleframe_code_13;
		double DXF_block_oleframe_code_14[5];


		double DXF_block_oleframe_code_20;
		double DXF_block_oleframe_code_21;
		double DXF_block_oleframe_code_22;
		double DXF_block_oleframe_code_23;
		double DXF_block_oleframe_code_24[5];

		double DXF_block_oleframe_code_30;
		double DXF_block_oleframe_code_31;
		double DXF_block_oleframe_code_32;


		int16_t DXF_block_oleframe_code_62;

		int16_t DXF_block_oleframe_code_70;
		int16_t DXF_block_oleframe_code_71;

		int32_t DXF_block_oleframe_code_90;
		int32_t DXF_block_oleframe_code_91;
		int32_t DXF_block_oleframe_code_92;

		QString DXF_block_oleframe_code_100[2];


		int16_t DXF_block_oleframe_code_280;
		int16_t DXF_block_oleframe_code_281;
		int16_t DXF_block_oleframe_code_282;
		int16_t DXF_block_oleframe_code_283;

		QString DXF_block_oleframe_code_310;
		QString DXF_block_oleframe_code_330;
		QString DXF_block_oleframe_code_340;
		QString DXF_block_oleframe_code_360;
	};

	struct DXF_block_ole2frame
	{
		QString DXF_block_ole2frame_code_5;
		QString DXF_block_ole2frame_code_6;
		QString DXF_block_ole2frame_code_8;

		double DXF_block_ole2frame_code_10;
		double DXF_block_ole2frame_code_11;
		double DXF_block_ole2frame_code_12;
		double DXF_block_ole2frame_code_13;
		double DXF_block_ole2frame_code_14[5];


		double DXF_block_ole2frame_code_20;
		double DXF_block_ole2frame_code_21;
		double DXF_block_ole2frame_code_22;
		double DXF_block_ole2frame_code_23;
		double DXF_block_ole2frame_code_24[5];

		double DXF_block_ole2frame_code_30;
		double DXF_block_ole2frame_code_31;
		double DXF_block_ole2frame_code_32;


		int16_t DXF_block_ole2frame_code_62;

		int16_t DXF_block_ole2frame_code_70;
		int16_t DXF_block_ole2frame_code_71;

		int32_t DXF_block_ole2frame_code_90;
		int32_t DXF_block_ole2frame_code_91;
		int32_t DXF_block_ole2frame_code_92;

		QString DXF_block_ole2frame_code_100[2];


		int16_t DXF_block_ole2frame_code_280;
		int16_t DXF_block_ole2frame_code_281;
		int16_t DXF_block_ole2frame_code_282;
		int16_t DXF_block_ole2frame_code_283;

		QString DXF_block_ole2frame_code_310;
		QString DXF_block_ole2frame_code_330;
		QString DXF_block_ole2frame_code_340;
		QString DXF_block_ole2frame_code_360;
	};

	struct DXF_block_point
	{
		QString DXF_block_point_code_5;
		QString DXF_block_point_code_6;
		QString DXF_block_point_code_8;

		double DXF_block_point_code_10;
		double DXF_block_point_code_11;
		double DXF_block_point_code_12;
		double DXF_block_point_code_13;
		double DXF_block_point_code_14[5];


		double DXF_block_point_code_20;
		double DXF_block_point_code_21;
		double DXF_block_point_code_22;
		double DXF_block_point_code_23;
		double DXF_block_point_code_24[5];

		double DXF_block_point_code_30;
		double DXF_block_point_code_31;
		double DXF_block_point_code_32;


		int16_t DXF_block_point_code_62;

		int16_t DXF_block_point_code_70;
		int16_t DXF_block_point_code_71;

		int32_t DXF_block_point_code_90;
		int32_t DXF_block_point_code_91;
		int32_t DXF_block_point_code_92;

		QString DXF_block_point_code_100[2];


		int16_t DXF_block_point_code_280;
		int16_t DXF_block_point_code_281;
		int16_t DXF_block_point_code_282;
		int16_t DXF_block_point_code_283;

		QString DXF_block_point_code_310;
		QString DXF_block_point_code_330;
		QString DXF_block_point_code_340;
		QString DXF_block_point_code_360;
	};

	struct DXF_block_polyline
	{
		QString DXF_block_polyline_code_5;
		QString DXF_block_polyline_code_6;
		QString DXF_block_polyline_code_8;

		double DXF_block_polyline_code_10;
		double DXF_block_polyline_code_11;
		double DXF_block_polyline_code_12;
		double DXF_block_polyline_code_13;
		double DXF_block_polyline_code_14[5];


		double DXF_block_polyline_code_20;
		double DXF_block_polyline_code_21;
		double DXF_block_polyline_code_22;
		double DXF_block_polyline_code_23;
		double DXF_block_polyline_code_24[5];

		double DXF_block_polyline_code_30;
		double DXF_block_polyline_code_31;
		double DXF_block_polyline_code_32;

		double DXF_block_polyline_code_40;
		double DXF_block_polyline_code_48;

		double DXF_block_polyline_code_50;
		double DXF_block_polyline_code_51;



		int16_t DXF_block_polyline_code_62;
		int16_t DXF_block_polyline_code_66;

		int16_t DXF_block_polyline_code_70;
		int16_t DXF_block_polyline_code_71;

		int32_t DXF_block_polyline_code_90;
		int32_t DXF_block_polyline_code_91;
		int32_t DXF_block_polyline_code_92;

		QString DXF_block_polyline_code_100[2];
		QString DXF_block_polyline_code_102[3];

		int16_t DXF_block_polyline_code_280;
		int16_t DXF_block_polyline_code_281;
		int16_t DXF_block_polyline_code_282;
		int16_t DXF_block_polyline_code_283;

		QString DXF_block_polyline_code_310;
		QString DXF_block_polyline_code_330[2];
		QString DXF_block_polyline_code_340;
		QString DXF_block_polyline_code_360;

		int16_t DXF_block_polyline_code_370;
	};

	struct DXF_block_ray
	{
		QString DXF_block_ray_code_5;
		QString DXF_block_ray_code_6;
		QString DXF_block_ray_code_8;

		double DXF_block_ray_code_10;
		double DXF_block_ray_code_11;
		double DXF_block_ray_code_12;
		double DXF_block_ray_code_13;
		double DXF_block_ray_code_14[5];


		double DXF_block_ray_code_20;
		double DXF_block_ray_code_21;
		double DXF_block_ray_code_22;
		double DXF_block_ray_code_23;
		double DXF_block_ray_code_24[5];

		double DXF_block_ray_code_30;
		double DXF_block_ray_code_31;
		double DXF_block_ray_code_32;


		int16_t DXF_block_ray_code_62;

		int16_t DXF_block_ray_code_70;
		int16_t DXF_block_ray_code_71;

		int32_t DXF_block_ray_code_90;
		int32_t DXF_block_ray_code_91;
		int32_t DXF_block_ray_code_92;

		QString DXF_block_ray_code_100[2];


		int16_t DXF_block_ray_code_280;
		int16_t DXF_block_ray_code_281;
		int16_t DXF_block_ray_code_282;
		int16_t DXF_block_ray_code_283;

		QString DXF_block_ray_code_310;
		QString DXF_block_ray_code_330;
		QString DXF_block_ray_code_340;
		QString DXF_block_ray_code_360;
	};

	struct DXF_block_region
	{
		QString DXF_block_region_code_5;
		QString DXF_block_region_code_6;
		QString DXF_block_region_code_8;

		double DXF_block_region_code_10;
		double DXF_block_region_code_11;
		double DXF_block_region_code_12;
		double DXF_block_region_code_13;
		double DXF_block_region_code_14[5];


		double DXF_block_region_code_20;
		double DXF_block_region_code_21;
		double DXF_block_region_code_22;
		double DXF_block_region_code_23;
		double DXF_block_region_code_24[5];

		double DXF_block_region_code_30;
		double DXF_block_region_code_31;
		double DXF_block_region_code_32;


		int16_t DXF_block_region_code_62;

		int16_t DXF_block_region_code_70;
		int16_t DXF_block_region_code_71;

		int32_t DXF_block_region_code_90;
		int32_t DXF_block_region_code_91;
		int32_t DXF_block_region_code_92;

		QString DXF_block_region_code_100[2];


		int16_t DXF_block_region_code_280;
		int16_t DXF_block_region_code_281;
		int16_t DXF_block_region_code_282;
		int16_t DXF_block_region_code_283;

		QString DXF_block_region_code_310;
		QString DXF_block_region_code_330;
		QString DXF_block_region_code_340;
		QString DXF_block_region_code_360;
	};

	struct DXF_block_section
	{
		QString DXF_block_section_code_5;
		QString DXF_block_section_code_6;
		QString DXF_block_section_code_8;

		double DXF_block_section_code_10;
		double DXF_block_section_code_11;
		double DXF_block_section_code_12;
		double DXF_block_section_code_13;
		double DXF_block_section_code_14[5];


		double DXF_block_section_code_20;
		double DXF_block_section_code_21;
		double DXF_block_section_code_22;
		double DXF_block_section_code_23;
		double DXF_block_section_code_24[5];

		double DXF_block_section_code_30;
		double DXF_block_section_code_31;
		double DXF_block_section_code_32;


		int16_t DXF_block_section_code_62;

		int16_t DXF_block_section_code_70;
		int16_t DXF_block_section_code_71;

		int32_t DXF_block_section_code_90;
		int32_t DXF_block_section_code_91;
		int32_t DXF_block_section_code_92;

		QString DXF_block_section_code_100[2];


		int16_t DXF_block_section_code_280;
		int16_t DXF_block_section_code_281;
		int16_t DXF_block_section_code_282;
		int16_t DXF_block_section_code_283;

		QString DXF_block_section_code_310;
		QString DXF_block_section_code_330;
		QString DXF_block_section_code_340;
		QString DXF_block_section_code_360;
	};

	struct DXF_block_seqend
	{
		QString DXF_block_seqend_code_5;
		QString DXF_block_seqend_code_6;
		QString DXF_block_seqend_code_8;

		double DXF_block_seqend_code_10[200];
		double DXF_block_seqend_code_11;
		double DXF_block_seqend_code_12;
		double DXF_block_seqend_code_13;
		double DXF_block_seqend_code_14[5];


		double DXF_block_seqend_code_20[200];
		double DXF_block_seqend_code_21;
		double DXF_block_seqend_code_22;
		double DXF_block_seqend_code_23;
		double DXF_block_seqend_code_24[5];

		double DXF_block_seqend_code_30[200];
		double DXF_block_seqend_code_31;
		double DXF_block_seqend_code_32;

		double DXF_block_seqend_code_40[200];
		double DXF_block_seqend_code_41;
		double DXF_block_seqend_code_42;
		double DXF_block_seqend_code_43;
		double DXF_block_seqend_code_44;
		double DXF_block_seqend_code_45;

		double DXF_block_seqend_code_48;

		double DXF_block_seqend_code_50;
		double DXF_block_seqend_code_51;

		int16_t DXF_block_seqend_code_62;

		int16_t DXF_block_seqend_code_70;
		int16_t DXF_block_seqend_code_71;
		int16_t DXF_block_seqend_code_72;
		int16_t DXF_block_seqend_code_73;
		int16_t DXF_block_seqend_code_74;
		int16_t DXF_block_seqend_code_75;

		int32_t DXF_block_seqend_code_90;
		int32_t DXF_block_seqend_code_91;
		int32_t DXF_block_seqend_code_92;

		QString DXF_block_seqend_code_100[2];

		double DXF_block_seqend_code_210;

		double DXF_block_seqend_code_220;

		double DXF_block_seqend_code_230;

		int16_t DXF_block_seqend_code_280;
		int16_t DXF_block_seqend_code_281;
		int16_t DXF_block_seqend_code_282;
		int16_t DXF_block_seqend_code_283;

		QString DXF_block_seqend_code_310;
		QString DXF_block_seqend_code_330[2];
		QString DXF_block_seqend_code_340;
		QString DXF_block_seqend_code_360;

		int16_t DXF_block_seqend_code_370;
	};

	struct DXF_block_shape
	{
		QString DXF_block_shape_code_5;
		QString DXF_block_shape_code_6;
		QString DXF_block_shape_code_8;

		double DXF_block_shape_code_10;
		double DXF_block_shape_code_11;
		double DXF_block_shape_code_12;
		double DXF_block_shape_code_13;
		double DXF_block_shape_code_14[5];


		double DXF_block_shape_code_20;
		double DXF_block_shape_code_21;
		double DXF_block_shape_code_22;
		double DXF_block_shape_code_23;
		double DXF_block_shape_code_24[5];

		double DXF_block_shape_code_30;
		double DXF_block_shape_code_31;
		double DXF_block_shape_code_32;


		int16_t DXF_block_shape_code_62;

		int16_t DXF_block_shape_code_70;
		int16_t DXF_block_shape_code_71;

		int32_t DXF_block_shape_code_90;
		int32_t DXF_block_shape_code_91;
		int32_t DXF_block_shape_code_92;

		QString DXF_block_shape_code_100[2];


		int16_t DXF_block_shape_code_280;
		int16_t DXF_block_shape_code_281;
		int16_t DXF_block_shape_code_282;
		int16_t DXF_block_shape_code_283;

		QString DXF_block_shape_code_310;
		QString DXF_block_shape_code_330;
		QString DXF_block_shape_code_340;
		QString DXF_block_shape_code_360;
	};

	struct DXF_block_solid
	{
		QString DXF_block_solid_code_5;
		QString DXF_block_solid_code_6;
		QString DXF_block_solid_code_8;

		double DXF_block_solid_code_10;
		double DXF_block_solid_code_11;
		double DXF_block_solid_code_12;
		double DXF_block_solid_code_13;
		double DXF_block_solid_code_14;


		double DXF_block_solid_code_20;
		double DXF_block_solid_code_21;
		double DXF_block_solid_code_22;
		double DXF_block_solid_code_23;
		double DXF_block_solid_code_24;

		double DXF_block_solid_code_30;
		double DXF_block_solid_code_31;
		double DXF_block_solid_code_32;
		double DXF_block_solid_code_33;

		double DXF_block_solid_code_40;
		double DXF_block_solid_code_41;
		double DXF_block_solid_code_42;
		double DXF_block_solid_code_43;
		double DXF_block_solid_code_44;
		double DXF_block_solid_code_45;

		double DXF_block_solid_code_48;

		double DXF_block_solid_code_50;
		double DXF_block_solid_code_51;

		int16_t DXF_block_solid_code_62;

		int16_t DXF_block_solid_code_70;
		int16_t DXF_block_solid_code_71;
		int16_t DXF_block_solid_code_72;
		int16_t DXF_block_solid_code_73;
		int16_t DXF_block_solid_code_74;
		int16_t DXF_block_solid_code_75;

		int32_t DXF_block_solid_code_90;
		int32_t DXF_block_solid_code_91;
		int32_t DXF_block_solid_code_92;

		QString DXF_block_solid_code_100[2];

		double DXF_block_solid_code_210;

		double DXF_block_solid_code_220;

		double DXF_block_solid_code_230;

		int16_t DXF_block_solid_code_280;
		int16_t DXF_block_solid_code_281;
		int16_t DXF_block_solid_code_282;
		int16_t DXF_block_solid_code_283;

		QString DXF_block_solid_code_310;
		QString DXF_block_solid_code_330[2];
		QString DXF_block_solid_code_340;
		QString DXF_block_solid_code_360;

		int16_t DXF_block_solid_code_370;
	};

	struct DXF_block_spline
	{
		QString DXF_block_spline_code_5;
		QString DXF_block_spline_code_6;
		QString DXF_block_spline_code_8;

		double DXF_block_spline_code_10[200];
		double DXF_block_spline_code_11;
		double DXF_block_spline_code_12;
		double DXF_block_spline_code_13;
		double DXF_block_spline_code_14[5];


		double DXF_block_spline_code_20[200];
		double DXF_block_spline_code_21;
		double DXF_block_spline_code_22;
		double DXF_block_spline_code_23;
		double DXF_block_spline_code_24[5];

		double DXF_block_spline_code_30[200];
		double DXF_block_spline_code_31;
		double DXF_block_spline_code_32;

		double DXF_block_spline_code_40[200];
		double DXF_block_spline_code_41;
		double DXF_block_spline_code_42;
		double DXF_block_spline_code_43;
		double DXF_block_spline_code_44;
		double DXF_block_spline_code_45;

		double DXF_block_spline_code_48;

		double DXF_block_spline_code_50;
		double DXF_block_spline_code_51;

		int16_t DXF_block_spline_code_62;

		int16_t DXF_block_spline_code_70;
		int16_t DXF_block_spline_code_71;
		int16_t DXF_block_spline_code_72;
		int16_t DXF_block_spline_code_73;
		int16_t DXF_block_spline_code_74;
		int16_t DXF_block_spline_code_75;

		int32_t DXF_block_spline_code_90;
		int32_t DXF_block_spline_code_91;
		int32_t DXF_block_spline_code_92;

		QString DXF_block_spline_code_100[2];

		double DXF_block_spline_code_210;

		double DXF_block_spline_code_220;

		double DXF_block_spline_code_230;

		int16_t DXF_block_spline_code_280;
		int16_t DXF_block_spline_code_281;
		int16_t DXF_block_spline_code_282;
		int16_t DXF_block_spline_code_283;

		QString DXF_block_spline_code_310;
		QString DXF_block_spline_code_330[2];
		QString DXF_block_spline_code_340;
		QString DXF_block_spline_code_360;

		int16_t DXF_block_spline_code_370;
	};

	struct DXF_block_sun
	{
		QString DXF_block_sun_code_5;
		QString DXF_block_sun_code_6;
		QString DXF_block_sun_code_8;

		double DXF_block_sun_code_10;
		double DXF_block_sun_code_11;
		double DXF_block_sun_code_12;
		double DXF_block_sun_code_13;
		double DXF_block_sun_code_14[5];


		double DXF_block_sun_code_20;
		double DXF_block_sun_code_21;
		double DXF_block_sun_code_22;
		double DXF_block_sun_code_23;
		double DXF_block_sun_code_24[5];

		double DXF_block_sun_code_30;
		double DXF_block_sun_code_31;
		double DXF_block_sun_code_32;


		int16_t DXF_block_sun_code_62;

		int16_t DXF_block_sun_code_70;
		int16_t DXF_block_sun_code_71;

		int32_t DXF_block_sun_code_90;
		int32_t DXF_block_sun_code_91;
		int32_t DXF_block_sun_code_92;

		QString DXF_block_sun_code_100[2];


		int16_t DXF_block_sun_code_280;
		int16_t DXF_block_sun_code_281;
		int16_t DXF_block_sun_code_282;
		int16_t DXF_block_sun_code_283;

		QString DXF_block_sun_code_310;
		QString DXF_block_sun_code_330;
		QString DXF_block_sun_code_340;
		QString DXF_block_sun_code_360;
	};

	struct DXF_block_surface
	{
		QString DXF_block_surface_code_5;
		QString DXF_block_surface_code_6;
		QString DXF_block_surface_code_8;

		double DXF_block_surface_code_10;
		double DXF_block_surface_code_11;
		double DXF_block_surface_code_12;
		double DXF_block_surface_code_13;
		double DXF_block_surface_code_14[5];


		double DXF_block_surface_code_20;
		double DXF_block_surface_code_21;
		double DXF_block_surface_code_22;
		double DXF_block_surface_code_23;
		double DXF_block_surface_code_24[5];

		double DXF_block_surface_code_30;
		double DXF_block_surface_code_31;
		double DXF_block_surface_code_32;


		int16_t DXF_block_surface_code_62;

		int16_t DXF_block_surface_code_70;
		int16_t DXF_block_surface_code_71;

		int32_t DXF_block_surface_code_90;
		int32_t DXF_block_surface_code_91;
		int32_t DXF_block_surface_code_92;

		QString DXF_block_surface_code_100[2];


		int16_t DXF_block_surface_code_280;
		int16_t DXF_block_surface_code_281;
		int16_t DXF_block_surface_code_282;
		int16_t DXF_block_surface_code_283;

		QString DXF_block_surface_code_310;
		QString DXF_block_surface_code_330;
		QString DXF_block_surface_code_340;
		QString DXF_block_surface_code_360;
	};

	struct DXF_block_table
	{
		QString DXF_block_text_code_5;
		QString DXF_block_text_code_6;
		QString DXF_block_text_code_8;

		double DXF_block_text_code_10;
		double DXF_block_text_code_11;
		double DXF_block_text_code_12;
		double DXF_block_text_code_13;
		double DXF_block_text_code_14[5];


		double DXF_block_text_code_20;
		double DXF_block_text_code_21;
		double DXF_block_text_code_22;
		double DXF_block_text_code_23;
		double DXF_block_text_code_24[5];

		double DXF_block_text_code_30;
		double DXF_block_text_code_31;
		double DXF_block_text_code_32;


		int16_t DXF_block_text_code_62;

		int16_t DXF_block_text_code_70;
		int16_t DXF_block_text_code_71;

		int32_t DXF_block_text_code_90;
		int32_t DXF_block_text_code_91;
		int32_t DXF_block_text_code_92;

		QString DXF_block_text_code_100[2];


		int16_t DXF_block_text_code_280;
		int16_t DXF_block_text_code_281;
		int16_t DXF_block_text_code_282;
		int16_t DXF_block_text_code_283;

		QString DXF_block_text_code_310;
		QString DXF_block_text_code_330;
		QString DXF_block_text_code_340;
		QString DXF_block_text_code_360;
	};

	struct DXF_block_text
	{
		QString DXF_block_text_code_1;
		QString DXF_block_text_code_2;
		QString DXF_block_text_code_3;
		QString DXF_block_text_code_5;
		QString DXF_block_text_code_6;
		QString DXF_block_text_code_7;
		QString DXF_block_text_code_8;

		double DXF_block_text_code_10;
		double DXF_block_text_code_11;

		double DXF_block_text_code_20;
		double DXF_block_text_code_21;

		double DXF_block_text_code_30;
		double DXF_block_text_code_31;

		double DXF_block_text_code_40;
		double DXF_block_text_code_50;

		int16_t DXF_block_text_code_62;

		int16_t DXF_block_text_code_72;
		int16_t DXF_block_text_code_73;

		QString DXF_block_text_code_100[5];
		QString DXF_block_text_code_102[2];

		QString DXF_block_text_code_330[2];
	};

	struct DXF_block_tolerance
	{
		QString DXF_block_tolerance_code_5;
		QString DXF_block_tolerance_code_6;
		QString DXF_block_tolerance_code_8;

		double DXF_block_tolerance_code_10;
		double DXF_block_tolerance_code_11;
		double DXF_block_tolerance_code_12;
		double DXF_block_tolerance_code_13;
		double DXF_block_tolerance_code_14[5];


		double DXF_block_tolerance_code_20;
		double DXF_block_tolerance_code_21;
		double DXF_block_tolerance_code_22;
		double DXF_block_tolerance_code_23;
		double DXF_block_tolerance_code_24[5];

		double DXF_block_tolerance_code_30;
		double DXF_block_tolerance_code_31;
		double DXF_block_tolerance_code_32;


		int16_t DXF_block_tolerance_code_62;

		int16_t DXF_block_tolerance_code_70;
		int16_t DXF_block_tolerance_code_71;

		int32_t DXF_block_tolerance_code_90;
		int32_t DXF_block_tolerance_code_91;
		int32_t DXF_block_tolerance_code_92;

		QString DXF_block_tolerance_code_100[2];


		int16_t DXF_block_tolerance_code_280;
		int16_t DXF_block_tolerance_code_281;
		int16_t DXF_block_tolerance_code_282;
		int16_t DXF_block_tolerance_code_283;

		QString DXF_block_tolerance_code_310;
		QString DXF_block_tolerance_code_330;
		QString DXF_block_tolerance_code_340;
		QString DXF_block_tolerance_code_360;
	};

	struct DXF_block_trace
	{
		QString DXF_block_trace_code_5;
		QString DXF_block_trace_code_6;
		QString DXF_block_trace_code_8;

		double DXF_block_trace_code_10;
		double DXF_block_trace_code_11;
		double DXF_block_trace_code_12;
		double DXF_block_trace_code_13;
		double DXF_block_trace_code_14[5];


		double DXF_block_trace_code_20;
		double DXF_block_trace_code_21;
		double DXF_block_trace_code_22;
		double DXF_block_trace_code_23;
		double DXF_block_trace_code_24[5];

		double DXF_block_trace_code_30;
		double DXF_block_trace_code_31;
		double DXF_block_trace_code_32;


		int16_t DXF_block_trace_code_62;

		int16_t DXF_block_trace_code_70;
		int16_t DXF_block_trace_code_71;

		int32_t DXF_block_trace_code_90;
		int32_t DXF_block_trace_code_91;
		int32_t DXF_block_trace_code_92;

		QString DXF_block_trace_code_100[2];


		int16_t DXF_block_trace_code_280;
		int16_t DXF_block_trace_code_281;
		int16_t DXF_block_trace_code_282;
		int16_t DXF_block_trace_code_283;

		QString DXF_block_trace_code_310;
		QString DXF_block_trace_code_330;
		QString DXF_block_trace_code_340;
		QString DXF_block_trace_code_360;
	};

	struct DXF_block_underlay
	{
		QString DXF_block_underlay_code_5;
		QString DXF_block_underlay_code_6;
		QString DXF_block_underlay_code_8;

		double DXF_block_underlay_code_10;
		double DXF_block_underlay_code_11;
		double DXF_block_underlay_code_12;
		double DXF_block_underlay_code_13;
		double DXF_block_underlay_code_14[5];


		double DXF_block_underlay_code_20;
		double DXF_block_underlay_code_21;
		double DXF_block_underlay_code_22;
		double DXF_block_underlay_code_23;
		double DXF_block_underlay_code_24[5];

		double DXF_block_underlay_code_30;
		double DXF_block_underlay_code_31;
		double DXF_block_underlay_code_32;


		int16_t DXF_block_underlay_code_62;

		int16_t DXF_block_underlay_code_70;
		int16_t DXF_block_underlay_code_71;

		int32_t DXF_block_underlay_code_90;
		int32_t DXF_block_underlay_code_91;
		int32_t DXF_block_underlay_code_92;

		QString DXF_block_underlay_code_100[2];


		int16_t DXF_block_underlay_code_280;
		int16_t DXF_block_underlay_code_281;
		int16_t DXF_block_underlay_code_282;
		int16_t DXF_block_underlay_code_283;

		QString DXF_block_underlay_code_310;
		QString DXF_block_underlay_code_330;
		QString DXF_block_underlay_code_340;
		QString DXF_block_underlay_code_360;
	};

	struct DXF_block_vertex
	{

		QString Master_block_handle_id;
		QString DXF_block_vertex_code_5;
		QString DXF_block_vertex_code_6;
		QString DXF_block_vertex_code_8;

		double DXF_block_vertex_code_10;
		double DXF_block_vertex_code_11;
		double DXF_block_vertex_code_12;
		double DXF_block_vertex_code_13;
		double DXF_block_vertex_code_14[5];


		double DXF_block_vertex_code_20;
		double DXF_block_vertex_code_21;
		double DXF_block_vertex_code_22;
		double DXF_block_vertex_code_23;
		double DXF_block_vertex_code_24[5];

		double DXF_block_vertex_code_30;
		double DXF_block_vertex_code_31;
		double DXF_block_vertex_code_32;

		double DXF_block_vertex_code_40;
		double DXF_block_vertex_code_41;

		double DXF_block_vertex_code_48;

		double DXF_block_vertex_code_50;
		double DXF_block_vertex_code_51;

		int16_t DXF_block_vertex_code_62;

		int16_t DXF_block_vertex_code_70;
		int16_t DXF_block_vertex_code_71;

		int32_t DXF_block_vertex_code_90;
		int32_t DXF_block_vertex_code_91;
		int32_t DXF_block_vertex_code_92;

		QString DXF_block_vertex_code_100[5];
		QString DXF_block_vertex_code_102[2];


		int16_t DXF_block_vertex_code_280;
		int16_t DXF_block_vertex_code_281;
		int16_t DXF_block_vertex_code_282;
		int16_t DXF_block_vertex_code_283;

		QString DXF_block_vertex_code_310;
		QString DXF_block_vertex_code_330[2];
		QString DXF_block_vertex_code_340;
		QString DXF_block_vertex_code_360;

		int16_t DXF_block_vertex_code_370;
	};

	struct DXF_block_viewport
	{
		QString DXF_block_viewport_code_1;
		QString DXF_block_viewport_code_2;
		QString DXF_block_viewport_code_3;
		QString DXF_block_viewport_code_4;
		QString DXF_block_viewport_code_5;
		QString DXF_block_viewport_code_6;
		QString DXF_block_viewport_code_8;

		double DXF_block_viewport_code_10;
		double DXF_block_viewport_code_11;
		double DXF_block_viewport_code_12;
		double DXF_block_viewport_code_13;
		double DXF_block_viewport_code_14[5];
		double DXF_block_viewport_code_15;
		double DXF_block_viewport_code_16;
		double DXF_block_viewport_code_17;

		double DXF_block_viewport_code_20;
		double DXF_block_viewport_code_21;
		double DXF_block_viewport_code_22;
		double DXF_block_viewport_code_23;
		double DXF_block_viewport_code_24;
		double DXF_block_viewport_code_25;
		double DXF_block_viewport_code_26;
		double DXF_block_viewport_code_27;

		double DXF_block_viewport_code_30;
		double DXF_block_viewport_code_31;
		double DXF_block_viewport_code_32;
		double DXF_block_viewport_code_33;
		double DXF_block_viewport_code_34;
		double DXF_block_viewport_code_35;
		double DXF_block_viewport_code_36;
		double DXF_block_viewport_code_37;

		double DXF_block_viewport_code_40;
		double DXF_block_viewport_code_41;
		double DXF_block_viewport_code_42;
		double DXF_block_viewport_code_43;
		double DXF_block_viewport_code_44;
		double DXF_block_viewport_code_45;
		double DXF_block_viewport_code_46;
		double DXF_block_viewport_code_48;

		double DXF_block_viewport_code_50;
		double DXF_block_viewport_code_51;

		int16_t DXF_block_viewport_code_62;
		int16_t DXF_block_viewport_code_68;
		int16_t DXF_block_viewport_code_69;

		int16_t DXF_block_viewport_code_70;
		int16_t DXF_block_viewport_code_71;
		int16_t DXF_block_viewport_code_72;
		int16_t DXF_block_viewport_code_74;
		int16_t DXF_block_viewport_code_79;

		int32_t DXF_block_viewport_code_90;
		int32_t DXF_block_viewport_code_91;
		int32_t DXF_block_viewport_code_92;

		QString DXF_block_viewport_code_100[2];
		QString DXF_block_viewport_code_102[2];

		double DXF_block_viewport_code_110;
		double DXF_block_viewport_code_111;
		double DXF_block_viewport_code_112;

		double DXF_block_viewport_code_120;
		double DXF_block_viewport_code_121;
		double DXF_block_viewport_code_122;

		double DXF_block_viewport_code_130;
		double DXF_block_viewport_code_131;
		double DXF_block_viewport_code_132;

		double DXF_block_viewport_code_146;


		int16_t DXF_block_viewport_code_280;
		int16_t DXF_block_viewport_code_281;
		int16_t DXF_block_viewport_code_282;
		int16_t DXF_block_viewport_code_283;

		QString DXF_block_viewport_code_310;
		QString DXF_block_viewport_code_330[2];
		QString DXF_block_viewport_code_340;
		QString DXF_block_viewport_code_360;

		int16_t DXF_block_viewport_code_370;

	};

	struct DXF_block_wipeout
	{
		QString DXF_block_wipeout_code_5;
		QString DXF_block_wipeout_code_6;
		QString DXF_block_wipeout_code_8;

		double DXF_block_wipeout_code_10;
		double DXF_block_wipeout_code_11;
		double DXF_block_wipeout_code_12;
		double DXF_block_wipeout_code_13;
		double DXF_block_wipeout_code_14[5];


		double DXF_block_wipeout_code_20;
		double DXF_block_wipeout_code_21;
		double DXF_block_wipeout_code_22;
		double DXF_block_wipeout_code_23;
		double DXF_block_wipeout_code_24[5];

		double DXF_block_wipeout_code_30;
		double DXF_block_wipeout_code_31;
		double DXF_block_wipeout_code_32;


		int16_t DXF_block_wipeout_code_62;

		int16_t DXF_block_wipeout_code_70;
		int16_t DXF_block_wipeout_code_71;

		int32_t DXF_block_wipeout_code_90;
		int32_t DXF_block_wipeout_code_91;
		int32_t DXF_block_wipeout_code_92;

		QString DXF_block_wipeout_code_100[2];


		int16_t DXF_block_wipeout_code_280;
		int16_t DXF_block_wipeout_code_281;
		int16_t DXF_block_wipeout_code_282;
		int16_t DXF_block_wipeout_code_283;

		QString DXF_block_wipeout_code_310;
		QString DXF_block_wipeout_code_330;
		QString DXF_block_wipeout_code_340;
		QString DXF_block_wipeout_code_360;
	};

	struct DXF_block_xline
	{
		QString DXF_block_xline_code_5;
		QString DXF_block_xline_code_6;
		QString DXF_block_xline_code_8;

		double DXF_block_xline_code_10;
		double DXF_block_xline_code_11;
		double DXF_block_xline_code_12;
		double DXF_block_xline_code_13;
		double DXF_block_xline_code_14[5];


		double DXF_block_xline_code_20;
		double DXF_block_xline_code_21;
		double DXF_block_xline_code_22;
		double DXF_block_xline_code_23;
		double DXF_block_xline_code_24[5];

		double DXF_block_xline_code_30;
		double DXF_block_xline_code_31;
		double DXF_block_xline_code_32;


		int16_t DXF_block_xline_code_62;

		int16_t DXF_block_xline_code_70;
		int16_t DXF_block_xline_code_71;

		int32_t DXF_block_xline_code_90;
		int32_t DXF_block_xline_code_91;
		int32_t DXF_block_xline_code_92;

		QString DXF_block_xline_code_100[2];


		int16_t DXF_block_xline_code_280;
		int16_t DXF_block_xline_code_281;
		int16_t DXF_block_xline_code_282;
		int16_t DXF_block_xline_code_283;

		QString DXF_block_xline_code_310;
		QString DXF_block_xline_code_330;
		QString DXF_block_xline_code_340;
		QString DXF_block_xline_code_360;
	};

	struct DXF_entities_3dface
	{
		QString DXF_entities_3dface_code_5;
		QString DXF_entities_3dface_code_6;

		QString DXF_entities_3dface_code_8;

		double DXF_entities_3dface_code_10;
		double DXF_entities_3dface_code_11;
		double DXF_entities_3dface_code_20;
		double DXF_entities_3dface_code_21;
		double DXF_entities_3dface_code_30;
		double DXF_entities_3dface_code_31;

		int16_t DXF_entities_3dface_code_62;

		QString DXF_entities_3dface_code_100[3];

		QString DXF_entities_3dface_code_330;
	};

	struct DXF_entities_3dsolid
	{
		QString DXF_entities_3dsolid_code_5;
		QString DXF_entities_3dsolid_code_6;

		QString DXF_entities_3dsolid_code_8;

		double DXF_entities_3dsolid_code_10;
		double DXF_entities_3dsolid_code_11;
		double DXF_entities_3dsolid_code_20;
		double DXF_entities_3dsolid_code_21;
		double DXF_entities_3dsolid_code_30;
		double DXF_entities_3dsolid_code_31;

		int16_t DXF_entities_3dsolid_code_62;

		QString DXF_entities_3dsolid_code_100[3];

		QString DXF_entities_3dsolid_code_330;
	};

	struct DXF_entities_acad_proxy_entity
	{
		QString DXF_entities_acad_proxy_entity_code_5;
		QString DXF_entities_acad_proxy_entity_code_6;

		QString DXF_entities_acad_proxy_entity_code_8;

		double DXF_entities_acad_proxy_entity_code_10;
		double DXF_entities_acad_proxy_entity_code_11;
		double DXF_entities_acad_proxy_entity_code_20;
		double DXF_entities_acad_proxy_entity_code_21;
		double DXF_entities_acad_proxy_entity_code_30;
		double DXF_entities_acad_proxy_entity_code_31;

		int16_t DXF_entities_acad_proxy_entity_code_62;

		QString DXF_entities_acad_proxy_entity_code_100[3];

		QString DXF_entities_acad_proxy_entity_code_330;
	};

	struct DXF_entities_arc
	{

		QString DXF_entities_arc_code_5;		// Handle
		QString DXF_entities_arc_code_6;		// Linetype name (present if not BYLAYER). The special name BYBLOCK indicates a floating linetype (optional)
		QString DXF_entities_arc_code_8;		// Layer name

		double DXF_entities_arc_code_10;		// Center point (in OCS) DXF: X value; APP: 3D point
		double DXF_entities_arc_code_20;		// DXF: Y values of center point (in OCS)
		double DXF_entities_arc_code_30;		// DXF: Z values of center point (in OCS)
		double DXF_entities_arc_code_39;		// Thickness (optional; default = 0)
		double DXF_entities_arc_code_40;		// Radius
		double DXF_entities_arc_code_48;		// Linetype scale (optional)

		double DXF_entities_arc_code_50;		// Start angle
		double DXF_entities_arc_code_51;		// End angle

		int16_t DXF_entities_arc_code_62;		// Color number (present if not BYLAYER);
												// zero indicates the BYBLOCK (floating) color;
												// 256 indicates BYLAYER;
												// a negative value indicates that the layer is turned off (optional)


		int16_t DXF_entities_arc_code_70;

		QString DXF_entities_arc_code_100[3];	//[1] Subclass marker (AcDbCircle)
												//[2] Subclass marker (AcDbArc)

		QString DXF_entities_arc_code_102[3];

		QString DXF_entities_arc_code_330[3];		// Soft-pointer ID/handle to owner dictionary (optional)

		int16_t DXF_entities_arc_code_370;

	};

	struct DXF_entities_attdef
	{
		QString DXF_entities_attdef_code_1;
		QString DXF_entities_attdef_code_2;
		QString DXF_entities_attdef_code_3;

		QString DXF_entities_attdef_code_5;
		QString DXF_entities_attdef_code_6;
		QString DXF_entities_attdef_code_8;

		double DXF_entities_attdef_code_10;
		double DXF_entities_attdef_code_20;
		double DXF_entities_attdef_code_30;
		double DXF_entities_attdef_code_40;
		double DXF_entities_attdef_code_50;


		int16_t DXF_entities_attdef_code_70;

		QString DXF_entities_attdef_code_100[3];

		QString DXF_entities_attdef_code_330;



	};

	struct DXF_entities_attrib
	{
		QString DXF_entities_attrib_code_1;
		QString DXF_entities_attrib_code_2;
		QString DXF_entities_attrib_code_3;

		QString DXF_entities_attrib_code_5;
		QString DXF_entities_attrib_code_6;
		QString DXF_entities_attrib_code_7;
		QString DXF_entities_attrib_code_8;

		double DXF_entities_attrib_code_10;
		double DXF_entities_attrib_code_11;
		double DXF_entities_attrib_code_20;
		double DXF_entities_attrib_code_21;
		double DXF_entities_attrib_code_30;
		double DXF_entities_attrib_code_31;

		double DXF_entities_attrib_code_40;
		double DXF_entities_attrib_code_50;

		int16_t DXF_entities_attrib_code_62;

		int16_t DXF_entities_attrib_code_70;
		int16_t DXF_entities_attrib_code_72;
		int16_t DXF_entities_attrib_code_73;

		int16_t DXF_entities_attrib_code_74;

		QString DXF_entities_attrib_code_100[3];

		int16_t DXF_entities_attrib_code_280;

		QString DXF_entities_attrib_code_330;
	};

	struct DXF_entities_body
	{
		QString DXF_entities_body_code_5;
		QString DXF_entities_body_code_6;

		QString DXF_entities_body_code_8;

		double DXF_entities_body_code_10;
		double DXF_entities_body_code_11;
		double DXF_entities_body_code_20;
		double DXF_entities_body_code_21;
		double DXF_entities_body_code_30;
		double DXF_entities_body_code_31;

		int16_t DXF_entities_body_code_62;

		QString DXF_entities_body_code_100[3];

		QString DXF_entities_body_code_330;
	};

	struct DXF_entities_circle
	{
		QString DXF_entities_circle_code_2;
		QString DXF_entities_circle_code_5;
		QString DXF_entities_circle_code_6;

		QString DXF_entities_circle_code_8;

		double DXF_entities_circle_code_10;
		double DXF_entities_circle_code_11;
		double DXF_entities_circle_code_20;
		double DXF_entities_circle_code_21;
		double DXF_entities_circle_code_30;
		double DXF_entities_circle_code_31;

		double DXF_entities_circle_code_40;
		double DXF_entities_circle_code_48;

		int16_t DXF_entities_circle_code_62;

		int16_t DXF_entities_circle_code_72;
		int16_t DXF_entities_circle_code_73;

		QString DXF_entities_circle_code_100[3];
		QString DXF_entities_circle_code_102[3];

		QString DXF_entities_circle_code_330[3];

		double DXF_entities_circle_code_370;

	};

	struct DXF_entities_dimension
	{
		QString DXF_entities_dimension_code_5;
		QString DXF_entities_dimension_code_6;

		QString DXF_entities_dimension_code_8;

		double DXF_entities_dimension_code_10;
		double DXF_entities_dimension_code_11;
		double DXF_entities_dimension_code_20;
		double DXF_entities_dimension_code_21;
		double DXF_entities_dimension_code_30;
		double DXF_entities_dimension_code_31;

		int16_t DXF_entities_dimension_code_62;

		QString DXF_entities_dimension_code_100[3];

		QString DXF_entities_dimension_code_330;
	};

	struct DXF_entities_ellipse
	{
		QString DXF_entities_ellipse_code_5;
		QString DXF_entities_ellipse_code_6;
		QString DXF_entities_ellipse_code_8;

		double DXF_entities_ellipse_code_10;
		double DXF_entities_ellipse_code_11;
		double DXF_entities_ellipse_code_20;
		double DXF_entities_ellipse_code_21;
		double DXF_entities_ellipse_code_30;
		double DXF_entities_ellipse_code_31;
		double DXF_entities_ellipse_code_40;

		double DXF_entities_ellipse_code_41;
		double DXF_entities_ellipse_code_42;

		int16_t DXF_entities_ellipse_code_62;
		int16_t DXF_entities_ellipse_code_70;

		QString DXF_entities_ellipse_code_100[3];

		double DXF_entities_ellipse_code_210;
		double DXF_entities_ellipse_code_220;
		double DXF_entities_ellipse_code_230;

		QString DXF_entities_ellipse_code_330;
	};

	struct DXF_entities_hatch
	{
		QString DXF_entities_hatch_code_5;
		QString DXF_entities_hatch_code_6;

		QString DXF_entities_hatch_code_8;

		double DXF_entities_hatch_code_10;
		double DXF_entities_hatch_code_11;
		double DXF_entities_hatch_code_20;
		double DXF_entities_hatch_code_21;
		double DXF_entities_hatch_code_30;
		double DXF_entities_hatch_code_31;

		int16_t DXF_entities_hatch_code_62;

		QString DXF_entities_hatch_code_100[3];

		QString DXF_entities_hatch_code_330;
	};

	struct DXF_entities_helix
	{
		QString DXF_entities_helix_code_5;
		QString DXF_entities_helix_code_6;

		QString DXF_entities_helix_code_8;

		double DXF_entities_helix_code_10;
		double DXF_entities_helix_code_11;
		double DXF_entities_helix_code_20;
		double DXF_entities_helix_code_21;
		double DXF_entities_helix_code_30;
		double DXF_entities_helix_code_31;

		int16_t DXF_entities_helix_code_62;

		QString DXF_entities_helix_code_100[3];

		QString DXF_entities_helix_code_330;
	};

	struct DXF_entities_image
	{
		QString DXF_entities_image_code_5;
		QString DXF_entities_image_code_6;

		QString DXF_entities_image_code_8;

		double DXF_entities_image_code_10;
		double DXF_entities_image_code_11;
		double DXF_entities_image_code_20;
		double DXF_entities_image_code_21;
		double DXF_entities_image_code_30;
		double DXF_entities_image_code_31;

		int16_t DXF_entities_image_code_62;

		QString DXF_entities_image_code_100[3];

		QString DXF_entities_image_code_330;
	};

	struct DXF_entities_insert
	{

		QString DXF_entities_insert_code_2;
		QString DXF_entities_insert_code_5;
		QString DXF_entities_insert_code_6;

		QString DXF_entities_insert_code_8;

		double DXF_entities_insert_code_10;
		double DXF_entities_insert_code_11;
		double DXF_entities_insert_code_20;
		double DXF_entities_insert_code_21;
		double DXF_entities_insert_code_30;
		double DXF_entities_insert_code_31;

		double DXF_entities_insert_code_40;
		double DXF_entities_insert_code_41;
		double DXF_entities_insert_code_42;
		double DXF_entities_insert_code_43;

		double DXF_entities_insert_code_50;

		int16_t DXF_entities_insert_code_62;
		int16_t DXF_entities_insert_code_66;

		QString DXF_entities_insert_code_100[3];
		QString DXF_entities_insert_code_102[3];

		QString DXF_entities_insert_code_330[3];
	};

	struct DXF_entities_leader
	{
		QString DXF_entities_leader_code_5;
		QString DXF_entities_leader_code_6;

		QString DXF_entities_leader_code_8;

		double DXF_entities_leader_code_10;
		double DXF_entities_leader_code_11;
		double DXF_entities_leader_code_20;
		double DXF_entities_leader_code_21;
		double DXF_entities_leader_code_30;
		double DXF_entities_leader_code_31;

		int16_t DXF_entities_leader_code_62;

		QString DXF_entities_leader_code_100[3];

		QString DXF_entities_leader_code_330;
	};

	struct DXF_entities_light
	{
		QString DXF_entities_light_code_5;
		QString DXF_entities_light_code_6;

		QString DXF_entities_light_code_8;

		double DXF_entities_light_code_10;
		double DXF_entities_light_code_11;
		double DXF_entities_light_code_20;
		double DXF_entities_light_code_21;
		double DXF_entities_light_code_30;
		double DXF_entities_light_code_31;

		int16_t DXF_entities_light_code_62;

		QString DXF_entities_light_code_100[3];

		QString DXF_entities_light_code_330;
	};

	struct DXF_entities_line
	{
		QString DXF_entities_line_code_5;
		QString DXF_entities_line_code_6;

		QString DXF_entities_line_code_8;

		double DXF_entities_line_code_10;
		double DXF_entities_line_code_11;
		double DXF_entities_line_code_20;
		double DXF_entities_line_code_21;
		double DXF_entities_line_code_30;
		double DXF_entities_line_code_31;

		double DXF_entities_line_code_48; // line type scale

		int16_t DXF_entities_line_code_62;
		int16_t DXF_entities_line_code_73;

		QString DXF_entities_line_code_100[5];
		QString DXF_entities_line_code_102[3];

		QString DXF_entities_line_code_330[3];

		int16_t DXF_entities_line_code_370;

	};

	struct DXF_entities_lwpolyline
	{
		QString DXF_entities_lwpolyline_code_5;
		QString DXF_entities_lwpolyline_code_6;

		QString DXF_entities_lwpolyline_code_8;

		double DXF_entities_lwpolyline_code_10[50]; //x
		double DXF_entities_lwpolyline_code_11;
		double DXF_entities_lwpolyline_code_20[50]; //y
		double DXF_entities_lwpolyline_code_21;
		double DXF_entities_lwpolyline_code_30; //z
		double DXF_entities_lwpolyline_code_31;

		double DXF_entities_lwpolyline_code_43;// constant width default=0

		int16_t DXF_entities_lwpolyline_code_62;

		int16_t DXF_entities_lwpolyline_code_70; //1= closed 128=plingen

		int32_t DXF_entities_lwpolyline_code_90; //number of vertices

		QString DXF_entities_lwpolyline_code_100[3];

		QString DXF_entities_lwpolyline_code_330;
	};

	struct DXF_entities_mesh
	{
		QString DXF_entities_mesh_code_5;
		QString DXF_entities_mesh_code_6;

		QString DXF_entities_mesh_code_8;

		double DXF_entities_mesh_code_10;
		double DXF_entities_mesh_code_11;
		double DXF_entities_mesh_code_20;
		double DXF_entities_mesh_code_21;
		double DXF_entities_mesh_code_30;
		double DXF_entities_mesh_code_31;

		int16_t DXF_entities_mesh_code_62;

		QString DXF_entities_mesh_code_100[3];

		QString DXF_entities_mesh_code_330;
	};

	struct DXF_entities_mline
	{
		QString DXF_entities_mline_code_5;
		QString DXF_entities_mline_code_6;

		QString DXF_entities_mline_code_8;

		double DXF_entities_mline_code_10;
		double DXF_entities_mline_code_11;
		double DXF_entities_mline_code_20;
		double DXF_entities_mline_code_21;
		double DXF_entities_mline_code_30;
		double DXF_entities_mline_code_31;

		int16_t DXF_entities_mline_code_62;

		QString DXF_entities_mline_code_100[3];

		QString DXF_entities_mline_code_330;
	};

	struct DXF_entities_mleaderstyle
	{
		QString DXF_entities_mleaderstyle_code_5;
		QString DXF_entities_mleaderstyle_code_6;

		QString DXF_entities_mleaderstyle_code_8;

		double DXF_entities_mleaderstyle_code_10;
		double DXF_entities_mleaderstyle_code_11;
		double DXF_entities_mleaderstyle_code_20;
		double DXF_entities_mleaderstyle_code_21;
		double DXF_entities_mleaderstyle_code_30;
		double DXF_entities_mleaderstyle_code_31;

		int16_t DXF_entities_mleaderstyle_code_62;

		QString DXF_entities_mleaderstyle_code_100[3];

		QString DXF_entities_mleaderstyle_code_330;
	};

	struct DXF_entities_mleader
	{
		QString DXF_entities_mleader_code_5;
		QString DXF_entities_mleader_code_6;

		QString DXF_entities_mleader_code_8;

		double DXF_entities_mleader_code_10;
		double DXF_entities_mleader_code_11;
		double DXF_entities_mleader_code_20;
		double DXF_entities_mleader_code_21;
		double DXF_entities_mleader_code_30;
		double DXF_entities_mleader_code_31;

		int16_t DXF_entities_mleader_code_62;

		QString DXF_entities_mleader_code_100[3];

		QString DXF_entities_mleader_code_330;
	};

	struct DXF_entities_mtext
	{
		QString DXF_entities_mtext_code_5;
		QString DXF_entities_mtext_code_6;

		QString DXF_entities_mtext_code_8;

		double DXF_entities_mtext_code_10;
		double DXF_entities_mtext_code_11;
		double DXF_entities_mtext_code_20;
		double DXF_entities_mtext_code_21;
		double DXF_entities_mtext_code_30;
		double DXF_entities_mtext_code_31;

		int16_t DXF_entities_mtext_code_62;

		QString DXF_entities_mtext_code_100[3];

		QString DXF_entities_mtext_code_330;
	};

	struct DXF_entities_oleframe
	{
		QString DXF_entities_oleframe_code_5;
		QString DXF_entities_oleframe_code_6;

		QString DXF_entities_oleframe_code_8;

		double DXF_entities_oleframe_code_10;
		double DXF_entities_oleframe_code_11;
		double DXF_entities_oleframe_code_20;
		double DXF_entities_oleframe_code_21;
		double DXF_entities_oleframe_code_30;
		double DXF_entities_oleframe_code_31;

		int16_t DXF_entities_oleframe_code_62;

		QString DXF_entities_oleframe_code_100[3];

		QString DXF_entities_oleframe_code_330;
	};

	struct DXF_entities_ole2frame
	{
		QString DXF_entities_ole2frame_code_5;
		QString DXF_entities_ole2frame_code_6;

		QString DXF_entities_ole2frame_code_8;

		double DXF_entities_ole2frame_code_10;
		double DXF_entities_ole2frame_code_11;
		double DXF_entities_ole2frame_code_20;
		double DXF_entities_ole2frame_code_21;
		double DXF_entities_ole2frame_code_30;
		double DXF_entities_ole2frame_code_31;

		int16_t DXF_entities_ole2frame_code_62;

		QString DXF_entities_ole2frame_code_100[3];

		QString DXF_entities_ole2frame_code_330;
	};

	struct DXF_entities_point
	{
		QString DXF_entities_point_code_5;
		QString DXF_entities_point_code_6;

		QString DXF_entities_point_code_8;

		double DXF_entities_point_code_10;
		double DXF_entities_point_code_11;
		double DXF_entities_point_code_20;
		double DXF_entities_point_code_21;
		double DXF_entities_point_code_30;
		double DXF_entities_point_code_31;

		int16_t DXF_entities_point_code_62;

		QString DXF_entities_point_code_100[3];

		QString DXF_entities_point_code_330;

		int16_t DXF_entities_point_code_370;

	};

	struct DXF_entities_polyline
	{
		QString DXF_entities_polyline_code_5;
		QString DXF_entities_polyline_code_6;

		QString DXF_entities_polyline_code_8;

		double DXF_entities_polyline_code_10;
		double DXF_entities_polyline_code_11;
		double DXF_entities_polyline_code_20;
		double DXF_entities_polyline_code_21;
		double DXF_entities_polyline_code_30;
		double DXF_entities_polyline_code_31;

		int16_t DXF_entities_polyline_code_62;
		int16_t DXF_entities_polyline_code_66;
		int16_t DXF_entities_polyline_code_70;

		QString DXF_entities_polyline_code_100[3];

		QString DXF_entities_polyline_code_330;
	};

	struct DXF_entities_ray
	{
		QString DXF_entities_ray_code_5;
		QString DXF_entities_ray_code_6;

		QString DXF_entities_ray_code_8;

		double DXF_entities_ray_code_10;
		double DXF_entities_ray_code_11;
		double DXF_entities_ray_code_20;
		double DXF_entities_ray_code_21;
		double DXF_entities_ray_code_30;
		double DXF_entities_ray_code_31;

		int16_t DXF_entities_ray_code_62;

		QString DXF_entities_ray_code_100[3];

		QString DXF_entities_ray_code_330;
	};

	struct DXF_entities_region
	{
		QString DXF_entities_region_code_5;
		QString DXF_entities_region_code_6;

		QString DXF_entities_region_code_8;

		double DXF_entities_region_code_10;
		double DXF_entities_region_code_11;
		double DXF_entities_region_code_20;
		double DXF_entities_region_code_21;
		double DXF_entities_region_code_30;
		double DXF_entities_region_code_31;

		int16_t DXF_entities_region_code_62;

		QString DXF_entities_region_code_100[3];

		QString DXF_entities_region_code_330;
	};

	struct DXF_entities_section
	{
		QString DXF_entities_section_code_5;
		QString DXF_entities_section_code_6;

		QString DXF_entities_section_code_8;

		double DXF_entities_section_code_10;
		double DXF_entities_section_code_11;
		double DXF_entities_section_code_20;
		double DXF_entities_section_code_21;
		double DXF_entities_section_code_30;
		double DXF_entities_section_code_31;

		int16_t DXF_entities_section_code_62;

		QString DXF_entities_section_code_100[3];

		QString DXF_entities_section_code_330;
	};

	struct DXF_entities_seqend
	{
		QString Master_handle_id;
		QString DXF_entities_seqend_code_5;
		QString DXF_entities_seqend_code_6;

		QString DXF_entities_seqend_code_8;

		double DXF_entities_seqend_code_10;
		double DXF_entities_seqend_code_11;
		double DXF_entities_seqend_code_20;
		double DXF_entities_seqend_code_21;
		double DXF_entities_seqend_code_30;
		double DXF_entities_seqend_code_31;

		int16_t DXF_entities_seqend_code_62;

		QString DXF_entities_seqend_code_100[3];

		QString DXF_entities_seqend_code_330;
	};

	struct DXF_entities_shape
	{
		QString DXF_entities_shape_code_5;
		QString DXF_entities_shape_code_6;

		QString DXF_entities_shape_code_8;

		double DXF_entities_shape_code_10;
		double DXF_entities_shape_code_11;
		double DXF_entities_shape_code_20;
		double DXF_entities_shape_code_21;
		double DXF_entities_shape_code_30;
		double DXF_entities_shape_code_31;

		int16_t DXF_entities_shape_code_62;

		QString DXF_entities_shape_code_100[3];

		QString DXF_entities_shape_code_330;
	};

	struct DXF_entities_solid
	{
		QString DXF_entities_solid_code_5;
		QString DXF_entities_solid_code_6;

		QString DXF_entities_solid_code_8;

		double DXF_entities_solid_code_10;
		double DXF_entities_solid_code_11;
		double DXF_entities_solid_code_12;
		double DXF_entities_solid_code_13;
		double DXF_entities_solid_code_20;
		double DXF_entities_solid_code_21;
		double DXF_entities_solid_code_22;
		double DXF_entities_solid_code_23;
		double DXF_entities_solid_code_30;
		double DXF_entities_solid_code_31;
		double DXF_entities_solid_code_32;
		double DXF_entities_solid_code_33;

		int16_t DXF_entities_solid_code_62;

		QString DXF_entities_solid_code_100[3];

		QString DXF_entities_solid_code_330;
	};

	struct DXF_entities_spline
	{
		QString DXF_entities_spline_code_5;
		QString DXF_entities_spline_code_6;

		QString DXF_entities_spline_code_8;

		double DXF_entities_spline_code_10[50];
		double DXF_entities_spline_code_11;
		double DXF_entities_spline_code_20[50];
		double DXF_entities_spline_code_21;
		double DXF_entities_spline_code_30[50];
		double DXF_entities_spline_code_31;

		double DXF_entities_spline_code_40[50];

		double DXF_entities_spline_code_42;
		double DXF_entities_spline_code_43;

		int16_t DXF_entities_spline_code_62;

		int16_t DXF_entities_spline_code_70;
		int16_t DXF_entities_spline_code_71;
		int16_t DXF_entities_spline_code_72;
		int16_t DXF_entities_spline_code_73;
		int16_t DXF_entities_spline_code_74;

		QString DXF_entities_spline_code_100[3];

		double DXF_entities_spline_code_210;
		double DXF_entities_spline_code_220;
		double DXF_entities_spline_code_230;

		QString DXF_entities_spline_code_330;
	};

	struct DXF_entities_sun
	{
		QString DXF_entities_sun_code_5;
		QString DXF_entities_sun_code_6;

		QString DXF_entities_sun_code_8;

		double DXF_entities_sun_code_10;
		double DXF_entities_sun_code_11;
		double DXF_entities_sun_code_20;
		double DXF_entities_sun_code_21;
		double DXF_entities_sun_code_30;
		double DXF_entities_sun_code_31;

		int16_t DXF_entities_sun_code_62;

		QString DXF_entities_sun_code_100[3];

		QString DXF_entities_sun_code_330;
	};

	struct DXF_entities_surface
	{
		QString DXF_entities_surface_code_5;
		QString DXF_entities_surface_code_6;

		QString DXF_entities_surface_code_8;

		double DXF_entities_surface_code_10;
		double DXF_entities_surface_code_11;
		double DXF_entities_surface_code_20;
		double DXF_entities_surface_code_21;
		double DXF_entities_surface_code_30;
		double DXF_entities_surface_code_31;

		int16_t DXF_entities_surface_code_62;

		QString DXF_entities_surface_code_100[3];

		QString DXF_entities_surface_code_330;
	};

	struct DXF_entities_table
	{
		QString DXF_entities_table_code_5;
		QString DXF_entities_table_code_6;

		QString DXF_entities_table_code_8;

		double DXF_entities_table_code_10;
		double DXF_entities_table_code_11;
		double DXF_entities_table_code_20;
		double DXF_entities_table_code_21;
		double DXF_entities_table_code_30;
		double DXF_entities_table_code_31;

		int16_t DXF_entities_table_code_62;

		QString DXF_entities_table_code_100[3];

		QString DXF_entities_table_code_330;
	};

	struct DXF_entities_text
	{
		QString DXF_entities_text_code_1; // Default value text string
		QString DXF_entities_text_code_5; //
		QString DXF_entities_text_code_6;
		QString DXF_entities_text_code_7;
		QString DXF_entities_text_code_8;

		double DXF_entities_text_code_10;
		double DXF_entities_text_code_11;
		double DXF_entities_text_code_20;
		double DXF_entities_text_code_21;
		double DXF_entities_text_code_30;
		double DXF_entities_text_code_31;

		double DXF_entities_text_code_40; // Text height
		double DXF_entities_text_code_50; // Text rotation

		int16_t DXF_entities_text_code_62;

		int16_t DXF_entities_text_code_72;
		int16_t DXF_entities_text_code_73;

		QString DXF_entities_text_code_100[3];
		QString DXF_entities_text_code_102[5];

		QString DXF_entities_text_code_330[5];

	};

	struct DXF_entities_tolerance
	{
		QString DXF_entities_tolerance_code_5;
		QString DXF_entities_tolerance_code_6;

		QString DXF_entities_tolerance_code_8;

		double DXF_entities_tolerance_code_10;
		double DXF_entities_tolerance_code_11;
		double DXF_entities_tolerance_code_20;
		double DXF_entities_tolerance_code_21;
		double DXF_entities_tolerance_code_30;
		double DXF_entities_tolerance_code_31;

		int16_t DXF_entities_tolerance_code_62;

		QString DXF_entities_tolerance_code_100[3];

		QString DXF_entities_tolerance_code_330;
	};

	struct DXF_entities_trace
	{
		QString DXF_entities_trace_code_5;
		QString DXF_entities_trace_code_6;

		QString DXF_entities_trace_code_8;

		double DXF_entities_trace_code_10;
		double DXF_entities_trace_code_11;
		double DXF_entities_trace_code_20;
		double DXF_entities_trace_code_21;
		double DXF_entities_trace_code_30;
		double DXF_entities_trace_code_31;

		int16_t DXF_entities_trace_code_62;

		QString DXF_entities_trace_code_100[3];

		QString DXF_entities_trace_code_330;
	};

	struct DXF_entities_underlay
	{
		QString DXF_entities_underlay_code_5;
		QString DXF_entities_underlay_code_6;

		QString DXF_entities_underlay_code_8;

		double DXF_entities_underlay_code_10;
		double DXF_entities_underlay_code_11;
		double DXF_entities_underlay_code_20;
		double DXF_entities_underlay_code_21;
		double DXF_entities_underlay_code_30;
		double DXF_entities_underlay_code_31;

		int16_t DXF_entities_underlay_code_62;

		QString DXF_entities_underlay_code_100[3];

		QString DXF_entities_underlay_code_330;
	};

	struct DXF_entities_vertex
	{
		QString Master_handle_id;
		QString DXF_entities_vertex_code_5;
		QString DXF_entities_vertex_code_6;

		QString DXF_entities_vertex_code_8;

		double DXF_entities_vertex_code_10;
		double DXF_entities_vertex_code_11;
		double DXF_entities_vertex_code_20;
		double DXF_entities_vertex_code_21;
		double DXF_entities_vertex_code_30;
		double DXF_entities_vertex_code_31;

		int16_t DXF_entities_vertex_code_62;

		QString DXF_entities_vertex_code_100[3];

		QString DXF_entities_vertex_code_330;
	};

	struct DXF_entities_viewport
	{
		QString DXF_entities_viewport_code_5;
		QString DXF_entities_viewport_code_6;

		QString DXF_entities_viewport_code_8;

		double DXF_entities_viewport_code_10;
		double DXF_entities_viewport_code_11;
		double DXF_entities_viewport_code_20;
		double DXF_entities_viewport_code_21;
		double DXF_entities_viewport_code_30;
		double DXF_entities_viewport_code_31;

		int16_t DXF_entities_viewport_code_62;

		QString DXF_entities_viewport_code_100[3];

		QString DXF_entities_viewport_code_330;
	};

	struct DXF_entities_wipeout
	{
		QString DXF_entities_wipeout_code_5;
		QString DXF_entities_wipeout_code_6;

		QString DXF_entities_wipeout_code_8;

		double DXF_entities_wipeout_code_10;
		double DXF_entities_wipeout_code_11;
		double DXF_entities_wipeout_code_20;
		double DXF_entities_wipeout_code_21;
		double DXF_entities_wipeout_code_30;
		double DXF_entities_wipeout_code_31;

		int16_t DXF_entities_wipeout_code_62;

		QString DXF_entities_wipeout_code_100[3];

		QString DXF_entities_wipeout_code_330;
	};

	struct DXF_entities_xline
	{
		QString DXF_entities_xline_code_5;
		QString DXF_entities_xline_code_6;

		QString DXF_entities_xline_code_8;

		double DXF_entities_xline_code_10;
		double DXF_entities_xline_code_11;
		double DXF_entities_xline_code_20;
		double DXF_entities_xline_code_21;
		double DXF_entities_xline_code_30;
		double DXF_entities_xline_code_31;

		int16_t DXF_entities_xline_code_62;

		QString DXF_entities_xline_code_100[3];

		QString DXF_entities_xline_code_330;
	};


class dxf_data
{


	public:



	dxf_data();



};

#endif // DXF_DATA_H
