/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.DownloadFactory;
import org.eclipse.swt.browser.FilePickerFactory;
import org.eclipse.swt.browser.HelperAppLauncherDialogFactory;
import org.eclipse.swt.browser.InputStream;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.PromptServiceFactory;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowCreator;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsIAppShell;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsICategoryManager;
import org.eclipse.swt.internal.mozilla.nsIComponentManager;
import org.eclipse.swt.internal.mozilla.nsIComponentRegistrar;
import org.eclipse.swt.internal.mozilla.nsIContextMenuListener;
import org.eclipse.swt.internal.mozilla.nsICookie;
import org.eclipse.swt.internal.mozilla.nsICookieManager;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDOMEvent;
import org.eclipse.swt.internal.mozilla.nsIDOMMouseEvent;
import org.eclipse.swt.internal.mozilla.nsIDOMWindow;
import org.eclipse.swt.internal.mozilla.nsIDocShell;
import org.eclipse.swt.internal.mozilla.nsIEmbeddingSiteWindow;
import org.eclipse.swt.internal.mozilla.nsIIOService;
import org.eclipse.swt.internal.mozilla.nsIInterfaceRequestor;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsIPrefBranch;
import org.eclipse.swt.internal.mozilla.nsIPrefLocalizedString;
import org.eclipse.swt.internal.mozilla.nsIPrefService;
import org.eclipse.swt.internal.mozilla.nsIRequest;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISimpleEnumerator;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipse.swt.internal.mozilla.nsITooltipListener;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.internal.mozilla.nsIURIContentListener;
import org.eclipse.swt.internal.mozilla.nsIWeakReference;
import org.eclipse.swt.internal.mozilla.nsIWebBrowser;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChromeFocus;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserFocus;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserStream;
import org.eclipse.swt.internal.mozilla.nsIWebNavigation;
import org.eclipse.swt.internal.mozilla.nsIWebProgress;
import org.eclipse.swt.internal.mozilla.nsIWebProgressListener;
import org.eclipse.swt.internal.mozilla.nsIWindowWatcher;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Browser
extends Composite {
    long embedHandle;
    long mozillaHandle;
    nsIWebBrowser webBrowser;
    XPCOMObject supports;
    XPCOMObject weakReference;
    XPCOMObject webProgressListener;
    XPCOMObject webBrowserChrome;
    XPCOMObject webBrowserChromeFocus;
    XPCOMObject embeddingSiteWindow;
    XPCOMObject interfaceRequestor;
    XPCOMObject supportsWeakReference;
    XPCOMObject contextMenuListener;
    XPCOMObject uriContentListener;
    XPCOMObject tooltipListener;
    int chromeFlags = 1;
    int refCount = 0;
    long request;
    Point location;
    Point size;
    boolean addressBar;
    boolean menuBar;
    boolean statusBar;
    boolean toolBar;
    boolean visible;
    Shell tip = null;
    CloseWindowListener[] closeWindowListeners = new CloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    VisibilityWindowListener[] visibilityWindowListeners = new VisibilityWindowListener[0];
    static nsIAppShell AppShell;
    static WindowCreator WindowCreator;
    static int BrowserCount;
    static boolean mozilla;
    static boolean ignoreDispose;
    static Callback eventCallback;
    static long eventProc;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";
    static final String URI_FROMMEMORY = "file:///";
    static final String ABOUT_BLANK = "about:blank";
    static final String PREFERENCE_LANGUAGES = "intl.accept_languages";
    static final String PREFERENCE_CHARSET = "intl.charset.default";
    static final String SEPARATOR_LOCALE = "-";
    static final String TOKENIZER_LOCALE = ",";
    static final int STOP_PROPOGATE = 1;
    static /* synthetic */ Class class$0;

    public Browser(Composite parent, int style) {
        super(Browser.fixIM(parent), style);
        long list;
        Display display = parent.getDisplay();
        display.setData(NO_INPUT_METHOD, null);
        long[] result = new long[1];
        if (!mozilla) {
            File file;
            String mozillaPath = null;
            long ptr = OS.getenv(Converter.wcsToMbcs(null, "MOZILLA_FIVE_HOME", true));
            if (ptr != 0L) {
                int length = OS.strlen(ptr);
                byte[] buffer = new byte[length];
                OS.memmove(buffer, ptr, (long)length);
                mozillaPath = new String(Converter.mbcsToWcs(null, buffer));
            }
            if (mozillaPath == null) {
                this.dispose();
                SWT.error(2, null, " [Unknown Mozilla path (MOZILLA_FIVE_HOME not set)]");
            }
            if ((file = new File(mozillaPath, "components/libwidget_gtk.so")).exists()) {
                this.dispose();
                SWT.error(2, null, " [Mozilla GTK2 required (GTK1.2 detected)]");
            }
            try {
                Library.loadLibrary("swt-mozilla");
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    Library.loadLibrary("swt-mozilla-gcc3");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.dispose();
                    SWT.error(2, e);
                }
            }
            long[] retVal = new long[1];
            nsEmbedString path = new nsEmbedString(mozillaPath);
            int rc = XPCOM.NS_NewLocalFile(path.getAddress(), true, retVal);
            path.dispose();
            if (rc != 0) {
                Browser.error(rc);
            }
            if (retVal[0] == 0L) {
                Browser.error(-2147467261);
            }
            nsILocalFile localFile = new nsILocalFile(retVal[0]);
            rc = XPCOM.NS_InitEmbedding(localFile.getAddress(), 0L);
            localFile.Release();
            if (rc != 0) {
                this.dispose();
                SWT.error(2, null, " [NS_InitEmbedding " + mozillaPath + " error " + rc + "]");
            }
            if ((rc = XPCOM.NS_GetComponentManager(result)) != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            nsIComponentManager componentManager = new nsIComponentManager(result[0]);
            result[0] = 0L;
            rc = componentManager.CreateInstance(XPCOM.NS_APPSHELL_CID, 0L, nsIAppShell.NS_IAPPSHELL_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            if ((rc = (AppShell = new nsIAppShell(result[0])).Create(0L, null)) != 0) {
                Browser.error(rc);
            }
            if ((rc = AppShell.Spinup()) != 0) {
                Browser.error(rc);
            }
            WindowCreator = new WindowCreator();
            WindowCreator.AddRef();
            rc = XPCOM.NS_GetServiceManager(result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
            result[0] = 0L;
            byte[] buffer = "@mozilla.org/embedcomp/window-watcher;1".getBytes();
            byte[] aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            rc = serviceManager.GetServiceByContractID(aContractID, nsIWindowWatcher.NS_IWINDOWWATCHER_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            nsIWindowWatcher windowWatcher = new nsIWindowWatcher(result[0]);
            result[0] = 0L;
            rc = windowWatcher.SetWindowCreator(WindowCreator.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            windowWatcher.Release();
            buffer = "@mozilla.org/preferences-service;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            rc = serviceManager.GetServiceByContractID(aContractID, nsIPrefService.NS_IPREFSERVICE_IID, result);
            serviceManager.Release();
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            nsIPrefService prefService = new nsIPrefService(result[0]);
            result[0] = 0L;
            buffer = new byte[1];
            rc = prefService.GetBranch(buffer, result);
            prefService.Release();
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            nsIPrefBranch prefBranch = new nsIPrefBranch(result[0]);
            result[0] = 0L;
            String prefLocales = null;
            nsIPrefLocalizedString localizedString = null;
            buffer = Converter.wcsToMbcs(null, PREFERENCE_LANGUAGES, true);
            rc = prefBranch.GetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
            if (rc != 0) {
                prefLocales = "en-us,en,";
            } else {
                if (result[0] == 0L) {
                    Browser.error(-2147467262);
                }
                localizedString = new nsIPrefLocalizedString(result[0]);
                result[0] = 0L;
                rc = localizedString.ToString(result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0L) {
                    Browser.error(-2147467262);
                }
                int length = XPCOM.strlen_PRUnichar(result[0]);
                char[] dest = new char[length];
                XPCOM.memmove(dest, result[0], length * 2);
                prefLocales = String.valueOf(new String(dest)) + TOKENIZER_LOCALE;
            }
            result[0] = 0L;
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            StringBuffer stringBuffer = new StringBuffer(language);
            stringBuffer.append(SEPARATOR_LOCALE);
            stringBuffer.append(country.toLowerCase());
            stringBuffer.append(TOKENIZER_LOCALE);
            stringBuffer.append(language);
            stringBuffer.append(TOKENIZER_LOCALE);
            String newLocales = stringBuffer.toString();
            StringTokenizer tokenzier = new StringTokenizer(prefLocales, TOKENIZER_LOCALE);
            while (tokenzier.hasMoreTokens()) {
                String token = (String.valueOf(tokenzier.nextToken()) + TOKENIZER_LOCALE).trim();
                if (newLocales.indexOf(token) != -1) continue;
                stringBuffer.append(token);
            }
            newLocales = stringBuffer.toString();
            if (!newLocales.equals(prefLocales)) {
                newLocales = newLocales.substring(0, newLocales.length() - TOKENIZER_LOCALE.length());
                int length = newLocales.length();
                char[] charBuffer = new char[length + 1];
                newLocales.getChars(0, length, charBuffer, 0);
                if (localizedString == null) {
                    byte[] contractID = Converter.wcsToMbcs(null, "@mozilla.org/pref-localizedstring;1", true);
                    rc = componentManager.CreateInstanceByContractID(contractID, 0L, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
                    if (rc != 0) {
                        Browser.error(rc);
                    }
                    if (result[0] == 0L) {
                        Browser.error(-2147467262);
                    }
                    localizedString = new nsIPrefLocalizedString(result[0]);
                    result[0] = 0L;
                }
                localizedString.SetDataWithLength(length, charBuffer);
                rc = prefBranch.SetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress());
            }
            if (localizedString != null) {
                localizedString.Release();
                localizedString = null;
            }
            String prefCharset = null;
            buffer = Converter.wcsToMbcs(null, PREFERENCE_CHARSET, true);
            rc = prefBranch.GetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
            if (rc != 0) {
                prefCharset = "ISO-8859-1";
            } else {
                if (result[0] == 0L) {
                    Browser.error(-2147467262);
                }
                localizedString = new nsIPrefLocalizedString(result[0]);
                result[0] = 0L;
                rc = localizedString.ToString(result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0L) {
                    Browser.error(-2147467262);
                }
                int length = XPCOM.strlen_PRUnichar(result[0]);
                char[] dest = new char[length];
                XPCOM.memmove(dest, result[0], length * 2);
                prefCharset = new String(dest);
            }
            result[0] = 0L;
            String newCharset = System.getProperty("file.encoding");
            if (!newCharset.equals(prefCharset)) {
                int length = newCharset.length();
                char[] charBuffer = new char[length + 1];
                newCharset.getChars(0, length, charBuffer, 0);
                if (localizedString == null) {
                    byte[] contractID = Converter.wcsToMbcs(null, "@mozilla.org/pref-localizedstring;1", true);
                    rc = componentManager.CreateInstanceByContractID(contractID, 0L, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
                    if (rc != 0) {
                        Browser.error(rc);
                    }
                    if (result[0] == 0L) {
                        Browser.error(-2147467262);
                    }
                    localizedString = new nsIPrefLocalizedString(result[0]);
                    result[0] = 0L;
                }
                localizedString.SetDataWithLength(length, charBuffer);
                rc = prefBranch.SetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress());
            }
            if (localizedString != null) {
                localizedString.Release();
            }
            prefBranch.Release();
            PromptServiceFactory factory = new PromptServiceFactory();
            factory.AddRef();
            rc = componentManager.QueryInterface(nsIComponentRegistrar.NS_ICOMPONENTREGISTRAR_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            nsIComponentRegistrar componentRegistrar = new nsIComponentRegistrar(result[0]);
            result[0] = 0L;
            buffer = "@mozilla.org/embedcomp/prompt-service;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            buffer = "Prompt Service".getBytes();
            byte[] aClassName = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_PROMPTSERVICE_CID, aClassName, aContractID, factory.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            factory.Release();
            HelperAppLauncherDialogFactory dialogFactory = new HelperAppLauncherDialogFactory();
            dialogFactory.AddRef();
            buffer = "@mozilla.org/helperapplauncherdialog;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            buffer = "Helper App Launcher Dialog".getBytes();
            aClassName = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_HELPERAPPLAUNCHERDIALOG_CID, aClassName, aContractID, dialogFactory.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            dialogFactory.Release();
            DownloadFactory downloadFactory = new DownloadFactory();
            downloadFactory.AddRef();
            buffer = "@mozilla.org/download;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            buffer = "Download".getBytes();
            aClassName = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_DOWNLOAD_CID, aClassName, aContractID, downloadFactory.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            downloadFactory.Release();
            FilePickerFactory pickerFactory = new FilePickerFactory();
            pickerFactory.AddRef();
            buffer = "@mozilla.org/filepicker;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            buffer = "FilePicker".getBytes();
            aClassName = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_FILEPICKER_CID, aClassName, aContractID, pickerFactory.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            pickerFactory.Release();
            componentRegistrar.Release();
            componentManager.Release();
            mozilla = true;
        }
        ++BrowserCount;
        int rc = XPCOM.NS_GetComponentManager(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIComponentManager componentManager = new nsIComponentManager(result[0]);
        result[0] = 0L;
        nsID NS_IWEBBROWSER_CID = new nsID("F1EAC761-87E9-11d3-AF80-00A024FFC08C");
        rc = componentManager.CreateInstance(NS_IWEBBROWSER_CID, 0L, nsIWebBrowser.NS_IWEBBROWSER_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        componentManager.Release();
        this.webBrowser = new nsIWebBrowser(result[0]);
        this.createCOMInterfaces();
        this.AddRef();
        rc = this.webBrowser.SetContainerWindow(this.webBrowserChrome.getAddress());
        if (rc != 0) {
            Browser.error(rc);
        }
        if ((rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result)) != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        Rectangle rect = this.getClientArea();
        if (rect.isEmpty()) {
            rect.width = 1;
            rect.height = 1;
        }
        this.embedHandle = OS.gtk_hbox_new(false, 0);
        OS.gtk_container_add(this.handle, this.embedHandle);
        OS.gtk_widget_show(this.embedHandle);
        rc = baseWindow.InitWindow(this.embedHandle, 0L, 0, 0, rect.width, rect.height);
        if (rc != 0) {
            Browser.error(-2147467259);
        }
        if ((rc = baseWindow.Create()) != 0) {
            Browser.error(-2147467259);
        }
        if ((rc = baseWindow.SetVisibility(true)) != 0) {
            Browser.error(-2147467259);
        }
        baseWindow.Release();
        rc = this.webBrowser.AddWebBrowserListener(this.weakReference.getAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
        if (rc != 0) {
            Browser.error(rc);
        }
        if ((rc = this.webBrowser.SetParentURIContentListener(this.uriContentListener.getAddress())) != 0) {
            Browser.error(rc);
        }
        if (eventCallback == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.browser.Browser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((eventProc = (eventCallback = new Callback(clazz, "eventProc", 3)).getAddress()) == 0L) {
                Browser.error(3);
            }
        }
        if ((list = OS.gtk_container_get_children(this.embedHandle)) != 0L) {
            this.mozillaHandle = OS.g_list_data(list);
            OS.g_list_free(list);
            if (this.mozillaHandle != 0L) {
                this.getDisplay().setData(ADD_WIDGET_KEY, new Object[]{new LONG(this.mozillaHandle), this});
                OS.g_signal_connect(this.mozillaHandle, OS.event, eventProc, 0L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_press_event, eventProc, 1L);
                OS.g_signal_connect(this.mozillaHandle, OS.key_release_event, eventProc, 1L);
            }
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (ignoreDispose) {
                            ignoreDispose = false;
                            break;
                        }
                        ignoreDispose = true;
                        Browser.this.notifyListeners(event.type, event);
                        event.type = 0;
                        Browser.this.onDispose(event.display);
                        break;
                    }
                    case 11: {
                        Browser.this.onResize();
                        break;
                    }
                    case 15: {
                        Browser.this.Activate();
                        break;
                    }
                    case 27: {
                        Display display = event.display;
                        if (Browser.this != display.getFocusControl()) break;
                        Browser.this.Deactivate();
                        break;
                    }
                    case 22: {
                        Display display = event.display;
                        display.asyncExec(new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (1.access$0(this.this$1).isDisposed()) {
                                    return;
                                }
                                1.access$0(this.this$1).onResize();
                            }
                        });
                    }
                }
            }

            static /* synthetic */ Browser access$0(1 var0) {
                return var0.Browser.this;
            }
        };
        int[] folderEvents = new int[]{12, 11, 15, 27, 22};
        int i = 0;
        while (i < folderEvents.length) {
            this.addListener(folderEvents[i], listener);
            ++i;
        }
    }

    public static void clearSessions() {
        if (!mozilla) {
            return;
        }
        long[] result = new long[1];
        int rc = XPCOM.NS_GetServiceManager(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0L;
        byte[] buffer = "@mozilla.org/cookiemanager;1".getBytes();
        byte[] aContractID = new byte[buffer.length + 1];
        System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
        rc = serviceManager.GetServiceByContractID(aContractID, nsICookieManager.NS_ICOOKIEMANAGER_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        serviceManager.Release();
        nsICookieManager manager = new nsICookieManager(result[0]);
        result[0] = 0L;
        rc = manager.GetEnumerator(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        manager.Release();
        nsISimpleEnumerator enumerator = new nsISimpleEnumerator(result[0]);
        boolean[] moreElements = new boolean[1];
        rc = enumerator.HasMoreElements(moreElements);
        if (rc != 0) {
            Browser.error(rc);
        }
        while (moreElements[0]) {
            result[0] = 0L;
            rc = enumerator.GetNext(result);
            if (rc != 0) {
                Browser.error(rc);
            }
            nsICookie cookie = new nsICookie(result[0]);
            long[] expires = new long[1];
            rc = cookie.GetExpires(expires);
            if (expires[0] == 0L) {
                long domain = XPCOM.nsEmbedCString_new();
                long name = XPCOM.nsEmbedCString_new();
                long path = XPCOM.nsEmbedCString_new();
                cookie.GetHost(domain);
                cookie.GetName(name);
                cookie.GetPath(path);
                rc = manager.Remove(domain, name, path, false);
                XPCOM.nsEmbedCString_delete(domain);
                XPCOM.nsEmbedCString_delete(name);
                XPCOM.nsEmbedCString_delete(path);
                if (rc != 0) {
                    Browser.error(rc);
                }
            }
            cookie.Release();
            rc = enumerator.HasMoreElements(moreElements);
            if (rc == 0) continue;
            Browser.error(rc);
        }
        enumerator.Release();
    }

    static long eventProc(long handle, long gdkEvent, long pointer) {
        Widget widget = Display.getCurrent().findWidget(handle);
        if (widget != null && widget instanceof Browser) {
            return ((Browser)widget).gtk_event(handle, gdkEvent, pointer);
        }
        return 0L;
    }

    static Composite fixIM(Composite parent) {
        Display display;
        if (parent != null && !parent.isDisposed() && (display = parent.getDisplay()) != null && display.getThread() == Thread.currentThread()) {
            display.setData(NO_INPUT_METHOD, "true");
        }
        return parent;
    }

    long gtk_event(long handle, long gdkEvent, long pointer) {
        if (pointer == 1L) {
            return 1L;
        }
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        switch (event.type) {
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                OS.gtk_widget_event(this.handle, gdkEvent);
            }
        }
        return 0L;
    }

    public void addCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = newCloseWindowListeners;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = listener;
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, this.locationListeners.length);
        this.locationListeners = newLocationListeners;
        this.locationListeners[this.locationListeners.length - 1] = listener;
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, this.openWindowListeners.length);
        this.openWindowListeners = newOpenWindowListeners;
        this.openWindowListeners[this.openWindowListeners.length - 1] = listener;
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, this.progressListeners.length);
        this.progressListeners = newProgressListeners;
        this.progressListeners[this.progressListeners.length - 1] = listener;
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, this.statusTextListeners.length);
        this.statusTextListeners = newStatusTextListeners;
        this.statusTextListeners[this.statusTextListeners.length - 1] = listener;
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, this.titleListeners.length);
        this.titleListeners = newTitleListeners;
        this.titleListeners[this.titleListeners.length - 1] = listener;
    }

    public void addVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = listener;
    }

    public boolean back() {
        this.checkWidget();
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.GoBack();
        webNavigation.Release();
        return rc == 0;
    }

    protected void checkSubclass() {
        int index;
        String name = this.getClass().getName();
        if (!name.substring(0, (index = name.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.QueryReferent(args[0], args[1]);
            }
        };
        int[] nArray3 = new int[8];
        nArray3[0] = 2;
        nArray3[3] = 4;
        nArray3[4] = 6;
        nArray3[5] = 3;
        nArray3[6] = 4;
        nArray3[7] = 3;
        this.webProgressListener = new XPCOMObject(nArray3){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.OnStateChange(args[0], args[1], args[2], args[3]);
            }

            public long method4(long[] args) {
                return Browser.this.OnProgressChange(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public long method5(long[] args) {
                return Browser.this.OnLocationChange(args[0], args[1], args[2]);
            }

            public long method6(long[] args) {
                return Browser.this.OnStatusChange(args[0], args[1], args[2], args[3]);
            }

            public long method7(long[] args) {
                return Browser.this.OnSecurityChange(args[0], args[1], args[2]);
            }
        };
        int[] nArray4 = new int[13];
        nArray4[0] = 2;
        nArray4[3] = 2;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[9] = 2;
        nArray4[11] = 1;
        nArray4[12] = 1;
        this.webBrowserChrome = new XPCOMObject(nArray4){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.SetStatus(args[0], args[1]);
            }

            public long method4(long[] args) {
                return Browser.this.GetWebBrowser(args[0]);
            }

            public long method5(long[] args) {
                return Browser.this.SetWebBrowser(args[0]);
            }

            public long method6(long[] args) {
                return Browser.this.GetChromeFlags(args[0]);
            }

            public long method7(long[] args) {
                return Browser.this.SetChromeFlags(args[0]);
            }

            public long method8(long[] args) {
                return Browser.this.DestroyBrowserWindow();
            }

            public long method9(long[] args) {
                return Browser.this.SizeBrowserTo(args[0], args[1]);
            }

            public long method10(long[] args) {
                return Browser.this.ShowAsModal();
            }

            public long method11(long[] args) {
                return Browser.this.IsWindowModal(args[0]);
            }

            public long method12(long[] args) {
                return Browser.this.ExitModalEventLoop(args[0]);
            }
        };
        int[] nArray5 = new int[5];
        nArray5[0] = 2;
        this.webBrowserChromeFocus = new XPCOMObject(nArray5){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.FocusNextElement();
            }

            public long method4(long[] args) {
                return Browser.this.FocusPrevElement();
            }
        };
        int[] nArray6 = new int[11];
        nArray6[0] = 2;
        nArray6[3] = 5;
        nArray6[4] = 5;
        nArray6[6] = 1;
        nArray6[7] = 1;
        nArray6[8] = 1;
        nArray6[9] = 1;
        nArray6[10] = 1;
        this.embeddingSiteWindow = new XPCOMObject(nArray6){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.SetDimensions(args[0], args[1], args[2], args[3], args[4]);
            }

            public long method4(long[] args) {
                return Browser.this.GetDimensions(args[0], args[1], args[2], args[3], args[4]);
            }

            public long method5(long[] args) {
                return Browser.this.SetFocus();
            }

            public long method6(long[] args) {
                return Browser.this.GetVisibility(args[0]);
            }

            public long method7(long[] args) {
                return Browser.this.SetVisibility(args[0]);
            }

            public long method8(long[] args) {
                return Browser.this.GetTitle(args[0]);
            }

            public long method9(long[] args) {
                return Browser.this.SetTitle(args[0]);
            }

            public long method10(long[] args) {
                return Browser.this.GetSiteWindow(args[0]);
            }
        };
        int[] nArray7 = new int[4];
        nArray7[0] = 2;
        nArray7[3] = 2;
        this.interfaceRequestor = new XPCOMObject(nArray7){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.GetInterface(args[0], args[1]);
            }
        };
        int[] nArray8 = new int[4];
        nArray8[0] = 2;
        nArray8[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray8){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.GetWeakReference(args[0]);
            }
        };
        int[] nArray9 = new int[4];
        nArray9[0] = 2;
        nArray9[3] = 3;
        this.contextMenuListener = new XPCOMObject(nArray9){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.OnShowContextMenu(args[0], args[1], args[2]);
            }
        };
        int[] nArray10 = new int[11];
        nArray10[0] = 2;
        nArray10[3] = 2;
        nArray10[4] = 5;
        nArray10[5] = 3;
        nArray10[6] = 4;
        nArray10[7] = 1;
        nArray10[8] = 1;
        nArray10[9] = 1;
        nArray10[10] = 1;
        this.uriContentListener = new XPCOMObject(nArray10){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.OnStartURIOpen(args[0], args[1]);
            }

            public long method4(long[] args) {
                return Browser.this.DoContent(args[0], args[1], args[2], args[3], args[4]);
            }

            public long method5(long[] args) {
                return Browser.this.IsPreferred(args[0], args[1], args[2]);
            }

            public long method6(long[] args) {
                return Browser.this.CanHandleContent(args[0], args[1], args[2], args[3]);
            }

            public long method7(long[] args) {
                return Browser.this.GetLoadCookie(args[0]);
            }

            public long method8(long[] args) {
                return Browser.this.SetLoadCookie(args[0]);
            }

            public long method9(long[] args) {
                return Browser.this.GetParentContentListener(args[0]);
            }

            public long method10(long[] args) {
                return Browser.this.SetParentContentListener(args[0]);
            }
        };
        int[] nArray11 = new int[5];
        nArray11[0] = 2;
        nArray11[3] = 3;
        this.tooltipListener = new XPCOMObject(nArray11){

            public long method0(long[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public long method1(long[] args) {
                return Browser.this.AddRef();
            }

            public long method2(long[] args) {
                return Browser.this.Release();
            }

            public long method3(long[] args) {
                return Browser.this.OnShowTooltip(args[0], args[1], args[2]);
            }

            public long method4(long[] args) {
                return Browser.this.OnHideTooltip();
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.webProgressListener != null) {
            this.webProgressListener.dispose();
            this.webProgressListener = null;
        }
        if (this.webBrowserChrome != null) {
            this.webBrowserChrome.dispose();
            this.webBrowserChrome = null;
        }
        if (this.webBrowserChromeFocus != null) {
            this.webBrowserChromeFocus.dispose();
            this.webBrowserChromeFocus = null;
        }
        if (this.embeddingSiteWindow != null) {
            this.embeddingSiteWindow.dispose();
            this.embeddingSiteWindow = null;
        }
        if (this.interfaceRequestor != null) {
            this.interfaceRequestor.dispose();
            this.interfaceRequestor = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
        if (this.contextMenuListener != null) {
            this.contextMenuListener.dispose();
            this.contextMenuListener = null;
        }
        if (this.uriContentListener != null) {
            this.uriContentListener.dispose();
            this.uriContentListener = null;
        }
        if (this.tooltipListener != null) {
            this.tooltipListener.dispose();
            this.tooltipListener = null;
        }
    }

    public boolean execute(String script) {
        this.checkWidget();
        if (script == null) {
            SWT.error(4);
        }
        String url = "javascript:" + script + ";void(0);";
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        char[] arg = url.toCharArray();
        char[] c = new char[arg.length + 1];
        System.arraycopy(arg, 0, c, 0, arg.length);
        rc = webNavigation.LoadURI(c, 0, 0L, 0L, 0L);
        webNavigation.Release();
        return rc == 0;
    }

    static Browser findBrowser(long handle) {
        long parent = OS.gtk_widget_get_parent(handle);
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(parent);
    }

    public boolean forward() {
        this.checkWidget();
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.GoForward();
        webNavigation.Release();
        return rc == 0;
    }

    public String getUrl() {
        long[] aCurrentURI;
        nsIWebNavigation webNavigation;
        this.checkWidget();
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (webNavigation = new nsIWebNavigation(result[0])).GetCurrentURI(aCurrentURI = new long[1])) != 0) {
            Browser.error(rc);
        }
        webNavigation.Release();
        byte[] dest = null;
        if (aCurrentURI[0] != 0L) {
            nsIURI uri = new nsIURI(aCurrentURI[0]);
            long aSpec = XPCOM.nsEmbedCString_new();
            rc = uri.GetSpec(aSpec);
            if (rc != 0) {
                Browser.error(rc);
            }
            int length = XPCOM.nsEmbedCString_Length(aSpec);
            long buffer = XPCOM.nsEmbedCString_get(aSpec);
            dest = new byte[length];
            XPCOM.memmove(dest, buffer, length);
            XPCOM.nsEmbedCString_delete(aSpec);
            uri.Release();
        }
        if (dest == null) {
            return "";
        }
        String location = new String(dest);
        if (location.equals(URI_FROMMEMORY)) {
            location = ABOUT_BLANK;
        }
        return location;
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        boolean[] aCanGoBack = new boolean[1];
        rc = webNavigation.GetCanGoBack(aCanGoBack);
        webNavigation.Release();
        return aCanGoBack[0];
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        boolean[] aCanGoForward = new boolean[1];
        rc = webNavigation.GetCanGoForward(aCanGoForward);
        webNavigation.Release();
        return aCanGoForward[0];
    }

    static String error(int code) {
        throw new SWTError("XPCOM error " + code);
    }

    void onDispose(Display display) {
        nsIBaseWindow baseWindow;
        long[] result;
        Object[] objectArray = new Object[2];
        objectArray[0] = new LONG(this.mozillaHandle);
        display.setData(ADD_WIDGET_KEY, objectArray);
        int rc = this.webBrowser.RemoveWebBrowserListener(this.weakReference.getAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
        if (rc != 0) {
            Browser.error(rc);
        }
        if ((rc = this.webBrowser.SetParentURIContentListener(0L)) != 0) {
            Browser.error(rc);
        }
        if ((rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result = new long[1])) != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (baseWindow = new nsIBaseWindow(result[0])).Destroy()) != 0) {
            Browser.error(rc);
        }
        baseWindow.Release();
        this.Release();
        this.webBrowser.Release();
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
        --BrowserCount;
    }

    void Activate() {
        nsIWebBrowserFocus webBrowserFocus;
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (webBrowserFocus = new nsIWebBrowserFocus(result[0])).Activate()) != 0) {
            Browser.error(rc);
        }
        webBrowserFocus.Release();
    }

    void Deactivate() {
        nsIWebBrowserFocus webBrowserFocus;
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (webBrowserFocus = new nsIWebBrowserFocus(result[0])).Deactivate()) != 0) {
            Browser.error(rc);
        }
        webBrowserFocus.Release();
    }

    void SetFocusAtFirstElement() {
        nsIWebBrowserFocus webBrowserFocus;
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (webBrowserFocus = new nsIWebBrowserFocus(result[0])).SetFocusAtFirstElement()) != 0) {
            Browser.error(rc);
        }
        webBrowserFocus.Release();
    }

    void onResize() {
        Rectangle rect = this.getClientArea();
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        OS.gtk_widget_set_size_request(this.embedHandle, rect.width, rect.height);
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        rc = baseWindow.SetPositionAndSize(rect.x, rect.y, rect.width, rect.height, true);
        if (rc != 0) {
            Browser.error(rc);
        }
        baseWindow.Release();
    }

    public void refresh() {
        this.checkWidget();
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.Reload(0);
        webNavigation.Release();
        if (rc == 0) {
            return;
        }
        if (rc != -2147467261 && rc != -2142109678) {
            Browser.error(rc);
        }
    }

    public void removeCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            if (listener == this.closeWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new CloseWindowListener[0];
            return;
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, index);
        System.arraycopy(this.closeWindowListeners, index + 1, newCloseWindowListeners, index, this.closeWindowListeners.length - index - 1);
        this.closeWindowListeners = newCloseWindowListeners;
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.locationListeners.length) {
            if (listener == this.locationListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, index);
        System.arraycopy(this.locationListeners, index + 1, newLocationListeners, index, this.locationListeners.length - index - 1);
        this.locationListeners = newLocationListeners;
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.openWindowListeners.length) {
            if (listener == this.openWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, index);
        System.arraycopy(this.openWindowListeners, index + 1, newOpenWindowListeners, index, this.openWindowListeners.length - index - 1);
        this.openWindowListeners = newOpenWindowListeners;
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.progressListeners.length) {
            if (listener == this.progressListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, index);
        System.arraycopy(this.progressListeners, index + 1, newProgressListeners, index, this.progressListeners.length - index - 1);
        this.progressListeners = newProgressListeners;
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            if (listener == this.statusTextListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, index);
        System.arraycopy(this.statusTextListeners, index + 1, newStatusTextListeners, index, this.statusTextListeners.length - index - 1);
        this.statusTextListeners = newStatusTextListeners;
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.titleListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.titleListeners.length) {
            if (listener == this.titleListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, index);
        System.arraycopy(this.titleListeners, index + 1, newTitleListeners, index, this.titleListeners.length - index - 1);
        this.titleListeners = newTitleListeners;
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            if (listener == this.visibilityWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new VisibilityWindowListener[0];
            return;
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, index);
        System.arraycopy(this.visibilityWindowListeners, index + 1, newVisibilityWindowListeners, index, this.visibilityWindowListeners.length - index - 1);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
    }

    public boolean setText(String html) {
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        if (this != this.getDisplay().getFocusControl()) {
            this.Deactivate();
        }
        byte[] data = null;
        try {
            data = html.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        long[] result = new long[1];
        int rc = XPCOM.NS_GetServiceManager(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0L;
        rc = serviceManager.GetService(XPCOM.NS_IOSERVICE_CID, nsIIOService.NS_IIOSERVICE_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        serviceManager.Release();
        nsIIOService ioService = new nsIIOService(result[0]);
        result[0] = 0L;
        byte[] aString = URI_FROMMEMORY.getBytes();
        long aSpec = XPCOM.nsEmbedCString_new(aString, aString.length);
        rc = ioService.NewURI(aSpec, null, 0L, result);
        XPCOM.nsEmbedCString_delete(aSpec);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        ioService.Release();
        nsIURI uri = new nsIURI(result[0]);
        result[0] = 0L;
        byte[] buffer = "text/html".getBytes();
        byte[] contentTypeBuffer = new byte[buffer.length + 1];
        System.arraycopy(buffer, 0, contentTypeBuffer, 0, buffer.length);
        long aContentType = XPCOM.nsEmbedCString_new(contentTypeBuffer, contentTypeBuffer.length);
        result[0] = 0L;
        rc = this.webBrowser.QueryInterface(nsIWebBrowserStream.NS_IWEBBROWSERSTREAM_IID, result);
        if (rc == 0) {
            nsIWebBrowserStream stream;
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            if ((rc = (stream = new nsIWebBrowserStream(result[0])).OpenStream(uri.getAddress(), aContentType)) != 0) {
                Browser.error(rc);
            }
            long ptr = XPCOM.PR_Malloc(data.length);
            XPCOM.memmove(ptr, data, data.length);
            rc = stream.AppendToStream(ptr, data.length);
            if (rc != 0) {
                Browser.error(rc);
            }
            if ((rc = stream.CloseStream()) != 0) {
                Browser.error(rc);
            }
            XPCOM.PR_Free(ptr);
            stream.Release();
        } else {
            rc = this.webBrowser.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0L) {
                Browser.error(-2147467262);
            }
            nsIInterfaceRequestor interfaceRequestor = new nsIInterfaceRequestor(result[0]);
            result[0] = 0L;
            rc = interfaceRequestor.GetInterface(nsIDocShell.NS_IDOCSHELL_IID, result);
            interfaceRequestor.Release();
            nsIDocShell docShell = new nsIDocShell(result[0]);
            result[0] = 0L;
            buffer = "UTF-8".getBytes();
            byte[] contentCharsetBuffer = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, contentCharsetBuffer, 0, buffer.length);
            long aContentCharset = XPCOM.nsEmbedCString_new(contentCharsetBuffer, contentCharsetBuffer.length);
            InputStream inputStream = new InputStream(data);
            inputStream.AddRef();
            rc = docShell.LoadStream(inputStream.getAddress(), uri.getAddress(), aContentType, aContentCharset, 0L);
            if (rc != 0) {
                Browser.error(rc);
            }
            XPCOM.nsEmbedCString_delete(aContentCharset);
            inputStream.Release();
            docShell.Release();
        }
        XPCOM.nsEmbedCString_delete(aContentType);
        uri.Release();
        return true;
    }

    public boolean setUrl(String url) {
        long[] result;
        int rc;
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        if ((rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result = new long[1])) != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        char[] arg = url.toCharArray();
        char[] c = new char[arg.length + 1];
        System.arraycopy(arg, 0, c, 0, arg.length);
        rc = webNavigation.LoadURI(c, 0, 0L, 0L, 0L);
        webNavigation.Release();
        return rc == 0;
    }

    public void stop() {
        nsIWebNavigation webNavigation;
        this.checkWidget();
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (webNavigation = new nsIWebNavigation(result[0])).Stop(3)) != 0) {
            Browser.error(rc);
        }
        webNavigation.Release();
    }

    long QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262L;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.webProgressListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIWebBrowserChrome.NS_IWEBBROWSERCHROME_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.webBrowserChrome.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIWebBrowserChromeFocus.NS_IWEBBROWSERCHROMEFOCUS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.webBrowserChromeFocus.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.embeddingSiteWindow.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.interfaceRequestor.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supportsWeakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIContextMenuListener.NS_ICONTEXTMENULISTENER_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.contextMenuListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsIURIContentListener.NS_IURICONTENTLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.uriContentListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (guid.Equals(nsITooltipListener.NS_ITOOLTIPLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.tooltipListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(ppvObject, new long[1], OS.PTR_SIZEOF);
        return -2147467262L;
    }

    long AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    long Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    long QueryReferent(long riid, long ppvObject) {
        return this.QueryInterface(riid, ppvObject);
    }

    long GetInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262L;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsIDOMWindow.NS_IDOMWINDOW_IID)) {
            long[] aContentDOMWindow = new long[1];
            int rc = this.webBrowser.GetContentDOMWindow(aContentDOMWindow);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (aContentDOMWindow[0] == 0L) {
                Browser.error(-2147467262);
            }
            XPCOM.memmove(ppvObject, aContentDOMWindow, OS.PTR_SIZEOF);
            return rc;
        }
        return this.QueryInterface(riid, ppvObject);
    }

    long GetWeakReference(long ppvObject) {
        XPCOM.memmove(ppvObject, new long[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0L;
    }

    long OnStateChange(long aWebProgress, long aRequest, long aStateFlags, long aStatus) {
        if ((aStateFlags & 0x20000L) == 0L) {
            return 0L;
        }
        if ((aStateFlags & 1L) != 0L) {
            if (this.request == 0L) {
                this.request = aRequest;
            }
        } else if ((aStateFlags & 2L) != 0L) {
            if (this.request == aRequest) {
                this.request = 0L;
            }
        } else if ((aStateFlags & 0x10L) != 0L && (this.request == aRequest || this.request == 0L)) {
            this.request = 0L;
            StatusTextEvent event = new StatusTextEvent(this);
            event.display = this.getDisplay();
            event.widget = this;
            event.text = "";
            int i = 0;
            while (i < this.statusTextListeners.length) {
                this.statusTextListeners[i].changed(event);
                ++i;
            }
            ProgressEvent event2 = new ProgressEvent(this);
            event2.display = this.getDisplay();
            event2.widget = this;
            int i2 = 0;
            while (i2 < this.progressListeners.length) {
                this.progressListeners[i2].completed(event2);
                ++i2;
            }
        }
        return 0L;
    }

    long OnProgressChange(long aWebProgress, long aRequest, long aCurSelfProgress, long aMaxSelfProgress, long aCurTotalProgress, long aMaxTotalProgress) {
        if (this.progressListeners.length == 0) {
            return 0L;
        }
        long total = aMaxTotalProgress;
        if (total <= 0L) {
            total = Integer.MAX_VALUE;
        }
        ProgressEvent event = new ProgressEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        event.current = (int)aCurTotalProgress;
        event.total = (int)aMaxTotalProgress;
        int i = 0;
        while (i < this.progressListeners.length) {
            this.progressListeners[i].changed(event);
            ++i;
        }
        return 0L;
    }

    long OnLocationChange(long aWebProgress, long aRequest, long aLocation) {
        long[] aTop;
        nsIDOMWindow domWindow;
        if (this.request != 0L && this.request != aRequest) {
            this.request = aRequest;
        }
        if (this.locationListeners.length == 0) {
            return 0L;
        }
        nsIWebProgress webProgress = new nsIWebProgress(aWebProgress);
        long[] aDOMWindow = new long[1];
        int rc = webProgress.GetDOMWindow(aDOMWindow);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (aDOMWindow[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (domWindow = new nsIDOMWindow(aDOMWindow[0])).GetTop(aTop = new long[1])) != 0) {
            Browser.error(rc);
        }
        if (aTop[0] == 0L) {
            Browser.error(-2147467262);
        }
        domWindow.Release();
        nsIDOMWindow topWindow = new nsIDOMWindow(aTop[0]);
        topWindow.Release();
        nsIURI location = new nsIURI(aLocation);
        long aSpec = XPCOM.nsEmbedCString_new();
        location.GetSpec(aSpec);
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        long buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aSpec);
        LocationEvent event = new LocationEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        event.location = new String(dest);
        if (event.location.equals(URI_FROMMEMORY)) {
            event.location = ABOUT_BLANK;
        }
        event.top = aTop[0] == aDOMWindow[0];
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(event);
            ++i;
        }
        return 0L;
    }

    long OnStatusChange(long aWebProgress, long aRequest, long aStatus, long aMessage) {
        nsIRequest request = new nsIRequest(aRequest);
        long aName = XPCOM.nsEmbedCString_new();
        request.GetName(aName);
        int length = XPCOM.nsEmbedCString_Length(aName);
        long buffer = XPCOM.nsEmbedCString_get(aName);
        byte[] bytes = new byte[length];
        XPCOM.memmove(bytes, buffer, length);
        XPCOM.nsEmbedCString_delete(aName);
        String value = new String(bytes);
        if (value.startsWith("https:")) {
            request.Cancel(2);
            return 0L;
        }
        if (this.statusTextListeners.length == 0) {
            return 0L;
        }
        StatusTextEvent event = new StatusTextEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        length = XPCOM.strlen_PRUnichar(aMessage);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aMessage, length * 2);
        event.text = new String(dest);
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(event);
            ++i;
        }
        return 0L;
    }

    long OnSecurityChange(long aWebProgress, long aRequest, long state) {
        return 0L;
    }

    long SetStatus(long statusType, long status) {
        StatusTextEvent event = new StatusTextEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        int length = XPCOM.strlen_PRUnichar(status);
        char[] dest = new char[length];
        XPCOM.memmove(dest, status, length * 2);
        String string = new String(dest);
        if (string == null) {
            string = "";
        }
        event.text = string;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(event);
            ++i;
        }
        return 0L;
    }

    long GetWebBrowser(long aWebBrowser) {
        long[] ret = new long[1];
        if (this.webBrowser != null) {
            this.webBrowser.AddRef();
            ret[0] = this.webBrowser.getAddress();
        }
        XPCOM.memmove(aWebBrowser, ret, OS.PTR_SIZEOF);
        return 0L;
    }

    long SetWebBrowser(long aWebBrowser) {
        if (this.webBrowser != null) {
            this.webBrowser.Release();
        }
        this.webBrowser = aWebBrowser != 0L ? new nsIWebBrowser(aWebBrowser) : null;
        return 0L;
    }

    long GetChromeFlags(long aChromeFlags) {
        int[] ret = new int[]{this.chromeFlags};
        XPCOM.memmove(aChromeFlags, ret, 4);
        return 0L;
    }

    long SetChromeFlags(long aChromeFlags) {
        this.chromeFlags = (int)aChromeFlags;
        return 0L;
    }

    long DestroyBrowserWindow() {
        WindowEvent newEvent = new WindowEvent(this);
        newEvent.display = this.getDisplay();
        newEvent.widget = this;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.dispose();
        return 0L;
    }

    long SizeBrowserTo(long aCX, long aCY) {
        this.size = new Point((int)aCX, (int)aCY);
        return 0L;
    }

    long ShowAsModal() {
        return -2147467263L;
    }

    long IsWindowModal(long retval) {
        XPCOM.memmove(retval, new int[1], 4);
        return 0L;
    }

    long ExitModalEventLoop(long aStatus) {
        return 0L;
    }

    long SetDimensions(long flags, long x, long y, long cx, long cy) {
        if (flags == 1L) {
            this.location = new Point((int)x, (int)y);
        }
        return 0L;
    }

    long GetDimensions(long flags, long x, long y, long cx, long cy) {
        return 0L;
    }

    long SetFocus() {
        nsIBaseWindow baseWindow;
        long[] result = new long[1];
        int rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        if ((rc = (baseWindow = new nsIBaseWindow(result[0])).SetFocus()) != 0) {
            Browser.error(rc);
        }
        baseWindow.Release();
        return 0L;
    }

    long GetVisibility(long aVisibility) {
        return 0L;
    }

    long SetVisibility(long aVisibility) {
        WindowEvent event = new WindowEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        if (aVisibility == 1L) {
            if (!this.visible) {
                this.visible = true;
                event.location = this.location;
                event.size = this.size;
                event.addressBar = this.addressBar;
                event.menuBar = this.menuBar;
                event.statusBar = this.statusBar;
                event.toolBar = this.toolBar;
                int i = 0;
                while (i < this.visibilityWindowListeners.length) {
                    this.visibilityWindowListeners[i].show(event);
                    ++i;
                }
                this.location = null;
                this.size = null;
            }
        } else {
            this.visible = false;
            int i = 0;
            while (i < this.visibilityWindowListeners.length) {
                this.visibilityWindowListeners[i].hide(event);
                ++i;
            }
        }
        return 0L;
    }

    long GetTitle(long aTitle) {
        return 0L;
    }

    long SetTitle(long aTitle) {
        if (this.titleListeners.length == 0) {
            return 0L;
        }
        TitleEvent event = new TitleEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        int length = XPCOM.strlen_PRUnichar(aTitle);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aTitle, length * 2);
        event.title = new String(dest);
        int i = 0;
        while (i < this.titleListeners.length) {
            this.titleListeners[i].changed(event);
            ++i;
        }
        return 0L;
    }

    long GetSiteWindow(long aSiteWindow) {
        XPCOM.memmove(aSiteWindow, new long[]{this.embedHandle}, OS.PTR_SIZEOF);
        return 0L;
    }

    long FocusNextElement() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Browser.this.traverse(16);
            }
        });
        return 0L;
    }

    long FocusPrevElement() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Browser.this.traverse(8);
            }
        });
        return 0L;
    }

    long OnShowContextMenu(long aContextFlags, long aEvent, long aNode) {
        nsIDOMEvent domEvent = new nsIDOMEvent(aEvent);
        long[] result = new long[1];
        int rc = domEvent.QueryInterface(nsIDOMMouseEvent.NS_IDOMMOUSEEVENT_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0L) {
            Browser.error(-2147467262);
        }
        nsIDOMMouseEvent domMouseEvent = new nsIDOMMouseEvent(result[0]);
        int[] aScreenX = new int[1];
        int[] aScreenY = new int[1];
        rc = domMouseEvent.GetScreenX(aScreenX);
        if (rc != 0) {
            Browser.error(rc);
        }
        if ((rc = domMouseEvent.GetScreenY(aScreenY)) != 0) {
            Browser.error(rc);
        }
        domMouseEvent.Release();
        Event event = new Event();
        event.x = aScreenX[0];
        event.y = aScreenY[0];
        this.notifyListeners(35, event);
        if (!event.doit) {
            return 0L;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (aScreenX[0] != event.x || aScreenY[0] != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
        }
        return 0L;
    }

    long OnStartURIOpen(long aURI, long retval) {
        boolean doit;
        nsIURI location = new nsIURI(aURI);
        long aSpec = XPCOM.nsEmbedCString_new();
        location.GetSpec(aSpec);
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        long buffer = XPCOM.nsEmbedCString_get(aSpec);
        buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aSpec);
        String value = new String(dest);
        boolean isHttps = value.startsWith("https:");
        if (this.locationListeners.length == 0) {
            XPCOM.memmove(retval, new int[]{isHttps ? 1 : 0}, 4);
            return 0L;
        }
        boolean bl = doit = !isHttps;
        if (this.request == 0L) {
            LocationEvent event = new LocationEvent(this);
            event.display = this.getDisplay();
            event.widget = this;
            event.location = value;
            if (event.location.equals(URI_FROMMEMORY)) {
                event.location = ABOUT_BLANK;
            }
            event.doit = doit;
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changing(event);
                ++i;
            }
            if (!isHttps) {
                doit = event.doit;
            }
        }
        XPCOM.memmove(retval, new int[]{doit ? 0 : 1}, 4);
        return 0L;
    }

    long DoContent(long aContentType, long aIsContentPreferred, long aRequest, long aContentHandler, long retval) {
        return -2147467263L;
    }

    long IsPreferred(long aContentType, long aDesiredContentType, long retval) {
        boolean preferred = false;
        int size = XPCOM.strlen(aContentType);
        if (size > 0) {
            byte[] typeBytes = new byte[size + 1];
            XPCOM.memmove(typeBytes, aContentType, size);
            String contentType = new String(typeBytes);
            if (!contentType.equals("application/x-vnd.mozilla.maybe-text") && !contentType.equals("multipart/x-mixed-replace")) {
                long[] result = new long[1];
                int rc = XPCOM.NS_GetServiceManager(result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0L) {
                    Browser.error(-2147467262);
                }
                nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
                result[0] = 0L;
                rc = serviceManager.GetService(XPCOM.NS_CATEGORYMANAGER_CID, nsICategoryManager.NS_ICATEGORYMANAGER_IID, result);
                serviceManager.Release();
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0L) {
                    Browser.error(-2147467262);
                }
                nsICategoryManager categoryManager = new nsICategoryManager(result[0]);
                result[0] = 0L;
                byte[] categoryBytes = Converter.wcsToMbcs(null, "Gecko-Content-Viewers", true);
                rc = categoryManager.GetCategoryEntry(categoryBytes, typeBytes, result);
                categoryManager.Release();
                preferred = rc == 0;
            }
        }
        XPCOM.memmove(retval, new int[]{preferred ? 1 : 0}, 4);
        return 0L;
    }

    long CanHandleContent(long aContentType, long aIsContentPreferred, long aDesiredContentType, long retval) {
        return -2147467263L;
    }

    long GetLoadCookie(long aLoadCookie) {
        return -2147467263L;
    }

    long SetLoadCookie(long aLoadCookie) {
        return -2147467263L;
    }

    long GetParentContentListener(long aParentContentListener) {
        return -2147467263L;
    }

    long SetParentContentListener(long aParentContentListener) {
        return -2147467263L;
    }

    long OnShowTooltip(long aXCoords, long aYCoords, long aTipText) {
        int length = XPCOM.strlen_PRUnichar(aTipText);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aTipText, length * 2);
        String text = new String(dest);
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        Display display = this.getDisplay();
        Shell parent = this.getShell();
        this.tip = new Shell(parent, 16384);
        this.tip.setLayout(new FillLayout());
        Label label = new Label(this.tip, 0x1000000);
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.setText(text);
        Point point = display.getCursorLocation();
        point.y += 21;
        this.tip.setLocation(point);
        this.tip.pack();
        this.tip.setVisible(true);
        return 0L;
    }

    long OnHideTooltip() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
        return 0L;
    }
}

