/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.AboutDialog;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.JUploadrEventDirector;
import org.scohen.juploadr.app.carbon.CarbonMenuEventHandler;
import org.scohen.juploadr.app.state.RestoreStateTask;
import org.scohen.juploadr.app.state.SaveStateTask;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.prefs.ConfigurationDialog;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.ProgressDialog;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.upload.UploadManager;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.uploadapi.PluginClassLoader;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.util.JUploadrBrowserLauncher;

public class JUploadr {
    public static Shell window;
    private TrayItem myItem;
    private Map imageAttributes;
    private Image logo;
    private Image tinyLogo;
    public Composite images;
    public Composite buttonRow;
    private ScrolledComposite imageContainer;
    private ProgressBar progress;
    final TextTransfer textTransfer = TextTransfer.getInstance();
    final FileTransfer fileTransfer = FileTransfer.getInstance();
    private Button btnSubmit;
    private boolean shouldDie = false;
    private ReusableUIFactory reusableUIFactory;
    private JUploadrEventDirector director = new JUploadrEventDirector(this);
    private Button loginButton;
    private Menu sites;
    private MenuItem implementations;

    public JUploadr() {
        this.reusableUIFactory = ReusableUIFactory.getInstance();
        this.logo = this.reusableUIFactory.getLogoImage();
        this.tinyLogo = this.reusableUIFactory.getTinyLogoImage();
        this.imageAttributes = new HashMap();
        this.initUI();
    }

    private void initUI() {
        window = new Shell(this.reusableUIFactory.getDisplay());
        window.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                Shell source = (Shell)event.widget;
                event.doit = JUploadr.this.shouldDie;
                if (!JUploadr.this.shouldDie) {
                    source.setVisible(false);
                }
            }
        });
        this.buildMenu(window);
        this.imageContainer = new ScrolledComposite((Composite)window, 2560);
        this.images = new Composite((Composite)this.imageContainer, 0);
        this.images.addMouseListener((MouseListener)this.director.mouseListener);
        this.imageContainer.addMouseListener((MouseListener)this.director.mouseListener);
        this.imageContainer.setContent((Control)this.images);
        this.imageContainer.setBackground(this.reusableUIFactory.getWhiteColor());
        this.imageContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                JUploadr.this.paintControl(arg0);
            }
        });
        this.addDropTarget((Composite)this.imageContainer);
        this.addDropTarget(this.images);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 5;
        this.images.setLayout((Layout)rowLayout);
        this.images.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                JUploadr.this.paintControl(event);
            }
        });
        this.imageContainer.addKeyListener(this.director.keyListener);
        this.images.addKeyListener(this.director.keyListener);
        window.addKeyListener(this.director.keyListener);
        this.images.setBackground(this.reusableUIFactory.getWhiteColor());
        this.createButtonRow();
        FormLayout windowLayout = new FormLayout();
        windowLayout.spacing = 5;
        window.setLayout((Layout)windowLayout);
        FormData imgData = new FormData();
        imgData.top = new FormAttachment(0, 1);
        imgData.right = new FormAttachment(100, 1);
        imgData.bottom = new FormAttachment(100, 0 - this.buttonRow.computeSize((int)-1, (int)-1).y);
        imgData.left = new FormAttachment(0, 1);
        this.imageContainer.setLayoutData((Object)imgData);
        FormData buttonData = new FormData();
        buttonData.top = new FormAttachment((Control)this.imageContainer, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.left = new FormAttachment(0, 0);
        this.buttonRow.setLayoutData((Object)buttonData);
        if (!Configuration.isMac()) {
            window.setImage(this.tinyLogo);
            this.myItem = this.createTray(this.reusableUIFactory.getDisplay(), Messages.getString("juploadr.ui.application.name"), this.tinyLogo);
            this.addDisposable(this.myItem);
        }
        window.setSize(454, 600);
        window.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                JUploadr.this.paintControl(event);
            }
        });
        window.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle bounds = JUploadr.this.imageContainer.getBounds();
                JUploadr.this.imageContainer.getVerticalBar().setPageIncrement(bounds.height);
            }
        });
        window.addKeyListener(this.director.keyListener);
        window.setText(Messages.getString("juploadr.ui.application.name"));
        this.imageContainer.getVerticalBar().setPageIncrement(this.imageContainer.getBounds().height);
    }

    private void addDisposable(Object blah) {
    }

    private void createButtonRow() {
        int iconHeight = ImageUploadApi.getInstance().getIcon().getImageData().y;
        this.buttonRow = new Composite((Composite)window, 0);
        GridLayout layout = new GridLayout(3, true);
        layout.marginBottom = 5;
        this.buttonRow.setLayout((Layout)layout);
        this.progress = new ProgressBar(this.buttonRow, 65792);
        this.progress.setForeground(this.reusableUIFactory.getProgressBarColor());
        this.progress.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.btnSubmit = new Button(this.buttonRow, 8);
        this.btnSubmit.setText(Messages.getString("juploadr.ui.button.upload.text.upload"));
        this.btnSubmit.addSelectionListener((SelectionListener)new UploadManager(this.imageAttributes, this.director));
        this.btnSubmit.setEnabled(false);
        this.btnSubmit.setSize(this.btnSubmit.computeSize(-1, iconHeight));
        this.loginButton = new Button(this.buttonRow, 8);
        ImageUploadApi api = ImageUploadApi.getInstance();
        this.loginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JUploadrBrowserLauncher.openURL(ImageUploadApi.getInstance().getCurrentAccount().getPhotoURL().toString());
            }
        });
        this.loginButton.setImage(api.getIcon());
        this.loginButton.setText(api.getCurrentAccount().getUsername() + "@" + api.getSiteName());
        this.btnSubmit.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        this.loginButton.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.loginButton.setEnabled(ImageUploadApi.getInstance().isCurrentAccountAuthenticated());
        this.addDisposable(this.btnSubmit);
        this.addDisposable(this.progress);
        this.addDisposable(this.buttonRow);
        this.buttonRow.pack();
    }

    private void addDropTarget(Composite composite) {
        DropTarget target = new DropTarget((Control)composite, 19);
        Transfer[] types = new Transfer[]{this.fileTransfer, this.textTransfer};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)this.director.dropTargetListener);
        this.addDisposable(target);
    }

    public void startup() {
        if (ImageUploadApi.getInstance().isCurrentAccountAuthenticated()) {
            Thread t = new Thread(){

                public void run() {
                    ImageUploadApi.getInstance();
                }
            };
            t.start();
        }
        window.open();
        RestoreStateTask restore = new RestoreStateTask(this);
        ProgressDialog dialog = new ProgressDialog(window, restore);
        dialog.execute();
        while (!window.isDisposed()) {
            if (this.reusableUIFactory.getDisplay().readAndDispatch()) continue;
            this.reusableUIFactory.getDisplay().sleep();
        }
    }

    private Menu buildMenu(Shell parent) {
        MenuItem child;
        Menu submenu;
        Menu bar = new Menu((Decorations)parent, 2);
        parent.setMenuBar(bar);
        if (!Configuration.isMac()) {
            MenuItem file = new MenuItem(bar, 64);
            file.setText(Messages.getString("juploadr.ui.menu.file"));
            file.setAccelerator(262214);
            submenu = new Menu((Decorations)parent, 4);
            child = new MenuItem(submenu, 8);
            child.setText(Messages.getString("juploadr.ui.menu.file.exit"));
            child.setAccelerator(120);
            child.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    JUploadr.this.quit();
                }
            });
            this.addDisposable(child);
            this.addDisposable(submenu);
            file.setMenu(submenu);
        }
        MenuItem view = new MenuItem(bar, 64);
        view.setText(Messages.getString("juploadr.ui.menu.edit"));
        view.setAccelerator(65605);
        submenu = new Menu((Decorations)parent, 4);
        child = new MenuItem(submenu, 32);
        child.setText(Messages.getString("juploadr.ui.photo.decorations.enable"));
        child.setSelection(Configuration.getInstance().getUseImageLayovers());
        child.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem item = (MenuItem)event.widget;
                Configuration.getInstance().setUseImageLayovers(item.getSelection());
                JUploadr.this.refresh();
            }
        });
        this.addDisposable(child);
        this.addLanguagesMenu(submenu);
        this.addAccountsMenu(submenu);
        if (!Configuration.isMac()) {
            child = new MenuItem(submenu, 8);
            child.setText(Messages.getString("juploadr.ui.menu.edit.preferences"));
            child.setAccelerator(80);
            child.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ConfigurationDialog setup = new ConfigurationDialog(window);
                    setup.setText(Messages.getString("juploadr.ui.dialog.preferences"));
                    setup.open();
                }
            });
            this.addDisposable(child);
        } else {
            CarbonMenuEventHandler handler = new CarbonMenuEventHandler(this);
            handler.hookApplicationMenu(ReusableUIFactory.getInstance().getDisplay(), Messages.getString("juploadr.ui.menu.help.about").substring(1) + " jUploadr");
        }
        this.addDisposable(submenu);
        this.addDisposable(view);
        view.setMenu(submenu);
        if (!Configuration.isMac()) {
            MenuItem help = new MenuItem(bar, 64);
            help.setText(Messages.getString("juploadr.ui.menu.help"));
            help.setAccelerator(0x1000051);
            this.addDisposable(help);
            submenu = new Menu((Decorations)parent, 4);
            child = new MenuItem(submenu, 8);
            child.setText(Messages.getString("juploadr.ui.menu.help.about"));
            child.setAccelerator(65);
            child.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    new AboutDialog();
                }
            });
            this.addDisposable(child);
            help.setMenu(submenu);
        }
        this.addDisposable(bar);
        return bar;
    }

    void addLanguagesMenu(Menu submenu) {
        MenuItem languages = new MenuItem(submenu, 64);
        Menu languageOptions = new Menu(languages);
        languages.setMenu(languageOptions);
        languages.setText(Messages.getString("juploadr.ui.menu.language"));
        final Configuration config = Configuration.getInstance();
        Locale[] locales = config.getValidLocales();
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            MenuItem language = new MenuItem(languageOptions, 32);
            language.setText(Character.toUpperCase(locale.getDisplayLanguage(locale).charAt(0)) + locale.getDisplayLanguage(locale).substring(1));
            language.setData((Object)locale);
            language.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem lang = (MenuItem)event.widget;
                    Menu parent = lang.getParent();
                    MenuItem[] kids = parent.getItems();
                    for (int i = 0; i < kids.length; ++i) {
                        MenuItem child = kids[i];
                        if (!child.getSelection() || child == lang) continue;
                        child.setSelection(false);
                    }
                    config.setLocale((Locale)lang.getData());
                    JUploadr.this.restart();
                }
            });
            if (config.getLocale().getLanguage().equals(locale.getLanguage())) {
                language.setSelection(true);
            }
            this.addDisposable(language);
        }
        this.addDisposable(languages);
    }

    void addAccountsMenu(Menu submenu) {
        this.implementations = new MenuItem(submenu, 64);
        this.implementations.setText(Messages.getString("juploadr.ui.menu.uploadto"));
        this.sites = new Menu(this.implementations);
        this.implementations.setMenu(this.sites);
        this.addAccountMenuData(this.implementations);
    }

    private void addAccountMenuData(MenuItem implementations) {
        ImageUploadApi[] imps = ImageUploadApi.getRegisteredImplemtations();
        List allAccounts = ImageUploadApi.allAccountsForAllApis();
        for (Account a : allAccounts) {
            MenuItem accountItem = new MenuItem(this.sites, 32);
            accountItem.setText(a.getName() + "@" + a.getApi().getSiteName());
            accountItem.setData((Object)a);
            accountItem.setSelection(a.equals(ImageUploadApi.getInstance().getCurrentAccount()));
            accountItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Account selected = (Account)event.widget.getData();
                    if (!selected.getApi().equals(ImageUploadApi.getInstance())) {
                        ImageUploadApi.changeImplementation(selected.getApi().getClass().getName(), JUploadr.this);
                    }
                    ImageUploadApi.getInstance().setCurrentAccount(selected);
                    JUploadr.this.loginButton.setImage(ImageUploadApi.getInstance().getIcon());
                    JUploadr.this.loginButton.setText(ImageUploadApi.getInstance().getCurrentAccount().getUsername() + "@" + ImageUploadApi.getInstance().getSiteName());
                    JUploadr.this.loginButton.setSize(JUploadr.this.loginButton.computeSize(-1, -1));
                    JUploadr.this.buttonRow.layout();
                    JUploadr.this.refresh();
                    MenuItem[] kids = ((MenuItem)event.widget).getParent().getItems();
                    for (int i = 0; i < kids.length; ++i) {
                        kids[i].setSelection(kids[i] == event.widget);
                    }
                }
            });
            this.addDisposable(accountItem);
        }
        if (allAccounts.size() > 0) {
            MenuItem sep = new MenuItem(this.sites, 2);
            this.addDisposable(sep);
        }
        for (int i = 0; i < imps.length; ++i) {
            ImageUploadApi imp = imps[i];
            MenuItem item = new MenuItem(this.sites, 8);
            Object[] args = new String[]{imp.getSiteName()};
            item.setText(Messages.getString("juploadr.ui.menu.newaccount", args));
            item.setImage(imp.getIcon());
            item.setData((Object)imp);
            this.addDisposable(item);
            final MenuItem localImplementations = implementations;
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageUploadApi api = (ImageUploadApi)event.widget.getData();
                    ImageUploadApi.changeImplementation(api.getClass().getName(), JUploadr.this);
                    try {
                        api.authenticate(api.newAccount("--"));
                        api.setCurrentAccount(api.getCurrentAccount());
                        MenuItem[] kids = JUploadr.this.sites.getItems();
                        for (int j = 0; j < kids.length; ++j) {
                            kids[j].dispose();
                        }
                        JUploadr.this.addAccountMenuData(localImplementations);
                    }
                    catch (ProtocolException e) {
                        e.printStackTrace();
                    }
                    catch (CommunicationException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void addButton(String imagePath) {
        if (this.imageAttributes.get(imagePath) == null) {
            ImageAttributes attributes = new ImageAttributes(this, this.images, imagePath);
            attributes.getButton().addMouseListener((MouseListener)this.director.mouseListener);
            attributes.getButton().addKeyListener(this.director.keyListener);
            this.images.setSize(this.images.computeSize(-1, -1));
            this.imageContainer.setMinSize(this.images.computeSize(-1, -1));
            this.images.layout();
            attributes.setRank(this.imageAttributes.size());
            this.imageAttributes.put(attributes.getKey(), attributes);
        } else {
            ((ImageAttributes)this.imageAttributes.get(imagePath)).setSelected(true);
            this.refresh();
            MessageUtils.showErrorMessage(Messages.getString("juploadr.ui.error.image.added.already"));
        }
    }

    private TrayItem createTray(Display display, String tooltip, Image image) {
        TrayItem item = null;
        Tray tray = display.getSystemTray();
        if (tray != null) {
            item = new TrayItem(tray, 0);
            item.setImage(image);
            if (tooltip != null) {
                item.setToolTipText(tooltip);
            }
            item.addListener(13, this.director.listener);
            item.addListener(14, this.director.listener);
            item.addListener(35, this.director.listener);
        }
        return item;
    }

    public void refresh() {
        Iterator iter = this.imageAttributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ImageAttributes att = (ImageAttributes)this.imageAttributes.get(key);
            if (att.getState() == 4) {
                iter.remove();
                continue;
            }
            att.getButton().redraw();
        }
        this.buttonRow.layout();
        this.images.redraw();
        window.redraw();
    }

    ProgressBar getProgressBar() {
        return this.progress;
    }

    Button getUploadButton() {
        return this.btnSubmit;
    }

    FileTransfer getFileTransfer() {
        return this.fileTransfer;
    }

    public void paintControl(PaintEvent event) {
        GC gfx = new GC((Drawable)this.images);
        if (this.imageAttributes.isEmpty()) {
            String message = Messages.getString("juploadr.ui.instructions");
            Point size = window.getSize();
            int width = size.x;
            gfx.drawImage(this.logo, width / 2 - this.logo.getBounds().width / 2, 5);
            Point textSize = gfx.textExtent(message);
            gfx.drawString(message, width / 2 - textSize.x / 2, this.logo.getBounds().height + 15);
            this.images.setSize(width, this.logo.getImageData().height + textSize.y + 15);
            this.btnSubmit.setEnabled(false);
        } else {
            Point size = this.imageContainer.getSize();
            this.btnSubmit.setEnabled(true);
            this.images.setSize(this.images.computeSize(size.x, -1));
        }
        Account current = ImageUploadApi.getInstance().getCurrentAccount();
        if (this.loginButton.getText().indexOf(current.getUsername()) < 0) {
            this.loginButton.setText(current.getUsername() + "@" + ImageUploadApi.getInstance().getSiteName());
            this.loginButton.setEnabled(ImageUploadApi.getInstance().isCurrentAccountAuthenticated());
            this.loginButton.setImage(ImageUploadApi.getInstance().getIcon());
            this.loginButton.setSize(this.loginButton.computeSize(-1, -1));
            this.buttonRow.layout();
        }
        gfx.dispose();
    }

    public void removeUploadedPhotos() {
        Iterator values = this.imageAttributes.values().iterator();
        while (values.hasNext()) {
            ImageAttributes element = (ImageAttributes)values.next();
            if (element.getState() != 1 && element.getState() != 4) continue;
            values.remove();
            element.removeFromWindow();
            element.dispose();
        }
        this.refresh();
    }

    public Map getImageAttributes() {
        return this.imageAttributes;
    }

    public void quit() {
        SaveStateTask saveState = new SaveStateTask(this);
        ProgressDialog dialog = new ProgressDialog(window, saveState);
        dialog.execute();
        this.shouldDie = true;
        window.close();
    }

    public void restart() {
        this.shouldDie = true;
        if (!Configuration.isMac()) {
            this.myItem.dispose();
        }
        window.close();
        window.dispose();
        this.initUI();
        this.startup();
    }

    public static void main(String[] args) {
        Thread.currentThread().setContextClassLoader(PluginClassLoader.getInstance());
        List<String> argList = Arrays.asList(args);
        if (System.getProperty("java.vm.name").indexOf("gcj") >= 0) {
            System.out.println(Messages.getString("juploadr.ui.gcj.incompatible"));
            System.exit(0);
        }
        if (argList.contains("--help")) {
            System.out.println("\n\n./jUploadr [-proxy] [--reset-preferences]\n");
            System.exit(0);
        }
        if (argList.contains("--reset-preferences")) {
            Configuration.getInstance().resetAllPrefs();
        }
        if (args != null && args.length > 0 && "-proxy".equals(args[0])) {
            System.setProperty("proxy", "true");
            Configuration.getInstance().setProxyEnabled(true);
        }
        new JUploadr().startup();
    }
}

