/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import java.util.LinkedList;
import java.util.List;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.RescaledImageAttributes;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.ui.Task;

public class RescaleTask
extends Task {
    private LinkedList photos;
    private List unscaled;
    private int current;
    private String currentPhotoTitle;

    public RescaleTask(List unscaled) {
        this.min = 0;
        this.max = unscaled.size();
        this.unscaled = unscaled;
        this.photos = new LinkedList();
    }

    public String getTitle() {
        Object[] args = new Object[]{new Integer(this.max)};
        return Messages.getString("juploadr.ui.task.rescale.resizing.title", args);
    }

    public void execute() {
        this.current = this.min;
        for (UploadImage photo : this.unscaled) {
            this.currentPhotoTitle = photo.getTitle();
            this.updateProgress(++this.current);
            this.photos.add(new RescaledImageAttributes(photo));
        }
    }

    public String getMessage() {
        if (this.currentPhotoTitle == null) {
            return Messages.getString("juploadr.ui.task.rescale.begining");
        }
        Object[] args = new Object[]{this.currentPhotoTitle, new Integer(this.current), new Integer(this.max)};
        return Messages.getString("juploadr.ui.task.rescale.resizing", args);
    }

    public LinkedList getRescaledPhotos() {
        return this.photos;
    }
}

