/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.app.scalers.ImageScalerFactory;
import org.scohen.juploadr.app.scalers.Scaler;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.ReusableUIFactory;

public class RescaledImageAttributes
implements UploadImage {
    private boolean rescaled = false;
    private File scaledFile;
    private UploadImage photo;
    private Configuration config = Configuration.getInstance();

    public RescaledImageAttributes(UploadImage source) {
        this.photo = source;
        this.rescale();
    }

    public String getDescription() {
        return this.photo.getDescription();
    }

    public String getImagePath() {
        if (this.scaledFile != null && this.scaledFile.exists() && this.scaledFile.length() > 0L) {
            return this.scaledFile.getAbsolutePath();
        }
        return this.photo.getImagePath();
    }

    public String getKey() {
        return this.photo.getKey();
    }

    public int getState() {
        return this.photo.getState();
    }

    public List getTags() {
        return this.photo.getTags();
    }

    public String getTitle() {
        return this.photo.getTitle();
    }

    public boolean hasDescription() {
        return this.photo.hasDescription();
    }

    public int hashCode() {
        return this.photo.hashCode();
    }

    public boolean hasTags() {
        return this.photo.hasTags();
    }

    public boolean hasTitle() {
        return this.photo.hasTitle();
    }

    public boolean isFamilyViewable() {
        return this.photo.isFamilyViewable();
    }

    public boolean isFriendViewable() {
        return this.photo.isFriendViewable();
    }

    public boolean isPubliclyVisible() {
        return this.photo.isPubliclyVisible();
    }

    public void setFamilyViewable(boolean familyViewable) {
        this.photo.setFamilyViewable(familyViewable);
    }

    public void setFriendViewable(boolean friendViewable) {
        this.photo.setFriendViewable(friendViewable);
    }

    public void setImagePath(String imagePath) {
        this.photo.setImagePath(imagePath);
    }

    public void setPubliclyVisible(boolean publiclyVisible) {
        this.photo.setPubliclyVisible(publiclyVisible);
    }

    public void setState(int state) {
        this.photo.setState(state);
    }

    public void setTags(List tags) {
        this.photo.setTags(tags);
    }

    public void setTitle(String title) {
        this.photo.setTitle(title);
    }

    public boolean isRescaled() {
        return this.rescaled;
    }

    public void rescale() {
        String imagePath = this.photo.getImagePath();
        if (this.config.getAutoResizePhotos()) {
            File origFile = new File(this.photo.getImagePath());
            Image orig = new Image((Device)ReusableUIFactory.getInstance().getDisplay(), origFile.getAbsolutePath());
            ImageData imageData = orig.getImageData();
            try {
                this.scaledFile = File.createTempFile("img", imagePath.substring(imagePath.lastIndexOf(".")));
                imagePath = this.scaledFile.getAbsolutePath();
                if (Math.max(imageData.width, imageData.height) > this.config.getMaxPhotoSize()) {
                    Point newSize = this.getScaledDimensions(imageData);
                    Scaler s = ImageScalerFactory.getScaler();
                    s.scale(origFile, this.scaledFile, newSize);
                    orig.dispose();
                    this.rescaled = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Point getScaledDimensions(ImageData orig) {
        int newHeight;
        int newWidth;
        if (orig.width > orig.height) {
            newWidth = this.config.getMaxPhotoSize();
            newHeight = (int)Math.floor((float)orig.height * (float)this.config.getMaxPhotoSize() / (float)orig.width);
        } else {
            newHeight = this.config.getMaxPhotoSize();
            newWidth = (int)Math.floor((float)orig.width * (float)this.config.getMaxPhotoSize() / (float)orig.height);
        }
        return new Point(newWidth, newHeight);
    }

    public int getRank() {
        return this.photo.getRank();
    }

    public int getRotation() {
        return this.photo.getRotation();
    }

    public void setRotation(int rotation) {
        this.photo.setRotation(rotation);
    }

    public String getPhotoId() {
        return this.photo.getPhotoId();
    }
}

