/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app.scalers;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.eclipse.swt.graphics.Point;
import org.scohen.juploadr.app.scalers.Scaler;
import org.scohen.juploadr.prefs.Configuration;

public class JAIScaler
extends Scaler {
    private static final String[] JAI_JAR_FILES = new String[]{"jai_core.jar", "jai_codec.jar", "mlibwrapper_jai.jar"};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JAIScaler() {
        if (!Configuration.isMac()) return;
        File extDir = new File("/System/Library/Java/Extensions/");
        LinkedList<URL> jarUrls = new LinkedList<URL>();
        if (!extDir.exists()) return;
        for (int i = 0; i < JAI_JAR_FILES.length; ++i) {
            String jarFile = JAI_JAR_FILES[i];
            File jar = new File(extDir, jarFile);
            if (jar.exists()) {
                try {
                    jarUrls.add(jar.toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            URLClassLoader.newInstance(jarUrls.toArray(new URL[jarUrls.size()]));
        }
    }

    public void doScale(File original, File scaled, Point newSize) {
        RenderedOp fullSize = JAI.create((String)"fileload", (Object)original.getAbsolutePath());
        float scale = (float)newSize.x / (float)fullSize.getWidth();
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(fullSize);
        pb.add(scale);
        pb.add(scale);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(new InterpolationBicubic(8));
        RenderedOp im = JAI.create((String)"scale", (ParameterBlock)pb, null);
        JAI.create((String)"filestore", (RenderedImage)im, (Object)scaled.getAbsolutePath(), (Object)"JPEG", null);
    }

    public boolean isOptimal() {
        return false;
    }
}

