/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app.state;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.beanutils.BeanUtils;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.state.ImageStateDescriptor;
import org.scohen.juploadr.app.state.SaveStateTask;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.Task;

public class RestoreStateTask
extends Task {
    private JUploadr uploadr;
    private Preferences prefs = Preferences.userNodeForPackage(SaveStateTask.class);
    private String[] keys;
    private Map imageStates = new HashMap();

    public RestoreStateTask(JUploadr uploadr) {
        this.uploadr = uploadr;
        this.min = 0;
        try {
            this.keys = this.prefs.keys();
            this.max = this.countPhotos(this.keys);
        }
        catch (BackingStoreException e) {
            this.keys = new String[0];
            this.max = this.keys.length;
        }
    }

    private int countPhotos(String[] keys) {
        int numPhotos = 0;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key.indexOf(".path") <= 0) continue;
            ++numPhotos;
        }
        return numPhotos;
    }

    public void execute() {
        for (int i = 0; i < this.keys.length; ++i) {
            int sequence = Integer.parseInt(this.keys[i].substring(0, this.keys[i].indexOf(46)));
            String key = this.keys[i].substring(this.keys[i].indexOf(46) + 1);
            if ("path".equals(key)) continue;
            ImageStateDescriptor state = this.stateAt(this.prefs.get(sequence + ".path", ""));
            try {
                BeanUtils.setProperty((Object)state, (String)key, (Object)this.prefs.get(this.keys[i], ""));
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        ArrayList sortedStates = new ArrayList(this.imageStates.values());
        Collections.sort(sortedStates, new Comparator(){

            public int compare(Object o1, Object o2) {
                ImageStateDescriptor s1 = (ImageStateDescriptor)o1;
                ImageStateDescriptor s2 = (ImageStateDescriptor)o2;
                return s1.getRank() - s2.getRank();
            }
        });
        Iterator iter = sortedStates.iterator();
        int progress = this.min;
        while (iter.hasNext()) {
            ImageStateDescriptor currentState = (ImageStateDescriptor)iter.next();
            if (new File(currentState.getPath()).exists()) {
                ImageAttributes atts = this.newAttributes(currentState.getPath());
                try {
                    BeanUtils.copyProperties((Object)atts, (Object)currentState);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            this.updateProgress(progress++);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            this.prefs.remove(this.keys[i]);
        }
    }

    public String getMessage() {
        return Messages.getString("juploadr.tasks.restorestate.restore");
    }

    public String getTitle() {
        return Messages.getString("juploadr.tasks.restorestate.restore");
    }

    private ImageStateDescriptor stateAt(String path) {
        ImageStateDescriptor state = (ImageStateDescriptor)this.imageStates.get(path);
        if (state == null) {
            state = new ImageStateDescriptor();
            state.setPath(path);
            this.imageStates.put(path, state);
        }
        return state;
    }

    private ImageAttributes newAttributes(final String path) {
        ReusableUIFactory.getInstance().getDisplay().syncExec(new Runnable(){

            public void run() {
                RestoreStateTask.this.uploadr.addButton(path);
            }
        });
        return (ImageAttributes)this.uploadr.getImageAttributes().get(path);
    }
}

