/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app.tags;

import au.com.lastweekend.jim.util.StringUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.PopupList;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.scohen.juploadr.app.tags.Tag;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.util.Trie;

public class TagsHelper
extends KeyAdapter {
    private Trie trie = new Trie(true);
    private static List newTags = new LinkedList();

    public TagsHelper() {
        List tags = ImageUploadApi.getInstance().getCurrentAccount().getUserTags();
        for (Tag tag : tags) {
            this.trie.add(tag.toDisplayString(), tag);
        }
        for (Tag tag : newTags) {
            this.trie.add(tag.toDisplayString(), tag);
        }
    }

    public void keyPressed(KeyEvent event) {
        Text txt = (Text)event.widget;
        if (event.keyCode == 13 || event.keyCode == 10) {
            event.doit = false;
            int caretPos = txt.getCaretPosition();
            int lastSpace = txt.getText().lastIndexOf(32, caretPos);
            String word = txt.getText().substring(lastSpace < 0 ? 0 : lastSpace, caretPos).trim();
            this.makePopup(word, txt);
        } else if (event.keyCode == 32) {
            Tag tag;
            String input = txt.getText();
            String word = "";
            Pattern lastQuoted = Pattern.compile(".*\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"$");
            if (!this.hasUnmatchedQuotes(input)) {
                if (input.trim().endsWith("\"")) {
                    Matcher matcher = lastQuoted.matcher(input);
                    if (matcher.matches()) {
                        word = matcher.group(1);
                    }
                } else {
                    String[] words = input.split(" ");
                    word = words[words.length - 1];
                }
            }
            if (word.trim().length() > 0 && this.trie.get((tag = new Tag(word)).toDisplayString()) == null) {
                this.trie.add(tag.toDisplayString(), tag);
                newTags.add(tag);
            }
        }
    }

    private void makePopup(String baseWord, Text text) {
        String[] suggestions = this.getSuggestions(baseWord);
        if (suggestions != null && suggestions.length > 0) {
            PopupList list = new PopupList(text.getShell());
            list.setItems(suggestions);
            list.select(suggestions[0]);
            Rectangle cursorPosition = text.getClientArea();
            cursorPosition = text.getShell().getDisplay().map((Control)text, null, cursorPosition);
            Rectangle initial = text.getBounds();
            String selected = list.open(new Rectangle(cursorPosition.x + text.getCaretLocation().x, cursorPosition.y - text.getBounds().height + text.getCaretLocation().y, this.setWidth(list), initial.height));
            if (selected != null) {
                String oldText = text.getText();
                int oldPosition = text.getCaretPosition();
                StringBuffer newWord = new StringBuffer(selected);
                if (selected.indexOf(32) >= 0) {
                    newWord.insert(0, '\"');
                    newWord.append("\"");
                }
                if (StringUtils.isBlank((String)baseWord)) {
                    text.setText(oldText.substring(0, oldPosition) + " " + newWord.toString() + " " + oldText.substring(oldPosition));
                    text.setSelection(oldPosition + newWord.length() + 2);
                } else {
                    text.setText(oldText.replaceAll("\\b" + baseWord + "\\b", newWord.toString()));
                    text.setSelection(oldPosition + (newWord.length() - baseWord.length()));
                }
            }
        }
    }

    private String[] getSuggestions(String word) {
        LinkedList<String> suggestions = new LinkedList<String>();
        Iterator iter = this.trie.getPrefixedBy(word);
        while (iter.hasNext()) {
            Tag t = (Tag)iter.next();
            suggestions.add(t.toDisplayString());
        }
        return suggestions.toArray(new String[suggestions.size()]);
    }

    private int setWidth(PopupList l) {
        int wordLength = 0;
        int longestWord = 0;
        String[] words = l.getItems();
        if (words != null && words.length > 0) {
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                wordLength = Math.max(word.length(), wordLength);
                if (wordLength != word.length()) continue;
                longestWord = i;
            }
            GC gc = new GC((Drawable)ReusableUIFactory.getInstance().getDisplay());
            wordLength = gc.textExtent((String)new StringBuilder().append((String)words[longestWord]).append((String)"  ").toString()).x;
            gc.dispose();
        }
        if (Configuration.isMac()) {
            wordLength += 50;
        }
        return wordLength;
    }

    private boolean hasUnmatchedQuotes(String s) {
        int quotes = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\"') continue;
            ++quotes;
        }
        return quotes % 2 != 0;
    }

    public void updateTags(List list) {
        for (Tag tag : list) {
            if (this.trie.get(tag.toDisplayString()) != null) continue;
            newTags.add(tag);
        }
    }
}

