/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.prefs;

import java.io.File;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.scohen.juploadr.prefs.Version;

public class Configuration {
    private static final String MAC_OS = "Mac OS X";
    public static final int DEFAULT_PROXY_PORT = 8080;
    private String PASSWORD_KEY = "password";
    private String EMAIL_KEY = "email";
    private String SHOULD_ENCRYPT_PASSWORD_KEY = "shouldEncryptPassword";
    private String ACCOUNT_TYPE_KEY = "accountType";
    private String MONTHLY_ALLOWABLE_UPLOAD_KEY = "monthlyAllowableUpload";
    private String CURRENT_UPLOAD_KEY = "currentUpload";
    private String DEFAULT_PRIVACY_SETTING_KEY = "defaultPrivacy";
    private String PROXY_ENABLED_KEY = "proxyEnabled";
    private String PROXY_HOST_KEY = "proxyHost";
    private String PROXY_PORT_KEY = "proxyPort";
    private String PROXY_USERNAME_KEY = "proxyUsername";
    private String PROXY_PASSWORD_KEY = "proxyPassword";
    private String USE_IMAGE_LAYOVERS_KEY = "useImageLayovers";
    private String AUTHED_TOKEN_KEY = "authedTokenKey";
    private String LAST_AUTHED_DATE_KEY = "lastAuthedDate";
    private String DEFAULT_TAGS_KEY = "defaultTags";
    private String AUTO_REMOVE_UPLOADED_PHOTOS_KEY = "autoRemoveUploadedPhotos";
    private String AUTO_RESIZE_PHOTOS_KEY = "autoResizePhotos";
    private String MAX_PHOTO_SIZE_KEY = "maxPhotoSize";
    private String AUTH_TOKEN_KEY = "authToken";
    private String UPLOAD_BY_EXIF_DATE_KEY = "uploadByExifDate";
    private String VERSION_UPGRADE_ACK_KEY = "lastVersionAcked";
    private String LANGUAGE_KEY = "language";
    private String THROTTLING_ENABLED = "useThrottling";
    private String THROTTLING_MAX_KBPS = "throttlingKBPS";
    private String UPLOAD_API_CLASS_KEY = "uploadApi";
    private String SCALING_QUALITY_KEY = "favorScalingQuality";
    private Locale[] locales = new Locale[]{Locale.ENGLISH, Locale.FRENCH, new Locale("es"), Locale.ITALIAN, Locale.GERMAN, new Locale("pt"), new Locale("pl")};
    private Preferences prefs = Preferences.userNodeForPackage(Configuration.class);
    private static Configuration instance = new Configuration();
    private String version;

    public static Configuration getInstance() {
        return instance;
    }

    protected Configuration() {
    }

    public void upgradeComplete() {
        this.prefs.remove(this.PASSWORD_KEY);
        this.prefs.remove(this.EMAIL_KEY);
        this.prefs.remove(this.SHOULD_ENCRYPT_PASSWORD_KEY);
        this.prefs.remove(this.ACCOUNT_TYPE_KEY);
        this.prefs.remove(this.MONTHLY_ALLOWABLE_UPLOAD_KEY);
        this.prefs.remove(this.CURRENT_UPLOAD_KEY);
        this.prefs.remove(this.LAST_AUTHED_DATE_KEY);
        this.prefs.remove(this.AUTH_TOKEN_KEY);
        this.prefs.remove(this.AUTHED_TOKEN_KEY);
        this.prefs.remove(this.DEFAULT_PRIVACY_SETTING_KEY);
        this.prefs.remove(this.DEFAULT_TAGS_KEY);
    }

    public boolean hasUpgraded() {
        return this.prefs.getInt(this.DEFAULT_PRIVACY_SETTING_KEY, -1024) < 0;
    }

    public int getDefaultPrivacySetting() {
        return this.prefs.getInt(this.DEFAULT_PRIVACY_SETTING_KEY, 1);
    }

    public String getDefaultTags() {
        return this.prefs.get(this.DEFAULT_TAGS_KEY, "");
    }

    public boolean isProxyEnabled() {
        return this.prefs.getBoolean(this.PROXY_ENABLED_KEY, false);
    }

    public String getOldUsername() {
        return this.prefs.get(this.EMAIL_KEY, "");
    }

    public String getOldToken() {
        return this.prefs.get(this.AUTH_TOKEN_KEY, "");
    }

    public void setProxyEnabled(boolean enabled) {
        this.prefs.putBoolean(this.PROXY_ENABLED_KEY, enabled);
    }

    public void setProxyHost(String hostname) {
        this.prefs.put(this.PROXY_HOST_KEY, hostname);
    }

    public String getProxyHost() {
        return this.prefs.get(this.PROXY_HOST_KEY, "");
    }

    public void setProxyPort(int port) {
        this.prefs.putInt(this.PROXY_PORT_KEY, port);
    }

    public int getProxyPort() {
        return this.prefs.getInt(this.PROXY_PORT_KEY, 8080);
    }

    public void setProxyUsername(String name) {
        this.prefs.put(this.PROXY_USERNAME_KEY, name);
    }

    public String getProxyUsername() {
        return this.prefs.get(this.PROXY_USERNAME_KEY, "");
    }

    public void setProxyPassword(String pass) {
        this.prefs.put(this.PROXY_PASSWORD_KEY, pass);
    }

    public String getProxyPassword() {
        return this.prefs.get(this.PROXY_PASSWORD_KEY, "");
    }

    public boolean proxySettingsValid() {
        return this.getProxyHost().length() > 0;
    }

    public void setUseImageLayovers(boolean useIt) {
        this.prefs.putBoolean(this.USE_IMAGE_LAYOVERS_KEY, useIt);
    }

    public boolean getUseImageLayovers() {
        return this.prefs.getBoolean(this.USE_IMAGE_LAYOVERS_KEY, true);
    }

    public boolean getAutoRemoveUploadedPhotos() {
        return this.prefs.getBoolean(this.AUTO_REMOVE_UPLOADED_PHOTOS_KEY, false);
    }

    public void setAutoRemoveUploadedPhotos(boolean remove) {
        this.prefs.putBoolean(this.AUTO_REMOVE_UPLOADED_PHOTOS_KEY, remove);
    }

    public void setAutoResizePhotos(boolean resize) {
        this.prefs.putBoolean(this.AUTO_RESIZE_PHOTOS_KEY, resize);
    }

    public boolean getAutoResizePhotos() {
        return this.prefs.getBoolean(this.AUTO_RESIZE_PHOTOS_KEY, false);
    }

    public void setMaxPhotoSize(int size) {
        this.prefs.putInt(this.MAX_PHOTO_SIZE_KEY, size);
    }

    public int getMaxPhotoSize() {
        return this.prefs.getInt(this.MAX_PHOTO_SIZE_KEY, 0);
    }

    public Locale getLocale() {
        Locale rv = Locale.getDefault();
        String lang = this.prefs.get(this.LANGUAGE_KEY, null);
        if (lang != null) {
            rv = new Locale(lang);
        }
        return rv;
    }

    public Locale[] getValidLocales() {
        return this.locales;
    }

    public void setLocale(Locale locale) {
        this.prefs.put(this.LANGUAGE_KEY, locale.getLanguage());
    }

    public boolean getUploadByExifDate() {
        return this.prefs.getBoolean(this.UPLOAD_BY_EXIF_DATE_KEY, false);
    }

    public void setUploadByExifDate(boolean shouldUpload) {
        this.prefs.putBoolean(this.UPLOAD_BY_EXIF_DATE_KEY, shouldUpload);
    }

    public String getVersion() {
        if (this.version == null) {
            try {
                File f = Configuration.isMac() ? new File(System.getProperty("user.dir"), "JUploadr.app/Contents/Resources/Java/juploadr.jar") : new File(System.getProperty("user.dir"), "lib" + File.separator + "juploadr.jar");
                JarFile jar = new JarFile(f);
                Manifest mf = jar.getManifest();
                Attributes entries = mf.getMainAttributes();
                this.version = (String)entries.get(new Attributes.Name("Version"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.version == null) {
            this.version = "Development";
        }
        return this.version;
    }

    public boolean shouldUpgradeTo(String version) {
        Version remote;
        if (version.equals(this.getVersion()) || version.equals(this.getLastVersionAcked()) || this.getVersion().equals("Development")) {
            return false;
        }
        Version local = new Version(this.getVersion());
        return local.compareTo(remote = new Version(version)) < 0;
    }

    public void setLastVersionAcked(String ver) {
        this.prefs.put(this.VERSION_UPGRADE_ACK_KEY, ver);
    }

    public String getLastVersionAcked() {
        return this.prefs.get(this.VERSION_UPGRADE_ACK_KEY, "");
    }

    public void resetAllPrefs() {
        try {
            this.prefs.clear();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isThrottlingEnabled() {
        return this.prefs.getBoolean(this.THROTTLING_ENABLED, false);
    }

    public void setThrottlingEnabled(boolean isEnabled) {
        this.prefs.putBoolean(this.THROTTLING_ENABLED, isEnabled);
    }

    public void setMaxKPerSecond(int kPerSecond) {
        this.prefs.putInt(this.THROTTLING_MAX_KBPS, kPerSecond);
    }

    public int getMaxKPerSecond() {
        return this.prefs.getInt(this.THROTTLING_MAX_KBPS, Integer.MAX_VALUE);
    }

    public String getUploadApiClassName() {
        return this.prefs.get(this.UPLOAD_API_CLASS_KEY, "org.scohen.juploadr.uploadapi.flickrrest.RestFlickrApi");
    }

    public void setUploadApiClassName(String name) {
        this.prefs.put(this.UPLOAD_API_CLASS_KEY, name);
    }

    public static boolean isMac() {
        return MAC_OS.equals(System.getProperty("os.name"));
    }

    public void setImageIORescalerEnabled(boolean b) {
        this.prefs.putBoolean(this.SCALING_QUALITY_KEY, b);
    }

    public boolean isScalingQualityFavored() {
        return this.prefs.getBoolean(this.SCALING_QUALITY_KEY, false);
    }
}

