/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.Transforms;

public class MultiSelectThumbnail
extends Canvas {
    private static final int BORDER_WIDTH = 5;
    private List atts;
    private Point mySize = new Point(256, 192);
    private int totalArea;
    private Point thumbSize;
    private Point minSize;
    private ReusableUIFactory uiFactory;

    public MultiSelectThumbnail(Composite parent, List atts) {
        super(parent, 0);
        this.totalArea = this.mySize.x * this.mySize.y;
        this.minSize = new Point(80, 60);
        this.uiFactory = ReusableUIFactory.getInstance();
        this.atts = new LinkedList();
        this.atts.addAll(atts);
        this.thumbSize = this.getThumbnailSize();
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent event) {
                MultiSelectThumbnail.this.mouseEnter(event);
            }

            public void mouseExit(MouseEvent event) {
                MultiSelectThumbnail.this.mouseExit(event);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent arg0) {
                MultiSelectThumbnail.this.mouseMove(arg0);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MultiSelectThumbnail.this.paintControl(e);
            }
        });
    }

    public Point computeSize(int w, int h, boolean changed) {
        return this.mySize;
    }

    public Point computeSize(int x, int y) {
        return this.computeSize(x, y, true);
    }

    void paintControl(PaintEvent e) {
        int yBounds;
        GC gc = e.gc;
        int xBounds = this.mySize.x;
        int yFraction = yBounds = this.mySize.y;
        int xFraction = xBounds;
        if (this.atts.size() > 1) {
            yFraction = (int)Math.floor((yBounds - this.thumbSize.y) / (this.atts.size() - 1));
            xFraction = (xBounds - this.thumbSize.x) / (this.atts.size() - 1);
        }
        int xPos = xFraction * (this.atts.size() - 1);
        int yPos = yFraction * (this.atts.size() - 1);
        Iterator iter = this.atts.iterator();
        ImageData shadowData = new ImageData(this.thumbSize.x - 5, this.thumbSize.y - 5, 24, new PaletteData(255, 255, 255));
        shadowData.alpha = 90;
        Color white = this.uiFactory.getWhiteColor();
        Image shadow = new Image((Device)e.display, shadowData);
        GC shadowGC = new GC((Drawable)shadow);
        shadowGC.setForeground(white);
        while (iter.hasNext()) {
            ImageAttributes element = (ImageAttributes)iter.next();
            this.drawThumbnail(element, shadow, e.display, gc, xPos, yPos);
            xPos -= xFraction;
            yPos -= yFraction;
        }
        shadow.dispose();
        shadowGC.dispose();
        this.setSize(this.computeSize(-1, -1));
    }

    private void drawThumbnail(ImageAttributes img, Image shadow, Display d, GC gc, int x, int y) {
        ImageData tnData;
        if (img.getRotation() != 0) {
            Image copy = this.copyImage(img.getThumbnail(), d);
            ImageData origData = copy.getImageData();
            byte[] data = new byte[origData.data.length];
            System.arraycopy(origData.data, 0, data, 0, origData.data.length);
            tnData = new ImageData(origData.width, origData.height, origData.depth, origData.palette, origData.bytesPerLine, data);
            tnData = Transforms.rotate(tnData, img.getRotation());
            copy.dispose();
        } else {
            tnData = img.getThumbnail().getImageData();
        }
        Image toDraw = new Image((Device)d, tnData);
        Color borderColor = new Color((Device)Display.getDefault(), 205, 205, 205);
        Color photoColor = new Color((Device)Display.getDefault(), 250, 250, 250);
        if (shadow != null) {
            int offset = (int)((double)this.thumbSize.x * 0.07);
            gc.drawImage(shadow, x + offset, y + offset);
        }
        gc.setForeground(borderColor);
        gc.setBackground(photoColor);
        gc.fillRectangle(x, y, this.thumbSize.x - 1, this.thumbSize.y - 1);
        gc.drawRectangle(x, y, this.thumbSize.x - 1, this.thumbSize.y - 1);
        gc.drawImage(toDraw, 0, 0, tnData.width, tnData.height, x + 5, y + 5, this.thumbSize.x - 10, this.thumbSize.y - 10);
        borderColor.dispose();
        photoColor.dispose();
        toDraw.dispose();
    }

    private Image copyImage(Image src, Display disp) {
        return new Image((Device)disp, src, 0);
    }

    private Point getThumbnailSize() {
        int individualThumbArea = (int)Math.floor(this.totalArea / this.atts.size());
        int x = (int)Math.floor(Math.sqrt(individualThumbArea / 12));
        this.thumbSize = new Point(4 * x, 3 * x);
        if (this.thumbSize.x < this.minSize.x) {
            this.thumbSize = this.minSize;
        }
        return this.thumbSize;
    }

    private void mouseEnter(MouseEvent e) {
    }

    private void mouseExit(MouseEvent e) {
        this.redraw();
    }

    private void mouseMove(MouseEvent event) {
    }
}

