/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.scohen.juploadr.ui.DefaultReusableUIFactory;

public abstract class ReusableUIFactory {
    private static final String REUSABLE_UI_FACTORY_IMPL_KEY = "juploadr.reusableuifactory.impl";
    private static ReusableUIFactory instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReusableUIFactory getInstance() {
        if (instance != null) return instance;
        String string = REUSABLE_UI_FACTORY_IMPL_KEY;
        synchronized (REUSABLE_UI_FACTORY_IMPL_KEY) {
            if (instance != null) return instance;
            try {
                String uiFactoryImplStr = System.getProperty(REUSABLE_UI_FACTORY_IMPL_KEY);
                instance = (ReusableUIFactory)Class.forName(uiFactoryImplStr).newInstance();
            }
            catch (Exception e) {
                instance = new DefaultReusableUIFactory();
            }
            return instance;
        }
    }

    public abstract Display getDisplay();

    public abstract Image getLogoImage();

    public abstract Image getTinyLogoImage();

    public abstract Image getUploadingImage();

    public abstract Image getUploadedImage();

    public abstract Image getUnknownImage();

    public abstract Image getRotateRightImage();

    public abstract Image getRotateLeftImage();

    public abstract Image getPhotosetOverlayImage();

    public abstract Color getFriendsColor();

    public abstract Color getFamilyColor();

    public abstract Color getPrivateColor();

    public abstract Color getPublicColor();

    public abstract Color getTagColor();

    public abstract Color getDescriptionColor();

    public abstract Color getTitleColor();

    public abstract Color getThumbnailBorderColor();

    public abstract Color getThumbnailBackgroundColor();

    public abstract Color getThumbnailSelectedBackgroundColor();

    public abstract Color getTagBorderColor();

    public abstract Color getProgressBarColor();

    public abstract Color getWhiteColor();

    public abstract Color getBlackColor();

    public abstract Color getAboutDialogFontColor();

    public abstract Font getThumbnailDecorationFont();

    public abstract Font getAuthorizeHeaderFont();

    public abstract Font getAuthorizationFooterFont();
}

