/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Sleak {
    private static final char DELIMETER = ':';
    Display display;
    SashForm parent;
    org.eclipse.swt.widgets.List list;
    Canvas canvas;
    Button start;
    Button stop;
    Text text;
    org.eclipse.swt.widgets.List types;
    Text filter;
    Object[] oldObjects = new Object[0];
    Error[] oldErrors = new Error[0];
    Object[] objects = new Object[0];
    Error[] errors = new Error[0];
    private Button checkDuplicates;
    private org.eclipse.swt.widgets.List dupes;
    private int[] previousWeights;
    private Object paintHolder;
    private int[] holderIndex;
    private int[] holder = new int[]{0};
    private Label status;
    private SashForm sashForm;
    private int previousTotal;
    private org.eclipse.swt.widgets.List dupeDetails;
    static Comparator sortResources = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            ResourceAndCount r1 = (ResourceAndCount)arg0;
            ResourceAndCount r2 = (ResourceAndCount)arg1;
            int diff = r2.count - r1.count;
            return diff == 0 ? -1 : diff;
        }
    };
    static Comparator classComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Class)o1).getName().compareTo(((Class)o2).getName());
        }
    };

    public static void main(String[] args) {
        DeviceData data = new DeviceData();
        data.tracking = true;
        data.debug = true;
        Display display = new Display(data);
        Sleak sleak = new Sleak();
        Shell shell = sleak.open();
        Sleak.makeLeak(display);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void makeLeak(final Display display) {
        display.timerExec(200, new Runnable(){

            public void run() {
                int i;
                new Color((Device)display, 255, 255, 1);
                new Color((Device)display, 255, 255, 1);
                new Color((Device)display, 255, 255, 1);
                new Font((Device)display, "Arial", 12, 1);
                new Font((Device)display, "Arial", 12, 1);
                new Image((Device)display, 16, 16);
                new Image((Device)display, 16, 16);
                new Image((Device)display, 300, 300);
                new Image((Device)display, 300, 300);
                for (i = 0; i < 20; ++i) {
                    new Color((Device)display, 0, i, 2);
                }
                for (i = 0; i < 5; ++i) {
                    new Font((Device)display, "Courier", i, 0);
                }
                for (i = 0; i < 5; ++i) {
                    new Region((Device)display);
                }
            }
        });
        display.timerExec(5000, new Runnable(){

            public void run() {
                new Color((Device)display, 255, 255, 1);
                display.timerExec(5000, (Runnable)this);
            }
        });
    }

    public Shell open() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        shell.setText("S-Leak");
        this.open((Composite)shell);
        Point size = shell.getSize();
        shell.setSize(size.x / 2, size.y / 2);
        shell.open();
        return shell;
    }

    public void open(Composite parent2) {
        parent2.setLayout((Layout)new FormLayout());
        this.parent = this.sashForm = new SashForm(parent2, 256);
        Composite column1 = new Composite((Composite)this.sashForm, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginLeft = 2;
        formLayout.marginRight = 2;
        column1.setLayout((Layout)formLayout);
        final SashForm column2Duplicates = new SashForm((Composite)this.sashForm, 512);
        column2Duplicates.setLayout((Layout)new FormLayout());
        SashForm column3 = new SashForm((Composite)this.sashForm, 512);
        this.sashForm.setWeights(new int[]{20, 0, 50});
        this.display = Display.getCurrent();
        this.list = new org.eclipse.swt.widgets.List(column1, 2562);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int selectionIndex;
                ((Sleak)Sleak.this).holder[0] = selectionIndex = Sleak.this.list.getSelectionIndex();
                Sleak.access$102(Sleak.this, Sleak.this.holder);
                if (selectionIndex == -1) {
                    Sleak.this.paintHolder = null;
                    return;
                }
                Sleak.this.paintHolder = Sleak.this.objects[selectionIndex];
                Sleak.this.refreshObject();
            }
        });
        this.canvas = new Canvas((Composite)column3, 2048);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.paintCanvas(event);
            }
        });
        this.text = new Text((Composite)column3, 2816);
        column3.setWeights(new int[]{20, 80});
        this.start = new Button(column1, 8);
        this.start.setText("Snap");
        this.start.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.refreshAll();
            }
        });
        this.stop = new Button(column1, 8);
        this.stop.setText("Diff");
        this.stop.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.refreshDifference(false);
            }
        });
        this.filter = new Text(column1, 2048);
        this.types = new org.eclipse.swt.widgets.List(column1, 2562);
        this.types.addListener(13, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.checkDuplicates = new Button(column1, 32);
        this.checkDuplicates.setText("Sort duplicates");
        this.checkDuplicates.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.showHideDuplicates(Sleak.this.sashForm, (Composite)column2Duplicates);
            }
        });
        this.dupes = new org.eclipse.swt.widgets.List((Composite)column2Duplicates, 2562);
        this.dupes.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.selectDupes();
            }
        });
        this.dupeDetails = new org.eclipse.swt.widgets.List((Composite)column2Duplicates, 2562);
        this.dupeDetails.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Sleak.this.selectDupeDetails();
            }
        });
        this.status = new Label(parent2, 18448);
        column2Duplicates.setVisible(false);
        this.setupLayout();
    }

    protected void selectDupeDetails() {
        int selected = this.dupeDetails.getSelectionIndex();
        List duplicates = (List)this.dupes.getData("duplicates");
        ResourceAndCount resourceAndCount = (ResourceAndCount)duplicates.get(this.dupes.getSelectionIndex());
        int resourceIndex = resourceAndCount.indexes[selected];
        this.paintHolder = this.objects[resourceIndex];
        this.holder[0] = resourceIndex;
        this.holderIndex = this.holder;
        this.refreshObject();
    }

    protected void selectDupes() {
        int index = this.dupes.getSelectionIndex();
        List duplicates = (List)this.dupes.getData("duplicates");
        ResourceAndCount resourceAndCount = (ResourceAndCount)duplicates.get(index);
        this.paintHolder = resourceAndCount.resource;
        this.holderIndex = resourceAndCount.indexes;
        this.list.setSelection(this.holderIndex);
        this.refreshObject();
        this.dupeDetails.removeAll();
        for (int i = 0; i < resourceAndCount.indexes.length; ++i) {
            int indexIntoList = resourceAndCount.indexes[i];
            if (indexIntoList == -1) {
                return;
            }
            this.dupeDetails.add(this.objectName(this.objects[indexIntoList]));
        }
    }

    private void setupLayout() {
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, -2);
        data.right = new FormAttachment(100, -2);
        data.left = new FormAttachment(0, 2);
        this.status.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment((Control)this.status, -2);
        this.sashForm.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -2);
        this.start.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.start, 2);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.start, 0, 131072);
        this.stop.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.stop, 2);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.start, 0, 131072);
        this.filter.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.filter, 2);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.start, 0, 131072);
        data.bottom = new FormAttachment(75);
        this.list.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.list, 2);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.start, 0, 131072);
        data.bottom = new FormAttachment((Control)this.checkDuplicates, -2);
        this.types.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment((Control)this.start, 0, 131072);
        data.bottom = new FormAttachment(100, -2);
        this.checkDuplicates.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -2);
        this.dupes.setLayoutData((Object)data);
    }

    void refreshTypes(Object[] newObjects) {
        HashMap counts = new HashMap(10);
        for (int i = 0; i < newObjects.length; ++i) {
            Object object = newObjects[i];
            int[] cnt = (int[])counts.get(object.getClass());
            if (cnt == null) {
                cnt = new int[1];
                counts.put(object.getClass(), cnt);
            }
            cnt[0] = cnt[0] + 1;
        }
        Class[] classes = counts.keySet().toArray(new Class[counts.size()]);
        Arrays.sort(classes, classComparator);
        String[] selectedItems = this.types.getSelection();
        int[] selIdxs = new int[selectedItems.length];
        int selIdx = 0;
        this.types.removeAll();
        block1: for (int i = 0; i < classes.length; ++i) {
            int[] cnt = (int[])counts.get(classes[i]);
            String className = classes[i].getName();
            int idx = className.lastIndexOf(46);
            if (idx != -1) {
                className = className.substring(idx + 1);
            }
            this.types.add(className + ':' + " " + cnt[0]);
            for (int j = 0; j < selectedItems.length; ++j) {
                if (!selectedItems[j].startsWith(className)) continue;
                selIdxs[selIdx++] = i;
                continue block1;
            }
        }
        while (selIdx < selIdxs.length) {
            selIdxs[selIdx] = -1;
            ++selIdx;
        }
        this.types.select(selIdxs);
    }

    void refreshDifference(boolean showDiff) {
        int i;
        String filterText;
        DeviceData info = this.display.getDeviceData();
        if (!info.tracking) {
            MessageBox dialog = new MessageBox(this.parent.getShell(), 40);
            dialog.setText(this.parent.getShell().getText());
            dialog.setMessage("Warning: Device is not tracking resource allocation");
            dialog.open();
        }
        Object[] newObjects = info.objects;
        Error[] newErrors = info.errors;
        Object[] diffObjects = new Object[newObjects.length];
        Error[] diffErrors = new Error[newErrors.length];
        int count = 0;
        String[] selectedTypes = this.types.getSelection();
        if (selectedTypes.length == 0 || selectedTypes.length == this.types.getItemCount()) {
            selectedTypes = null;
        }
        if ((filterText = this.filter.getText().trim()).length() == 0) {
            filterText = null;
        }
        String[] typeNames = null;
        if (selectedTypes != null) {
            typeNames = new String[selectedTypes.length];
            for (i = 0; i < selectedTypes.length; ++i) {
                int delimeterIndex = selectedTypes[i].lastIndexOf(58);
                typeNames[i] = delimeterIndex == -1 ? selectedTypes[i] : selectedTypes[i].substring(0, delimeterIndex);
            }
        }
        for (i = 0; i < newObjects.length; ++i) {
            int index;
            for (index = 0; index < this.oldObjects.length && newObjects[i] != this.oldObjects[index]; ++index) {
            }
            if (index != this.oldObjects.length) continue;
            if (typeNames != null) {
                boolean found = false;
                for (int j = 0; j < typeNames.length; ++j) {
                    if (newObjects[i].getClass().getName().indexOf(typeNames[j]) <= -1) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (filterText != null) {
                StackTraceElement[] stes = newErrors[i].getStackTrace();
                boolean found = false;
                for (int j = 0; j < stes.length; ++j) {
                    if (stes[j].getClassName().indexOf(filterText) <= 0) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            diffObjects[count] = newObjects[i];
            diffErrors[count] = newErrors[i];
            ++count;
        }
        this.objects = new Object[count];
        this.errors = new Error[count];
        System.arraycopy(diffObjects, 0, this.objects, 0, count);
        System.arraycopy(diffErrors, 0, this.errors, 0, count);
        this.list.removeAll();
        this.text.setText("");
        this.canvas.redraw();
        for (i = 0; i < this.objects.length; ++i) {
            this.list.add(this.objectName(this.objects[i]));
        }
        this.refreshTypes(newObjects);
        String statusMessage = "Total: " + this.objects.length;
        int diff = this.objects.length - this.previousTotal;
        if (showDiff && this.previousTotal > 0 && diff != 0) {
            statusMessage = statusMessage + " ";
            if (diff > 0) {
                statusMessage = statusMessage + "+";
            }
            statusMessage = statusMessage + diff;
        }
        this.previousTotal = this.objects.length;
        this.status.setText(statusMessage);
    }

    String objectName(Object object) {
        String string = object.toString();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1);
    }

    void toggleStackTrace() {
        this.refreshObject();
    }

    void paintCanvas(Event event) {
        this.canvas.setCursor(null);
        if (this.paintHolder == null) {
            return;
        }
        Object object = this.paintHolder;
        GC gc = event.gc;
        if (object instanceof Color) {
            if (((Color)object).isDisposed()) {
                return;
            }
            gc.setBackground((Color)object);
            gc.fillRectangle(this.canvas.getClientArea());
            return;
        }
        if (object instanceof Cursor) {
            if (((Cursor)object).isDisposed()) {
                return;
            }
            this.canvas.setCursor((Cursor)object);
            return;
        }
        if (object instanceof Font) {
            if (((Font)object).isDisposed()) {
                return;
            }
            gc.setFont((Font)object);
            FontData[] array = gc.getFont().getFontData();
            String string = "";
            String lf = this.text.getLineDelimiter();
            for (int i = 0; i < array.length; ++i) {
                FontData data = array[i];
                String style = "NORMAL";
                int bits = data.getStyle();
                if (bits != 0) {
                    if ((bits & 1) != 0) {
                        style = "BOLD ";
                    }
                    if ((bits & 2) != 0) {
                        style = style + "ITALIC";
                    }
                }
                string = string + data.getName() + " " + data.getHeight() + " " + style + lf;
            }
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof Image) {
            Image image = (Image)object;
            if (!image.isDisposed()) {
                gc.drawImage((Image)object, 0, 0);
            }
            return;
        }
        if (object instanceof Path) {
            Path path = (Path)object;
            if (!path.isDisposed()) {
                gc.drawPath(path);
            }
            return;
        }
        if (object instanceof Pattern) {
            Pattern pattern = (Pattern)object;
            if (!pattern.isDisposed()) {
                gc.setBackgroundPattern(pattern);
                gc.fillRectangle(this.canvas.getClientArea());
            }
            return;
        }
        if (object instanceof Region) {
            if (((Region)object).isDisposed()) {
                return;
            }
            String string = ((Region)object).getBounds().toString();
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof TextLayout) {
            TextLayout layout = (TextLayout)object;
            if (!layout.isDisposed()) {
                layout.draw(gc, 0, 0);
            }
            return;
        }
        if (object instanceof Transform) {
            Transform xform = (Transform)object;
            if (!xform.isDisposed()) {
                String s = xform.toString();
                gc.drawString(s, 0, 0);
            }
            return;
        }
    }

    void refreshObject() {
        if (this.paintHolder == null) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream s = new PrintStream(stream);
        this.errors[this.holderIndex[0]].printStackTrace(s);
        this.text.setText(stream.toString());
        this.canvas.redraw();
        this.text.getParent().layout();
    }

    void refreshAll() {
        this.oldObjects = new Object[0];
        this.oldErrors = new Error[0];
        this.refreshDifference(true);
        this.oldObjects = this.objects;
        this.oldErrors = this.errors;
    }

    private void showHideDuplicates(SashForm sashForm, Composite column2) {
        column2.setVisible(this.checkDuplicates.getSelection());
        int[] weights = sashForm.getWeights();
        int[] newWeights = sashForm.getWeights();
        if (this.checkDuplicates.getSelection()) {
            if (this.previousWeights == null || Math.abs(weights[0] - this.previousWeights[0]) > 30) {
                int half;
                int sum = weights[0] + weights[1] + weights[2];
                newWeights[1] = half = (sum - weights[0]) / 2;
                newWeights[2] = half;
            } else {
                newWeights = this.previousWeights;
            }
            this.dupes.removeAll();
            this.computeDuplicates();
        } else {
            int weight0;
            this.previousWeights = weights;
            int sum = weights[0] + weights[1] + weights[2];
            newWeights[0] = weight0 = (int)((float)sum * ((float)weights[0] / (float)sum));
            newWeights[1] = 0;
            newWeights[2] = sum - weight0;
        }
        column2.getParent().layout();
        sashForm.setWeights(newWeights);
    }

    protected void computeDuplicates() {
        HashMap<ResourceAndCount, ResourceAndCount> dups = new HashMap<ResourceAndCount, ResourceAndCount>();
        for (int i = 0; i < this.objects.length; ++i) {
            Object object = this.objects[i];
            ResourceAndCount lookup = new ResourceAndCount(object);
            ResourceAndCount resourceAndCount = (ResourceAndCount)dups.get(lookup);
            if (resourceAndCount == null) {
                resourceAndCount = lookup;
                dups.put(resourceAndCount, resourceAndCount);
            }
            resourceAndCount.addIndex(i);
            resourceAndCount.inc();
        }
        ArrayList<ResourceAndCount> duplicates = new ArrayList<ResourceAndCount>();
        for (ResourceAndCount resourceAndCount : dups.values()) {
            if (resourceAndCount.count <= 1) continue;
            duplicates.add(resourceAndCount);
        }
        Collections.sort(duplicates, sortResources);
        this.dupes.setData("duplicates", duplicates);
        for (ResourceAndCount resourceAndCount : duplicates) {
            this.dupes.add(this.objectName(resourceAndCount.resource) + ':' + " " + resourceAndCount.count);
        }
    }

    static /* synthetic */ int[] access$102(Sleak x0, int[] x1) {
        x0.holderIndex = x1;
        return x1;
    }

    static class ResourceAndCount {
        Object resource;
        int count;
        private int[] indexes;
        private int hashCode = -1;

        public ResourceAndCount(Object resource) {
            this.resource = resource;
            this.count = 0;
        }

        public void inc() {
            ++this.count;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.hashForResource();
            }
            return this.hashCode;
        }

        private int hashForResource() {
            if (this.resource instanceof Color) {
                return this.hashColor(this.resource);
            }
            if (this.resource instanceof Cursor) {
                return this.resource.hashCode();
            }
            if (this.resource instanceof Font) {
                return this.fontHash(this.resource).hashCode();
            }
            if (this.resource instanceof GC) {
                return this.resource.hashCode();
            }
            if (this.resource instanceof Image) {
                return this.imageHash(this.resource);
            }
            if (this.resource instanceof Path || this.resource instanceof Pattern || this.resource instanceof Region || this.resource instanceof TextLayout || this.resource instanceof Transform) {
                // empty if block
            }
            return -1;
        }

        private int hashColor(Object aColor) {
            if (aColor == null) {
                return 1;
            }
            Color color = (Color)aColor;
            return color.getRGB().hashCode();
        }

        private int imageHash(Object resource2) {
            Image image = (Image)resource2;
            if (image.isDisposed()) {
                return -1;
            }
            byte[] bs = image.getImageData().data;
            int hash = 0;
            int multiplier = 1;
            for (int i = 0; i < bs.length; ++i) {
                hash += bs[i] * multiplier;
                int shifted = multiplier << 5;
                multiplier = shifted - multiplier;
            }
            Rectangle bounds = image.getBounds();
            return hash * bounds.width * 23 * bounds.height;
        }

        private boolean equalsForObject(ResourceAndCount other) {
            Object resourcea = this.resource;
            Object resourceb = other.resource;
            if (resourcea.getClass() != resourceb.getClass()) {
                return false;
            }
            if (resourcea instanceof Color) {
                return ((Color)resourcea).getRGB().equals((Object)((Color)resourceb).getRGB());
            }
            if (resourcea instanceof Cursor) {
                return resourcea.equals(resourceb);
            }
            if (resourcea instanceof Font) {
                return this.fontHash(resourcea).equals(this.fontHash(resourceb));
            }
            if (resourcea instanceof GC) {
                return resourcea.equals(resourceb);
            }
            if (resourcea instanceof Image) {
                return this.hashCode() == other.hashCode();
            }
            if (resourcea instanceof Path || resourcea instanceof Pattern || resourcea instanceof Region || resourcea instanceof TextLayout || resourcea instanceof Transform) {
                // empty if block
            }
            return false;
        }

        private String fontHash(Object resourcea) {
            FontData[] array = ((Font)resourcea).getFontData();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                FontData data = array[i];
                String style = "NORMAL";
                int bits = data.getStyle();
                if (bits != 0) {
                    if ((bits & 1) != 0) {
                        style = "BOLD ";
                    }
                    if ((bits & 2) != 0) {
                        style = style + "ITALIC";
                    }
                }
                buffer.append(data.getName());
                buffer.append(data.getHeight());
                buffer.append(style);
            }
            return buffer.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceAndCount other = (ResourceAndCount)obj;
            return !(this.resource == null ? other.resource != null : !this.equalsForResource(other));
        }

        private boolean equalsForResource(ResourceAndCount other) {
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            return this.equalsForObject(other);
        }

        public void addIndex(int toAdd) {
            int index;
            if (this.indexes == null) {
                this.indexes = new int[4];
                Arrays.fill(this.indexes, -1);
            }
            int length = this.indexes.length;
            for (index = length - 1; index >= 0 && this.indexes[index] == -1; --index) {
            }
            if (++index == length) {
                int[] newIndexes = new int[length + 4];
                Arrays.fill(newIndexes, -1);
                System.arraycopy(this.indexes, 0, newIndexes, 0, length);
                this.indexes = newIndexes;
            }
            this.indexes[index] = toAdd;
        }
    }
}

