/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui.thumbnail;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.Transforms;
import org.scohen.juploadr.ui.thumbnail.Thumbnail;

public class UploadThumbnail
extends Canvas
implements Thumbnail {
    private static int THUMBNAIL_WIDTH = 96;
    private static int THUMBNAIL_HEIGHT = 96;
    private Image image;
    private ImageData originalData;
    private ImageAttributes attrs;
    private Color borderColor;
    private Color selectedBackground;
    private Color background;
    private int currentRotation = 0;

    UploadThumbnail(Composite parent, ImageAttributes attrs, int style) {
        super(parent, style);
        this.attrs = attrs;
        ReusableUIFactory uiFactory = ReusableUIFactory.getInstance();
        this.borderColor = uiFactory.getThumbnailBorderColor();
        this.background = uiFactory.getThumbnailBackgroundColor();
        this.selectedBackground = uiFactory.getThumbnailSelectedBackgroundColor();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UploadThumbnail.this.image.dispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                UploadThumbnail.this.paintControl(e);
            }
        });
    }

    void paintControl(PaintEvent event) {
        GC gc = event.gc;
        ImageData imageData = this.image.getImageData();
        if (this.attrs.getRotation() != this.currentRotation) {
            int rotation = this.attrs.getRotation();
            if (rotation != 0) {
                ImageData rotated = Transforms.rotate(this.originalData, rotation);
                this.image.dispose();
                this.image = new Image((Device)event.display, rotated);
            } else {
                this.image.dispose();
                this.image = new Image((Device)event.display, this.originalData);
            }
            GC imgGC = new GC((Drawable)this.image);
            imgGC.drawImage(this.image, 0, 0);
            imgGC.dispose();
            this.currentRotation = this.attrs.getRotation();
        }
        gc.setForeground(this.borderColor);
        gc.setBackground(this.attrs.isSelected() ? this.selectedBackground : this.background);
        gc.fillRectangle(1, 1, THUMBNAIL_WIDTH, THUMBNAIL_HEIGHT);
        gc.drawRectangle(0, 0, THUMBNAIL_WIDTH - 1, THUMBNAIL_HEIGHT - 1);
        gc.drawImage(this.image, 5, 5);
        gc.drawRectangle(5, 5, imageData.width, imageData.height);
    }

    public Point computeSize(int x, int y) {
        return new Point(THUMBNAIL_WIDTH, THUMBNAIL_HEIGHT);
    }

    public Point computeSize(int arg0, int arg1, boolean arg2) {
        return this.computeSize(arg0, arg1);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.originalData = image.getImageData();
        THUMBNAIL_WIDTH = this.originalData.width + 10 + 1;
        THUMBNAIL_HEIGHT = this.originalData.height + 10 + 1;
    }

    public ImageAttributes getImageAttributes() {
        return this.attrs;
    }
}

