/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.uploadapi.ImageUploadApi;

public class PluginClassLoader
extends ClassLoader {
    private Map classCache = new HashMap();
    private List pluginClasses = new ArrayList();
    private Set packages = new HashSet();
    private static PluginClassLoader instance;

    protected PluginClassLoader() {
        this.buildCache();
    }

    public static synchronized PluginClassLoader getInstance() {
        if (instance == null) {
            instance = new PluginClassLoader();
        }
        return instance;
    }

    private void buildCache() {
        File[] jarFiles;
        File pluginsDirectory = new File(System.getProperty("user.dir"), "plugins");
        if (Configuration.isMac() && !pluginsDirectory.exists()) {
            pluginsDirectory = new File(System.getProperty("user.dir"), "JUploadr.app/Contents/Resources/Java/plugins/");
        }
        if ((jarFiles = pluginsDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().toLowerCase().endsWith(".jar") || pathname.getAbsolutePath().toLowerCase().endsWith(".zip");
            }
        })) != null) {
            for (int i = 0; i < jarFiles.length; ++i) {
                File jarFile = jarFiles[i];
                try {
                    JarFile jar = new JarFile(jarFile);
                    Manifest mf = jar.getManifest();
                    Attributes entries = mf.getMainAttributes();
                    String implementationClass = (String)entries.get(new Attributes.Name("Plugin-Class"));
                    if (implementationClass != null) {
                        this.pluginClasses.add(implementationClass);
                    }
                    Enumeration<JarEntry> allEntries = jar.entries();
                    while (allEntries.hasMoreElements()) {
                        JarEntry entry = allEntries.nextElement();
                        String className = this.toClassName(entry.getName());
                        this.classCache.put(className, new PluginCacheEntry(jar, className));
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ImageUploadApi[] getApis() {
        ImageUploadApi[] apis = new ImageUploadApi[this.pluginClasses.size()];
        Iterator iter = this.pluginClasses.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String next = (String)iter.next();
            try {
                Class<?> c = this.loadClass(next);
                apis[i++] = (ImageUploadApi)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return apis;
    }

    private String toClassName(String name) {
        String className = name;
        if (name.endsWith(".class")) {
            className = name.substring(0, name.lastIndexOf(46));
            className = className.replace('/', '.');
        }
        return className;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> toLoad = null;
        if (this.classCache.containsKey(name)) {
            PluginCacheEntry entry = (PluginCacheEntry)this.classCache.get(name);
            if (entry.clazz == null) {
                byte[] classBytes = this.loadClassBytes(entry.jar, name);
                if (classBytes != null) {
                    toLoad = this.defineClass(name, classBytes, 0, classBytes.length);
                    String packageName = name.substring(0, name.lastIndexOf(46));
                    if (!this.packages.contains(packageName)) {
                        this.definePackage(packageName, "Juploadr", "1.0", "scohen.org", "Juploadr", "1.0", "scohen.org", null);
                        this.packages.add(packageName);
                    }
                    if (toLoad == null) {
                        throw new ClassFormatError();
                    }
                }
            } else {
                toLoad = entry.clazz;
            }
        } else {
            return super.findClass(name);
        }
        return toLoad;
    }

    public InputStream getResourceAsStream(String name) {
        PluginCacheEntry entry = (PluginCacheEntry)this.classCache.get(name);
        if (entry != null) {
            JarEntry jarEntry = entry.jar.getJarEntry(name);
            try {
                return entry.jar.getInputStream(jarEntry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return super.getResourceAsStream(name);
        }
        return null;
    }

    private byte[] loadClassBytes(JarFile jar, String name) {
        String resourceName = name.replace('.', '/') + ".class";
        byte[] classData = null;
        JarEntry entry = (JarEntry)jar.getEntry(resourceName);
        if (entry != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)entry.getSize());
            byte[] buffer = new byte[4096];
            int numread = 0;
            try {
                InputStream jarFile = jar.getInputStream(entry);
                while ((numread = jarFile.read(buffer)) > 0) {
                    baos.write(buffer, 0, numread);
                }
                classData = baos.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No entry " + resourceName + " in  " + jar.getName());
        }
        return classData;
    }

    private class PluginCacheEntry {
        public JarFile jar;
        public String className;
        public Class clazz;

        public PluginCacheEntry(JarFile jar, String className) {
            this.className = className;
            this.jar = jar;
        }
    }
}

