/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.util;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.io.IOException;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.ReusableUIFactory;

public class JUploadrBrowserLauncher {
    private static BrowserLauncher launcher;

    public static void openURL(String url) {
        JUploadrBrowserLauncher.openURL(url, Messages.getString("juploadr.browser.not.found"));
    }

    public static void openURL(final String url, final String message) {
        if (launcher != null && !Configuration.isMac()) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        launcher.openURLinBrowser(JUploadrBrowserLauncher.getFirefoxBrowser(launcher.getBrowserList()), url);
                    }
                    catch (BrowserLaunchingInitializingException e) {
                        JUploadrBrowserLauncher.handleNoBrowserAvailable(url, message);
                    }
                    catch (BrowserLaunchingExecutionException e) {
                        JUploadrBrowserLauncher.handleNoBrowserAvailable(url, message);
                    }
                    catch (UnsupportedOperatingSystemException e) {
                        JUploadrBrowserLauncher.handleNoBrowserAvailable(url, message);
                    }
                }
            };
            ReusableUIFactory.getInstance().getDisplay().syncExec((Runnable)t);
        } else if (Configuration.isMac()) {
            try {
                Runtime.getRuntime().exec("open " + url);
            }
            catch (IOException e) {
                JUploadrBrowserLauncher.handleNoBrowserAvailable(url, message);
            }
        } else {
            JUploadrBrowserLauncher.handleNoBrowserAvailable(url, message);
        }
    }

    private static String getFirefoxBrowser(List browsers) {
        if (browsers != null && browsers.size() > 0) {
            String browserName = (String)browsers.get(0);
            for (String name : browsers) {
                if (!"Firefox".equalsIgnoreCase(name)) continue;
                return name;
            }
            return browserName;
        }
        return null;
    }

    private static void handleNoBrowserAvailable(String url, String message) {
        Clipboard clipboard = new Clipboard(ReusableUIFactory.getInstance().getDisplay());
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        Object[] data = new Object[]{url};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
        MessageUtils.showErrorMessage(message);
    }

    static {
        try {
            launcher = new BrowserLauncher(null);
        }
        catch (BrowserLaunchingInitializingException e) {
        }
        catch (UnsupportedOperatingSystemException unsupportedOperatingSystemException) {
            // empty catch block
        }
    }
}

