/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.AbstractTiffTagReader;
import au.com.lastweekend.jim.io.exif.ThumbnailTiffDirectory;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThumbnailTiffDirectoryReader
extends AbstractTiffTagReader {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$exif$ThumbnailTiffDirectoryReader == null ? (class$au$com$lastweekend$jim$io$exif$ThumbnailTiffDirectoryReader = ThumbnailTiffDirectoryReader.class$("au.com.lastweekend.jim.io.exif.ThumbnailTiffDirectoryReader")) : class$au$com$lastweekend$jim$io$exif$ThumbnailTiffDirectoryReader));
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$exif$ThumbnailTiffDirectoryReader;

    public ThumbnailTiffDirectoryReader(byte[] data) {
        super(data);
    }

    public Directory extract(Directory parentDirectory) throws TiffTagProcessingException {
        this.setDirectory(new ThumbnailTiffDirectory());
        this.processTiffTags();
        this.extractThumbnail();
        return this.getDirectory();
    }

    protected AbstractTiffTagReader getLinkedDirectoryReader() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void extractThumbnail() throws TiffTagProcessingException {
        int length;
        int offset;
        Directory directory = this.getDirectory();
        if (!directory.containsTag(259)) {
            return;
        }
        try {
            void var3_3;
            void var4_4;
            int compression = directory.getInt(259);
            switch (compression) {
                case 1: {
                    int offsetTag = 273;
                    int lengthTag = 279;
                    break;
                }
                case 6: {
                    int offsetTag = 513;
                    int lengthTag = 514;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!directory.containsTag((int)var4_4) || !directory.containsTag((int)var3_3)) {
                return;
            }
            offset = directory.getInt((int)var3_3);
            length = directory.getInt((int)var4_4);
        }
        catch (MetadataException e) {
            LOG.warn((Object)"Unable to extract thumbnail from thumbnail tags", (Throwable)e);
            return;
        }
        byte[] data = this.getData();
        if (offset + length > data.length) {
            LOG.warn((Object)"Thumbnail length exceeds available data, truncating");
            length = data.length - offset;
        }
        if (length > 0 && offset + length <= data.length) {
            byte[] result = new byte[length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = data[offset + i];
            }
            directory.setTag(61441, 1, result);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

