/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.ExifDirectoryWriter;
import au.com.lastweekend.jim.io.exif.ExifTransform;
import au.com.lastweekend.jim.io.exif.ThumbnailTiffDirectory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class ThumbnailTiffDirectoryWriter
extends ExifDirectoryWriter {
    private List _writableTags;

    public ThumbnailTiffDirectoryWriter(ThumbnailTiffDirectory thumbnailDirectory, ExifTransform transform) {
        super(thumbnailDirectory, transform);
    }

    protected int getWriteableTagCount() {
        return this.getWritableTags().size();
    }

    private List getWritableTags() {
        if (this._writableTags == null) {
            this._writableTags = new ArrayList();
            ThumbnailTiffDirectory thumbnailDirectory = this.getThumbnailTiffDirectory();
            Iterator iterator = thumbnailDirectory.getTagIterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                if (tag.getTagType() == 61441) continue;
                this._writableTags.add(tag);
            }
        }
        return this._writableTags;
    }

    private ThumbnailTiffDirectory getThumbnailTiffDirectory() {
        ThumbnailTiffDirectory thumbnailDirectory = (ThumbnailTiffDirectory)this.getDirectory();
        return thumbnailDirectory;
    }

    protected Iterator getWriteableTagIterator() {
        return this.getWritableTags().iterator();
    }

    protected int getTagDataLength(int tagType, Object tagValue, int formatCode) {
        if (tagType == 513) {
            return this.getThumbnailDataLength();
        }
        return super.getTagDataLength(tagType, tagValue, formatCode);
    }

    private int getThumbnailDataLength() {
        try {
            return this.getTransformedThumbnailData().length;
        }
        catch (MetadataException e) {
            throw new RuntimeException("Unable to get thumbnail while calculating size", e);
        }
    }

    protected void writeLongTag(Object longTag, OutputStream output) throws IOException {
        if (longTag instanceof Tag && ((Tag)longTag).getTagType() == 513) {
            try {
                byte[] tagData = this.getTransformedThumbnailData();
                output.write(tagData);
            }
            catch (MetadataException e) {
                throw new IOException("Unable to get thumbnail data to write");
            }
        } else {
            super.writeLongTag(longTag, output);
        }
    }

    private byte[] getTransformedThumbnailData() throws MetadataException {
        BufferedImage originalImage;
        if (this.getExifTransform().isThumbnailTransformRequired() && this.getThumbnailTiffDirectory().isJPEGCompression() && (originalImage = this.getThumbnailTiffDirectory().getThumbnailImage()) != null) {
            BufferedImage transformedImage = this.getExifTransform().transformThumbnail(originalImage);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)transformedImage, "JPEG", outStream);
            }
            catch (IOException e) {
                throw new MetadataException("Unable to rotate thumbnail", e);
            }
            return outStream.toByteArray();
        }
        byte[] thumbnailData = this.getThumbnailTiffDirectory().getThumbnailData();
        if (thumbnailData == null) {
            return new byte[0];
        }
        return thumbnailData;
    }

    protected Object getTransformedTagValue(int tagType) {
        if (tagType == 514) {
            return new Integer(this.getThumbnailDataLength());
        }
        return super.getTransformedTagValue(tagType);
    }

    protected int writeTagInfo(Tag tag, int nextTagValueOffset, List longTagList, OutputStream output) throws IOException {
        ThumbnailTiffDirectory thumbnailDirectory = this.getThumbnailTiffDirectory();
        int tagType = tag.getTagType();
        if (tagType == 513) {
            int thumbnailLength = this.getThumbnailDataLength();
            int newOffset = nextTagValueOffset + thumbnailLength;
            longTagList.add(tag);
            this.writeOffsetTagInfoHeader(tagType, tag.getFormatCode(), 1, nextTagValueOffset, output);
            return newOffset;
        }
        return super.writeTagInfo(tag, nextTagValueOffset, longTagList, output);
    }

    public int getComponentCount() {
        return 1;
    }
}

