/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.canon;

import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.TagDescriptor;

public class CanonMakernoteDescriptor
extends TagDescriptor {
    public CanonMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 49409: {
                return this.getMacroModeDescription();
            }
            case 49410: {
                return this.getSelfTimerDelayDescription();
            }
            case 49412: {
                return this.getFlashModeDescription();
            }
            case 49413: {
                return this.getContinuousDriveModeDescription();
            }
            case 49415: {
                return this.getFocusMode1Description();
            }
            case 49418: {
                return this.getImageSizeDescription();
            }
            case 49419: {
                return this.getEasyShootingModeDescription();
            }
            case 49421: {
                return this.getContrastDescription();
            }
            case 49422: {
                return this.getSaturationDescription();
            }
            case 49423: {
                return this.getSharpnessDescription();
            }
            case 49424: {
                return this.getIsoDescription();
            }
            case 49425: {
                return this.getMeteringModeDescription();
            }
            case 49427: {
                return this.getAfPointSelectedDescription();
            }
            case 49428: {
                return this.getExposureModeDescription();
            }
            case 49431: {
                return this.getLongFocalLengthDescription();
            }
            case 49432: {
                return this.getShortFocalLengthDescription();
            }
            case 49433: {
                return this.getFocalUnitsPerMillimetreDescription();
            }
            case 49437: {
                return this.getFlashDetailsDescription();
            }
            case 49440: {
                return this.getFocusMode2Description();
            }
            case 49671: {
                return this.getWhiteBalanceDescription();
            }
            case 49678: {
                return this.getAfPointUsedDescription();
            }
            case 49679: {
                return this.getFlashBiasDescription();
            }
        }
        return this.getDirectory().getString(tagType);
    }

    private String getFlashBiasDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49679)) {
            return null;
        }
        int value = this.getDirectory().getInt(49679);
        switch (value) {
            case 65472: {
                return "-2 EV";
            }
            case 65484: {
                return "-1.67 EV";
            }
            case 65488: {
                return "-1.50 EV";
            }
            case 65492: {
                return "-1.33 EV";
            }
            case 65504: {
                return "-1 EV";
            }
            case 65516: {
                return "-0.67 EV";
            }
            case 65520: {
                return "-0.50 EV";
            }
            case 65524: {
                return "-0.33 EV";
            }
            case 0: {
                return "0 EV";
            }
            case 12: {
                return "0.33 EV";
            }
            case 16: {
                return "0.50 EV";
            }
            case 20: {
                return "0.67 EV";
            }
            case 32: {
                return "1 EV";
            }
            case 44: {
                return "1.33 EV";
            }
            case 48: {
                return "1.50 EV";
            }
            case 52: {
                return "1.67 EV";
            }
            case 64: {
                return "2 EV";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getAfPointUsedDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49678)) {
            return null;
        }
        int value = this.getDirectory().getInt(49678);
        if ((value & 7) == 0) {
            return "Right";
        }
        if ((value & 7) == 1) {
            return "Centre";
        }
        if ((value & 7) == 2) {
            return "Left";
        }
        return "Unknown (" + value + ")";
    }

    private String getWhiteBalanceDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49671)) {
            return null;
        }
        int value = this.getDirectory().getInt(49671);
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Sunny";
            }
            case 2: {
                return "Cloudy";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Flourescent";
            }
            case 5: {
                return "Flash";
            }
            case 6: {
                return "Custom";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getFocusMode2Description() throws MetadataException {
        if (!this.getDirectory().containsTag(49440)) {
            return null;
        }
        int value = this.getDirectory().getInt(49440);
        switch (value) {
            case 0: {
                return "Single";
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getFlashDetailsDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49437)) {
            return null;
        }
        int value = this.getDirectory().getInt(49437);
        if ((value << 14 & 1) > 0) {
            return "External E-TTL";
        }
        if ((value << 13 & 1) > 0) {
            return "Internal flash";
        }
        if ((value << 11 & 1) > 0) {
            return "FP sync used";
        }
        if ((value << 4 & 1) > 0) {
            return "FP sync enabled";
        }
        return "Unknown (" + value + ")";
    }

    private String getFocalUnitsPerMillimetreDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49433)) {
            return "";
        }
        int value = this.getDirectory().getInt(49433);
        if (value != 0) {
            return Integer.toString(value);
        }
        return "";
    }

    private String getShortFocalLengthDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49432)) {
            return null;
        }
        int value = this.getDirectory().getInt(49432);
        String units = this.getFocalUnitsPerMillimetreDescription();
        return Integer.toString(value) + " " + units;
    }

    private String getLongFocalLengthDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49431)) {
            return null;
        }
        int value = this.getDirectory().getInt(49431);
        String units = this.getFocalUnitsPerMillimetreDescription();
        return Integer.toString(value) + " " + units;
    }

    private String getExposureModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49428)) {
            return null;
        }
        int value = this.getDirectory().getInt(49428);
        switch (value) {
            case 0: {
                return "Easy shooting";
            }
            case 1: {
                return "Program";
            }
            case 2: {
                return "Tv-priority";
            }
            case 3: {
                return "Av-priority";
            }
            case 4: {
                return "Manual";
            }
            case 5: {
                return "A-DEP";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getAfPointSelectedDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49427)) {
            return null;
        }
        int value = this.getDirectory().getInt(49427);
        switch (value) {
            case 12288: {
                return "None (MF)";
            }
            case 12289: {
                return "Auto selected";
            }
            case 12290: {
                return "Right";
            }
            case 12291: {
                return "Centre";
            }
            case 12292: {
                return "Left";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getMeteringModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49425)) {
            return null;
        }
        int value = this.getDirectory().getInt(49425);
        switch (value) {
            case 3: {
                return "Evaluative";
            }
            case 4: {
                return "Partial";
            }
            case 5: {
                return "Centre weighted";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getIsoDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49424)) {
            return null;
        }
        int value = this.getDirectory().getInt(49424);
        switch (value) {
            case 0: {
                return "Not specified (see ISOSpeedRatings tag)";
            }
            case 15: {
                return "Auto";
            }
            case 16: {
                return "50";
            }
            case 17: {
                return "100";
            }
            case 18: {
                return "200";
            }
            case 19: {
                return "400";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getSharpnessDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49423)) {
            return null;
        }
        int value = this.getDirectory().getInt(49423);
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getSaturationDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49422)) {
            return null;
        }
        int value = this.getDirectory().getInt(49422);
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getContrastDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49421)) {
            return null;
        }
        int value = this.getDirectory().getInt(49421);
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getEasyShootingModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49419)) {
            return null;
        }
        int value = this.getDirectory().getInt(49419);
        switch (value) {
            case 0: {
                return "Full auto";
            }
            case 1: {
                return "Manual";
            }
            case 2: {
                return "Landscape";
            }
            case 3: {
                return "Fast shutter";
            }
            case 4: {
                return "Slow shutter";
            }
            case 5: {
                return "Night";
            }
            case 6: {
                return "B&W";
            }
            case 7: {
                return "Sepia";
            }
            case 8: {
                return "Portrait";
            }
            case 9: {
                return "Sports";
            }
            case 10: {
                return "Macro / Closeup";
            }
            case 11: {
                return "Pan focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getImageSizeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49418)) {
            return null;
        }
        int value = this.getDirectory().getInt(49418);
        switch (value) {
            case 0: {
                return "Large";
            }
            case 1: {
                return "Medium";
            }
            case 2: {
                return "Small";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getFocusMode1Description() throws MetadataException {
        if (!this.getDirectory().containsTag(49415)) {
            return null;
        }
        int value = this.getDirectory().getInt(49415);
        switch (value) {
            case 0: {
                return "One-shot";
            }
            case 1: {
                return "AI Servo";
            }
            case 2: {
                return "AI Focus";
            }
            case 3: {
                return "MF";
            }
            case 4: {
                return "Single";
            }
            case 5: {
                return "Continuous";
            }
            case 6: {
                return "MF";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getContinuousDriveModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49413)) {
            return null;
        }
        int value = this.getDirectory().getInt(49413);
        switch (value) {
            case 0: {
                if (this.getDirectory().getInt(49410) == 0) {
                    return "Single shot";
                }
                return "Single shot with self-timer";
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getFlashModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49412)) {
            return null;
        }
        int value = this.getDirectory().getInt(49412);
        switch (value) {
            case 0: {
                return "No flash fired";
            }
            case 1: {
                return "Auto";
            }
            case 2: {
                return "On";
            }
            case 3: {
                return "Red-eye reduction";
            }
            case 4: {
                return "Slow-synchro";
            }
            case 5: {
                return "Auto and red-eye reduction";
            }
            case 6: {
                return "On and red-eye reduction";
            }
            case 16: {
                return "Extenal flash";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getSelfTimerDelayDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49410)) {
            return null;
        }
        int value = this.getDirectory().getInt(49410);
        if (value == 0) {
            return "Self timer not used";
        }
        return Double.toString((double)value * 0.1) + " sec";
    }

    private String getMacroModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(49409)) {
            return null;
        }
        int value = this.getDirectory().getInt(49409);
        switch (value) {
            case 1: {
                return "Macro";
            }
            case 2: {
                return "Normal";
            }
        }
        return "Unknown (" + value + ")";
    }
}

