/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.minolta;

import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.TagDescriptor;
import au.com.lastweekend.jim.util.Rational;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;

public class MinoltaCameraSettingsDescriptor
extends TagDescriptor {
    public MinoltaCameraSettingsDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 3074: {
                return this.getExposureModeDescription();
            }
            case 3075: {
                return this.getFlashModeDescription();
            }
            case 3076: {
                return this.getWhiteBalanceDescription();
            }
            case 3077: {
                return this.getImageSizeDescription();
            }
            case 3110: {
                return this.getCameraModelDescription();
            }
            case 3078: {
                return this.getImageQualityDescription();
            }
            case 3079: {
                return this.getDriveModeDescription();
            }
            case 3080: {
                return this.getMeteringModeDescription();
            }
            case 3081: {
                return this.getFilmSpeedDescription();
            }
            case 3082: {
                return this.getShutterSpeedDescription();
            }
            case 3083: 
            case 3096: {
                return this.getApertureDescription(tagType);
            }
            case 3084: 
            case 3099: 
            case 3111: 
            case 3116: {
                return this.getOnOffDescription(tagType);
            }
            case 3101: 
            case 3102: 
            case 3103: {
                return this.getWhiteBalanceCoefficientDescription(tagType);
            }
            case 3085: {
                return this.getDigitalZoomDescription();
            }
            case 3086: {
                return this.getExposureCompensationDescription();
            }
            case 3087: {
                return this.getBracketStepDescription();
            }
            case 3091: {
                return this.getFocalLengthDescription();
            }
            case 3092: {
                return this.getFocusDistanceDescription();
            }
            case 3094: {
                return this.getDateDescription();
            }
            case 3095: {
                return this.getTimeDescription();
            }
            case 3104: 
            case 3105: 
            case 3114: {
                return this.getCompensationDescription(tagType);
            }
            case 3107: {
                return this.getSubjectProgramDescription();
            }
            case 3106: {
                return this.getSharpnessDescription();
            }
            case 3108: {
                return this.getFlashCompensationDescription();
            }
            case 3109: {
                return this.getISOSettingDescription();
            }
            case 3113: {
                return this.getColourModeDescription();
            }
            case 3112: {
                return this.getFolderNameDescription();
            }
            case 3117: {
                return this.getBrightnessValueDescription();
            }
            case 3120: {
                return this.getWideFocusZoneDescription();
            }
            case 3124: {
                return this.getColourProfileDescription();
            }
            case 3123: {
                return this.getDECPositionDescription();
            }
            case 3122: {
                return this.getFocusAreaDescription();
            }
            case 3121: {
                return this.getFocusModeDescription();
            }
        }
        return this.getDirectory().getString(tagType);
    }

    private String getFocusModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3121)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3121);
        switch (tagValue) {
            case 0: {
                return "Auto Focus";
            }
            case 1: {
                return "Manual Focus";
            }
        }
        return null;
    }

    private String getFocusAreaDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3122)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3122);
        switch (tagValue) {
            case 0: {
                return "Wide";
            }
            case 1: {
                return "Spot";
            }
        }
        return null;
    }

    private String getDECPositionDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3123)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3123);
        switch (tagValue) {
            case 0: {
                return "Exposure";
            }
            case 1: {
                return "Contrast";
            }
            case 2: {
                return "Saturation";
            }
            case 3: {
                return "Filter";
            }
        }
        return null;
    }

    private String getColourProfileDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3124)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3124);
        switch (tagValue) {
            case 0: {
                return "Not embedded";
            }
            case 1: {
                return "Embedded";
            }
        }
        return null;
    }

    private String getWideFocusZoneDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3120)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3120);
        switch (tagValue) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Centre (horizontal)";
            }
            case 2: {
                return "Centre (vertical)";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return null;
    }

    private String getBrightnessValueDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3117)) {
            return null;
        }
        double tagValue = this.getDirectory().getInt(3117);
        double bv = Math.pow(2.0, tagValue / 8.0 - 6.0);
        return (int)bv + "";
    }

    private String getFolderNameDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3112)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3112);
        switch (tagValue) {
            case 0: {
                return "Standard";
            }
            case 1: {
                return "Data format";
            }
        }
        return null;
    }

    private String getColourModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3113)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3113);
        switch (tagValue) {
            case 0: {
                return "Natural color";
            }
            case 1: {
                return "Black&White";
            }
            case 2: {
                return "Vivid color";
            }
            case 3: {
                return "Solarization";
            }
            case 4: {
                return "AdobeRGB";
            }
        }
        return null;
    }

    private String getISOSettingDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3109)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3109);
        switch (tagValue) {
            case 0: {
                return "100";
            }
            case 1: {
                return "200";
            }
            case 2: {
                return "400";
            }
            case 3: {
                return "800";
            }
            case 4: {
                return "Auto";
            }
        }
        return null;
    }

    private String getFlashCompensationDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3108)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3108);
        Rational rational = new Rational(tagValue - 6, 3);
        return rational.toSimpleString(false);
    }

    private String getSharpnessDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3106)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3106);
        switch (tagValue) {
            case 0: {
                return "Hard";
            }
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Soft";
            }
        }
        return null;
    }

    private String getSubjectProgramDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3107)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3107);
        switch (tagValue) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Portrait";
            }
            case 2: {
                return "Text";
            }
            case 3: {
                return "Night portrait";
            }
            case 4: {
                return "Sunset";
            }
            case 5: {
                return "Sports action";
            }
        }
        return null;
    }

    private String getCompensationDescription(int tagType) throws MetadataException {
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(tagType);
        return tagValue - 3 + "";
    }

    private String getTimeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3095)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3095);
        int hour = tagValue / 65536;
        int minute = tagValue / 256 - hour * 256;
        int second = tagValue % 256;
        DateFormat timeFormat = DateFormat.getTimeInstance();
        GregorianCalendar calendarDate = new GregorianCalendar(1900, 1, 1, hour, minute, second);
        return timeFormat.format(calendarDate.getTime());
    }

    private String getDateDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3094)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3094);
        int year = tagValue / 65536;
        int month = tagValue / 256 - year * 256;
        int day = tagValue % 256;
        DateFormat dateFormat = DateFormat.getDateInstance();
        GregorianCalendar calendarDate = new GregorianCalendar(year, month - 1, day);
        return dateFormat.format(calendarDate.getTime());
    }

    private String getFocusDistanceDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3092)) {
            return null;
        }
        double tagValue = this.getDirectory().getInt(3092);
        double focusDistance = tagValue / 1000.0;
        DecimalFormat formatter = new DecimalFormat("0.00");
        return formatter.format(focusDistance) + "m";
    }

    private String getFocalLengthDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3091)) {
            return null;
        }
        double tagValue = this.getDirectory().getInt(3091);
        double focalLength = tagValue / 256.0;
        double focalLength35mm = focalLength * 3.9333;
        DecimalFormat formatter = new DecimalFormat("0.00");
        return formatter.format(focalLength) + "mm (" + formatter.format(focalLength35mm) + "mm)";
    }

    private String getBracketStepDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3087)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3087);
        switch (tagValue) {
            case 0: {
                return "1/3 ev";
            }
            case 1: {
                return "2/3 ev";
            }
            case 2: {
                return "1 ev";
            }
        }
        return null;
    }

    private String getExposureCompensationDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3085)) {
            return null;
        }
        double tagValue = this.getDirectory().getInt(3085);
        double expComp = tagValue / 3.0 - 2.0;
        DecimalFormat formatter = new DecimalFormat("0.0");
        return formatter.format(expComp) + " ev";
    }

    private String getDigitalZoomDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3085)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3085);
        switch (tagValue) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Digital magnification used";
            }
            case 2: {
                return "Digital zoom 2x";
            }
            case 3: {
                return "?????";
            }
        }
        return null;
    }

    private String getWhiteBalanceCoefficientDescription(int tagType) throws MetadataException {
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        double tagValue = this.getDirectory().getInt(tagType);
        DecimalFormat formatter = new DecimalFormat("0.00");
        return formatter.format(tagValue / 256.0);
    }

    private String getOnOffDescription(int tagType) throws MetadataException {
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(tagType);
        switch (tagValue) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return null;
    }

    private String getApertureDescription(int tagType) throws MetadataException {
        if (!this.getDirectory().containsTag(tagType)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(tagType);
        double fStop = Math.pow(2.0, (double)tagValue / 16.0 - 0.5);
        DecimalFormat formatter = new DecimalFormat("0.#");
        return "F" + formatter.format(fStop);
    }

    private String getShutterSpeedDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3082)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3082);
        double shutterSpeed = Math.pow(2.0, (48.0 - (double)tagValue) / 8.0);
        if (shutterSpeed < 1.0) {
            return "1/" + (int)(1.0 / shutterSpeed) + " secs";
        }
        return (int)shutterSpeed + " secs: ";
    }

    private String getFilmSpeedDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3081)) {
            return null;
        }
        int tagValue = this.getDirectory().getInt(3081);
        double speedValue = (double)tagValue / 8.0 - 1.0;
        int isoValue = (int)(Math.pow(2.0, speedValue) * 3.125);
        return isoValue + " ASA";
    }

    private String getMeteringModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3080)) {
            return null;
        }
        switch (this.getDirectory().getInt(3080)) {
            case 0: {
                return "Multi-segment";
            }
            case 1: {
                return "Center weighted";
            }
            case 2: {
                return "Spot";
            }
        }
        return null;
    }

    private String getDriveModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3079)) {
            return null;
        }
        switch (this.getDirectory().getInt(3079)) {
            case 0: {
                return "single";
            }
            case 1: {
                return "continuous";
            }
            case 2: {
                return "self-timer";
            }
            case 4: {
                return "bracketing";
            }
            case 5: {
                return "interval";
            }
            case 6: {
                return "UHS continuous";
            }
            case 7: {
                return "HS continuous";
            }
        }
        return null;
    }

    private String getImageQualityDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3078)) {
            return null;
        }
        switch (this.getDirectory().getInt(3078)) {
            case 0: {
                return "Raw";
            }
            case 1: {
                return "Superfine";
            }
            case 2: {
                return "Fine";
            }
            case 3: {
                return "Standard";
            }
            case 4: {
                return "Economy";
            }
            case 5: {
                return "Extra fine";
            }
        }
        return null;
    }

    private String getCameraModelDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3110)) {
            return null;
        }
        switch (this.getDirectory().getInt(3110)) {
            case 0: {
                return "DiMAGE 7";
            }
            case 1: {
                return "DiMAGE 5";
            }
            case 2: {
                return "DiMAGE S304";
            }
            case 3: {
                return "DiMAGE S404";
            }
            case 4: {
                return "DiMAGE 7i";
            }
            case 5: {
                return "DiMAGE 7Hi";
            }
        }
        return null;
    }

    private String getImageSizeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3077)) {
            return null;
        }
        switch (this.getDirectory().getInt(3077)) {
            case 0: {
                switch (this.getDirectory().getInt(3110)) {
                    case 5: {
                        return "2048 x 1536";
                    }
                }
                return "2560 x 1920";
            }
            case 1: {
                return "1600 x 1200";
            }
            case 2: {
                return "1280 x 960";
            }
            case 3: {
                return "640 x 480";
            }
        }
        return null;
    }

    private String getWhiteBalanceDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3076)) {
            return null;
        }
        switch (this.getDirectory().getInt(3076)) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Cloudy";
            }
            case 3: {
                return "Tungsten";
            }
            case 5: {
                return "Custom";
            }
            case 7: {
                return "Fluorescent";
            }
            case 8: {
                return "Fluorescent 2";
            }
            case 11: {
                return "Custom 2";
            }
            case 12: {
                return "Custom 3";
            }
        }
        return null;
    }

    private String getFlashModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3075)) {
            return null;
        }
        switch (this.getDirectory().getInt(3075)) {
            case 0: {
                return "Fill-flash";
            }
            case 1: {
                return "Red-eye reduction";
            }
            case 2: {
                return "Rear flash sync";
            }
            case 3: {
                return "Wireless";
            }
        }
        return null;
    }

    private String getExposureModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(3074)) {
            return null;
        }
        switch (this.getDirectory().getInt(3074)) {
            case 0: {
                return "Program Mode";
            }
            case 1: {
                return "Aperture Priority";
            }
            case 2: {
                return "Shutter Priority";
            }
            case 3: {
                return "Manual";
            }
        }
        return null;
    }
}

