/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.minolta;

import au.com.lastweekend.jim.io.exif.AbstractTiffTagWriter;
import au.com.lastweekend.jim.io.exif.DirectoryWriter;
import au.com.lastweekend.jim.io.exif.ExifTransform;
import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteWriter;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaCameraSettingsDirectory;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaCameraSettingsWriter;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaMakernoteDirectory;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class MinoltaMakernoteWriter
extends AbstractTiffTagWriter
implements MakernoteWriter {
    public MinoltaMakernoteWriter(MinoltaMakernoteDirectory directory, ExifTransform transform, TiffTagFormat dataFormat, int startOffset) {
        super(directory, transform);
        this.setDataFormat(dataFormat);
        this.setStartOffset(startOffset);
    }

    protected int getTagDataLength(int tagType, Object tagValue, int formatCode) {
        if (tagType == 0) {
            return 4;
        }
        return super.getTagDataLength(tagType, tagValue, formatCode);
    }

    protected int writeTagInfo(Tag tag, int nextTagValueOffset, List longTagList, OutputStream output) throws IOException {
        if (tag.getTagType() == 0) {
            this.writeSmallValueTagInfoHeader(tag.getTagType(), 7, 4, "MLT0".getBytes(), 0, output);
            return nextTagValueOffset;
        }
        return super.writeTagInfo(tag, nextTagValueOffset, longTagList, output);
    }

    protected DirectoryWriter getDirectoryWriter(int tagType, Directory directory, int startOffset) {
        if (tagType == 1 || tagType == 3) {
            return new MinoltaCameraSettingsWriter((MinoltaCameraSettingsDirectory)directory);
        }
        return super.getDirectoryWriter(tagType, directory, startOffset);
    }

    public int getComponentCount() {
        return this.getDirectoryLength();
    }
}

