/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.nikon;

import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.TagDescriptor;
import au.com.lastweekend.jim.util.Rational;

public class NikonType3MakernoteDescriptor
extends TagDescriptor {
    public NikonType3MakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
        }
        return this.getDirectory().getString(tagType);
    }

    public String getLensDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(132)) {
            return null;
        }
        Rational[] lensValues = this.getDirectory().getRationalArray(132);
        if (lensValues.length != 4) {
            return this.getDirectory().getString(132);
        }
        StringBuffer description = new StringBuffer();
        description.append(lensValues[0].intValue());
        description.append('-');
        description.append(lensValues[1].intValue());
        description.append("mm f/");
        description.append(lensValues[2].floatValue());
        description.append('-');
        description.append(lensValues[3].floatValue());
        return description.toString();
    }

    public String getHueAdjustmentDescription() {
        if (!this.getDirectory().containsTag(146)) {
            return null;
        }
        return this.getDirectory().getString(146) + " degrees";
    }

    public String getColorModeDescription() {
        if (!this.getDirectory().containsTag(141)) {
            return null;
        }
        String raw = this.getDirectory().getString(141);
        if (raw.startsWith("MODE1")) {
            return "Mode I (sRGB)";
        }
        return raw;
    }
}

