/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import java.io.IOException;
import java.io.InputStream;

public class JpegBitBuffer {
    private InputStream _input;
    private int _readCounter = 0;
    private int _currentByte = 0;
    private int _bitsAvailable;

    public JpegBitBuffer(InputStream input) {
        this._input = input;
    }

    public int getBits(int bitsToFetch) throws JpegProcessingException {
        while (bitsToFetch > this._bitsAvailable) {
            this._currentByte = (this._currentByte << 8) + this.getNextByte();
            this._bitsAvailable += 8;
        }
        this._bitsAvailable -= bitsToFetch;
        int result = this._currentByte >> this._bitsAvailable;
        this._currentByte &= ~(-1 << this._bitsAvailable);
        return result;
    }

    private int getNextByte() throws JpegProcessingException {
        try {
            byte stuffer;
            int readByte = this._input.read();
            if (readByte == 255 && (stuffer = (byte)this._input.read()) != 0) {
                throw new JpegProcessingException("Expected zero byte after 0xFF marker, got" + Integer.toHexString(stuffer));
            }
            return readByte;
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
    }
}

