/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.util.LoggingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JpegBitOutput {
    private static final byte MARKER = -1;
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$JpegBitOutput == null ? (class$au$com$lastweekend$jim$io$jpeg$JpegBitOutput = JpegBitOutput.class$("au.com.lastweekend.jim.io.jpeg.JpegBitOutput")) : class$au$com$lastweekend$jim$io$jpeg$JpegBitOutput));
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private OutputStream _output;
    private int _currentByte;
    private int _bitCount;
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$JpegBitOutput;

    public JpegBitOutput(OutputStream output) {
        this._output = output;
    }

    public void writeBits(int size, int value) throws JpegProcessingException {
        this._currentByte = this._currentByte << size | (value &= ~(-1 << size));
        this._bitCount += size;
        try {
            while (this._bitCount >= 8) {
                int byteToWrite = this._currentByte >> this._bitCount - 8;
                this._output.write(byteToWrite);
                if ((byteToWrite & 0xFF) == 255) {
                    this._output.write(0);
                }
                this._bitCount -= 8;
            }
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
        this._currentByte &= ~(-1 << this._bitCount);
    }

    public void alignBytes() throws JpegProcessingException {
        if (this._bitCount != 0) {
            this.writeBits(8 - this._bitCount, 255);
        }
    }

    public boolean isDebugEnabled() {
        return DEBUG_ENABLED;
    }

    public void debug(String message) {
        if (LOG.isDebugEnabled()) {
            if (this._output instanceof LoggingOutputStream) {
                LoggingOutputStream los = (LoggingOutputStream)this._output;
                message = message + " at byte " + los.getStreamPosition() + "[" + this._bitCount + "]";
            }
            LOG.debug((Object)message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

