/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

public final class JpegSegment {
    private byte _identifier;
    private int _size;
    private byte[] _data;
    public static final byte SEGMENT_BOUNDARY = -1;
    public static final byte SEGMENT_APP0 = -32;
    public static final byte SEGMENT_APP1 = -31;
    public static final byte SEGMENT_APP2 = -30;
    public static final byte SEGMENT_APP3 = -29;
    public static final byte SEGMENT_APP4 = -28;
    public static final byte SEGMENT_APP5 = -27;
    public static final byte SEGMENT_APP6 = -26;
    public static final byte SEGMENT_APP7 = -25;
    public static final byte SEGMENT_APP8 = -24;
    public static final byte SEGMENT_APP9 = -23;
    public static final byte SEGMENT_APPA = -22;
    public static final byte SEGMENT_APPB = -21;
    public static final byte SEGMENT_APPC = -20;
    public static final byte SEGMENT_APPD = -19;
    public static final byte SEGMENT_APPE = -18;
    public static final byte SEGMENT_APPF = -17;
    public static final byte SEGMENT_SOI = -40;
    public static final byte SEGMENT_DQT = -37;
    public static final byte SEGMENT_DHT = -60;
    public static final byte SEGMENT_DRI = -35;
    public static final byte SEGMENT_SOF0 = -64;
    public static final byte SEGMENT_SOF1 = -63;
    public static final byte SEGMENT_COM = -2;
    public static final byte MARKER_EOI = -39;
    public static final byte SEGMENT_SOS = -38;
    public static final String EXIF_IDENTIFIER = "Exif\u0000\u0000";
    public static final byte RESTARTS_END = -41;
    public static final byte RESTARTS_BEGIN = -48;

    public JpegSegment(byte identifier, int length, byte[] data) {
        this._identifier = identifier;
        this._size = length;
        this._data = data;
    }

    public byte[] getData() {
        return this._data;
    }

    public byte getIdentifier() {
        return this._identifier;
    }

    public int getSize() {
        return this._size;
    }

    public int getInputStreamLength() {
        return 4 + this._size;
    }

    public boolean isStartOfScan() {
        return this.getIdentifier() == -38;
    }

    public byte getLow4Bits(int offset) {
        return (byte)(this._data[offset] & 0xF);
    }

    public byte getHigh4Bits(int offset) {
        return (byte)(this._data[offset] >> 4 & 0xF);
    }

    public byte get8Bits(int offset) {
        return (byte)(this._data[offset] & 0xFF);
    }

    public int get16Bits(int offset) {
        return this._data[offset] << 8 & 0xFF00 | this._data[offset + 1] & 0xFF;
    }
}

