/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegSegment;
import au.com.lastweekend.jim.io.jpeg.RawJpegSegmentDirectory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import java.util.HashMap;

public class JpegStartOfFrameDirectory
extends RawJpegSegmentDirectory {
    public static final int TAG_FRAME_PRECISION = 1;
    public static final int TAG_FRAME_WIDTH = 2;
    public static final int TAG_FRAME_HEIGHT = 3;
    public static final int TAG_FRAME_COMPONENTS = 4;
    public static final int TAG_COMPONENT_IDS = 5;
    public static final int TAG_VERTICAL_SAMPLING_FACTORS = 6;
    public static final int TAG_HORIZONTAL_SAMPLING_FACTORS = 7;
    public static final int TAG_QUANTISATION_TABLES = 8;
    private static final HashMap TAG_NAME_MAP = new HashMap();

    protected HashMap getTagNameMap() {
        return TAG_NAME_MAP;
    }

    public JpegStartOfFrameDirectory(JpegSegment segment) {
        super(segment);
    }

    public String getName() {
        return "Jpeg Start of Frame";
    }

    public byte getNumberOfComponents() {
        return (Byte)this.getObject(4);
    }

    public byte getComponentID(int i) {
        return this.getByteArrayValue(5, i);
    }

    public byte getHorizontalSamplingFactor(int i) {
        return this.getByteArrayValue(7, i);
    }

    public byte getVerticalSamplingFactor(int i) {
        return this.getByteArrayValue(6, i);
    }

    public int getFrameWidth() throws JpegProcessingException {
        try {
            return this.getInt(2);
        }
        catch (MetadataException e) {
            throw new JpegProcessingException(e);
        }
    }

    public int getFrameHeight() throws JpegProcessingException {
        try {
            return this.getInt(3);
        }
        catch (MetadataException e) {
            throw new JpegProcessingException(e);
        }
    }

    public byte getFramePrecisison() throws JpegProcessingException {
        try {
            return (byte)this.getInt(1);
        }
        catch (MetadataException e) {
            throw new JpegProcessingException(e);
        }
    }

    public byte getQuantisationTable(int i) {
        return this.getByteArrayValue(8, i);
    }

    static {
        TAG_NAME_MAP.put(new Integer(1), "Frame Precision");
        TAG_NAME_MAP.put(new Integer(2), "Frame Width");
        TAG_NAME_MAP.put(new Integer(3), "Frame Height");
        TAG_NAME_MAP.put(new Integer(4), "Number of Components");
        TAG_NAME_MAP.put(new Integer(5), "Component IDs");
        TAG_NAME_MAP.put(new Integer(6), "Vertical Sampling Factors");
        TAG_NAME_MAP.put(new Integer(7), "Horizontal Sampling Factors");
        TAG_NAME_MAP.put(new Integer(8), "Quantisation table id");
    }
}

