/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.HuffmanTable;
import au.com.lastweekend.jim.io.jpeg.JpegBitBuffer;
import au.com.lastweekend.jim.io.jpeg.JpegBitOutput;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.ScanComponent;
import au.com.lastweekend.jim.io.jpeg.write.JpegTransform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Scan {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$Scan == null ? (class$au$com$lastweekend$jim$io$jpeg$Scan = Scan.class$("au.com.lastweekend.jim.io.jpeg.Scan")) : class$au$com$lastweekend$jim$io$jpeg$Scan));
    private static final int MAX_COMPONENTS = 4;
    private static final int MAX_DECODERS = 4;
    private HuffmanTable[] _huffmanACDecoders = new HuffmanTable[4];
    private HuffmanTable[] _huffmanDCDecoders = new HuffmanTable[4];
    private ScanComponent[] _scanComponents = new ScanComponent[4];
    private int _width;
    private int _height;
    private int _maxHorizontalSamplingFactor;
    private int _maxVerticalSamplingFactor;
    private int _mcuRows;
    private int _mcuColumns;
    private int _restartInterval = -1;
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$Scan;

    public void setHuffmanDecoder(boolean isACTable, byte tableIndex, HuffmanTable decoder) {
        byte index = tableIndex;
        if (isACTable) {
            this._huffmanACDecoders[index] = decoder;
        } else {
            this._huffmanDCDecoders[index] = decoder;
        }
    }

    public void createComponent(byte componentID, byte horizontalSamplingFactor, byte verticalSamplingFactor) {
        ScanComponent comp;
        this._scanComponents[comp.getComponentID()] = comp = new ScanComponent(this, componentID, horizontalSamplingFactor, verticalSamplingFactor);
    }

    public void setComponentDecoders(byte componentID, byte dcDecoderIndex, byte acDecoderIndex) {
        byte componentIndex = componentID;
        ScanComponent scanComponent = this._scanComponents[componentIndex];
        scanComponent.setDCDecoder(this._huffmanDCDecoders[dcDecoderIndex]);
        scanComponent.setACDecoder(this._huffmanACDecoders[acDecoderIndex]);
    }

    public void read(InputStream inStream) throws JpegProcessingException {
        this.initialiseScan();
        JpegBitBuffer bitBuffer = new JpegBitBuffer(inStream);
        int mcusToRestart = this._restartInterval;
        for (int mcuY = 0; mcuY < this._mcuRows; ++mcuY) {
            for (int mcuX = 0; mcuX < this._mcuColumns; ++mcuX) {
                if (mcusToRestart == 0) {
                    this.restartDecoder(inStream);
                    bitBuffer = new JpegBitBuffer(inStream);
                    mcusToRestart = this._restartInterval;
                }
                this.decodeMCU(mcuX, mcuY, bitBuffer);
                --mcusToRestart;
            }
        }
    }

    private void restartDecoder(InputStream inStream) throws JpegProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Processing Restart marker");
        }
        try {
            byte markerBoundary = (byte)inStream.read();
            byte restartMarker = (byte)inStream.read();
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
        for (int c = 0; c < 4; ++c) {
            ScanComponent scanComponent = this._scanComponents[c];
            if (scanComponent == null) continue;
            scanComponent.restartDecoder();
        }
    }

    private void decodeMCU(int mcuX, int mcuY, JpegBitBuffer bitBuffer) throws JpegProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading MCU x=" + mcuX + " y=" + mcuY));
        }
        for (int c = 0; c < 4; ++c) {
            ScanComponent scanComponent = this._scanComponents[c];
            if (scanComponent == null) continue;
            scanComponent.readMCU(mcuX, mcuY, bitBuffer);
        }
    }

    private void initialiseScan() {
        ScanComponent scanComponent;
        this._maxHorizontalSamplingFactor = 0;
        this._maxVerticalSamplingFactor = 0;
        for (int i = 0; i < 4; ++i) {
            scanComponent = this._scanComponents[i];
            if (scanComponent == null) continue;
            this._maxHorizontalSamplingFactor = Math.max(this._maxHorizontalSamplingFactor, scanComponent.getHorizontalSamplingFactor());
            this._maxVerticalSamplingFactor = Math.max(this._maxVerticalSamplingFactor, scanComponent.getVerticalSamplingFactor());
        }
        this._mcuRows = this.divCeil(this.divCeil(this._height, this._maxVerticalSamplingFactor), 8);
        this._mcuColumns = this.divCeil(this.divCeil(this._width, this._maxHorizontalSamplingFactor), 8);
        LOG.debug((Object)("mcuRows=" + this._mcuRows + " mcuColumns=" + this._mcuColumns));
        for (int c = 0; c < 4; ++c) {
            scanComponent = this._scanComponents[c];
            if (scanComponent == null) continue;
            scanComponent.initialiseScan(this._mcuColumns, this._mcuRows);
        }
    }

    private int divCeil(int dividend, int divisor) {
        int result = dividend / divisor;
        if (dividend % divisor != 0) {
            ++result;
        }
        return result;
    }

    public void setHeight(int frameHeight) {
        this._height = frameHeight;
    }

    public void setWidth(int frameWidth) {
        this._width = frameWidth;
    }

    public void writeTransform(JpegTransform transform, OutputStream outStream) throws JpegProcessingException {
        JpegBitOutput bitOutput = new JpegBitOutput(outStream);
        this.initialiseTransform(transform);
        JpegTransform.Coordinate transformedDimensions = transform.transform(this.getMCUColumns(), this.getMCURows());
        int mcuRows = transformedDimensions.getHeight();
        int mcuColumns = transformedDimensions.getWidth();
        int mcusToRestart = this._restartInterval;
        int restarts = 0;
        for (int mcuY = 0; mcuY < mcuRows; ++mcuY) {
            for (int mcuX = 0; mcuX < mcuColumns; ++mcuX) {
                if (mcusToRestart == 0) {
                    bitOutput.alignBytes();
                    this.restartEncoder(outStream, restarts++);
                    mcusToRestart = this._restartInterval;
                }
                if (bitOutput.isDebugEnabled()) {
                    bitOutput.debug("Writing MCU x=" + mcuX + " y=" + mcuY);
                }
                for (int c = 0; c < 4; ++c) {
                    ScanComponent scanComponent = this._scanComponents[c];
                    if (scanComponent == null) continue;
                    scanComponent.writeMCU(mcuX, mcuY, bitOutput);
                }
                --mcusToRestart;
            }
        }
        bitOutput.alignBytes();
    }

    private void restartEncoder(OutputStream outStream, int restarts) throws JpegProcessingException {
        try {
            outStream.write(-1);
            outStream.write(-48 + restarts % 8);
            for (int c = 0; c < 4; ++c) {
                ScanComponent scanComponent = this._scanComponents[c];
                if (scanComponent == null) continue;
                scanComponent.restartEncoder();
            }
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
    }

    private void writeRestartMarker(OutputStream outStream) {
    }

    private void initialiseTransform(JpegTransform transform) {
        for (int c = 0; c < 4; ++c) {
            ScanComponent scanComponent = this._scanComponents[c];
            if (scanComponent == null) continue;
            scanComponent.initialiseTransform(transform);
        }
    }

    public int getMCURows() {
        return this._mcuRows;
    }

    public int getMCUColumns() {
        return this._mcuColumns;
    }

    public void setRestartInterval(int restartInterval) {
        this._restartInterval = restartInterval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

