/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.DCTBlock;
import au.com.lastweekend.jim.io.jpeg.HuffmanTable;
import au.com.lastweekend.jim.io.jpeg.JpegBitBuffer;
import au.com.lastweekend.jim.io.jpeg.JpegBitOutput;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.RunLengthEncodedDCTBlock;
import au.com.lastweekend.jim.io.jpeg.Scan;
import au.com.lastweekend.jim.io.jpeg.write.JpegTransform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScanComponent {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$ScanComponent == null ? (class$au$com$lastweekend$jim$io$jpeg$ScanComponent = ScanComponent.class$("au.com.lastweekend.jim.io.jpeg.ScanComponent")) : class$au$com$lastweekend$jim$io$jpeg$ScanComponent));
    private Scan _scan;
    private byte _componentID;
    private int _horizontalSamplingFactor;
    private int _verticalSamplingFactor;
    private HuffmanTable _acHuffmanTable;
    private HuffmanTable _dcHuffmanTable;
    private int _dcPredictor = 0;
    private DCTBlock[][] _coefficients;
    private JpegTransform _transform;
    private short[] _workingValues = new short[63];
    private byte[] _workingIndexes = new byte[63];
    private int[][] _workingDCTMatrix = new int[8][8];
    private JpegTransform.Coordinate _transformedSamplingFactors;
    private JpegTransform.Coordinate _transformedSampleDimensions;
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$ScanComponent;

    public ScanComponent(Scan scan, byte componentID, int horizontalSamplingFactor, int verticalSamplingFactor) {
        this._scan = scan;
        this._componentID = componentID;
        this._horizontalSamplingFactor = horizontalSamplingFactor;
        this._verticalSamplingFactor = verticalSamplingFactor;
    }

    public byte getComponentID() {
        return this._componentID;
    }

    public void setDCDecoder(HuffmanTable decoder) {
        this._dcHuffmanTable = decoder;
    }

    public void setACDecoder(HuffmanTable decoder) {
        this._acHuffmanTable = decoder;
    }

    public int getHorizontalSamplingFactor() {
        return this._horizontalSamplingFactor;
    }

    public int getVerticalSamplingFactor() {
        return this._verticalSamplingFactor;
    }

    public void readMCU(int mcuX, int mcuY, JpegBitBuffer bitBuffer) throws JpegProcessingException {
        for (int v = 0; v < this._verticalSamplingFactor; ++v) {
            int y = mcuY * this._verticalSamplingFactor + v;
            for (int h = 0; h < this._horizontalSamplingFactor; ++h) {
                int x = mcuX * this._horizontalSamplingFactor + h;
                this.readBlockCoefficients(x, y, bitBuffer);
            }
        }
    }

    private void readBlockCoefficients(int x, int y, JpegBitBuffer bitBuffer) throws JpegProcessingException {
        RunLengthEncodedDCTBlock coefficients = new RunLengthEncodedDCTBlock();
        ((DCTBlock)coefficients).readCoefficients(this, bitBuffer);
        this._coefficients[x][y] = coefficients;
        this._dcPredictor = ((DCTBlock)coefficients).getDCCoefficient();
    }

    public void initialiseScan(int mcuColumns, int mcuRows) {
        int horizontalSampleBlocks = mcuColumns * this._horizontalSamplingFactor;
        int verticalSampleBlocks = mcuRows * this._verticalSamplingFactor;
        this._coefficients = new DCTBlock[horizontalSampleBlocks][verticalSampleBlocks];
        this._dcPredictor = 0;
    }

    public void restartDecoder() {
        this._dcPredictor = 0;
    }

    public void writeMCU(int mcuX, int mcuY, JpegBitOutput bitOutput) throws JpegProcessingException {
        for (int v = 0; v < this._transformedSamplingFactors.getHeight(); ++v) {
            int y = mcuY * this._transformedSamplingFactors.getHeight() + v;
            for (int h = 0; h < this._transformedSamplingFactors.getWidth(); ++h) {
                int x = mcuX * this._transformedSamplingFactors.getWidth() + h;
                this.writeBlockCoefficients(x, y, bitOutput);
            }
        }
    }

    private void writeBlockCoefficients(int x, int y, JpegBitOutput bitOutput) throws JpegProcessingException {
        JpegTransform.Coordinate blockLocation = this._transform.reverseTransform(x, y, this._transformedSampleDimensions.getWidth(), this._transformedSampleDimensions.getHeight());
        DCTBlock sampleBlock = this.getBlockCoefficients(blockLocation.getX(), blockLocation.getY());
        DCTBlock newBlock = this._transform.transformBlock(this, sampleBlock);
        newBlock.writeCoefficients(this, bitOutput);
        this._dcPredictor = newBlock.getDCCoefficient();
    }

    public void initialiseTransform(JpegTransform transform) {
        this._dcPredictor = 0;
        this._transform = transform;
        this._transformedSamplingFactors = this._transform.transform(this._horizontalSamplingFactor, this._verticalSamplingFactor);
        this._transformedSampleDimensions = this._transform.transform(this._coefficients.length, this._coefficients[0].length);
    }

    public void restartEncoder() {
        this._dcPredictor = 0;
    }

    public HuffmanTable getDCHuffmanTable() {
        return this._dcHuffmanTable;
    }

    public int getDCPredictor() {
        return this._dcPredictor;
    }

    public byte[] getWorkingIndexes() {
        return this._workingIndexes;
    }

    public short[] getWorkingValues() {
        return this._workingValues;
    }

    public HuffmanTable getACHuffmanTable() {
        return this._acHuffmanTable;
    }

    public DCTBlock getBlockCoefficients(int x, int y) {
        return this._coefficients[x][y];
    }

    public int[][] getWorkingDCTMatrix() {
        return this._workingDCTMatrix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

