/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.write;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegSegment;
import au.com.lastweekend.jim.io.jpeg.RawJpegSegmentDirectory;
import au.com.lastweekend.jim.io.jpeg.write.AbstractSegmentDirectoryWriter;
import au.com.lastweekend.jim.io.metadata.Directory;
import java.io.IOException;
import java.io.OutputStream;

public class RawSegmentDirectoryWriter
extends AbstractSegmentDirectoryWriter {
    public void writeDirectory(Directory directory, OutputStream output) throws JpegProcessingException {
        if (directory instanceof RawJpegSegmentDirectory) {
            RawJpegSegmentDirectory rawDirectory = (RawJpegSegmentDirectory)directory;
            try {
                this.writeSegment(rawDirectory.getSegment(), output);
            }
            catch (IOException e) {
                throw new JpegProcessingException(e);
            }
        }
    }

    private void writeSegment(JpegSegment segment, OutputStream output) throws IOException {
        if (segment != null) {
            byte[] data = segment.getData();
            int dataLength = data.length + 2;
            this.writeHeader(segment.getIdentifier(), dataLength, output);
            output.write(data);
        }
    }
}

