/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileOps {
    private static final int MOVE = 1;
    private static final int COPY = 2;
    public static final FileOps INSTANCE = new FileOps();
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$util$FileOps == null ? (class$au$com$lastweekend$jim$util$FileOps = FileOps.class$("au.com.lastweekend.jim.util.FileOps")) : class$au$com$lastweekend$jim$util$FileOps));
    private File _trashDir = new File(System.getProperty("java.io.tmpdir"));
    static /* synthetic */ Class class$au$com$lastweekend$jim$util$FileOps;

    public void copy(File from, File to) throws IOException {
        if (to.isDirectory()) {
            this.doCopy(from, new File(to, from.getName()));
        } else {
            this.doCopy(from, to);
        }
    }

    private void doCopy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            this.copy(from.listFiles(), to);
        } else {
            FileChannel sourceChannel = new FileInputStream(from).getChannel();
            FileChannel destinationChannel = new FileOutputStream(to).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
            sourceChannel.close();
            destinationChannel.close();
        }
    }

    public void move(File from, File to) throws IOException {
        if (to.isDirectory()) {
            this.doMove(from, new File(to, from.getName()));
        } else {
            this.doMove(from, to);
        }
    }

    private void doMove(File from, File to) throws IOException {
        if (from.exists() && to.exists() && !to.isDirectory()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting " + to + " to allow renameTo"));
            }
            to.delete();
        }
        if (!from.renameTo(to)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unable to use rename to move " + from.getAbsolutePath() + " to " + to.getAbsolutePath()));
            }
            this.doCopy(from, to);
            if (from.isDirectory()) {
                this.deleteDirectory(from);
            } else if (!from.delete()) {
                throw new IOException("Unable to delete " + from);
            }
        }
    }

    public void move(File[] fileList, File toDir) throws IOException {
        this.processFiles(fileList, toDir, 1);
    }

    public void copy(File[] fileList, File toDir) throws IOException {
        this.processFiles(fileList, toDir, 2);
    }

    public void move(List fileList, File toDir) throws IOException {
        this.move(this.collectionToFileArray(fileList), toDir);
    }

    public void copy(List fileList, File toDir) throws IOException {
        this.copy(this.collectionToFileArray(fileList), toDir);
    }

    private void processFiles(File[] fileList, File toDir, int action) throws IOException {
        if (!toDir.exists()) {
            toDir.mkdir();
        }
        if (!toDir.isDirectory()) {
            throw new IOException(toDir + " is not a directory");
        }
        for (int i = 0; i < fileList.length; ++i) {
            File fileFrom = fileList[i];
            File fileTo = new File(toDir, fileFrom.getName());
            if (action == 1) {
                this.move(fileFrom, fileTo);
                continue;
            }
            this.doCopy(fileFrom, fileTo);
        }
    }

    public void deleteDirectory(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(dir + "is not a directory");
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        dir.delete();
    }

    private File[] collectionToFileArray(Collection fileCollection) {
        File[] files = new File[fileCollection.size()];
        int i = 0;
        Iterator iter = fileCollection.iterator();
        while (iter.hasNext()) {
            File element;
            files[i] = element = (File)iter.next();
            ++i;
        }
        return files;
    }

    public File[] find(File huntDirectory, FileFilter filter) {
        HashSet c = new HashSet();
        this.doFind(c, huntDirectory, filter);
        File[] files = new File[c.size()];
        return this.collectionToFileArray(c);
    }

    private void doFind(Collection c, File huntDirectory, FileFilter filter) {
        File[] files = huntDirectory.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File theFile = files[i];
            if (theFile.isDirectory()) {
                this.doFind(c, theFile, filter);
                continue;
            }
            c.add(theFile);
        }
    }

    public void moveToTrash(File file) throws IOException {
        File trashFile = new File(this._trashDir, file.getName());
        while (trashFile.exists()) {
            trashFile = new File(this._trashDir, file.getName() + "." + Math.random() * 1000.0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting to trash by Moving " + file + " to " + trashFile));
        }
        this.move(file, trashFile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

