/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;

public class LoggingOutputStream
extends OutputStream {
    private Stack _offsetStack = new Stack();
    private long _writeCount = 0L;
    private OutputStream _impl;

    public LoggingOutputStream(OutputStream impl) {
        this._impl = impl;
    }

    public void write(int b) throws IOException {
        ++this._writeCount;
        this._impl.write(b);
    }

    public String getStreamPosition() {
        return this._writeCount + this._offsetStack.toString();
    }

    public void pushOffset() {
        this._offsetStack.push(new Long(this._writeCount));
        this._writeCount = 0L;
    }

    public void popOffset() {
        this._writeCount += ((Long)this._offsetStack.pop()).longValue();
    }

    public void close() throws IOException {
        this._impl.close();
        super.close();
    }

    public void flush() throws IOException {
        this._impl.flush();
        super.flush();
    }
}

