/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.util;

import java.io.Serializable;

public class Rational
extends Number
implements Serializable {
    private final int _numerator;
    private final int _denominator;
    private int _maxSimplificationCalculations = 1000;

    public Rational(int numerator, int denominator) {
        this._numerator = numerator;
        this._denominator = denominator;
    }

    public double doubleValue() {
        return (double)this._numerator / (double)this._denominator;
    }

    public float floatValue() {
        return (float)this._numerator / (float)this._denominator;
    }

    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    public final int intValue() {
        return (int)this.doubleValue();
    }

    public final long longValue() {
        return (long)this.doubleValue();
    }

    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final int getDenominator() {
        return this._denominator;
    }

    public final int getNumerator() {
        return this._numerator;
    }

    public Rational getReciprocal() {
        return new Rational(this._denominator, this._numerator);
    }

    public boolean isInteger() {
        return this._denominator == 1 || this._denominator != 0 && this._numerator % this._denominator == 0 || this._denominator == 0 && this._numerator == 0;
    }

    public String toString() {
        return this._numerator + "/" + this._denominator;
    }

    public String toSimpleString(boolean allowDecimal) {
        String doubleString;
        if (this._denominator == 0 && this._numerator != 0) {
            return this.toString();
        }
        if (this.isInteger()) {
            return Integer.toString(this.intValue());
        }
        if (this._numerator != 1 && this._denominator % this._numerator == 0) {
            int newDenominator = this._denominator / this._numerator;
            return new Rational(1, newDenominator).toSimpleString(allowDecimal);
        }
        Rational simplifiedInstance = this.getSimplifiedInstance();
        if (allowDecimal && (doubleString = Double.toString(simplifiedInstance.doubleValue())).length() < 5) {
            return doubleString;
        }
        return simplifiedInstance.toString();
    }

    private boolean tooComplexForSimplification() {
        double maxPossibleCalculations = (double)(Math.min(this._denominator, this._numerator) - 1) / 5.0 + 2.0;
        return maxPossibleCalculations > (double)this._maxSimplificationCalculations;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rational)) {
            return false;
        }
        Rational that = (Rational)obj;
        return this.doubleValue() == that.doubleValue();
    }

    public Rational getSimplifiedInstance() {
        if (this.tooComplexForSimplification()) {
            return this;
        }
        for (int factor = 2; factor <= Math.min(this._denominator, this._numerator); ++factor) {
            if (factor % 2 == 0 && factor > 2 || factor % 5 == 0 && factor > 5 || this._denominator % factor != 0 || this._numerator % factor != 0) continue;
            return new Rational(this._numerator / factor, this._denominator / factor);
        }
        return this;
    }

    public int hashCode() {
        return new Double(this.doubleValue()).hashCode();
    }
}

