/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.ui.Task;
import org.scohen.juploadr.uploadapi.flickrrest.Messages;
import org.scohen.juploadr.uploadapi.flickrrest.RestFlickrApi;
import org.scohen.juploadr.uploadapi.flickrrest.photosets.AddPhoto;

public class AddToPhotosetTask
extends Task {
    private Collection sets;
    private RestFlickrApi api;
    private int numberOfSets;
    private boolean hasSetsToAdd;
    private String currentPhoto;
    private String currentSet;
    private int current = 0;

    public AddToPhotosetTask(Collection photoSets, RestFlickrApi api) {
        this.sets = photoSets;
        this.api = api;
        this.min = 0;
        this.max = this.getTotalNumberOfPhotosToAdd(photoSets);
        this.hasSetsToAdd = this.max != 0;
    }

    public String getTitle() {
        Object[] args = new Object[]{new Integer(this.max)};
        return Messages.getString("juploadr.flickrrest.task.addtophotoset.title", args);
    }

    public void execute() {
        for (PhotoSet set : this.sets) {
            this.currentSet = set.getTitle();
            List photos = set.getPhotos();
            for (ImageAttributes thumb : photos) {
                AddPhoto add;
                this.currentPhoto = thumb.getTitle();
                this.updateProgress(++this.current);
                if (thumb.getPhotoId() != null && !thumb.getPhotoId().equals(set.getPrimaryPhotoId()) && !this.api.executeMethod(add = new AddPhoto(set, (UploadImage)thumb))) continue;
            }
        }
    }

    private int getTotalNumberOfPhotosToAdd(Collection sets) {
        Iterator iter = sets.iterator();
        int count = 0;
        while (iter.hasNext()) {
            PhotoSet set = (PhotoSet)iter.next();
            if (set.getPhotos().size() <= 0) continue;
            ++this.numberOfSets;
            count += set.getPhotos().size();
        }
        return count;
    }

    public String getMessage() {
        Object[] arguments = new Object[]{new Integer(this.max - this.current + 1), new Integer(this.numberOfSets), this.currentPhoto, this.currentSet};
        return Messages.getString("juploadr.flickrrest.task.addtophotoset.dialog", arguments);
    }

    public boolean hasSetsToAdd() {
        return this.hasSetsToAdd;
    }
}

