/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.eclipse.swt.widgets.Decorations;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.event.UploadCompleteEvent;
import org.scohen.juploadr.event.UploadStatusMonitor;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.PopupHandler;
import org.scohen.juploadr.ui.ProgressDialog;
import org.scohen.juploadr.ui.Task;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.UploadFailedException;
import org.scohen.juploadr.uploadapi.flickrrest.AddToPhotosetTask;
import org.scohen.juploadr.uploadapi.flickrrest.CreateAllPhotosetsTask;
import org.scohen.juploadr.uploadapi.flickrrest.FlickrMethod;
import org.scohen.juploadr.uploadapi.flickrrest.Messages;
import org.scohen.juploadr.uploadapi.flickrrest.PostUploadAction;
import org.scohen.juploadr.uploadapi.flickrrest.RotateTask;
import org.scohen.juploadr.uploadapi.flickrrest.authentication.FlickrAccount;
import org.scohen.juploadr.uploadapi.flickrrest.authentication.FlickrAuthEventDirector;
import org.scohen.juploadr.uploadapi.flickrrest.photosets.GetPhotosetList;
import org.scohen.juploadr.uploadapi.flickrrest.tags.GetListUser;
import org.scohen.juploadr.uploadapi.flickrrest.ui.FlickrForm;
import org.scohen.juploadr.uploadapi.flickrrest.ui.JUploadrPopupHandler;
import org.scohen.juploadr.uploadapi.flickrrest.ui.MetadataForm;
import org.scohen.juploadr.uploadapi.flickrrest.upload.FlickrUpload;
import org.scohen.juploadr.util.NonNullList;

public class RestFlickrApi
extends ImageUploadApi {
    public static final String FLICKR_SHARED_SECRET = "e45cca24a72f6eb9";
    public static final String FLICKR_API_KEY = "1892f5f9d32f01b86f53b50cdac89c8c";
    public Configuration config;
    private Class[] configClasses = new Class[]{FlickrForm.class, MetadataForm.class};
    private static NonNullList photoSets = new NonNullList();
    private static Map unfinishedActions = new HashMap();
    private static Account currentAccount;
    private static final String DEFAULT_ACCOUNT_KEY;
    private static Preferences prefs;
    private static final ImageUploadApi instance;

    public RestFlickrApi() {
        this.config = Configuration.getInstance();
    }

    public static synchronized ImageUploadApi getInstance() {
        return instance;
    }

    public String getSiteName() {
        return "Flickr";
    }

    public void upload(UploadImage imageAttributes, UploadStatusMonitor monitor) throws UploadFailedException, CommunicationException {
        if (!this.isCurrentAccountAuthenticated()) {
            try {
                this.authenticate(this.getCurrentAccount());
            }
            catch (ProtocolException e) {
                throw new UploadFailedException(e.getMessage(), (Throwable)e);
            }
        }
        FlickrUpload flickrUpload = new FlickrUpload(imageAttributes, monitor);
        try {
            flickrUpload.execute();
        }
        catch (ProtocolException e) {
            throw new UploadFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public Account getCurrentAccount() {
        if (currentAccount == null) {
            Map accounts = FlickrAccount.allAccounts();
            if (currentAccount == null) {
                currentAccount = FlickrAccount.getNullAccount();
            }
            if (accounts.size() > 0 && accounts.get(prefs.get(DEFAULT_ACCOUNT_KEY, "")) != null) {
                currentAccount = (Account)accounts.get(prefs.get(DEFAULT_ACCOUNT_KEY, ""));
            }
        }
        return currentAccount;
    }

    public Account newAccount(String name) {
        return new FlickrAccount(name);
    }

    public void setCurrentAccount(Account account) {
        if (account != null && !(account instanceof FlickrAccount)) {
            Object[] args = new Object[]{account.getClass().getName(), FlickrAccount.class.getName()};
            throw new IllegalArgumentException(Messages.getString("uploadapi.flickr.incorrect.account.type", args));
        }
        currentAccount = account;
        if (currentAccount.getUsername() != null) {
            prefs.put(DEFAULT_ACCOUNT_KEY, currentAccount.getUsername());
        }
    }

    public List allAccounts() {
        return new LinkedList(FlickrAccount.allAccounts().values());
    }

    public boolean isCurrentAccountNullAccount() {
        return this.getCurrentAccount().equals((Object)FlickrAccount.getNullAccount());
    }

    public boolean authenticate(Account account) throws ProtocolException, CommunicationException {
        FlickrAuthEventDirector eventDirector = new FlickrAuthEventDirector();
        return eventDirector.execute((FlickrAccount)account);
    }

    public void initialize() {
        if (this.isCurrentAccountAuthenticated()) {
            Thread getPhotoSets = new Thread(){

                public void run() {
                    GetPhotosetList getPhotoSets = new GetPhotosetList();
                    try {
                        getPhotoSets.execute();
                    }
                    catch (ProtocolException e) {
                        e.printStackTrace();
                    }
                    catch (CommunicationException e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread getTags = new Thread(){

                public void run() {
                    Account account = ImageUploadApi.getInstance().getCurrentAccount();
                    GetListUser getTags = new GetListUser();
                    try {
                        getTags.execute();
                        account.setUserTags(getTags.getTags());
                        account.save();
                    }
                    catch (ProtocolException e) {
                        e.printStackTrace();
                    }
                    catch (CommunicationException e) {
                        e.printStackTrace();
                    }
                }
            };
            getPhotoSets.start();
            getTags.start();
        }
    }

    public Class[] getConfiurationDialogs() {
        return this.configClasses;
    }

    public PopupHandler windowRightClicked(Decorations parent, JUploadr clicked) {
        return new JUploadrPopupHandler(parent, clicked, (List)photoSets);
    }

    public PopupHandler thumbnailRightClicked(Decorations parent, JUploadr uploadr, ImageAttributes clicked) {
        if (!clicked.isSelected()) {
            Collection allAttributes = uploadr.getImageAttributes().values();
            for (ImageAttributes atts : allAttributes) {
                atts.setSelected(atts.equals(clicked));
            }
        }
        uploadr.refresh();
        return new JUploadrPopupHandler(parent, uploadr, (List)photoSets);
    }

    public static void setPhotoSets(List sets) {
        photoSets = sets instanceof NonNullList ? (NonNullList)sets : new NonNullList(sets);
    }

    public static void addPhotoSet(PhotoSet set) {
        photoSets.add((Object)set);
        Collections.sort(photoSets);
    }

    public void postProcessUpload(UploadCompleteEvent e, ImageAttributes atts) {
        atts.setPhotoId(e.getResponse().getPhotoId());
    }

    public void postProcessAllUploads(Collection images) {
        AddToPhotosetTask addTask;
        ProgressDialog pd;
        CreateAllPhotosetsTask createTask = new CreateAllPhotosetsTask((Collection)photoSets, this);
        if (createTask.hasSetsToCreate()) {
            pd = new ProgressDialog(JUploadr.window, (Task)createTask);
            pd.execute();
        }
        if ((addTask = new AddToPhotosetTask((Collection)photoSets, this)).hasSetsToAdd()) {
            pd = new ProgressDialog(JUploadr.window, (Task)addTask);
            pd.execute();
        }
        this.rotateImages(images);
        while (unfinishedActions.size() > 0 && this.showUnfinishedUploadErrorMessage()) {
            this.retryUnfinishedActions();
        }
        photoSets.clear();
        GetPhotosetList getList = new GetPhotosetList();
        this.executeMethod(getList);
        photoSets = new NonNullList(getList.getPhotoSets());
    }

    private void retryUnfinishedActions() {
        LinkedList actions = new LinkedList();
        for (List next : unfinishedActions.values()) {
            actions.addAll(next);
        }
        unfinishedActions.clear();
        for (FlickrMethod method : actions) {
            this.executeMethod(method);
        }
    }

    private boolean showUnfinishedUploadErrorMessage() {
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.append(Messages.getString("juploadr.flickerrest.error.after.upload"));
        Iterator failureClasses = unfinishedActions.keySet().iterator();
        while (failureClasses.hasNext()) {
            List actions = this.getFailedActions((Class)failureClasses.next());
            if (actions == null) continue;
            for (PostUploadAction method : actions) {
                errorMessage.append(Messages.getString("juploadr.flickerrest.failed.to"));
                errorMessage.append(method.getErrorText());
                errorMessage.append("\n");
            }
        }
        errorMessage.append(Messages.getString("juploadr.flickerrest.option.retry"));
        return MessageUtils.showMessage((String)errorMessage.toString(), (String)Messages.getString("juploadr.flickerrest.actions.failed"), (int)200);
    }

    private void rotateImages(Collection images) {
        Collection coll = this.getImagesToRotate(images);
        if (coll.size() > 0) {
            RotateTask rt = new RotateTask(coll, this);
            ProgressDialog pd = new ProgressDialog(JUploadr.window, (Task)rt);
            pd.execute();
        }
    }

    private void addFailedAction(PostUploadAction failed) {
        LinkedList<PostUploadAction> failedActions = (LinkedList<PostUploadAction>)unfinishedActions.get(failed.getClass());
        if (failedActions == null) {
            failedActions = new LinkedList<PostUploadAction>();
        }
        if (!failedActions.contains(failed)) {
            failedActions.add(failed);
        }
        unfinishedActions.put(failed.getClass(), failedActions);
    }

    private List getFailedActions(Class clazz) {
        return (List)unfinishedActions.get(clazz);
    }

    private Collection getImagesToRotate(Collection allImages) {
        LinkedList<UploadImage> images = new LinkedList<UploadImage>();
        for (UploadImage image : allImages) {
            if (image.getRotation() == 0) continue;
            images.add(image);
        }
        return images;
    }

    public boolean executeMethod(FlickrMethod method) {
        try {
            method.execute();
            return true;
        }
        catch (ProtocolException e) {
        }
        catch (CommunicationException communicationException) {
            // empty catch block
        }
        if (method instanceof PostUploadAction) {
            this.addFailedAction((PostUploadAction)((Object)method));
        }
        return false;
    }

    static {
        DEFAULT_ACCOUNT_KEY = RestFlickrApi.class.getName() + ".defaultAccount";
        prefs = Preferences.userNodeForPackage(RestFlickrApi.class);
        instance = new RestFlickrApi();
    }
}

