/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest.authentication;

import org.eclipse.swt.widgets.Shell;
import org.scohen.juploadr.app.authentication.AuthorizationDialog;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.flickrrest.Messages;
import org.scohen.juploadr.uploadapi.flickrrest.RestFlickrApi;
import org.scohen.juploadr.uploadapi.flickrrest.StringSigner;
import org.scohen.juploadr.uploadapi.flickrrest.authentication.FlickrAccount;
import org.scohen.juploadr.uploadapi.flickrrest.authentication.GetFrob;
import org.scohen.juploadr.uploadapi.flickrrest.authentication.GetToken;
import org.scohen.juploadr.uploadapi.flickrrest.upload.GetUploadStatus;
import org.scohen.juploadr.util.JUploadrBrowserLauncher;

public class FlickrAuthEventDirector {
    private static final String PERMS = "write";
    private static final String LINK_BASE = "http://flickr.com/services/auth/?api_key=1892f5f9d32f01b86f53b50cdac89c8c&perms=write";
    private String frob;

    public boolean execute(FlickrAccount info) throws ProtocolException, CommunicationException {
        ImageUploadApi api = RestFlickrApi.getInstance();
        if (!info.isAuthenticated()) {
            GetFrob getFrob = new GetFrob();
            getFrob.execute();
            this.frob = getFrob.getFrob();
            info.setFrob(this.frob);
            Shell shell = ReusableUIFactory.getInstance().getDisplay().getActiveShell();
            AuthorizationDialog authDialog = new AuthorizationDialog(Messages.getString("juploadr.flickrrest.authdialog.line1"), Messages.getString("juploadr.flickrrest.authdialog.line2"), Messages.getString("juploadr.flickrrest.authdialog.line3"), Messages.getString("juploadr.flickrrest.button.authorize"), shell);
            boolean shouldAuth = authDialog.open();
            if (!shouldAuth) {
                return false;
            }
            String authLink = this.buildAuthLink();
            JUploadrBrowserLauncher.openURL((String)authLink, (String)Messages.getString("juploadr.flickrrest.authdialog.browser.not.found"));
            AuthorizationDialog continueDialog = new AuthorizationDialog(Messages.getString("juploadr.flickrrest.continuedialog.line1"), Messages.getString("juploadr.flickrrest.continuedialog.line2"), Messages.getString("juploadr.flickrrest.continuedialog.line3"), Messages.getString("juploadr.flickrrest.button.complete-auth"), shell);
            if (!continueDialog.open()) {
                return false;
            }
            GetToken getToken = new GetToken(this.frob);
            getToken.execute();
            info.setToken(getToken.getToken());
            info.setAuthenticated(getToken.getToken() != null);
            api.setCurrentAccount((Account)info);
        }
        if (ImageUploadApi.getInstance().isCurrentAccountAuthenticated()) {
            GetUploadStatus gus = new GetUploadStatus();
            gus.execute();
            info.configureFrom(gus);
            info.save();
            ImageUploadApi.getInstance().setCurrentAccount((Account)info);
        }
        return true;
    }

    private String buildAuthLink() {
        StringBuffer link = new StringBuffer(LINK_BASE);
        link.append("&frob=");
        link.append(this.frob);
        link.append("&api_sig=");
        StringBuffer apiSig = new StringBuffer("e45cca24a72f6eb9");
        apiSig.append("api_key");
        apiSig.append("1892f5f9d32f01b86f53b50cdac89c8c");
        apiSig.append("frob");
        apiSig.append(this.frob);
        apiSig.append("perms");
        apiSig.append(PERMS);
        link.append(StringSigner.md5(apiSig.toString()));
        return link.toString();
    }
}

