/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.ImageAttributesUI;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.MultiImageAttributesUI;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.ui.PopupData;
import org.scohen.juploadr.ui.PopupHandler;
import org.scohen.juploadr.uploadapi.zooomr.Messages;
import org.scohen.juploadr.uploadapi.zooomr.ui.NewPhotoSetDialog;

public class ZooomrPopupHandler
extends PopupHandler {
    private String A_NEW_SET = org.scohen.juploadr.uploadapi.flickrrest.Messages.getString((String)"juploadr.flickrrest.ui.popup.a.new.set");
    private String REMOVE_UPLOADED_IMAGES = Messages.getString("juploadr.ui.popup.remove.uploaded");
    private String ENABLE_UPLOADED_IMAGES = Messages.getString("juploadr.ui.popup.reupload.uploaded");
    private String SELECT_ALL_PHOTOS = Messages.getString("juploadr.ui.popup.select.all");
    private String SELECT_NONE = Messages.getString("juploadr.ui.popup.deselect.all");
    private String INVERT_SELECTION = Messages.getString("juploadr.ui.popup.invert.selection");
    private String EDIT_SELECTED_PHOTOS = Messages.getString("juploadr.ui.popup.edit.selected");
    private String REMOVE_SELECTED_PHOTOS = Messages.getString("juploadr.ui.popup.remove.selected");
    private JUploadr uploader;

    public ZooomrPopupHandler(Decorations parent, JUploadr uploadr) {
        super(parent);
        this.uploader = uploadr;
        this.show();
    }

    protected void widgetSelected(SelectionEvent event) {
        MenuItem src = (MenuItem)event.widget;
        String action = src.getText();
        if (action.equals(this.REMOVE_UPLOADED_IMAGES)) {
            this.uploader.removeUploadedPhotos();
        } else if (this.SELECT_ALL_PHOTOS.equals(action) || this.SELECT_NONE.equals(action)) {
            boolean selected = this.SELECT_ALL_PHOTOS.equals(action);
            for (ImageAttributes atts : this.uploader.getImageAttributes().values()) {
                atts.setSelected(selected);
            }
            this.uploader.refresh();
        } else if (this.INVERT_SELECTION.equals(action)) {
            Iterator values = this.uploader.getImageAttributes().values().iterator();
            while (values.hasNext()) {
                ImageAttributes atts;
                atts.setSelected(!(atts = (ImageAttributes)values.next()).isSelected());
            }
            this.uploader.refresh();
        } else if (this.EDIT_SELECTED_PHOTOS.equals(action)) {
            List atts = this.getSelectedPhotos();
            Object ui = atts.size() == 1 ? new ImageAttributesUI((ImageAttributes)atts.get(0)) : new MultiImageAttributesUI(atts);
            ui.show(this.parent.getDisplay());
        } else if (this.REMOVE_SELECTED_PHOTOS.equals(action)) {
            List atts = this.getSelectedPhotos();
            for (int i = 0; i < atts.size(); ++i) {
                ImageAttributes att = (ImageAttributes)atts.get(i);
                att.removeFromWindow();
            }
            this.uploader.refresh();
        } else if (this.ENABLE_UPLOADED_IMAGES.equals(action)) {
            for (ImageAttributes atts : this.uploader.getImageAttributes().values()) {
                atts.setState(2);
                atts.getButton().setEnabled(true);
            }
            this.uploader.refresh();
        } else if (this.A_NEW_SET.equals(action)) {
            ArrayList<ImageAttributes> selected = new ArrayList<ImageAttributes>();
            for (ImageAttributes att : this.uploader.getImageAttributes().values()) {
                if (!att.isSelected()) continue;
                selected.add(att);
            }
            NewPhotoSetDialog dialog = new NewPhotoSetDialog(JUploadr.window, selected);
            dialog.open();
            this.uploader.refresh();
        } else {
            MenuItem item = (MenuItem)event.widget;
            PhotoSet set = (PhotoSet)item.getData();
            for (ImageAttributes att : this.uploader.getImageAttributes().values()) {
                if (!att.isSelected()) continue;
                List alreadyAdded = att.getPhotoSets();
                if (alreadyAdded.contains(set)) {
                    alreadyAdded.remove(set);
                    continue;
                }
                set.addPhoto(att);
            }
            this.uploader.refresh();
        }
    }

    private List getSelectedPhotos() {
        Iterator values = this.uploader.getImageAttributes().values().iterator();
        LinkedList<ImageAttributes> atts = new LinkedList<ImageAttributes>();
        while (values.hasNext()) {
            ImageAttributes element = (ImageAttributes)values.next();
            if (!element.isSelected()) continue;
            atts.add(element);
        }
        return atts;
    }

    protected void regenerateOptions() {
        this.options = new LinkedList();
        if (this.arePhotosSelected()) {
            this.options.add(new PopupData(this.EDIT_SELECTED_PHOTOS, true));
        } else {
            this.options.add(new PopupData(this.EDIT_SELECTED_PHOTOS, false));
        }
        this.options.add(new PopupData(this.SELECT_ALL_PHOTOS, true));
        this.options.add(new PopupData(this.SELECT_NONE, true));
        this.options.add(new PopupData(this.INVERT_SELECTION, true));
        this.options.add(PopupData.SEPARATOR);
        if (this.areAnyPhotosUploaded()) {
            this.options.add(new PopupData(this.REMOVE_UPLOADED_IMAGES, true));
            this.options.add(new PopupData(this.ENABLE_UPLOADED_IMAGES, true));
        } else {
            this.options.add(new PopupData(this.REMOVE_UPLOADED_IMAGES, false));
            this.options.add(new PopupData(this.ENABLE_UPLOADED_IMAGES, false));
        }
        if (this.arePhotosSelected()) {
            this.options.add(new PopupData(this.REMOVE_SELECTED_PHOTOS, true));
        } else {
            this.options.add(new PopupData(this.REMOVE_SELECTED_PHOTOS, false));
        }
    }

    private boolean arePhotosSelected() {
        for (ImageAttributes next : this.uploader.getImageAttributes().values()) {
            if (!next.isSelected() || next.getState() == 4) continue;
            return true;
        }
        return false;
    }

    private boolean areAnyPhotosUploaded() {
        for (UploadImage atts : this.uploader.getImageAttributes().values()) {
            if (atts.getState() != 1) continue;
            return true;
        }
        return false;
    }
}

