/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr.upload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.app.tags.TagParser;
import org.scohen.juploadr.event.ImageUploadResponse;
import org.scohen.juploadr.event.MonitorFilePart;
import org.scohen.juploadr.event.UploadCompleteEvent;
import org.scohen.juploadr.event.UploadEvent;
import org.scohen.juploadr.event.UploadStatusMonitor;
import org.scohen.juploadr.upload.HttpClientFactory;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.UploadFailedException;
import org.scohen.juploadr.uploadapi.zooomr.DefaultZooomrHandler;
import org.scohen.juploadr.uploadapi.zooomr.ZooomrMethod;
import org.scohen.juploadr.uploadapi.zooomr.ZooomrRestApi;
import org.scohen.juploadr.uploadapi.zooomr.authentication.ZooomrAccount;
import org.scohen.juploadr.uploadapi.zooomr.upload.ZooomrUploadResponseHandler;

public class ZooomrUpload
extends ZooomrMethod {
    public static final int STATUS_OK = 1;
    public static final int STATUS_FAILED = 0;
    private static final String URL = "http://beta.zooomr.com/bluenote/api/upload/";
    private UploadImage image;
    private UploadStatusMonitor monitor;
    private SortedMap params = new TreeMap();
    private ZooomrUploadResponseHandler handler;

    public ZooomrUpload(UploadImage img, UploadStatusMonitor monitor) {
        this.image = img;
        this.monitor = monitor;
        this.handler = new ZooomrUploadResponseHandler(this);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
    }

    public boolean execute() throws ProtocolException, CommunicationException {
        HttpClient client = HttpClientFactory.getHttpClient();
        this.monitor.uploadStarted(new UploadEvent(this.image, 0.0, true, false));
        PostMethod post = new PostMethod(URL);
        List parts = this.getParts();
        MultipartRequestEntity entity = new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), post.getParams());
        post.setRequestEntity((RequestEntity)entity);
        try {
            int status = client.executeMethod((HttpMethod)post);
            if (status == 200) {
                try {
                    String response = post.getResponseBodyAsString();
                    post.releaseConnection();
                    boolean success = this.parseResponse(response);
                    if (!success) {
                        throw new UploadFailedException(Messages.getString((String)"juploadr.ui.error.status"));
                    }
                    this.image.setState(1);
                    ImageUploadResponse resp = new ImageUploadResponse(this.handler.getPhotoID());
                    this.monitor.uploadFinished(new UploadCompleteEvent(resp, this.image));
                }
                catch (IOException e) {
                    this.fail(Messages.getString((String)"juploadr.ui.error.response.unreadable") + e.getMessage(), e);
                }
            } else {
                Object[] args = new Object[]{new Integer(status)};
                this.fail(Messages.getString((String)"juploadr.ui.error.bad.http.response", (Object[])args), null);
            }
        }
        catch (ConnectException ce) {
            this.fail(Messages.getString((String)"juploadr.ui.error.unable.to.connect"), ce);
        }
        catch (NoRouteToHostException route) {
            this.fail(Messages.getString((String)"juploadr.ui.error.no.internet"), route);
        }
        catch (UnknownHostException uhe) {
            this.fail(Messages.getString((String)"juploadr.ui.error.unknown.host"), uhe);
        }
        catch (HttpException e) {
            this.fail(Messages.getString((String)"juploadr.ui.error.http.exception") + (Object)((Object)e), e);
        }
        catch (IOException e) {
            this.fail(Messages.getString((String)"juploadr.ui.error.simple.ioexception") + e.getMessage() + "" + e, e);
        }
        return true;
    }

    private void fail(String message, Throwable cause) throws CommunicationException {
        this.monitor.uploadFailed(new UploadEvent(this.image, 0.0, true, false, message));
        if (cause != null) {
            throw new CommunicationException(message, cause);
        }
        throw new CommunicationException(message);
    }

    private List getParts() throws UploadFailedException {
        LinkedList<Object> parts = new LinkedList<Object>();
        try {
            this.addNonNullStringPart(parts, "auth_token", ((ZooomrAccount)ZooomrRestApi.getInstance().getCurrentAccount()).getToken());
            this.addNonNullStringPart(parts, "api_key", "6dd0b757dc9013189d2f250d0385320dc7f291d7");
            this.addNonNullStringPart(parts, "title", this.image.getTitle());
            this.addNonNullStringPart(parts, "tags", TagParser.toRequestString((List)this.image.getTags()));
            this.addNonNullStringPart(parts, "description", this.image.getDescription());
            this.addBooleanPart(parts, "is_public", this.image.isPubliclyVisible());
            this.addBooleanPart(parts, "is_friend", this.image.isFriendViewable());
            this.addBooleanPart(parts, "is_family", this.image.isFamilyViewable());
            MonitorFilePart file = new MonitorFilePart("photo", new File(this.image.getImagePath()), this.image);
            file.addStateChangeListener(this.monitor);
            parts.add(file);
            parts.add(new StringPart("api_sig", this.getSignature()));
        }
        catch (FileNotFoundException e) {
            Object[] args = new String[]{this.image.getImagePath()};
            throw new UploadFailedException(Messages.getString((String)"juploadr.ui.error.file.notfound", (Object[])args));
        }
        return parts;
    }

    private void addBooleanPart(List parts, String paramName, boolean shouldSet) {
        String value = shouldSet ? "1" : "0";
        StringPart part = new StringPart(paramName, value);
        parts.add(part);
        this.params.put(paramName, value);
    }

    private void addNonNullStringPart(List parts, String paramName, String paramValue) {
        if (paramValue != null) {
            StringPart part = new StringPart(paramName, paramValue);
            part.setCharSet("UTF-8");
            parts.add(part);
            this.params.put(paramName, paramValue);
        }
    }

    public DefaultZooomrHandler getResponseHandler() {
        return this.handler;
    }

    public SortedMap getParams() {
        return this.params;
    }

    public boolean isAuthorized() {
        return false;
    }
}

