
#ifndef TABDIALOG_H
#define TABDIALOG_H

#include <QDialog>
#include <QLineEdit>
#include <QComboBox>
#include <QListWidget>
#include <QFontComboBox>
#include <QTextEdit>
#include <QCheckBox>
#include <QFormLayout>
#include <QVBoxLayout>



class QDialogButtonBox;
class QFileInfo;
class QTabWidget;

namespace Ui {
class TabDialog;
}

class ListenDialog: public QDialog
{
	Q_OBJECT

public:
	explicit ListenDialog(QWidget *parent = 0);
	~ListenDialog();

private slots:
	void myaccept();
	void myreject();

public:
	QVBoxLayout *verticalLayout;
	QFormLayout *formLayout;
	QLineEdit *portNo;
	QTextEdit *CText;
	QVBoxLayout *verticalLayout_2;
	QDialogButtonBox *buttonBox;
	QCheckBox *Enabled;


};



class TabDialog : public QDialog
{
	Q_OBJECT

public:
	explicit TabDialog(QWidget *parent = 0);
	~TabDialog();

private slots:
	void myaccept();
	void myreject();

private:
	//   Ui::TabDialog *ui;
	QDialogButtonBox *buttonBox;
};

class AGWDialog : public QDialog
{
	Q_OBJECT

public:
	explicit AGWDialog(QWidget *parent = 0);
	~AGWDialog();

public:
	QPushButton *okButton;
	QPushButton *cancelButton;

private slots:
	void myaccept();
	void myreject();

private:
	//   Ui::TabDialog *ui;
	QDialogButtonBox *buttonBox;
};

class AGWConnect : public QDialog
{
	Q_OBJECT

public:
	explicit AGWConnect(QWidget *parent = 0);
	~AGWConnect();

public:
	QLineEdit * wCallFrom;
	QComboBox * wCallTo;
	QLineEdit * Digis;
	QListWidget * RadioPorts;

private slots:
	void myaccept();
	void myreject();

private:
	//   Ui::TabDialog *ui;
	QDialogButtonBox *buttonBox;
};

class fontDialog : public QDialog
{
	Q_OBJECT

public:
	explicit fontDialog(int Menu, QWidget *parent = 0);
	~fontDialog();

public:
	QFontComboBox *font;
	QComboBox *style;
	QComboBox *size;
	QTextEdit * sample;
	QFont workingFont;
	int workingSize;
	int Menuflag;			// Set if menu font

private slots:
	void myaccept();
	void myreject();
	void fontchanged(QFont);
	void stylechanged();
	void sizechanged();

private:
	
	QDialogButtonBox *buttonBox;
};

#endif
