#
/*
 *    Copyright (C) 2013 .. 2023
 *    Jan van Katwijk (J.vanKatwijk@gmail.com)
 *    Lazy Chair Computing
 *
 *    This file is part of the Qt-DAB program
 *
 *    Qt-DAB is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    Qt-DAB is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with Qt-DAB; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#
#pragma once

#include	<QObject>
#include	<cstdio>
#include	<cstdint>
#include	<vector>
#include	"fft-handler.h"
#include	"phasetable.h"
#include	"dab-constants.h"
#include	"dab-params.h"
#include	"process-params.h"
#include	"ringbuffer.h"

class	RadioInterface;

class freqSyncer : public QObject, public phaseTable {
Q_OBJECT
public:
			freqSyncer 		(RadioInterface *,
	                                         processParams *);
			~freqSyncer		();
	int16_t		estimate_CarrierOffset	(std::vector<std::complex<float>>);
private:
	std::vector<std::complex<float>> refTable;
	dabParams	params;
	std::vector<float> phaseDifferences;
	int16_t		diff_length;
	int32_t		T_u;
	int32_t		T_g;
	int16_t		carriers;
	fftHandler	fft_forward;
};
//#endif

