//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2021 Edouard Griffiths, F4EXB <f4exb06@gmail.com>                                          //
//                                                                                                          //
// This program is free software; you can redistribute it and/or modify                                     //
// it under the terms of the GNU General Public License as published by                                     //
// the Free Software Foundation as version 3 of the License, or                                             //
// (at your option) any later version.                                                                      //
//                                                                                                          //
// This program is distributed in the hope that it will be useful,                                          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of                                           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                                             //
// GNU General Public License V3 for more details.                                                          //
//                                                                                                          //
// You should have received a copy of the GNU General Public License                                        //
// along with this program. If not, see <http://www.gnu.org/licenses/>.                                     //
//                                                                                                          //
// Source: http://onfreq.com/syntorx/dcs.html                                                               //
//                                                                                                          //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "dcscodes.h"

const QMap<unsigned int, unsigned int> DCSCodes::m_toCanonicalCode {
    {0023, 0023},
    {0340, 0023},
    {0766, 0023},
    {0025, 0025},
    {0026, 0026},
    {0566, 0026},
    {0031, 0031},
    {0374, 0031},
    {0643, 0031},
    {0032, 0032},
    {0036, 0036},
    {0137, 0036},
    {0043, 0043},
    {0355, 0043},
    {0047, 0047},
    {0375, 0047},
    {0707, 0047},
    {0051, 0051},
    {0771, 0051},
    {0520, 0051},
    {0053, 0053},
    {0054, 0054},
    {0405, 0054},
    {0675, 0054},
    {0065, 0065},
    {0301, 0065},
    {0071, 0071},
    {0603, 0071},
    {0717, 0071},
    {0746, 0071},
    {0072, 0072},
    {0470, 0072},
    {0701, 0072},
    {0073, 0073},
    {0640, 0073},
    {0074, 0074},
    {0360, 0074},
    {0721, 0074},
    {0112, 0112},
    {0250, 0112},
    {0505, 0112},
    {0512, 0112},
    {0114, 0114},
    {0327, 0114},
    {0615, 0114},
    {0115, 0115},
    {0534, 0115},
    {0674, 0115},
    {0116, 0116},
    {0060, 0116},
    {0737, 0116},
    {0122, 0122},
    {0535, 0125},
    {0125, 0125},
    {0173, 0125},
    {0131, 0131},
    {0572, 0131},
    {0702, 0131},
    {0132, 0132},
    {0605, 0132},
    {0634, 0132},
    {0714, 0132},
    {0134, 0134},
    {0273, 0134},
    {0143, 0143},
    {0333, 0143},
    {0145, 0145},
    {0525, 0145},
    {0152, 0152},
    {0366, 0152},
    {0415, 0152},
    {0155, 0155},
    {0233, 0155},
    {0660, 0155},
    {0156, 0156},
    {0517, 0156},
    {0741, 0156},
    {0162, 0162},
    {0416, 0162},
    {0553, 0162},
    {0165, 0165},
    {0354, 0165},
    {0172, 0172},
    {0057, 0172},
    {0174, 0174},
    {0142, 0174},
    {0270, 0174},
    {0205, 0205},
    {0135, 0205},
    {0610, 0205},
    {0212, 0212},
    {0253, 0212},
    {0223, 0223},
    {0350, 0223},
    {0475, 0223},
    {0750, 0223},
    {0225, 0225},
    {0536, 0225},
    {0226, 0226},
    {0104, 0226},
    {0557, 0226},
    {0243, 0243},
    {0267, 0243},
    {0342, 0243},
    {0244, 0244},
    {0176, 0244},
    {0417, 0244},
    {0245, 0245},
    {0370, 0245},
    {0246, 0246},
    {0542, 0246},
    {0653, 0246},
    {0554, 0245},
    {0251, 0251},
    {0236, 0251},
    {0704, 0251},
    {0742, 0251},
    {0252, 0252},
    {0661, 0252},
    {0255, 0255},
    {0425, 0255},
    {0261, 0261},
    {0227, 0261},
    {0567, 0261},
    {0263, 0263},
    {0213, 0263},
    {0736, 0263},
    {0265, 0265},
    {0171, 0265},
    {0426, 0265},
    {0266, 0266},
    {0655, 0266},
    {0271, 0271},
    {0427, 0271},
    {0510, 0271},
    {0762, 0271},
    {0274, 0274},
    {0652, 0274},
    {0306, 0306},
    {0147, 0306},
    {0303, 0306},
    {0761, 0306},
    {0311, 0311},
    {0330, 0311},
    {0456, 0311},
    {0561, 0311},
    {0315, 0315},
    {0321, 0315},
    {0673, 0315},
    {0325, 0325},
    {0550, 0325},
    {0626, 0325},
    {0331, 0331},
    {0372, 0331},
    {0507, 0331},
    {0332, 0332},
    {0433, 0332},
    {0552, 0332},
    {0343, 0343},
    {0324, 0343},
    {0570, 0343},
    {0346, 0346},
    {0616, 0346},
    {0635, 0346},
    {0724, 0346},
    {0351, 0351},
    {0353, 0351},
    {0435, 0351},
    {0356, 0356},
    {0521, 0356},
    {0364, 0364},
    {0130, 0364},
    {0641, 0364},
    {0365, 0365},
    {0107, 0365},
    {0371, 0371},
    {0217, 0371},
    {0453, 0371},
    {0530, 0371},
    {0411, 0411},
    {0117, 0411},
    {0756, 0411},
    {0412, 0412},
    {0127, 0412},
    {0441, 0412},
    {0711, 0412},
    {0413, 0413},
    {0133, 0413},
    {0620, 0413},
    {0423, 0423},
    {0234, 0423},
    {0563, 0423},
    {0621, 0423},
    {0713, 0423},
    {0431, 0431},
    {0262, 0431},
    {0316, 0431},
    {0730, 0431},
    {0432, 0432},
    {0432, 0432},
    {0276, 0432},
    {0326, 0432},
    {0445, 0445},
    {0222, 0445},
    {0457, 0445},
    {0575, 0445},
    {0446, 0446},
    {0467, 0446},
    {0511, 0446},
    {0672, 0446},
    {0452, 0452},
    {0524, 0452},
    {0765, 0452},
    {0454, 0454},
    {0545, 0454},
    {0513, 0454},
    {0564, 0454},
    {0455, 0455},
    {0533, 0455},
    {0551, 0455},
    {0462, 0462},
    {0462, 0462},
    {0472, 0462},
    {0623, 0462},
    {0725, 0462},
    {0464, 0464},
    {0237, 0464},
    {0642, 0464},
    {0772, 0464},
    {0465, 0465},
    {0056, 0465},
    {0656, 0465},
    {0466, 0466},
    {0144, 0466},
    {0666, 0466},
    {0503, 0503},
    {0157, 0503},
    {0322, 0503},
    {0506, 0506},
    {0224, 0506},
    {0313, 0506},
    {0574, 0506},
    {0516, 0516},
    {0067, 0516},
    {0720, 0516},
    {0523, 0523},
    {0647, 0523},
    {0726, 0523},
    {0526, 0526},
    {0562, 0526},
    {0645, 0526},
    {0532, 0532},
    {0161, 0532},
    {0345, 0532},
    {0546, 0546},
    {0317, 0546},
    {0614, 0546},
    {0751, 0546},
    {0565, 0565},
    {0307, 0565},
    {0362, 0565},
    {0606, 0606},
    {0153, 0606},
    {0630, 0606},
    {0612, 0612},
    {0254, 0612},
    {0314, 0612},
    {0706, 0612},
    {0624, 0624},
    {0075, 0624},
    {0501, 0624},
    {0627, 0627},
    {0037, 0627},
    {0560, 0627},
    {0631, 0631},
    {0231, 0631},
    {0504, 0631},
    {0636, 0631},
    {0745, 0631},
    {0632, 0632},
    {0123, 0632},
    {0657, 0632},
    {0654, 0654},
    {0163, 0654},
    {0460, 0654},
    {0607, 0654},
    {0662, 0662},
    {0363, 0662},
    {0436, 0662},
    {0443, 0662},
    {0444, 0662},
    {0664, 0664},
    {0344, 0664},
    {0471, 0664},
    {0715, 0664},
    {0703, 0703},
    {0150, 0703},
    {0256, 0703},
    {0712, 0712},
    {0136, 0712},
    {0502, 0712},
    {0723, 0723},
    {0235, 0723},
    {0671, 0723},
    {0611, 0723},
    {0731, 0731},
    {0447, 0731},
    {0473, 0731},
    {0474, 0731},
    {0744, 0731},
    {0732, 0732},
    {0164, 0732},
    {0207, 0732},
    {0734, 0734},
    {0066, 0734},
    {0743, 0743},
    {0312, 0743},
    {0515, 0743},
    {0663, 0743},
    {0754, 0754},
    {0076, 0754},
    {0203, 0754},
};

const QMap<unsigned int, unsigned int> DCSCodes::m_signFlip = {
    {0023, 0047},
    {0025, 0244},
    {0026, 0464},
    {0031, 0627},
    {0032, 0051},
    {0043, 0445},
    {0047, 0023},
    {0051, 0032},
    {0053, 0452},
    {0054, 0413},
    {0065, 0271},
    {0071, 0306},
    {0072, 0245},
    {0073, 0506},
    {0074, 0174},
    {0114, 0712},
    {0115, 0152},
    {0116, 0754},
    {0122, 0225},
    {0125, 0365},
    {0131, 0364},
    {0132, 0546},
    {0134, 0223},
    {0143, 0412},
    {0145, 0274},
    {0152, 0115},
    {0155, 0731},
    {0156, 0265},
    {0162, 0503},
    {0165, 0251},
    {0172, 0036},
    {0174, 0074},
    {0205, 0263},
    {0212, 0356},
    {0223, 0134},
    {0225, 0122},
    {0226, 0411},
    {0243, 0351},
    {0244, 0025},
    {0245, 0072},
    {0246, 0523},
    {0251, 0165},
    {0252, 0462},
    {0255, 0511},
    {0261, 0732},
    {0263, 0205},
    {0265, 0156},
    {0266, 0454},
    {0271, 0065},
    {0274, 0145},
    {0306, 0071},
    {0311, 0664},
    {0315, 0423},
    {0325, 0526},
    {0331, 0465},
    {0332, 0455},
    {0343, 0532},
    {0346, 0612},
    {0351, 0243},
    {0356, 0212},
    {0364, 0131},
    {0365, 0125},
    {0371, 0734},
    {0411, 0226},
    {0412, 0143},
    {0413, 0054},
    {0423, 0315},
    {0431, 0723},
    {0432, 0516},
    {0445, 0043},
    {0446, 0255},
    {0452, 0053},
    {0454, 0655},
    {0455, 0332},
    {0462, 0252},
    {0464, 0026},
    {0465, 0331},
    {0466, 0662},
    {0503, 0162},
    {0506, 0073},
    {0516, 0432},
    {0523, 0246},
    {0526, 0325},
    {0532, 0343},
    {0546, 0132},
    {0565, 0703},
    {0606, 0631},
    {0612, 0346},
    {0624, 0632},
    {0627, 0031},
    {0631, 0606},
    {0632, 0624},
    {0654, 0743},
    {0662, 0466},
    {0664, 0311},
    {0703, 0565},
    {0712, 0114},
    {0723, 0431},
    {0731, 0155},
    {0732, 0261},
    {0734, 0371},
    {0743, 0654},
    {0754, 0116},
};


void DCSCodes::getCanonicalCodes(QList<unsigned int>& codes)
{
    codes.clear();

    for (auto code : m_toCanonicalCode.keys())
    {
        if (code == m_toCanonicalCode.value(code)) {
            codes.append(code);
        }
    }
}
