/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGAPTDemodActions_los.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGAPTDemodActions_los::SWGAPTDemodActions_los(QString* json) {
    init();
    this->fromJson(*json);
}

SWGAPTDemodActions_los::SWGAPTDemodActions_los() {
    satellite_name = nullptr;
    m_satellite_name_isSet = false;
}

SWGAPTDemodActions_los::~SWGAPTDemodActions_los() {
    this->cleanup();
}

void
SWGAPTDemodActions_los::init() {
    satellite_name = new QString("");
    m_satellite_name_isSet = false;
}

void
SWGAPTDemodActions_los::cleanup() {
    if(satellite_name != nullptr) { 
        delete satellite_name;
    }
}

SWGAPTDemodActions_los*
SWGAPTDemodActions_los::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGAPTDemodActions_los::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&satellite_name, pJson["satelliteName"], "QString", "QString");
    
}

QString
SWGAPTDemodActions_los::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGAPTDemodActions_los::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(satellite_name != nullptr && *satellite_name != QString("")){
        toJsonValue(QString("satelliteName"), satellite_name, obj, QString("QString"));
    }

    return obj;
}

QString*
SWGAPTDemodActions_los::getSatelliteName() {
    return satellite_name;
}
void
SWGAPTDemodActions_los::setSatelliteName(QString* satellite_name) {
    this->satellite_name = satellite_name;
    this->m_satellite_name_isSet = true;
}


bool
SWGAPTDemodActions_los::isSet(){
    bool isObjectUpdated = false;
    do{
        if(satellite_name && *satellite_name != QString("")){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

