/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

/*
 * SWGFreqScannerSettings.h
 *
 * FreqScanner
 */

#ifndef SWGFreqScannerSettings_H_
#define SWGFreqScannerSettings_H_

#include <QJsonObject>


#include "SWGChannelMarker.h"
#include "SWGFreqScannerFrequency.h"
#include "SWGRollupState.h"
#include <QList>
#include <QString>

#include "SWGObject.h"
#include "export.h"

namespace SWGSDRangel {

class SWG_API SWGFreqScannerSettings: public SWGObject {
public:
    SWGFreqScannerSettings();
    SWGFreqScannerSettings(QString* json);
    virtual ~SWGFreqScannerSettings();
    void init();
    void cleanup();

    virtual QString asJson () override;
    virtual QJsonObject* asJsonObject() override;
    virtual void fromJsonObject(QJsonObject &json) override;
    virtual SWGFreqScannerSettings* fromJson(QString &jsonString) override;

    qint32 getChannelBandwidth();
    void setChannelBandwidth(qint32 channel_bandwidth);

    qint32 getChannelFrequencyOffset();
    void setChannelFrequencyOffset(qint32 channel_frequency_offset);

    float getThreshold();
    void setThreshold(float threshold);

    QList<SWGFreqScannerFrequency*>* getFrequencies();
    void setFrequencies(QList<SWGFreqScannerFrequency*>* frequencies);

    QString* getChannel();
    void setChannel(QString* channel);

    float getScanTime();
    void setScanTime(float scan_time);

    float getRetransmitTime();
    void setRetransmitTime(float retransmit_time);

    float getTuneTime();
    void setTuneTime(float tune_time);

    qint32 getPriority();
    void setPriority(qint32 priority);

    qint32 getMeasurement();
    void setMeasurement(qint32 measurement);

    qint32 getMode();
    void setMode(qint32 mode);

    qint32 getRgbColor();
    void setRgbColor(qint32 rgb_color);

    QString* getTitle();
    void setTitle(QString* title);

    qint32 getStreamIndex();
    void setStreamIndex(qint32 stream_index);

    qint32 getUseReverseApi();
    void setUseReverseApi(qint32 use_reverse_api);

    QString* getReverseApiAddress();
    void setReverseApiAddress(QString* reverse_api_address);

    qint32 getReverseApiPort();
    void setReverseApiPort(qint32 reverse_api_port);

    qint32 getReverseApiDeviceIndex();
    void setReverseApiDeviceIndex(qint32 reverse_api_device_index);

    qint32 getReverseApiChannelIndex();
    void setReverseApiChannelIndex(qint32 reverse_api_channel_index);

    SWGChannelMarker* getChannelMarker();
    void setChannelMarker(SWGChannelMarker* channel_marker);

    SWGRollupState* getRollupState();
    void setRollupState(SWGRollupState* rollup_state);


    virtual bool isSet() override;

private:
    qint32 channel_bandwidth;
    bool m_channel_bandwidth_isSet;

    qint32 channel_frequency_offset;
    bool m_channel_frequency_offset_isSet;

    float threshold;
    bool m_threshold_isSet;

    QList<SWGFreqScannerFrequency*>* frequencies;
    bool m_frequencies_isSet;

    QString* channel;
    bool m_channel_isSet;

    float scan_time;
    bool m_scan_time_isSet;

    float retransmit_time;
    bool m_retransmit_time_isSet;

    float tune_time;
    bool m_tune_time_isSet;

    qint32 priority;
    bool m_priority_isSet;

    qint32 measurement;
    bool m_measurement_isSet;

    qint32 mode;
    bool m_mode_isSet;

    qint32 rgb_color;
    bool m_rgb_color_isSet;

    QString* title;
    bool m_title_isSet;

    qint32 stream_index;
    bool m_stream_index_isSet;

    qint32 use_reverse_api;
    bool m_use_reverse_api_isSet;

    QString* reverse_api_address;
    bool m_reverse_api_address_isSet;

    qint32 reverse_api_port;
    bool m_reverse_api_port_isSet;

    qint32 reverse_api_device_index;
    bool m_reverse_api_device_index_isSet;

    qint32 reverse_api_channel_index;
    bool m_reverse_api_channel_index_isSet;

    SWGChannelMarker* channel_marker;
    bool m_channel_marker_isSet;

    SWGRollupState* rollup_state;
    bool m_rollup_state_isSet;

};

}

#endif /* SWGFreqScannerSettings_H_ */
