/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 7.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGM17ModSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGM17ModSettings::SWGM17ModSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGM17ModSettings::SWGM17ModSettings() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    fm_deviation = 0.0f;
    m_fm_deviation_isSet = false;
    tone_frequency = 0.0f;
    m_tone_frequency_isSet = false;
    volume_factor = 0.0f;
    m_volume_factor_isSet = false;
    channel_mute = 0;
    m_channel_mute_isSet = false;
    play_loop = 0;
    m_play_loop_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    m17_mode = 0;
    m_m17_mode_isSet = false;
    audio_type = 0;
    m_audio_type_isSet = false;
    packet_type = 0;
    m_packet_type_isSet = false;
    audio_device_name = nullptr;
    m_audio_device_name_isSet = false;
    feedback_audio_device_name = nullptr;
    m_feedback_audio_device_name_isSet = false;
    feedback_volume_factor = 0.0f;
    m_feedback_volume_factor_isSet = false;
    feedback_audio_enable = 0;
    m_feedback_audio_enable_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    source_call = nullptr;
    m_source_call_isSet = false;
    dest_call = nullptr;
    m_dest_call_isSet = false;
    insert_position = 0;
    m_insert_position_isSet = false;
    can = 0;
    m_can_isSet = false;
    sms_text = nullptr;
    m_sms_text_isSet = false;
    loop_packet = 0;
    m_loop_packet_isSet = false;
    loop_packet_interval = 0;
    m_loop_packet_interval_isSet = false;
    aprs_callsign = nullptr;
    m_aprs_callsign_isSet = false;
    aprs_to = nullptr;
    m_aprs_to_isSet = false;
    aprs_via = nullptr;
    m_aprs_via_isSet = false;
    aprs_data = nullptr;
    m_aprs_data_isSet = false;
    aprs_insert_position = 0;
    m_aprs_insert_position_isSet = false;
    channel_marker = nullptr;
    m_channel_marker_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGM17ModSettings::~SWGM17ModSettings() {
    this->cleanup();
}

void
SWGM17ModSettings::init() {
    input_frequency_offset = 0L;
    m_input_frequency_offset_isSet = false;
    rf_bandwidth = 0.0f;
    m_rf_bandwidth_isSet = false;
    fm_deviation = 0.0f;
    m_fm_deviation_isSet = false;
    tone_frequency = 0.0f;
    m_tone_frequency_isSet = false;
    volume_factor = 0.0f;
    m_volume_factor_isSet = false;
    channel_mute = 0;
    m_channel_mute_isSet = false;
    play_loop = 0;
    m_play_loop_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    m17_mode = 0;
    m_m17_mode_isSet = false;
    audio_type = 0;
    m_audio_type_isSet = false;
    packet_type = 0;
    m_packet_type_isSet = false;
    audio_device_name = new QString("");
    m_audio_device_name_isSet = false;
    feedback_audio_device_name = new QString("");
    m_feedback_audio_device_name_isSet = false;
    feedback_volume_factor = 0.0f;
    m_feedback_volume_factor_isSet = false;
    feedback_audio_enable = 0;
    m_feedback_audio_enable_isSet = false;
    stream_index = 0;
    m_stream_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
    source_call = new QString("");
    m_source_call_isSet = false;
    dest_call = new QString("");
    m_dest_call_isSet = false;
    insert_position = 0;
    m_insert_position_isSet = false;
    can = 0;
    m_can_isSet = false;
    sms_text = new QString("");
    m_sms_text_isSet = false;
    loop_packet = 0;
    m_loop_packet_isSet = false;
    loop_packet_interval = 0;
    m_loop_packet_interval_isSet = false;
    aprs_callsign = new QString("");
    m_aprs_callsign_isSet = false;
    aprs_to = new QString("");
    m_aprs_to_isSet = false;
    aprs_via = new QString("");
    m_aprs_via_isSet = false;
    aprs_data = new QString("");
    m_aprs_data_isSet = false;
    aprs_insert_position = 0;
    m_aprs_insert_position_isSet = false;
    channel_marker = new SWGChannelMarker();
    m_channel_marker_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGM17ModSettings::cleanup() {








    if(title != nullptr) { 
        delete title;
    }



    if(audio_device_name != nullptr) { 
        delete audio_device_name;
    }
    if(feedback_audio_device_name != nullptr) { 
        delete feedback_audio_device_name;
    }




    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(source_call != nullptr) { 
        delete source_call;
    }
    if(dest_call != nullptr) { 
        delete dest_call;
    }


    if(sms_text != nullptr) { 
        delete sms_text;
    }


    if(aprs_callsign != nullptr) { 
        delete aprs_callsign;
    }
    if(aprs_to != nullptr) { 
        delete aprs_to;
    }
    if(aprs_via != nullptr) { 
        delete aprs_via;
    }
    if(aprs_data != nullptr) { 
        delete aprs_data;
    }

    if(channel_marker != nullptr) { 
        delete channel_marker;
    }
    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGM17ModSettings*
SWGM17ModSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGM17ModSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&input_frequency_offset, pJson["inputFrequencyOffset"], "qint64", "");
    
    ::SWGSDRangel::setValue(&rf_bandwidth, pJson["rfBandwidth"], "float", "");
    
    ::SWGSDRangel::setValue(&fm_deviation, pJson["fmDeviation"], "float", "");
    
    ::SWGSDRangel::setValue(&tone_frequency, pJson["toneFrequency"], "float", "");
    
    ::SWGSDRangel::setValue(&volume_factor, pJson["volumeFactor"], "float", "");
    
    ::SWGSDRangel::setValue(&channel_mute, pJson["channelMute"], "qint32", "");
    
    ::SWGSDRangel::setValue(&play_loop, pJson["playLoop"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&m17_mode, pJson["m17Mode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&audio_type, pJson["audioType"], "qint32", "");
    
    ::SWGSDRangel::setValue(&packet_type, pJson["packetType"], "qint32", "");
    
    ::SWGSDRangel::setValue(&audio_device_name, pJson["audioDeviceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&feedback_audio_device_name, pJson["feedbackAudioDeviceName"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&feedback_volume_factor, pJson["feedbackVolumeFactor"], "float", "");
    
    ::SWGSDRangel::setValue(&feedback_audio_enable, pJson["feedbackAudioEnable"], "qint32", "");
    
    ::SWGSDRangel::setValue(&stream_index, pJson["streamIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&source_call, pJson["sourceCall"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&dest_call, pJson["destCall"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&insert_position, pJson["insertPosition"], "qint32", "");
    
    ::SWGSDRangel::setValue(&can, pJson["can"], "qint32", "");
    
    ::SWGSDRangel::setValue(&sms_text, pJson["smsText"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&loop_packet, pJson["loopPacket"], "qint32", "");
    
    ::SWGSDRangel::setValue(&loop_packet_interval, pJson["loopPacketInterval"], "qint32", "");
    
    ::SWGSDRangel::setValue(&aprs_callsign, pJson["aprsCallsign"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&aprs_to, pJson["aprsTo"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&aprs_via, pJson["aprsVia"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&aprs_data, pJson["aprsData"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&aprs_insert_position, pJson["aprsInsertPosition"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_marker, pJson["channelMarker"], "SWGChannelMarker", "SWGChannelMarker");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGM17ModSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGM17ModSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_input_frequency_offset_isSet){
        obj->insert("inputFrequencyOffset", QJsonValue(input_frequency_offset));
    }
    if(m_rf_bandwidth_isSet){
        obj->insert("rfBandwidth", QJsonValue(rf_bandwidth));
    }
    if(m_fm_deviation_isSet){
        obj->insert("fmDeviation", QJsonValue(fm_deviation));
    }
    if(m_tone_frequency_isSet){
        obj->insert("toneFrequency", QJsonValue(tone_frequency));
    }
    if(m_volume_factor_isSet){
        obj->insert("volumeFactor", QJsonValue(volume_factor));
    }
    if(m_channel_mute_isSet){
        obj->insert("channelMute", QJsonValue(channel_mute));
    }
    if(m_play_loop_isSet){
        obj->insert("playLoop", QJsonValue(play_loop));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_m17_mode_isSet){
        obj->insert("m17Mode", QJsonValue(m17_mode));
    }
    if(m_audio_type_isSet){
        obj->insert("audioType", QJsonValue(audio_type));
    }
    if(m_packet_type_isSet){
        obj->insert("packetType", QJsonValue(packet_type));
    }
    if(audio_device_name != nullptr && *audio_device_name != QString("")){
        toJsonValue(QString("audioDeviceName"), audio_device_name, obj, QString("QString"));
    }
    if(feedback_audio_device_name != nullptr && *feedback_audio_device_name != QString("")){
        toJsonValue(QString("feedbackAudioDeviceName"), feedback_audio_device_name, obj, QString("QString"));
    }
    if(m_feedback_volume_factor_isSet){
        obj->insert("feedbackVolumeFactor", QJsonValue(feedback_volume_factor));
    }
    if(m_feedback_audio_enable_isSet){
        obj->insert("feedbackAudioEnable", QJsonValue(feedback_audio_enable));
    }
    if(m_stream_index_isSet){
        obj->insert("streamIndex", QJsonValue(stream_index));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }
    if(source_call != nullptr && *source_call != QString("")){
        toJsonValue(QString("sourceCall"), source_call, obj, QString("QString"));
    }
    if(dest_call != nullptr && *dest_call != QString("")){
        toJsonValue(QString("destCall"), dest_call, obj, QString("QString"));
    }
    if(m_insert_position_isSet){
        obj->insert("insertPosition", QJsonValue(insert_position));
    }
    if(m_can_isSet){
        obj->insert("can", QJsonValue(can));
    }
    if(sms_text != nullptr && *sms_text != QString("")){
        toJsonValue(QString("smsText"), sms_text, obj, QString("QString"));
    }
    if(m_loop_packet_isSet){
        obj->insert("loopPacket", QJsonValue(loop_packet));
    }
    if(m_loop_packet_interval_isSet){
        obj->insert("loopPacketInterval", QJsonValue(loop_packet_interval));
    }
    if(aprs_callsign != nullptr && *aprs_callsign != QString("")){
        toJsonValue(QString("aprsCallsign"), aprs_callsign, obj, QString("QString"));
    }
    if(aprs_to != nullptr && *aprs_to != QString("")){
        toJsonValue(QString("aprsTo"), aprs_to, obj, QString("QString"));
    }
    if(aprs_via != nullptr && *aprs_via != QString("")){
        toJsonValue(QString("aprsVia"), aprs_via, obj, QString("QString"));
    }
    if(aprs_data != nullptr && *aprs_data != QString("")){
        toJsonValue(QString("aprsData"), aprs_data, obj, QString("QString"));
    }
    if(m_aprs_insert_position_isSet){
        obj->insert("aprsInsertPosition", QJsonValue(aprs_insert_position));
    }
    if((channel_marker != nullptr) && (channel_marker->isSet())){
        toJsonValue(QString("channelMarker"), channel_marker, obj, QString("SWGChannelMarker"));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint64
SWGM17ModSettings::getInputFrequencyOffset() {
    return input_frequency_offset;
}
void
SWGM17ModSettings::setInputFrequencyOffset(qint64 input_frequency_offset) {
    this->input_frequency_offset = input_frequency_offset;
    this->m_input_frequency_offset_isSet = true;
}

float
SWGM17ModSettings::getRfBandwidth() {
    return rf_bandwidth;
}
void
SWGM17ModSettings::setRfBandwidth(float rf_bandwidth) {
    this->rf_bandwidth = rf_bandwidth;
    this->m_rf_bandwidth_isSet = true;
}

float
SWGM17ModSettings::getFmDeviation() {
    return fm_deviation;
}
void
SWGM17ModSettings::setFmDeviation(float fm_deviation) {
    this->fm_deviation = fm_deviation;
    this->m_fm_deviation_isSet = true;
}

float
SWGM17ModSettings::getToneFrequency() {
    return tone_frequency;
}
void
SWGM17ModSettings::setToneFrequency(float tone_frequency) {
    this->tone_frequency = tone_frequency;
    this->m_tone_frequency_isSet = true;
}

float
SWGM17ModSettings::getVolumeFactor() {
    return volume_factor;
}
void
SWGM17ModSettings::setVolumeFactor(float volume_factor) {
    this->volume_factor = volume_factor;
    this->m_volume_factor_isSet = true;
}

qint32
SWGM17ModSettings::getChannelMute() {
    return channel_mute;
}
void
SWGM17ModSettings::setChannelMute(qint32 channel_mute) {
    this->channel_mute = channel_mute;
    this->m_channel_mute_isSet = true;
}

qint32
SWGM17ModSettings::getPlayLoop() {
    return play_loop;
}
void
SWGM17ModSettings::setPlayLoop(qint32 play_loop) {
    this->play_loop = play_loop;
    this->m_play_loop_isSet = true;
}

qint32
SWGM17ModSettings::getRgbColor() {
    return rgb_color;
}
void
SWGM17ModSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

QString*
SWGM17ModSettings::getTitle() {
    return title;
}
void
SWGM17ModSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGM17ModSettings::getM17Mode() {
    return m17_mode;
}
void
SWGM17ModSettings::setM17Mode(qint32 m17_mode) {
    this->m17_mode = m17_mode;
    this->m_m17_mode_isSet = true;
}

qint32
SWGM17ModSettings::getAudioType() {
    return audio_type;
}
void
SWGM17ModSettings::setAudioType(qint32 audio_type) {
    this->audio_type = audio_type;
    this->m_audio_type_isSet = true;
}

qint32
SWGM17ModSettings::getPacketType() {
    return packet_type;
}
void
SWGM17ModSettings::setPacketType(qint32 packet_type) {
    this->packet_type = packet_type;
    this->m_packet_type_isSet = true;
}

QString*
SWGM17ModSettings::getAudioDeviceName() {
    return audio_device_name;
}
void
SWGM17ModSettings::setAudioDeviceName(QString* audio_device_name) {
    this->audio_device_name = audio_device_name;
    this->m_audio_device_name_isSet = true;
}

QString*
SWGM17ModSettings::getFeedbackAudioDeviceName() {
    return feedback_audio_device_name;
}
void
SWGM17ModSettings::setFeedbackAudioDeviceName(QString* feedback_audio_device_name) {
    this->feedback_audio_device_name = feedback_audio_device_name;
    this->m_feedback_audio_device_name_isSet = true;
}

float
SWGM17ModSettings::getFeedbackVolumeFactor() {
    return feedback_volume_factor;
}
void
SWGM17ModSettings::setFeedbackVolumeFactor(float feedback_volume_factor) {
    this->feedback_volume_factor = feedback_volume_factor;
    this->m_feedback_volume_factor_isSet = true;
}

qint32
SWGM17ModSettings::getFeedbackAudioEnable() {
    return feedback_audio_enable;
}
void
SWGM17ModSettings::setFeedbackAudioEnable(qint32 feedback_audio_enable) {
    this->feedback_audio_enable = feedback_audio_enable;
    this->m_feedback_audio_enable_isSet = true;
}

qint32
SWGM17ModSettings::getStreamIndex() {
    return stream_index;
}
void
SWGM17ModSettings::setStreamIndex(qint32 stream_index) {
    this->stream_index = stream_index;
    this->m_stream_index_isSet = true;
}

qint32
SWGM17ModSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGM17ModSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGM17ModSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGM17ModSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGM17ModSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGM17ModSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGM17ModSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGM17ModSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGM17ModSettings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGM17ModSettings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}

QString*
SWGM17ModSettings::getSourceCall() {
    return source_call;
}
void
SWGM17ModSettings::setSourceCall(QString* source_call) {
    this->source_call = source_call;
    this->m_source_call_isSet = true;
}

QString*
SWGM17ModSettings::getDestCall() {
    return dest_call;
}
void
SWGM17ModSettings::setDestCall(QString* dest_call) {
    this->dest_call = dest_call;
    this->m_dest_call_isSet = true;
}

qint32
SWGM17ModSettings::getInsertPosition() {
    return insert_position;
}
void
SWGM17ModSettings::setInsertPosition(qint32 insert_position) {
    this->insert_position = insert_position;
    this->m_insert_position_isSet = true;
}

qint32
SWGM17ModSettings::getCan() {
    return can;
}
void
SWGM17ModSettings::setCan(qint32 can) {
    this->can = can;
    this->m_can_isSet = true;
}

QString*
SWGM17ModSettings::getSmsText() {
    return sms_text;
}
void
SWGM17ModSettings::setSmsText(QString* sms_text) {
    this->sms_text = sms_text;
    this->m_sms_text_isSet = true;
}

qint32
SWGM17ModSettings::getLoopPacket() {
    return loop_packet;
}
void
SWGM17ModSettings::setLoopPacket(qint32 loop_packet) {
    this->loop_packet = loop_packet;
    this->m_loop_packet_isSet = true;
}

qint32
SWGM17ModSettings::getLoopPacketInterval() {
    return loop_packet_interval;
}
void
SWGM17ModSettings::setLoopPacketInterval(qint32 loop_packet_interval) {
    this->loop_packet_interval = loop_packet_interval;
    this->m_loop_packet_interval_isSet = true;
}

QString*
SWGM17ModSettings::getAprsCallsign() {
    return aprs_callsign;
}
void
SWGM17ModSettings::setAprsCallsign(QString* aprs_callsign) {
    this->aprs_callsign = aprs_callsign;
    this->m_aprs_callsign_isSet = true;
}

QString*
SWGM17ModSettings::getAprsTo() {
    return aprs_to;
}
void
SWGM17ModSettings::setAprsTo(QString* aprs_to) {
    this->aprs_to = aprs_to;
    this->m_aprs_to_isSet = true;
}

QString*
SWGM17ModSettings::getAprsVia() {
    return aprs_via;
}
void
SWGM17ModSettings::setAprsVia(QString* aprs_via) {
    this->aprs_via = aprs_via;
    this->m_aprs_via_isSet = true;
}

QString*
SWGM17ModSettings::getAprsData() {
    return aprs_data;
}
void
SWGM17ModSettings::setAprsData(QString* aprs_data) {
    this->aprs_data = aprs_data;
    this->m_aprs_data_isSet = true;
}

qint32
SWGM17ModSettings::getAprsInsertPosition() {
    return aprs_insert_position;
}
void
SWGM17ModSettings::setAprsInsertPosition(qint32 aprs_insert_position) {
    this->aprs_insert_position = aprs_insert_position;
    this->m_aprs_insert_position_isSet = true;
}

SWGChannelMarker*
SWGM17ModSettings::getChannelMarker() {
    return channel_marker;
}
void
SWGM17ModSettings::setChannelMarker(SWGChannelMarker* channel_marker) {
    this->channel_marker = channel_marker;
    this->m_channel_marker_isSet = true;
}

SWGRollupState*
SWGM17ModSettings::getRollupState() {
    return rollup_state;
}
void
SWGM17ModSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGM17ModSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_input_frequency_offset_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rf_bandwidth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fm_deviation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_tone_frequency_isSet){
            isObjectUpdated = true; break;
        }
        if(m_volume_factor_isSet){
            isObjectUpdated = true; break;
        }
        if(m_channel_mute_isSet){
            isObjectUpdated = true; break;
        }
        if(m_play_loop_isSet){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_m17_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_audio_type_isSet){
            isObjectUpdated = true; break;
        }
        if(m_packet_type_isSet){
            isObjectUpdated = true; break;
        }
        if(audio_device_name && *audio_device_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(feedback_audio_device_name && *feedback_audio_device_name != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_feedback_volume_factor_isSet){
            isObjectUpdated = true; break;
        }
        if(m_feedback_audio_enable_isSet){
            isObjectUpdated = true; break;
        }
        if(m_stream_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(source_call && *source_call != QString("")){
            isObjectUpdated = true; break;
        }
        if(dest_call && *dest_call != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_insert_position_isSet){
            isObjectUpdated = true; break;
        }
        if(m_can_isSet){
            isObjectUpdated = true; break;
        }
        if(sms_text && *sms_text != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_loop_packet_isSet){
            isObjectUpdated = true; break;
        }
        if(m_loop_packet_interval_isSet){
            isObjectUpdated = true; break;
        }
        if(aprs_callsign && *aprs_callsign != QString("")){
            isObjectUpdated = true; break;
        }
        if(aprs_to && *aprs_to != QString("")){
            isObjectUpdated = true; break;
        }
        if(aprs_via && *aprs_via != QString("")){
            isObjectUpdated = true; break;
        }
        if(aprs_data && *aprs_data != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_aprs_insert_position_isSet){
            isObjectUpdated = true; break;
        }
        if(channel_marker && channel_marker->isSet()){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

