/*  meterlog10.c

This file is part of a program that implements a Software-Defined Radio.

Copyright (C) 2013 Warren Pratt, NR0V
Copyright (C) 2024 Edouard Griffiths, F4EXB Adapted to SDRangel

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

The author can be reached by email at

warren@wpratt.com

*/

#include "comm.hpp"
#include "meterlog10.hpp"

namespace WDSP {

const int MemLog::mbits  = 11;
const int MemLog::mmask  = 2047;
const double MemLog::mconv = 0.301029995663981;
const double MemLog::mtable[2048] = {
0.0000000000000000e+000,  7.0426901124664325e-004,  1.4081943928083889e-003,  2.1117764798519820e-003,
2.8150156070540383e-003,  3.5179121086019987e-003,  4.2204663181950848e-003,  4.9226785690452447e-003,
5.6245491938781075e-003,  6.3260785249339207e-003,  7.0272668939685033e-003,  7.7281146322541816e-003,
8.4286220705807290e-003,  9.1287895392563011e-003,  9.8286173681083767e-003,  1.0528105886484680e-002,
1.1227255423254120e-002,  1.1926066306807714e-002,  1.2624538865059513e-002,  1.3322673425447519e-002,
1.4020470314934629e-002,  1.4717929860009516e-002,  1.5415052386687583e-002,  1.6111838220511852e-002,
1.6808287686553888e-002,  1.7504401109414709e-002,  1.8200178813225682e-002,  1.8895621121649452e-002,
1.9590728357880813e-002,  2.0285500844647641e-002,  2.0979938904211771e-002,  2.1674042858369907e-002,
2.2367813028454510e-002,  2.3061249735334684e-002,  2.3754353299417087e-002,  2.4447124040646806e-002,
2.5139562278508228e-002,  2.5831668332025957e-002,  2.6523442519765676e-002,  2.7214885159835025e-002,
2.7905996569884486e-002,  2.8596777067108246e-002,  2.9287226968245095e-002,  2.9977346589579280e-002,
3.0667136246941371e-002,  3.1356596255709142e-002,  3.2045726930808413e-002,  3.2734528586713947e-002,
3.3423001537450280e-002,  3.4111146096592597e-002,  3.4798962577267598e-002,  3.5486451292154303e-002,
3.6173612553484981e-002,  3.6860446673045943e-002,  3.7546953962178407e-002,  3.8233134731779347e-002,
3.8918989292302350e-002,  3.9604517953758425e-002,  4.0289721025716888e-002,  4.0974598817306154e-002,
4.1659151637214620e-002,  4.2343379793691460e-002,  4.3027283594547480e-002,  4.3710863347155952e-002,
4.4394119358453436e-002,  4.5077051934940590e-002,  4.5759661382683010e-002,  4.6441948007312085e-002,
4.7123912114025744e-002,  4.7805554007589353e-002,  4.8486873992336470e-002,  4.9167872372169713e-002,
4.9848549450561525e-002,  5.0528905530555022e-002,  5.1208940914764793e-002,  5.1888655905377674e-002,
5.2568050804153624e-002,  5.3247125912426453e-002,  5.3925881531104676e-002,  5.4604317960672298e-002,
5.5282435501189602e-002,  5.5960234452293950e-002,  5.6637715113200586e-002,  5.7314877782703437e-002,
5.7991722759175850e-002,  5.8668250340571465e-002,  5.9344460824424933e-002,  6.0020354507852730e-002,
6.0695931687553932e-002,  6.1371192659811009e-002,  6.2046137720490599e-002,  6.2720767165044267e-002,
6.3395081288509306e-002,  6.4069080385509486e-002,  6.4742764750255880e-002,  6.5416134676547555e-002,
6.6089190457772423e-002,  6.6761932386907946e-002,  6.7434360756521899e-002,  6.8106475858773191e-002,
6.8778277985412611e-002,  6.9449767427783499e-002,  7.0120944476822628e-002,  7.0791809423060917e-002,
7.1462362556624137e-002,  7.2132604167233730e-002,  7.2802534544207528e-002,  7.3472153976460494e-002,
7.4141462752505466e-002,  7.4810461160453992e-002,  7.5479149488016914e-002,  7.6147528022505254e-002,
7.6815597050830894e-002,  7.7483356859507274e-002,  7.8150807734650246e-002,  7.8817949961978662e-002,
7.9484783826815258e-002,  8.0151309614087257e-002,  8.0817527608327167e-002,  8.1483438093673519e-002,
8.2149041353871563e-002,  8.2814337672273974e-002,  8.3479327331841671e-002,  8.4144010615144385e-002,
8.4808387804361535e-002,  8.5472459181282878e-002,  8.6136225027309166e-002,  8.6799685623452999e-002,
8.7462841250339415e-002,  8.8125692188206650e-002,  8.8788238716906873e-002,  8.9450481115906866e-002,
9.0112419664288707e-002,  9.0774054640750543e-002,  9.1435386323607218e-002,  9.2096414990791034e-002,
9.2757140919852446e-002,  9.3417564387960714e-002,  9.4077685671904637e-002,  9.4737505048093279e-002,
9.5397022792556560e-002,  9.6056239180946093e-002,  9.6715154488535765e-002,  9.7373768990222445e-002,
9.8032082960526720e-002,  9.8690096673593519e-002,  9.9347810403192877e-002,  1.0000522442272053e-001,
1.0066233900519864e-001,  1.0131915442327648e-001,  1.0197567094923112e-001,  1.0263188885496805e-001,
1.0328780841202195e-001,  1.0394342989155728e-001,  1.0459875356436894e-001,  1.0525377970088309e-001,
1.0590850857115762e-001,  1.0656294044488293e-001,  1.0721707559138261e-001,  1.0787091427961401e-001,
1.0852445677816905e-001,  1.0917770335527474e-001,  1.0983065427879392e-001,  1.1048330981622587e-001,
1.1113567023470704e-001,  1.1178773580101162e-001,  1.1243950678155225e-001,  1.1309098344238065e-001,
1.1374216604918833e-001,  1.1439305486730712e-001,  1.1504365016170993e-001,  1.1569395219701137e-001,
1.1634396123746831e-001,  1.1699367754698069e-001,  1.1764310138909200e-001,  1.1829223302699000e-001,
1.1894107272350742e-001,  1.1958962074112245e-001,  1.2023787734195947e-001,  1.2088584278778969e-001,
1.2153351734003176e-001,  1.2218090125975241e-001,  1.2282799480766708e-001,  1.2347479824414055e-001,
1.2412131182918758e-001,  1.2476753582247349e-001,  1.2541347048331486e-001,  1.2605911607068010e-001,
1.2670447284319009e-001,  1.2734954105911880e-001,  1.2799432097639396e-001,  1.2863881285259751e-001,
1.2928301694496647e-001,  1.2992693351039331e-001,  1.3057056280542675e-001,  1.3121390508627229e-001,
1.3185696060879285e-001,  1.3249972962850928e-001,  1.3314221240060117e-001,  1.3378440917990725e-001,
1.3442632022092610e-001,  1.3506794577781681e-001,  1.3570928610439942e-001,  1.3635034145415567e-001,
1.3699111208022957e-001,  1.3763159823542795e-001,  1.3827180017222110e-001,  1.3891171814274328e-001,
1.3955135239879354e-001,  1.4019070319183608e-001,  1.4082977077300082e-001,  1.4146855539308437e-001,
1.4210705730255005e-001,  1.4274527675152901e-001,  1.4338321398982046e-001,  1.4402086926689242e-001,
1.4465824283188231e-001,  1.4529533493359742e-001,  1.4593214582051564e-001,  1.4656867574078589e-001,
1.4720492494222884e-001,  1.4784089367233738e-001,  1.4847658217827733e-001,  1.4911199070688783e-001,
1.4974711950468206e-001,  1.5038196881784779e-001,  1.5101653889224789e-001,  1.5165082997342097e-001,
1.5228484230658190e-001,  1.5291857613662249e-001,  1.5355203170811183e-001,  1.5418520926529714e-001,
1.5481810905210403e-001,  1.5545073131213735e-001,  1.5608307628868168e-001,  1.5671514422470162e-001,
1.5734693536284278e-001,  1.5797844994543206e-001,  1.5860968821447821e-001,  1.5924065041167257e-001,
1.5987133677838941e-001,  1.6050174755568664e-001,  1.6113188298430628e-001,  1.6176174330467505e-001,
1.6239132875690487e-001,  1.6302063958079349e-001,  1.6364967601582500e-001,  1.6427843830117031e-001,
1.6490692667568779e-001,  1.6553514137792383e-001,  1.6616308264611326e-001,  1.6679075071818000e-001,
1.6741814583173756e-001,  1.6804526822408961e-001,  1.6867211813223043e-001,  1.6929869579284559e-001,
1.6992500144231237e-001,  1.7055103531670032e-001,  1.7117679765177185e-001,  1.7180228868298272e-001,
1.7242750864548248e-001,  1.7305245777411524e-001,  1.7367713630341988e-001,  1.7430154446763094e-001,
1.7492568250067883e-001,  1.7554955063619046e-001,  1.7617314910748991e-001,  1.7679647814759875e-001,
1.7741953798923660e-001,  1.7804232886482183e-001,  1.7866485100647178e-001,  1.7928710464600359e-001,
1.7990909001493446e-001,  1.8053080734448240e-001,  1.8115225686556649e-001,  1.8177343880880761e-001,
1.8239435340452886e-001,  1.8301500088275607e-001,  1.8363538147321837e-001,  1.8425549540534858e-001,
1.8487534290828386e-001,  1.8549492421086611e-001,  1.8611423954164258e-001,  1.8673328912886625e-001,
1.8735207320049643e-001,  1.8797059198419924e-001,  1.8858884570734810e-001,  1.8920683459702425e-001,
1.8982455888001723e-001,  1.9044201878282538e-001,  1.9105921453165634e-001,  1.9167614635242758e-001,
1.9229281447076688e-001,  1.9290921911201278e-001,  1.9352536050121508e-001,  1.9414123886313550e-001,
1.9475685442224788e-001,  1.9537220740273889e-001,  1.9598729802850845e-001,  1.9660212652317025e-001,
1.9721669311005219e-001,  1.9783099801219684e-001,  1.9844504145236205e-001,  1.9905882365302136e-001,
1.9967234483636440e-001,  2.0028560522429753e-001,  2.0089860503844420e-001,  2.0151134450014555e-001,
2.0212382383046071e-001,  2.0273604325016748e-001,  2.0334800297976266e-001,  2.0395970323946255e-001,
2.0457114424920361e-001,  2.0518232622864258e-001,  2.0579324939715726e-001,  2.0640391397384683e-001,
2.0701432017753244e-001,  2.0762446822675754e-001,  2.0823435833978840e-001,  2.0884399073461471e-001,
2.0945336562894978e-001,  2.1006248324023125e-001,  2.1067134378562147e-001,  2.1127994748200787e-001,
2.1188829454600366e-001,  2.1249638519394801e-001,  2.1310421964190671e-001,  2.1371179810567254e-001,
2.1431912080076582e-001,  2.1492618794243468e-001,  2.1553299974565579e-001,  2.1613955642513461e-001,
2.1674585819530584e-001,  2.1735190527033405e-001,  2.1795769786411398e-001,  2.1856323619027099e-001,
2.1916852046216157e-001,  2.1977355089287390e-001,  2.2037832769522800e-001,  2.2098285108177657e-001,
2.2158712126480504e-001,  2.2219113845633220e-001,  2.2279490286811091e-001,  2.2339841471162797e-001,
2.2400167419810504e-001,  2.2460468153849889e-001,  2.2520743694350198e-001,  2.2580994062354257e-001,
2.2641219278878566e-001,  2.2701419364913295e-001,  2.2761594341422362e-001,  2.2821744229343452e-001,
2.2881869049588088e-001,  2.2941968823041642e-001,  2.3002043570563410e-001,  2.3062093312986631e-001,
2.3122118071118541e-001,  2.3182117865740429e-001,  2.3242092717607646e-001,  2.3302042647449686e-001,
2.3361967675970208e-001,  2.3421867823847067e-001,  2.3481743111732398e-001,  2.3541593560252616e-001,
2.3601419190008480e-001,  2.3661220021575136e-001,  2.3720996075502146e-001,  2.3780747372313552e-001,
2.3840473932507891e-001,  2.3900175776558261e-001,  2.3959852924912356e-001,  2.4019505397992494e-001,
2.4079133216195686e-001,  2.4138736399893651e-001,  2.4198314969432871e-001,  2.4257868945134642e-001,
2.4317398347295091e-001,  2.4376903196185237e-001,  2.4436383512051027e-001,  2.4495839315113374e-001,
2.4555270625568210e-001,  2.4614677463586504e-001,  2.4674059849314325e-001,  2.4733417802872884e-001,
2.4792751344358549e-001,  2.4852060493842920e-001,  2.4911345271372837e-001,  2.4970605696970449e-001,
2.5029841790633245e-001,  2.5089053572334064e-001,  2.5148241062021204e-001,  2.5207404279618389e-001,
2.5266543245024864e-001,  2.5325657978115390e-001,  2.5384748498740323e-001,  2.5443814826725630e-001,
2.5502856981872951e-001,  2.5561874983959609e-001,  2.5620868852738665e-001,  2.5679838607938965e-001,
2.5738784269265180e-001,  2.5797705856397818e-001,  2.5856603388993293e-001,  2.5915476886683958e-001,
2.5974326369078155e-001,  2.6033151855760200e-001,  2.6091953366290499e-001,  2.6150730920205539e-001,
2.6209484537017941e-001,  2.6268214236216481e-001,  2.6326920037266166e-001,  2.6385601959608235e-001,
2.6444260022660221e-001,  2.6502894245815983e-001,  2.6561504648445733e-001,  2.6620091249896100e-001,
2.6678654069490132e-001,  2.6737193126527387e-001,  2.6795708440283911e-001,  2.6854200030012310e-001,
2.6912667914941790e-001,  2.6971112114278190e-001,  2.7029532647204002e-001,  2.7087929532878435e-001,
2.7146302790437460e-001,  2.7204652438993787e-001,  2.7262978497636975e-001,  2.7321280985433433e-001,
2.7379559921426466e-001,  2.7437815324636305e-001,  2.7496047214060154e-001,  2.7554255608672223e-001,
2.7612440527423759e-001,  2.7670601989243088e-001,  2.7728740013035663e-001,  2.7786854617684087e-001,
2.7844945822048139e-001,  2.7903013644964852e-001,  2.7961058105248499e-001,  2.8019079221690657e-001,
2.8077077013060253e-001,  2.8135051498103575e-001,  2.8193002695544328e-001,  2.8250930624083653e-001,
2.8308835302400187e-001,  2.8366716749150073e-001,  2.8424574982967005e-001,  2.8482410022462290e-001,
2.8540221886224837e-001,  2.8598010592821227e-001,  2.8655776160795737e-001,  2.8713518608670380e-001,
2.8771237954944939e-001,  2.8828934218096997e-001,  2.8886607416581983e-001,  2.8944257568833187e-001,
2.9001884693261837e-001,  2.9059488808257078e-001,  2.9117069932186052e-001,  2.9174628083393922e-001,
2.9232163280203893e-001,  2.9289675540917259e-001,  2.9347164883813431e-001,  2.9404631327149994e-001,
2.9462074889162698e-001,  2.9519495588065547e-001,  2.9576893442050778e-001,  2.9634268469288944e-001,
2.9691620687928921e-001,  2.9748950116097944e-001,  2.9806256771901651e-001,  2.9863540673424116e-001,
2.9920801838727878e-001,  2.9978040285853974e-001,  3.0035256032821983e-001,  3.0092449097630042e-001,
3.0149619498254898e-001,  3.0206767252651939e-001,  3.0263892378755225e-001,  3.0320994894477510e-001,
3.0378074817710293e-001,  3.0435132166323847e-001,  3.0492166958167249e-001,  3.0549179211068411e-001,
3.0606168942834128e-001,  3.0663136171250094e-001,  3.0720080914080944e-001,  3.0777003189070284e-001,
3.0833903013940728e-001,  3.0890780406393920e-001,  3.0947635384110589e-001,  3.1004467964750571e-001,
3.1061278165952821e-001,  3.1118066005335476e-001,  3.1174831500495892e-001,  3.1231574669010626e-001,
3.1288295528435539e-001,  3.1344994096305762e-001,  3.1401670390135794e-001,  3.1458324427419465e-001,
3.1514956225630036e-001,  3.1571565802220181e-001,  3.1628153174622031e-001,  3.1684718360247227e-001,
3.1741261376486940e-001,  3.1797782240711886e-001,  3.1854280970272381e-001,  3.1910757582498367e-001,
3.1967212094699443e-001,  3.2023644524164885e-001,  3.2080054888163700e-001,  3.2136443203944637e-001,
3.2192809488736235e-001,  3.2249153759746840e-001,  3.2305476034164660e-001,  3.2361776329157749e-001,
3.2418054661874102e-001,  3.2474311049441640e-001,  3.2530545508968250e-001,  3.2586758057541831e-001,
3.2642948712230313e-001,  3.2699117490081686e-001,  3.2755264408124046e-001,  3.2811389483365605e-001,
3.2867492732794734e-001,  3.2923574173379999e-001,  3.2979633822070181e-001,  3.3035671695794311e-001,
3.3091687811461695e-001,  3.3147682185961974e-001,  3.3203654836165097e-001,  3.3259605778921408e-001,
3.3315535031061649e-001,  3.3371442609396990e-001,  3.3427328530719069e-001,  3.3483192811800017e-001,
3.3539035469392492e-001,  3.3594856520229699e-001,  3.3650655981025435e-001,  3.3706433868474101e-001,
3.3762190199250752e-001,  3.3817924990011117e-001,  3.3873638257391619e-001,  3.3929330018009435e-001,
3.3985000288462475e-001,  3.4040649085329461e-001,  3.4096276425169947e-001,  3.4151882324524319e-001,
3.4207466799913855e-001,  3.4263029867840739e-001,  3.4318571544788107e-001,  3.4374091847220056e-001,
3.4429590791581688e-001,  3.4485068394299118e-001,  3.4540524671779538e-001,  3.4595959640411222e-001,
3.4651373316563550e-001,  3.4706765716587057e-001,  3.4762136856813453e-001,  3.4817486753555638e-001,
3.4872815423107756e-001,  3.4928122881745205e-001,  3.4983409145724681e-001,  3.5038674231284189e-001,
3.5093918154643078e-001,  3.5149140932002076e-001,  3.5204342579543318e-001,  3.5259523113430374e-001,
3.5314682549808257e-001,  3.5369820904803478e-001,  3.5424938194524075e-001,  3.5480034435059621e-001,
3.5535109642481261e-001,  3.5590163832841742e-001,  3.5645197022175457e-001,  3.5700209226498419e-001,
3.5755200461808367e-001,  3.5810170744084729e-001,  3.5865120089288688e-001,  3.5920048513363184e-001,
3.5974956032232963e-001,  3.6029842661804584e-001,  3.6084708417966471e-001,  3.6139553316588924e-001,
3.6194377373524150e-001,  3.6249180604606285e-001,  3.6303963025651437e-001,  3.6358724652457697e-001,
3.6413465500805176e-001,  3.6468185586456020e-001,  3.6522884925154470e-001,  3.6577563532626839e-001,
3.6632221424581579e-001,  3.6686858616709295e-001,  3.6741475124682760e-001,  3.6796070964156979e-001,
3.6850646150769167e-001,  3.6905200700138807e-001,  3.6959734627867674e-001,  3.7014247949539852e-001,
3.7068740680721768e-001,  3.7123212836962216e-001,  3.7177664433792384e-001,  3.7232095486725891e-001,
3.7286506011258774e-001,  3.7340896022869580e-001,  3.7395265537019334e-001,  3.7449614569151596e-001,
3.7503943134692475e-001,  3.7558251249050661e-001,  3.7612538927617450e-001,  3.7666806185766766e-001,
3.7721053038855196e-001,  3.7775279502222003e-001,  3.7829485591189177e-001,  3.7883671321061424e-001,
3.7937836707126216e-001,  3.7991981764653820e-001,  3.8046106508897315e-001,  3.8100210955092612e-001,
3.8154295118458498e-001,  3.8208359014196641e-001,  3.8262402657491629e-001,  3.8316426063510989e-001,
3.8370429247405224e-001,  3.8424412224307819e-001,  3.8478375009335281e-001,  3.8532317617587164e-001,
3.8586240064146093e-001,  3.8640142364077773e-001,  3.8694024532431054e-001,  3.8747886584237901e-001,
3.8801728534513480e-001,  3.8855550398256117e-001,  3.8909352190447394e-001,  3.8963133926052113e-001,
3.9016895620018355e-001,  3.9070637287277493e-001,  3.9124358942744231e-001,  3.9178060601316611e-001,
3.9231742277876025e-001,  3.9285403987287298e-001,  3.9339045744398649e-001,  3.9392667564041739e-001,
3.9446269461031708e-001,  3.9499851450167184e-001,  3.9553413546230315e-001,  3.9606955763986784e-001,
3.9660478118185849e-001,  3.9713980623560352e-001,  3.9767463294826755e-001,  3.9820926146685159e-001,
3.9874369193819326e-001,  3.9927792450896704e-001,  3.9981195932568453e-001,  4.0034579653469476e-001,
4.0087943628218431e-001,  4.0141287871417763e-001,  4.0194612397653712e-001,  4.0247917221496371e-001,
4.0301202357499677e-001,  4.0354467820201440e-001,  4.0407713624123393e-001,  4.0460939783771172e-001,
4.0514146313634392e-001,  4.0567333228186608e-001,  4.0620500541885413e-001,  4.0673648269172391e-001,
4.0726776424473182e-001,  4.0779885022197493e-001,  4.0832974076739126e-001,  4.0886043602476002e-001,
4.0939093613770178e-001,  4.0992124124967860e-001,  4.1045135150399464e-001,  4.1098126704379601e-001,
4.1151098801207114e-001,  4.1204051455165103e-001,  4.1256984680520947e-001,  4.1309898491526326e-001,
4.1362792902417245e-001,  4.1415667927414057e-001,  4.1468523580721478e-001,  4.1521359876528630e-001,
4.1574176829009046e-001,  4.1626974452320686e-001,  4.1679752760605998e-001,  4.1732511767991892e-001,
4.1785251488589781e-001,  4.1837971936495644e-001,  4.1890673125789957e-001,  4.1943355070537813e-001,
4.1996017784788903e-001,  4.2048661282577515e-001,  4.2101285577922587e-001,  4.2153890684827733e-001,
4.2206476617281236e-001,  4.2259043389256096e-001,  4.2311591014710065e-001,  4.2364119507585613e-001,
4.2416628881810009e-001,  4.2469119151295320e-001,  4.2521590329938430e-001,  4.2574042431621051e-001,
4.2626475470209790e-001,  4.2678889459556119e-001,  4.2731284413496412e-001,  4.2783660345851998e-001,
4.2836017270429139e-001,  4.2888355201019068e-001,  4.2940674151398039e-001,  4.2992974135327294e-001,
4.3045255166553137e-001,  4.3097517258806928e-001,  4.3149760425805095e-001,  4.3201984681249178e-001,
4.3254190038825852e-001,  4.3306376512206940e-001,  4.3358544115049413e-001,  4.3410692860995465e-001,
4.3462822763672460e-001,  4.3514933836693043e-001,  4.3567026093655065e-001,  4.3619099548141693e-001,
4.3671154213721369e-001,  4.3723190103947868e-001,  4.3775207232360275e-001,  4.3827205612483067e-001,
4.3879185257826087e-001,  4.3931146181884595e-001,  4.3983088398139258e-001,  4.4035011920056194e-001,
4.4086916761086975e-001,  4.4138802934668692e-001,  4.4190670454223913e-001,  4.4242519333160735e-001,
4.4294349584872833e-001,  4.4346161222739416e-001,  4.4397954260125300e-001,  4.4449728710380915e-001,
4.4501484586842310e-001,  4.4553221902831214e-001,  4.4604940671654997e-001,  4.4656640906606732e-001,
4.4708322620965224e-001,  4.4759985827994986e-001,  4.4811630540946312e-001,  4.4863256773055249e-001,
4.4914864537543642e-001,  4.4966453847619164e-001,  4.5018024716475330e-001,  4.5069577157291496e-001,
4.5121111183232882e-001,  4.5172626807450633e-001,  4.5224124043081809e-001,  4.5275602903249390e-001,
4.5327063401062317e-001,  4.5378505549615517e-001,  4.5429929361989918e-001,  4.5481334851252442e-001,
4.5532722030456074e-001,  4.5584090912639835e-001,  4.5635441510828845e-001,  4.5686773838034306e-001,
4.5738087907253527e-001,  4.5789383731469985e-001,  4.5840661323653270e-001,  4.5891920696759192e-001,
4.5943161863729726e-001,  4.5994384837493074e-001,  4.6045589630963657e-001,  4.6096776257042177e-001,
4.6147944728615592e-001,  4.6199095058557149e-001,  4.6250227259726412e-001,  4.6301341344969293e-001,
4.6352437327118023e-001,  4.6403515218991237e-001,  4.6454575033393936e-001,  4.6505616783117537e-001,
4.6556640480939882e-001,  4.6607646139625275e-001,  4.6658633771924468e-001,  4.6709603390574705e-001,
4.6760555008299742e-001,  4.6811488637809856e-001,  4.6862404291801857e-001,  4.6913301982959116e-001,
4.6964181723951609e-001,  4.7015043527435896e-001,  4.7065887406055135e-001,  4.7116713372439167e-001,
4.7167521439204446e-001,  4.7218311618954112e-001,  4.7269083924278038e-001,  4.7319838367752748e-001,
4.7370574961941531e-001,  4.7421293719394425e-001,  4.7471994652648242e-001,  4.7522677774226557e-001,
4.7573343096639775e-001,  4.7623990632385116e-001,  4.7674620393946637e-001,  4.7725232393795269e-001,
4.7775826644388808e-001,  4.7826403158171960e-001,  4.7876961947576346e-001,  4.7927503025020518e-001,
4.7978026402909968e-001,  4.8028532093637188e-001,  4.8079020109581644e-001,  4.8129490463109803e-001,
4.8179943166575173e-001,  4.8230378232318288e-001,  4.8280795672666771e-001,  4.8331195499935287e-001,
4.8381577726425645e-001,  4.8431942364426717e-001,  4.8482289426214564e-001,  4.8532618924052362e-001,
4.8582930870190477e-001,  4.8633225276866437e-001,  4.8683502156305014e-001,  4.8733761520718172e-001,
4.8784003382305130e-001,  4.8834227753252368e-001,  4.8884434645733643e-001,  4.8934624071909993e-001,
4.8984796043929779e-001,  4.9034950573928698e-001,  4.9085087674029787e-001,  4.9135207356343452e-001,
4.9185309632967472e-001,  4.9235394515987035e-001,  4.9285462017474752e-001,  4.9335512149490657e-001,
4.9385544924082253e-001,  4.9435560353284480e-001,  4.9485558449119810e-001,  4.9535539223598191e-001,
4.9585502688717098e-001,  4.9635448856461545e-001,  4.9685377738804115e-001,  4.9735289347704947e-001,
4.9785183695111779e-001,  4.9835060792959962e-001,  4.9884920653172460e-001,  4.9934763287659895e-001,
4.9984588708320532e-001,  5.0034396927040325e-001,  5.0084187955692927e-001,  5.0133961806139682e-001,
5.0183718490229678e-001,  5.0233458019799737e-001,  5.0283180406674444e-001,  5.0332885662666160e-001,
5.0382573799575070e-001,  5.0432244829189121e-001,  5.0481898763284128e-001,  5.0531535613623724e-001,
5.0581155391959443e-001,  5.0630758110030638e-001,  5.0680343779564618e-001,  5.0729912412276579e-001,
5.0779464019869625e-001,  5.0828998614034848e-001,  5.0878516206451252e-001,  5.0928016808785881e-001,
5.0977500432693701e-001,  5.1026967089817765e-001,  5.1076416791789092e-001,  5.1125849550226776e-001,
5.1175265376737955e-001,  5.1224664282917876e-001,  5.1274046280349828e-001,  5.1323411380605266e-001,
5.1372759595243733e-001,  5.1422090935812914e-001,  5.1471405413848692e-001,  5.1520703040875060e-001,
5.1569983828404242e-001,  5.1619247787936684e-001,  5.1668494930961018e-001,  5.1717725268954140e-001,
5.1766938813381191e-001,  5.1816135575695565e-001,  5.1865315567338988e-001,  5.1914478799741448e-001,
5.1963625284321280e-001,  5.2012755032485114e-001,  5.2061868055627991e-001,  5.2110964365133250e-001,
5.2160043972372672e-001,  5.2209106888706402e-001,  5.2258153125483009e-001,  5.2307182694039489e-001,
5.2356195605701283e-001,  5.2405191871782297e-001,  5.2454171503584923e-001,  5.2503134512400018e-001,
5.2552080909506971e-001,  5.2601010706173679e-001,  5.2649923913656593e-001,  5.2698820543200708e-001,
5.2747700606039605e-001,  5.2796564113395417e-001,  5.2845411076478921e-001,  5.2894241506489481e-001,
5.2943055414615103e-001,  5.2991852812032414e-001,  5.3040633709906770e-001,  5.3089398119392139e-001,
5.3138146051631208e-001,  5.3186877517755382e-001,  5.3235592528884768e-001,  5.3284291096128233e-001,
5.3332973230583380e-001,  5.3381638943336596e-001,  5.3430288245463053e-001,  5.3478921148026692e-001,
5.3527537662080327e-001,  5.3576137798665546e-001,  5.3624721568812816e-001,  5.3673288983541445e-001,
5.3721840053859626e-001,  5.3770374790764430e-001,  5.3818893205241869e-001,  5.3867395308266830e-001,
5.3915881110803132e-001,  5.3964350623803614e-001,  5.4012803858209990e-001,  5.4061240824953005e-001,
5.4109661534952391e-001,  5.4158065999116878e-001,  5.4206454228344236e-001,  5.4254826233521247e-001,
5.4303182025523777e-001,  5.4351521615216736e-001,  5.4399845013454129e-001,  5.4448152231079050e-001,
5.4496443278923712e-001,  5.4544718167809458e-001,  5.4592976908546731e-001,  5.4641219511935213e-001,
5.4689445988763674e-001,  5.4737656349810093e-001,  5.4785850605841668e-001,  5.4834028767614795e-001,
5.4882190845875112e-001,  5.4930336851357453e-001,  5.4978466794785952e-001,  5.5026580686874027e-001,
5.5074678538324318e-001,  5.5122760359828826e-001,  5.5170826162068842e-001,  5.5218875955714974e-001,
5.5266909751427185e-001,  5.5314927559854776e-001,  5.5362929391636462e-001,  5.5410915257400295e-001,
5.5458885167763738e-001,  5.5506839133333685e-001,  5.5554777164706448e-001,  5.5602699272467748e-001,
5.5650605467192815e-001,  5.5698495759446309e-001,  5.5746370159782399e-001,  5.5794228678744717e-001,
5.5842071326866427e-001,  5.5889898114670222e-001,  5.5937709052668327e-001,  5.5985504151362508e-001,
5.6033283421244118e-001,  5.6081046872794083e-001,  5.6128794516482916e-001,  5.6176526362770718e-001,
5.6224242422107273e-001,  5.6271942704931921e-001,  5.6319627221673718e-001,  5.6367295982751342e-001,
5.6414948998573167e-001,  5.6462586279537241e-001,  5.6510207836031323e-001,  5.6557813678432900e-001,
5.6605403817109168e-001,  5.6652978262417075e-001,  5.6700537024703346e-001,  5.6748080114304444e-001,
5.6795607541546633e-001,  5.6843119316745983e-001,  5.6890615450208348e-001,  5.6938095952229439e-001,
5.6985560833094784e-001,  5.7033010103079773e-001,  5.7080443772449674e-001,  5.7127861851459583e-001,
5.7175264350354538e-001,  5.7222651279369474e-001,  5.7270022648729224e-001,  5.7317378468648561e-001,
5.7364718749332200e-001,  5.7412043500974841e-001,  5.7459352733761093e-001,  5.7506646457865618e-001,
5.7553924683453039e-001,  5.7601187420678002e-001,  5.7648434679685145e-001,  5.7695666470609186e-001,
5.7742882803574869e-001,  5.7790083688696992e-001,  5.7837269136080471e-001,  5.7884439155820244e-001,
5.7931593758001410e-001,  5.7978732952699152e-001,  5.8025856749978777e-001,  5.8072965159895773e-001,
5.8120058192495705e-001,  5.8167135857814389e-001,  5.8214198165877751e-001,  5.8261245126701955e-001,
5.8308276750293342e-001,  5.8355293046648482e-001,  5.8402294025754176e-001,  5.8449279697587453e-001,
5.8496250072115619e-001,  5.8543205159296230e-001,  5.8590144969077129e-001,  5.8637069511396456e-001,
5.8683978796182656e-001,  5.8730872833354475e-001,  5.8777751632821018e-001,  5.8824615204481723e-001,
5.8871463558226367e-001,  5.8918296703935125e-001,  5.8965114651478534e-001,  5.9011917410717518e-001,
5.9058704991503430e-001,  5.9105477403678031e-001,  5.9152234657073499e-001,  5.9198976761512467e-001,
5.9245703726808041e-001,  5.9292415562763767e-001,  5.9339112279173689e-001,  5.9385793885822336e-001,
5.9432460392484743e-001,  5.9479111808926455e-001,  5.9525748144903567e-001,  5.9572369410162695e-001,
5.9618975614441028e-001,  5.9665566767466305e-001,  5.9712142878956842e-001,  5.9758703958621573e-001,
5.9805250016159994e-001,  5.9851781061262244e-001,  5.9898297103609077e-001,  5.9944798152871903e-001,
5.9991284218712770e-001,  6.0037755310784380e-001,  6.0084211438730128e-001,  6.0130652612184077e-001,
6.0177078840771003e-001,  6.0223490134106406e-001,  6.0269886501796488e-001,  6.0316267953438185e-001,
6.0362634498619194e-001,  6.0408986146917965e-001,  6.0455322907903697e-001,  6.0501644791136422e-001,
6.0547951806166922e-001,  6.0594243962536798e-001,  6.0640521269778469e-001,  6.0686783737415195e-001,
6.0733031374961077e-001,  6.0779264191921034e-001,  6.0825482197790881e-001,  6.0871685402057329e-001,
6.0917873814197931e-001,  6.0964047443681180e-001,  6.1010206299966441e-001,  6.1056350392504044e-001,
6.1102479730735226e-001,  6.1148594324092187e-001,  6.1194694181998066e-001,  6.1240779313866989e-001,
6.1286849729104065e-001,  6.1332905437105378e-001,  6.1378946447258032e-001,  6.1424972768940123e-001,
6.1470984411520824e-001,  6.1516981384360292e-001,  6.1562963696809758e-001,  6.1608931358211516e-001,
6.1654884377898933e-001,  6.1700822765196461e-001,  6.1746746529419627e-001,  6.1792655679875097e-001,
6.1838550225860645e-001,  6.1884430176665151e-001,  6.1930295541568670e-001,  6.1976146329842374e-001,
6.2021982550748633e-001,  6.2067804213540978e-001,  6.2113611327464113e-001,  6.2159403901753962e-001,
6.2205181945637633e-001,  6.2250945468333463e-001,  6.2296694479051018e-001,  6.2342428986991139e-001,
6.2388149001345850e-001,  6.2433854531298505e-001,  6.2479545586023699e-001,  6.2525222174687300e-001,
6.2570884306446528e-001,  6.2616531990449842e-001,  6.2662165235837075e-001,  6.2707784051739368e-001,
6.2753388447279190e-001,  6.2798978431570363e-001,  6.2844554013718112e-001,  6.2890115202818997e-001,
6.2935662007960957e-001,  6.2981194438223365e-001,  6.3026712502676951e-001,  6.3072216210383913e-001,
6.3117705570397842e-001,  6.3163180591763768e-001,  6.3208641283518197e-001,  6.3254087654689062e-001,
6.3299519714295782e-001,  6.3344937471349272e-001,  6.3390340934851908e-001,  6.3435730113797606e-001,
6.3481105017171768e-001,  6.3526465653951336e-001,  6.3571812033104769e-001,  6.3617144163592099e-001,
6.3662462054364888e-001,  6.3707765714366271e-001,  6.3753055152530980e-001,  6.3798330377785317e-001,
6.3843591399047173e-001,  6.3888838225226086e-001,  6.3934070865223169e-001,  6.3979289327931199e-001,
6.4024493622234580e-001,  6.4069683757009366e-001,  6.4114859741123253e-001,  6.4160021583435678e-001,
6.4205169292797670e-001,  6.4250302878052035e-001,  6.4295422348033204e-001,  6.4340527711567386e-001,
6.4385618977472470e-001,  6.4430696154558109e-001,  6.4475759251625697e-001,  6.4520808277468356e-001,
6.4565843240871013e-001,  6.4610864150610336e-001,  6.4655871015454802e-001,  6.4700863844164680e-001,
6.4745842645492035e-001,  6.4790807428180752e-001,  6.4835758200966542e-001,  6.4880694972576980e-001,
6.4925617751731446e-001,  6.4970526547141205e-001,  6.5015421367509374e-001,  6.5060302221530975e-001,
6.5105169117892858e-001,  6.5150022065273849e-001,  6.5194861072344634e-001,  6.5239686147767806e-001,
6.5284497300197930e-001,  6.5329294538281479e-001,  6.5374077870656877e-001,  6.5418847305954508e-001,
6.5463602852796732e-001,  6.5508344519797879e-001,  6.5553072315564265e-001,  6.5597786248694212e-001,
6.5642486327778027e-001,  6.5687172561398077e-001,  6.5731844958128727e-001,  6.5776503526536367e-001,
6.5821148275179464e-001,  6.5865779212608544e-001,  6.5910396347366162e-001,  6.5954999687986982e-001,
6.5999589242997758e-001,  6.6044165020917311e-001,  6.6088727030256589e-001,  6.6133275279518655e-001,
6.6177809777198704e-001,  6.6222330531784046e-001,  6.6266837551754154e-001,  6.6311330845580641e-001,
6.6355810421727301e-001,  6.6400276288650084e-001,  6.6444728454797142e-001,  6.6489166928608812e-001,
6.6533591718517626e-001,  6.6578002832948335e-001,  6.6622400280317917e-001,  6.6666784069035590e-001,
6.6711154207502776e-001,  6.6755510704113186e-001,  6.6799853567252787e-001,  6.6844182805299779e-001,
6.6888498426624710e-001,  6.6932800439590334e-001,  6.6977088852551769e-001,  6.7021363673856416e-001,
6.7065624911843991e-001,  6.7109872574846541e-001,  6.7154106671188440e-001,  6.7198327209186415e-001,
6.7242534197149562e-001,  6.7286727643379307e-001,  6.7330907556169495e-001,  6.7375073943806307e-001,
6.7419226814568345e-001,  6.7463366176726602e-001,  6.7507492038544492e-001,  6.7551604408277832e-001,
6.7595703294174880e-001,  6.7639788704476345e-001,  6.7683860647415350e-001,  6.7727919131217496e-001,
6.7771964164100862e-001,  6.7815995754275982e-001,  6.7860013909945882e-001,  6.7904018639306085e-001,
6.7948009950544597e-001,  6.7991987851841984e-001,  6.8035952351371276e-001,  6.8079903457298063e-001,
6.8123841177780486e-001,  6.8167765520969192e-001,  6.8211676495007434e-001,  6.8255574108031014e-001,
6.8299458368168287e-001,  6.8343329283540233e-001,  6.8387186862260385e-001,  6.8431031112434904e-001,
6.8474862042162565e-001,  6.8518679659534754e-001,  6.8562483972635480e-001,  6.8606274989541416e-001,
6.8650052718321841e-001,  6.8693817167038729e-001,  6.8737568343746713e-001,  6.8781306256493080e-001,
6.8825030913317820e-001,  6.8868742322253595e-001,  6.8912440491325799e-001,  6.8956125428552517e-001,
6.8999797141944541e-001,  6.9043455639505402e-001,  6.9087100929231382e-001,  6.9130733019111479e-001,
6.9174351917127475e-001,  6.9217957631253879e-001,  6.9261550169458008e-001,  6.9305129539699928e-001,
6.9348695749932521e-001,  6.9392248808101453e-001,  6.9435788722145175e-001,  6.9479315499995009e-001,
6.9522829149575038e-001,  6.9566329678802219e-001,  6.9609817095586313e-001,  6.9653291407829987e-001,
6.9696752623428715e-001,  6.9740200750270842e-001,  6.9783635796237620e-001,  6.9827057769203149e-001,
6.9870466677034448e-001,  6.9913862527591430e-001,  6.9957245328726902e-001,  7.0000615088286611e-001,
7.0043971814109218e-001,  7.0087315514026305e-001,  7.0130646195862456e-001,  7.0173963867435107e-001,
7.0217268536554767e-001,  7.0260560211024814e-001,  7.0303838898641680e-001,  7.0347104607194733e-001,
7.0390357344466359e-001,  7.0433597118231950e-001,  7.0476823936259880e-001,  7.0520037806311564e-001,
7.0563238736141454e-001,  7.0606426733497030e-001,  7.0649601806118789e-001,  7.0692763961740335e-001,
7.0735913208088275e-001,  7.0779049552882334e-001,  7.0822173003835265e-001,  7.0865283568652959e-001,
7.0908381255034381e-001,  7.0951466070671576e-001,  7.0994538023249720e-001,  7.1037597120447105e-001,
7.1080643369935159e-001,  7.1123676779378442e-001,  7.1166697356434627e-001,  7.1209705108754584e-001,
7.1252700043982320e-001,  7.1295682169755015e-001,  7.1338651493703009e-001,  7.1381608023449850e-001,
7.1424551766612254e-001,  7.1467482730800180e-001,  7.1510400923616735e-001,  7.1553306352658286e-001,
7.1596199025514418e-001,  7.1639078949767943e-001,  7.1681946132994900e-001,  7.1724800582764603e-001,
7.1767642306639601e-001,  7.1810471312175739e-001,  7.1853287606922078e-001,  7.1896091198421030e-001,
7.1938882094208223e-001,  7.1981660301812656e-001,  7.2024425828756578e-001,  7.2067178682555566e-001,
7.2109918870718503e-001,  7.2152646400747666e-001,  7.2195361280138581e-001,  7.2238063516380147e-001,
7.2280753116954666e-001,  7.2323430089337726e-001,  7.2366094440998319e-001,  7.2408746179398831e-001,
7.2451385311994976e-001,  7.2494011846235917e-001,  7.2536625789564169e-001,  7.2579227149415704e-001,
7.2621815933219858e-001,  7.2664392148399426e-001,  7.2706955802370621e-001,  7.2749506902543093e-001,
7.2792045456319909e-001,  7.2834571471097664e-001,  7.2877084954266336e-001,  7.2919585913209406e-001,
7.2962074355303852e-001,  7.3004550287920089e-001,  7.3047013718422060e-001,  7.3089464654167180e-001,
7.3131903102506413e-001,  7.3174329070784194e-001,  7.3216742566338500e-001,  7.3259143596500842e-001,
7.3301532168596262e-001,  7.3343908289943360e-001,  7.3386271967854244e-001,  7.3428623209634647e-001,
7.3470962022583819e-001,  7.3513288413994626e-001,  7.3555602391153485e-001,  7.3597903961340405e-001,
7.3640193131829024e-001,  7.3682469909886539e-001,  7.3724734302773809e-001,  7.3766986317745276e-001,
7.3809225962049041e-001,  7.3851453242926801e-001,  7.3893668167613935e-001,  7.3935870743339449e-001,
7.3978060977326021e-001,  7.4020238876789979e-001,  7.4062404448941344e-001,  7.4104557700983786e-001,
7.4146698640114694e-001,  7.4188827273525138e-001,  7.4230943608399902e-001,  7.4273047651917445e-001,
7.4315139411249986e-001,  7.4357218893563448e-001,  7.4399286106017470e-001,  7.4441341055765453e-001,
7.4483383749954557e-001,  7.4525414195725659e-001,  7.4567432400213407e-001,  7.4609438370546244e-001,
7.4651432113846361e-001,  7.4693413637229711e-001,  7.4735382947806106e-001,  7.4777340052679087e-001,
7.4819284958946031e-001,  7.4861217673698111e-001,  7.4903138204020348e-001,  7.4945046556991557e-001,
7.4986942739684392e-001,  7.5028826759165368e-001,  7.5070698622494814e-001,  7.5112558336726942e-001,
7.5154405908909816e-001,  7.5196241346085357e-001,  7.5238064655289383e-001,  7.5279875843551569e-001,
7.5321674917895498e-001,  7.5363461885338667e-001,  7.5405236752892424e-001,  7.5446999527562086e-001,
7.5488750216346856e-001,  7.5530488826239861e-001,  7.5572215364228179e-001,  7.5613929837292804e-001,
7.5655632252408700e-001,  7.5697322616544760e-001,  7.5739000936663869e-001,  7.5780667219722841e-001,
7.5822321472672494e-001,  7.5863963702457604e-001,  7.5905593916016967e-001,  7.5947212120283336e-001,
7.5988818322183493e-001,  7.6030412528638236e-001,  7.6071994746562333e-001,  7.6113564982864601e-001,
7.6155123244447931e-001,  7.6196669538209183e-001,  7.6238203871039278e-001,  7.6279726249823210e-001,
7.6321236681440019e-001,  7.6362735172762797e-001,  7.6404221730658717e-001,  7.6445696361989024e-001,
7.6487159073609068e-001,  7.6528609872368247e-001,  7.6570048765110110e-001,  7.6611475758672265e-001,
7.6652890859886458e-001,  7.6694294075578540e-001,  7.6735685412568511e-001,  7.6777064877670453e-001,
7.6818432477692644e-001,  7.6859788219437453e-001,  7.6901132109701453e-001,  7.6942464155275347e-001,
7.6983784362943997e-001,  7.7025092739486467e-001,  7.7066389291675952e-001,  7.7107674026279871e-001,
7.7148946950059838e-001,  7.7190208069771626e-001,  7.7231457392165259e-001,  7.7272694923984941e-001,
7.7313920671969116e-001,  7.7355134642850432e-001,  7.7396336843355784e-001,  7.7437527280206298e-001,
7.7478705960117344e-001,  7.7519872889798547e-001,  7.7561028075953808e-001,  7.7602171525281249e-001,
7.7643303244473305e-001,  7.7684423240216660e-001,  7.7725531519192304e-001,  7.7766628088075496e-001,
7.7807712953535813e-001,  7.7848786122237124e-001,  7.7889847600837614e-001,  7.7930897395989762e-001,
7.7971935514340407e-001,  7.8012961962530680e-001,  7.8053976747196097e-001,  7.8094979874966464e-001,
7.8135971352465960e-001,  7.8176951186313115e-001,  7.8217919383120837e-001,  7.8258875949496365e-001,
7.8299820892041361e-001,  7.8340754217351827e-001,  7.8381675932018158e-001,  7.8422586042625175e-001,
7.8463484555752050e-001,  7.8504371477972412e-001,  7.8545246815854264e-001,  7.8586110575960044e-001,
7.8626962764846597e-001,  7.8667803389065238e-001,  7.8708632455161687e-001,  7.8749449969676122e-001,
7.8790255939143161e-001,  7.8831050370091882e-001,  7.8871833269045832e-001,  7.8912604642523043e-001,
7.8953364497035983e-001,  7.8994112839091613e-001,  7.9034849675191421e-001,  7.9075575011831345e-001,
7.9116288855501826e-001,  7.9156991212687855e-001,  7.9197682089868859e-001,  7.9238361493518872e-001,
7.9279029430106385e-001,  7.9319685906094461e-001,  7.9360330927940681e-001,  7.9400964502097160e-001,
7.9441586635010597e-001,  7.9482197333122218e-001,  7.9522796602867818e-001,  7.9563384450677765e-001,
7.9603960882976998e-001,  7.9644525906185037e-001,  7.9685079526715985e-001,  7.9725621750978548e-001,
7.9766152585376004e-001,  7.9806672036306292e-001,  7.9847180110161886e-001,  7.9887676813329944e-001,
7.9928162152192206e-001,  7.9968636133125037e-001,  8.0009098762499486e-001,  8.0049550046681195e-001,
8.0089989992030475e-001,  8.0130418604902276e-001,  8.0170835891646197e-001,  8.0211241858606563e-001,
8.0251636512122282e-001,  8.0292019858527008e-001,  8.0332391904149059e-001,  8.0372752655311419e-001,
8.0413102118331770e-001,  8.0453440299522549e-001,  8.0493767205190825e-001,  8.0534082841638421e-001,
8.0574387215161880e-001,  8.0614680332052446e-001,  8.0654962198596114e-001,  8.0695232821073626e-001,
8.0735492205760406e-001,  8.0775740358926706e-001,  8.0815977286837482e-001,  8.0856202995752446e-001,
8.0896417491926120e-001,  8.0936620781607749e-001,  8.0976812871041370e-001,  8.1016993766465817e-001,
8.1057163474114702e-001,  8.1097322000216410e-001,  8.1137469350994185e-001,  8.1177605532666008e-001,
8.1217730551444733e-001,  8.1257844413537983e-001,  8.1297947125148218e-001,  8.1338038692472758e-001,
8.1378119121703707e-001,  8.1418188419028048e-001,  8.1458246590627603e-001,  8.1498293642679021e-001,
8.1538329581353852e-001,  8.1578354412818488e-001,  8.1618368143234155e-001,  8.1658370778757028e-001,
8.1698362325538099e-001,  8.1738342789723262e-001,  8.1778312177453327e-001,  8.1818270494863987e-001,
8.1858217748085815e-001,  8.1898153943244345e-001,  8.1938079086459958e-001,  8.1977993183848019e-001,
8.2017896241518773e-001,  8.2057788265577425e-001,  8.2097669262124096e-001,  8.2137539237253876e-001,
8.2177398197056772e-001,  8.2217246147617762e-001,  8.2257083095016792e-001,  8.2296909045328748e-001,
8.2336724004623507e-001,  8.2376527978965919e-001,  8.2416320974415802e-001,  8.2456102997027969e-001,
8.2495874052852247e-001,  8.2535634147933423e-001,  8.2575383288311299e-001,  8.2615121480020715e-001,
8.2654848729091501e-001,  8.2694565041548485e-001,  8.2734270423411582e-001,  8.2773964880695672e-001,
8.2813648419410713e-001,  8.2853321045561679e-001,  8.2892982765148637e-001,  8.2932633584166637e-001,
8.2972273508605854e-001,  8.3011902544451499e-001,  8.3051520697683834e-001,  8.3091127974278201e-001,
8.3130724380205079e-001,  8.3170309921429941e-001,  8.3209884603913431e-001,  8.3249448433611228e-001,
8.3289001416474162e-001,  8.3328543558448143e-001,  8.3368074865474195e-001,  8.3407595343488461e-001,
8.3447104998422206e-001,  8.3486603836201823e-001,  8.3526091862748864e-001,  8.3565569083979963e-001,
8.3605035505806968e-001,  8.3644491134136822e-001,  8.3683935974871659e-001,  8.3723370033908728e-001,
8.3762793317140483e-001,  8.3802205830454546e-001,  8.3841607579733712e-001,  8.3880998570855936e-001,
8.3920378809694385e-001,  8.3959748302117421e-001,  8.3999107053988564e-001,  8.4038455071166585e-001,
8.4077792359505443e-001,  8.4117118924854284e-001,  8.4156434773057509e-001,  8.4195739909954737e-001,
8.4235034341380788e-001,  8.4274318073165755e-001,  8.4313591111134945e-001,  8.4352853461108901e-001,
8.4392105128903439e-001,  8.4431346120329631e-001,  8.4470576441193768e-001,  8.4509796097297452e-001,
8.4549005094437524e-001,  8.4588203438406107e-001,  8.4627391134990648e-001,  8.4666568189973801e-001,
8.4705734609133565e-001,  8.4744890398243211e-001,  8.4784035563071314e-001,  8.4823170109381774e-001,
8.4862294042933795e-001,  8.4901407369481863e-001,  8.4940510094775834e-001,  8.4979602224560857e-001,
8.5018683764577418e-001,  8.5057754720561352e-001,  8.5096815098243817e-001,  8.5135864903351322e-001,
8.5174904141605756e-001,  8.5213932818724314e-001,  8.5252950940419581e-001,  8.5291958512399524e-001,
8.5330955540367448e-001,  8.5369942030022050e-001,  8.5408917987057409e-001,  8.5447883417162984e-001,
8.5486838326023640e-001,  8.5525782719319610e-001,  8.5564716602726576e-001,  8.5603639981915569e-001,
8.5642552862553079e-001,  8.5681455250300964e-001,  8.5720347150816567e-001,  8.5759228569752588e-001,
8.5798099512757209e-001,  8.5836959985474026e-001,  8.5875809993542074e-001,  8.5914649542595867e-001,
8.5953478638265290e-001,  8.5992297286175767e-001,  8.6031105491948145e-001,  8.6069903261198766e-001,
8.6108690599539373e-001,  8.6147467512577258e-001,  8.6186234005915152e-001,  8.6224990085151287e-001,
8.6263735755879367e-001,  8.6302471023688632e-001,  8.6341195894163758e-001,  8.6379910372884983e-001,
8.6418614465428023e-001,  8.6457308177364123e-001,  8.6495991514260018e-001,  8.6534664481677981e-001,
8.6573327085175877e-001,  8.6611979330306987e-001,  8.6650621222620194e-001,  8.6689252767659952e-001,
8.6727873970966185e-001,  8.6766484838074454e-001,  8.6805085374515811e-001,  8.6843675585816893e-001,
8.6882255477499892e-001,  8.6920825055082629e-001,  8.6959384324078404e-001,  8.6997933289996177e-001,
8.7036471958340444e-001,  8.7075000334611330e-001,  8.7113518424304537e-001,  8.7152026232911350e-001,
8.7190523765918682e-001,  8.7229011028809045e-001,  8.7267488027060558e-001,  8.7305954766146976e-001,
8.7344411251537646e-001,  8.7382857488697596e-001,  8.7421293483087414e-001,  8.7459719240163414e-001,
8.7498134765377444e-001,  8.7536540064177093e-001,  8.7574935142005550e-001,  8.7613320004301665e-001,
8.7651694656499968e-001,  8.7690059104030638e-001,  8.7728413352319523e-001,  8.7766757406788121e-001,
8.7805091272853664e-001,  8.7843414955929056e-001,  8.7881728461422814e-001,  8.7920031794739262e-001,
8.7958324961278311e-001,  8.7996607966435669e-001,  8.8034880815602667e-001,  8.8073143514166397e-001,
8.8111396067509662e-001,  8.8149638481010961e-001,  8.8187870760044540e-001,  8.8226092909980358e-001,
8.8264304936184135e-001,  8.8302506844017270e-001,  8.8340698638836979e-001,  8.8378880325996145e-001,
8.8417051910843503e-001,  8.8455213398723431e-001,  8.8493364794976137e-001,  8.8531506104937596e-001,
8.8569637333939533e-001,  8.8607758487309396e-001,  8.8645869570370506e-001,  8.8683970588441929e-001,
8.8722061546838504e-001,  8.8760142450870849e-001,  8.8798213305845408e-001,  8.8836274117064418e-001,
8.8874324889825906e-001,  8.8912365629423729e-001,  8.8950396341147564e-001,  8.8988417030282874e-001,
8.9026427702110933e-001,  8.9064428361908921e-001,  8.9102419014949741e-001,  8.9140399666502235e-001,
8.9178370321831013e-001,  8.9216330986196557e-001,  8.9254281664855206e-001,  8.9292222363059115e-001,
8.9330153086056352e-001,  8.9368073839090778e-001,  8.9405984627402180e-001,  8.9443885456226213e-001,
8.9481776330794338e-001,  8.9519657256334006e-001,  8.9557528238068440e-001,  8.9595389281216808e-001,
8.9633240390994184e-001,  8.9671081572611511e-001,  8.9708912831275611e-001,  8.9746734172189280e-001,
8.9784545600551147e-001,  8.9822347121555823e-001,  8.9860138740393758e-001,  8.9897920462251413e-001,
8.9935692292311098e-001,  8.9973454235751127e-001,  9.0011206297745650e-001,  9.0048948483464875e-001,
9.0086680798074847e-001,  9.0124403246737650e-001,  9.0162115834611234e-001,  9.0199818566849566e-001,
9.0237511448602559e-001,  9.0275194485016075e-001,  9.0312867681231956e-001,  9.0350531042387994e-001,
9.0388184573618013e-001,  9.0425828280051801e-001,  9.0463462166815056e-001,  9.0501086239029582e-001,
9.0538700501813074e-001,  9.0576304960279319e-001,  9.0613899619538019e-001,  9.0651484484694955e-001,
9.0689059560851848e-001,  9.0726624853106508e-001,  9.0764180366552705e-001,  9.0801726106280278e-001,
9.0839262077375038e-001,  9.0876788284918897e-001,  9.0914304733989726e-001,  9.0951811429661489e-001,
9.0989308377004208e-001,  9.1026795581083852e-001,  9.1064273046962607e-001,  9.1101740779698570e-001,
9.1139198784345932e-001,  9.1176647065955008e-001,  9.1214085629572106e-001,  9.1251514480239659e-001,
9.1288933622996160e-001,  9.1326343062876181e-001,  9.1363742804910353e-001,  9.1401132854125444e-001,
9.1438513215544270e-001,  9.1475883894185794e-001,  9.1513244895065038e-001,  9.1550596223193115e-001,
9.1587937883577308e-001,  9.1625269881220983e-001,  9.1662592221123584e-001,  9.1699904908280705e-001,
9.1737207947684118e-001,  9.1774501344321646e-001,  9.1811785103177268e-001,  9.1849059229231111e-001,
9.1886323727459451e-001,  9.1923578602834688e-001,  9.1960823860325380e-001,  9.1998059504896212e-001,
9.2035285541508105e-001,  9.2072501975118048e-001,  9.2109708810679236e-001,  9.2146906053141053e-001,
9.2184093707449000e-001,  9.2221271778544811e-001,  9.2258440271366371e-001,  9.2295599190847766e-001,
9.2332748541919218e-001,  9.2369888329507233e-001,  9.2407018558534448e-001,  9.2444139233919720e-001,
9.2481250360578093e-001,  9.2518351943420840e-001,  9.2555443987355435e-001,  9.2592526497285566e-001,
9.2629599478111158e-001,  9.2666662934728328e-001,  9.2703716872029474e-001,  9.2740761294903151e-001,
9.2777796208234220e-001,  9.2814821616903731e-001,  9.2851837525789005e-001,  9.2888843939763588e-001,
9.2925840863697295e-001,  9.2962828302456202e-001,  9.2999806260902640e-001,  9.3036774743895168e-001,
9.3073733756288624e-001,  9.3110683302934172e-001,  9.3147623388679179e-001,  9.3184554018367316e-001,
9.3221475196838521e-001,  9.3258386928929071e-001,  9.3295289219471467e-001,  9.3332182073294523e-001,
9.3369065495223380e-001,  9.3405939490079426e-001,  9.3442804062680396e-001,  9.3479659217840305e-001,
9.3516504960369495e-001,  9.3553341295074632e-001,  9.3590168226758697e-001,  9.3626985760220960e-001,
9.3663793900257053e-001,  9.3700592651658943e-001,  9.3737382019214899e-001,  9.3774162007709538e-001,
9.3810932621923859e-001,  9.3847693866635173e-001,  9.3884445746617096e-001,  9.3921188266639699e-001,
9.3957921431469305e-001,  9.3994645245868669e-001,  9.4031359714596874e-001,  9.4068064842409405e-001,
9.4104760634058060e-001,  9.4141447094291075e-001,  9.4178124227853011e-001,  9.4214792039484874e-001,
9.4251450533923986e-001,  9.4288099715904095e-001,  9.4324739590155360e-001,  9.4361370161404301e-001,
9.4397991434373862e-001,  9.4434603413783369e-001,  9.4471206104348582e-001,  9.4507799510781654e-001,
9.4544383637791152e-001,  9.4580958490082090e-001,  9.4617524072355874e-001,  9.4654080389310347e-001,
9.4690627445639775e-001,  9.4727165246034861e-001,  9.4763693795182757e-001,  9.4800213097767061e-001,
9.4836723158467762e-001,  9.4873223981961374e-001,  9.4909715572920783e-001,  9.4946197936015420e-001,
9.4982671075911085e-001,  9.5019134997270083e-001,  9.5055589704751198e-001,  9.5092035203009662e-001,
9.5128471496697198e-001,  9.5164898590461966e-001,  9.5201316488948640e-001,  9.5237725196798384e-001,
9.5274124718648812e-001,  9.5310515059134082e-001,  9.5346896222884792e-001,  9.5383268214528061e-001,
9.5419631038687525e-001,  9.5455984699983287e-001,  9.5492329203032000e-001,  9.5528664552446818e-001,
9.5564990752837387e-001,  9.5601307808809877e-001,  9.5637615724967007e-001,  9.5673914505908009e-001,
9.5710204156228629e-001,  9.5746484680521138e-001,  9.5782756083374387e-001,  9.5819018369373754e-001,
9.5855271543101106e-001,  9.5891515609134959e-001,  9.5927750572050263e-001,  9.5963976436418608e-001,
9.6000193206808082e-001,  9.6036400887783413e-001,  9.6072599483905807e-001,  9.6108788999733064e-001,
9.6144969439819583e-001,  9.6181140808716326e-001,  9.6217303110970820e-001,  9.6253456351127165e-001,
9.6289600533726050e-001,  9.6325735663304790e-001,  9.6361861744397259e-001,  9.6397978781533911e-001,
9.6434086779241834e-001,  9.6470185742044690e-001,  9.6506275674462760e-001,  9.6542356581012922e-001,
9.6578428466208699e-001,  9.6614491334560193e-001,  9.6650545190574111e-001,  9.6686590038753850e-001,
9.6722625883599356e-001,  9.6758652729607242e-001,  9.6794670581270770e-001,  9.6830679443079792e-001,
9.6866679319520843e-001,  9.6902670215077058e-001,  9.6938652134228265e-001,  9.6974625081450894e-001,
9.7010589061218078e-001,  9.7046544077999519e-001,  9.7082490136261712e-001,  9.7118427240467686e-001,
9.7154355395077185e-001,  9.7190274604546667e-001,  9.7226184873329191e-001,  9.7262086205874509e-001,
9.7297978606629087e-001,  9.7333862080036049e-001,  9.7369736630535186e-001,  9.7405602262563018e-001,
9.7441458980552709e-001,  9.7477306788934170e-001,  9.7513145692133973e-001,  9.7548975694575402e-001,
9.7584796800678464e-001,  9.7620609014859849e-001,  9.7656412341532972e-001,  9.7692206785107960e-001,
9.7727992349991655e-001,  9.7763769040587623e-001,  9.7799536861296144e-001,  9.7835295816514267e-001,
9.7871045910635723e-001,  9.7906787148051000e-001,  9.7942519533147321e-001,  9.7978243070308657e-001,
9.8013957763915704e-001,  9.8049663618345917e-001,  9.8085360637973529e-001,  9.8121048827169477e-001,
9.8156728190301468e-001,  9.8192398731733999e-001,  9.8228060455828281e-001,  9.8263713366942373e-001,
9.8299357469431004e-001,  9.8334992767645768e-001,  9.8370619265934944e-001,  9.8406236968643668e-001,
9.8441845880113821e-001,  9.8477446004684077e-001,  9.8513037346689891e-001,  9.8548619910463542e-001,
9.8584193700334044e-001,  9.8619758720627293e-001,  9.8655314975665886e-001,  9.8690862469769336e-001,
9.8726401207253855e-001,  9.8761931192432550e-001,  9.8797452429615296e-001,  9.8832964923108790e-001,
9.8868468677216581e-001,  9.8903963696239017e-001,  9.8939449984473249e-001,  9.8974927546213298e-001,
9.9010396385750010e-001,  9.9045856507371044e-001,  9.9081307915360939e-001,  9.9116750614001037e-001,
9.9152184607569527e-001,  9.9187609900341478e-001,  9.9223026496588806e-001,  9.9258434400580220e-001,
9.9293833616581384e-001,  9.9329224148854744e-001,  9.9364606001659650e-001,  9.9399979179252318e-001,
9.9435343685885791e-001,  9.9470699525810047e-001,  9.9506046703271911e-001,  9.9541385222515089e-001,
9.9576715087780143e-001,  9.9612036303304574e-001,  9.9647348873322728e-001,  9.9682652802065863e-001,
9.9717948093762132e-001,  9.9753234752636577e-001,  9.9788512782911110e-001,  9.9823782188804633e-001,
9.9859042974532852e-001,  9.9894295144308476e-001,  9.9929538702341059e-001,  9.9964773652837102e-001};


double MemLog::mlog10 (double val)
{
    uint64_t* pin = (uint64_t*)(&val);
    uint64_t    N = *pin;
    int e = (int)(((N >> 52) & 2047) - 1023);
    int m = (int)((N >> (52 - mbits)) & mmask);
    return mconv * (e + mtable[m]);
}

} // namespace WDSP
