#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "common.h"
#include "cat.h"
#include "shared.h"


/* File variables */
static GtkWidget
  *quit_dialog  = NULL,
  *save_dialog  = NULL,
  *error_dialog = NULL,
  *bad_entry_dialog = NULL;

static int newc_ptr = 0;


/*  Error_Dialog()
 *
 *  Opens an error dialog box
 */

  void
Error_Dialog( char *mesg, gboolean hide )
{
  if( error_dialog != NULL ) return;
  error_dialog = create_error_dialog();
  GtkWidget *lbl = lookup_widget( error_dialog, "error_message" );
  gtk_label_set_text( GTK_LABEL(lbl), mesg );
  if( hide )
	gtk_widget_hide( lookup_widget(error_dialog, "error_ok_button") );
  gtk_widget_show( error_dialog );
}


  void
Quit_Dialog( char *mesg )
{
  if( quit_dialog != NULL ) return;
  quit_dialog = create_quit_dialog();
  GtkWidget *lbl = lookup_widget( quit_dialog, "quit_message" );
  gtk_label_set_text( GTK_LABEL(lbl), mesg );
  gtk_widget_show( quit_dialog );
}


  void
Save_Dialog( char *mesg )
{
  if( save_dialog != NULL ) return;
  save_dialog = create_save_dialog();
  GtkWidget *lbl = lookup_widget( save_dialog, "save_message" );
  gtk_label_set_text( GTK_LABEL(lbl), mesg );
  gtk_widget_show( save_dialog );
}


  void
Bad_Entry_Dialog( char *mesg )
{
  if( bad_entry_dialog != NULL ) return;
  bad_entry_dialog = create_bad_entry_dialog();
  GtkWidget *lbl = lookup_widget( bad_entry_dialog, "bad_entry" );
  gtk_label_set_text( GTK_LABEL(lbl), mesg );
  gtk_widget_show( bad_entry_dialog );
}


void
on_main_window_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
  Cleanup();
  gtk_main_quit();
}


gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  if( isFlagSet(TRANSMIT_MODE) ||
	  isFlagSet(RECEIVE_MODE) )
  {
	Quit_Dialog(
		_("xfhell is running\n"\
		  "Do you want to quit?") );
	return TRUE;
  }
  else return FALSE;
}


  gboolean
on_tx_textview_button_press_event(
	GtkWidget       *widget,
	GdkEventButton  *event,
	gpointer         user_data)
{
  switch( event->button )
  {
	case 1: /* Focus to textview */
	  break;

	case 2: /* Toggle Tx/Rx/Macro modes */
	  if( isFlagSet(TRANSMIT_MACRO) )
		ClearFlag( TRANSMIT_MACRO  );
	  else if( isFlagSet(TRANSMIT_KEYBD) )
	  {
		ClearFlag( TRANSMIT_KEYBD  );
		SetFlag( RECEIVE_MODE );
		g_idle_add( Receive_Mode, NULL );
	  }
	  else
	  {
		SetFlag( TRANSMIT_KEYBD );
		ClearFlag( RECEIVE_MODE );
		Set_TxRx_Labels();
		g_idle_add( Transmit_Keybd, "dummy" );
	  }
	  break;

	case 3: /* Popup menu */
	  if( isFlagSet(PLAYBACK_SETUP) && isFlagSet(TRANSMIT_KEYBD) )
		gtk_widget_set_sensitive( lookup_widget(gbl_popup_menu,
			  "identify_in_cw"), TRUE );
	  else
		gtk_widget_set_sensitive( lookup_widget(gbl_popup_menu,
			  "identify_in_cw"), FALSE );

	  gtk_menu_popup( GTK_MENU(gbl_popup_menu),
		  NULL, NULL, NULL, NULL, 3, 0);
	  break;
  } /* switch( event->button ) */

  return FALSE;
}


gboolean
on_tx_textview_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  /* Text buffer marker */
  static GtkTextIter txtbuf_iter;

  /* Character cnt for word wrap */
  static int char_cnt = 0;


  /* Do nothing if not in keybd mode */
  if( isFlagClear(TRANSMIT_KEYBD) &&
	  isFlagClear(RECEIVE_MODE) )
	return( FALSE );

  /* Deal with backspace */
  if( (event->keyval == GDK_BackSpace) && char_cnt )
  {
	/* Reduce char cnt for word wrap */
	char_cnt--;

	/* Track xmit char ptr with new char ptr */
	if( txch_ptr == newc_ptr )
	  if( --txch_ptr < 0 )
		txch_ptr += KEY_BUFF_SIZE;

	/* Backspace new char ptr */
	if( --newc_ptr < 0 )
	  newc_ptr += KEY_BUFF_SIZE;

	/* Count down spaces if deleted */
	if( keybd_buff[newc_ptr] == ' ' )
	  space_cnt--;
	if( space_cnt < 0 )
	  space_cnt = 0;

	/* Reterminate buffer */
	keybd_buff[newc_ptr] = '\0';

	Print_Character(
		BS, gbl_tx_text_buffer,
		gbl_tx_scrolledwindow,
		&txtbuf_iter );

	return( TRUE );
  } /* if( (event->keyval == GDK_BackSpace) && char_cnt ) */

  /* Enter new caracter to key buffer */
  keybd_buff[newc_ptr] = event->keyval;
  char_cnt++;

  /* Capitalize letters if enabled */
  if( isFlagSet(CAPITALIZE)	&&
	  (keybd_buff[newc_ptr] > 0x60) &&
	  (keybd_buff[newc_ptr] < 0x7b) )
	keybd_buff[newc_ptr] -= 0x20;

  /* Set up TRANSMIT text view */
  gtk_text_buffer_get_iter_at_offset(
	  gbl_tx_text_buffer, &txtbuf_iter,
	  gtk_text_buffer_get_char_count
	  (gbl_tx_text_buffer) );

  /* Print ascii characters to screen */
  if( keybd_buff[newc_ptr] <= 0xff )
	Print_Character(
		(int)keybd_buff[newc_ptr],
		gbl_tx_text_buffer,
		gbl_tx_scrolledwindow,
		&txtbuf_iter );

  /* Set keybd busy flag since a space */
  /* will start xmission of the buffer */
  if( keybd_buff[newc_ptr] == ' ' )
  {
	if( isFlagClear(RECEIVE_MODE) )
	  SetFlag( KEYBD_BUSY );

	/* If zero typed-in spaces left in keyboard string,
	 * increment space count to allow for the default
	 * end space added below */
	if( !space_cnt ) space_cnt++;
	space_cnt++;

	/* Do word wrapping */
	if( char_cnt >= rc_data.wwrap )
	{
	  char_cnt = 0; /* Reset word wrap */
	  Print_Character(
		  GDK_Return,
		  gbl_tx_text_buffer,
		  gbl_tx_scrolledwindow,
		  &txtbuf_iter );
	}

  } /* if( keybd_buff[newc_ptr] == ' ' ) */

  /* Send a space in place of Return */
  if( keybd_buff[newc_ptr] == GDK_Return )
  {
	keybd_buff[newc_ptr] = ' ';
	if( isFlagClear(RECEIVE_MODE) )
	  SetFlag( KEYBD_BUSY );

	/* If zero typed-in spaces left in keyboard string,
	 * increment space count to allow for the default
	 * end space added below */
	if( !space_cnt ) space_cnt++;
	space_cnt++;
	char_cnt = 0; /* Reset word wrap */
  }

  /* Increment keystroke ptr & enter a default space */
  if( ++newc_ptr >= KEY_BUFF_SIZE )
	newc_ptr = 0;
  keybd_buff[newc_ptr] = ' ';

  /* Increment keystroke ptr & terminate buf */
  if( ++newc_ptr >= KEY_BUFF_SIZE )
	newc_ptr = 0;
  keybd_buff[newc_ptr] = '\0';

  /* Backstep keystroke ptr for next keystroke by user */
  if( --newc_ptr < 0 )
	newc_ptr += KEY_BUFF_SIZE;

  return FALSE;
}


void
on_txvol_spinbutton_value_changed      (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  char mesg[MESG_SIZE];
  int error, spin_val;

  spin_val = gtk_spin_button_get_value_as_int(spinbutton);

  /* If tcvr is K2 or K3, set power output setting */
  if( (rc_data.tcvr_type == K2) || (rc_data.tcvr_type == K3) )
  {
	rc_data.tx_output = spin_val;
	if( isFlagSet(CAT_SETUP) )
	  Set_Tx_Power( rc_data.tx_output, 0 );
	rc_data.pbk_lev = K3_PBK_LEVEL;
  }
  else rc_data.pbk_lev = spin_val;

  /* Set line output level */
  Set_Playback_Level( rc_data.pbk_lev, mesg, &error );
}


gboolean
on_drawingarea_expose_event            (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  if( receive_pixbuf.pixbuf == NULL )
	return FALSE;

  gdk_draw_pixbuf(
	  widget->window, NULL, receive_pixbuf.pixbuf,
	  event->area.x, event->area.y,
	  event->area.x, event->area.y,
	  event->area.width, event->area.height,
	  GDK_RGB_DITHER_NONE, 0, 0 );

  return FALSE;
}


gboolean
on_drawingarea_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  switch( event->button )
  {
	case 2: /* Toggle Tx/Rx/Macro modes */
	  if( isFlagSet(RECEIVE_MODE) )
	  {
		ClearFlag( RECEIVE_MODE );
		Set_TxRx_Labels();
	  }
	  else
	  {
		if( isFlagClear(TRANSMIT_MACRO) )
		{
		  SetFlag( RECEIVE_MODE );
		  ClearFlag( TRANSMIT_KEYBD );
		  g_idle_add( Receive_Mode, NULL );
		}
		else
		{
		  ClearFlag( TRANSMIT_MACRO );
		  SetFlag( TRANSMIT_KEYBD );
		  Set_TxRx_Labels();
		}

	  } /* if( isFlagSet(RECEIVE_MODE) ) */
	  break;

	case 3: /* Popup menu */
	  if( isFlagSet(PLAYBACK_SETUP) &&
		  isFlagSet(TRANSMIT_KEYBD) )
		gtk_widget_set_sensitive( lookup_widget
			(gbl_popup_menu, "identify_in_cw"), TRUE );
	  else
		gtk_widget_set_sensitive( lookup_widget
			(gbl_popup_menu, "identify_in_cw"), FALSE );

	  gtk_menu_popup( GTK_MENU(gbl_popup_menu),
		  NULL, NULL, NULL, NULL, 3, 0);

  } /* switch( event->button ) */

  return FALSE;
}


void
on_drawingarea_size_allocate           (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
  if( !Create_Pixbuf(widget) )
	Error_Dialog( _("Failed to create pixbuf for Rx window"), QUIT );
  SetFlag( CLEAR_RX_WINDOW );
}


void
on_xmit_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  if( isFlagSet(TRANSMIT_MACRO) )
	ClearFlag( TRANSMIT_MACRO  );
  else if( isFlagSet(TRANSMIT_KEYBD) )
  {
	ClearFlag( TRANSMIT_KEYBD  );
	SetFlag( RECEIVE_MODE );
	Set_TxRx_Labels();
	g_idle_add( Receive_Mode, NULL );
  }
  else
  {
	SetFlag( TRANSMIT_KEYBD );
	ClearFlag( RECEIVE_MODE );
	Set_TxRx_Labels();
	SetFlag( KEYBD_BUSY );
	g_idle_add( Transmit_Keybd, NULL );
  }
}


void
on_rcve_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  if( isFlagSet(RECEIVE_MODE) )
  {
	ClearFlag( RECEIVE_MODE );
	Set_TxRx_Labels();
  }
  else
  {
	if( isFlagClear(TRANSMIT_MACRO) )
	{
	  SetFlag( RECEIVE_MODE );
	  ClearFlag( TRANSMIT_KEYBD );
	  Set_TxRx_Labels();
	  g_idle_add( Receive_Mode, NULL );
	}
	else
	{
	  ClearFlag( TRANSMIT_MACRO );
	  SetFlag( TRANSMIT_KEYBD );
	  Set_TxRx_Labels();
	}

  } /* if( isFlagSet(RECEIVE_MODE) ) */
}


void
on_deskew_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
  {
	SetFlag( AUTO_DESKEW );
	rc_data.num_rows = 1;
  }
  else
  {
	ClearFlag( AUTO_DESKEW );
	rc_data.num_rows = 2;
  }

  SetFlag( CLEAR_RX_WINDOW );
  Set_TxRx_Labels();
}


void
on_height_checkbutton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gbl_drawingarea == NULL ) return;
  if( gtk_toggle_button_get_active(togglebutton) )
	gtk_widget_set_size_request( gbl_drawingarea,
		gbl_drawingarea->allocation.width, 172 );
  else
	gtk_widget_set_size_request( gbl_drawingarea,
		gbl_drawingarea->allocation.width, 340 );
  SetFlag( INITIALIZE_CAIRO );
}


void
on_rxvol_spinbutton_value_changed      (GtkSpinButton   *spinbutton,
                                        gpointer         user_data)
{
  char mesg[MESG_SIZE];
  int error;

  rc_data.cap_lev = gtk_spin_button_get_value_as_int(spinbutton);
  if( !Set_Capture_Level(rc_data.cap_lev, mesg, &error) )
  {
	Strlcat( mesg, snd_strerror(error), sizeof(mesg) );
	fprintf( stderr, "%s\n", mesg );
  }
}


void
on_contrast_value_changed              (GtkRange        *range,
                                        gpointer         user_data)
{
  GtkAdjustment *adjustment;

  /* Read and enter contrast value */
  adjustment = gtk_range_get_adjustment( range );
  contrast = ELEMENT_MAX+1 -
	(int)(adjustment->value * ((double)ELEMENT_MAX/10.0));
}


gboolean
on_scope_expose_event                  (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  if( wfall_pixbuf.pixbuf == NULL )
	return FALSE;

  if( isFlagClear(ENABLE_SCOPE) )
  {
	/* Draw waterfall */
	gdk_draw_pixbuf(
		widget->window, NULL, wfall_pixbuf.pixbuf,
		event->area.x, event->area.y,
		event->area.x, event->area.y,
		event->area.width, event->area.height,
		GDK_RGB_DITHER_NONE, 0, 0 );

	gtk_label_set_text( GTK_LABEL(gbl_scope_label), "Waterfall" );
  }

  return FALSE;
}


  gboolean
on_scope_button_press_event            (GtkWidget       *widget,
										GdkEventButton  *event,
                                        gpointer         user_data)
{
  switch( event->button )
  {
	case 1:
	  if( isFlagSet(CAT_SETUP) &&
		  isFlagSet(RECEIVE_MODE) &&
		  isFlagClear(ENABLE_SCOPE) )
		Tune_Tcvr( event->x );

  } /* switch( event->button ) */

  return FALSE;
}


void
on_scope_size_allocate                 (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
  int idx;

  /* Destroy existing pixbuff */
  if( wfall_pixbuf.pixbuf != NULL )
  {
	g_object_unref( G_OBJECT(wfall_pixbuf.pixbuf) );
	wfall_pixbuf.pixbuf = NULL;
  }

  /* Create waterfall pixbuf */
  wfall_pixbuf.pixbuf = gdk_pixbuf_new(
	  GDK_COLORSPACE_RGB, FALSE, 8,
	  allocation->width, allocation->height );
  if( wfall_pixbuf.pixbuf == NULL )
	Error_Dialog( _("Failed to create pixbuf for waterfall"), QUIT );

  wfall_pixbuf.pixels     = gdk_pixbuf_get_pixels( wfall_pixbuf.pixbuf );
  wfall_pixbuf.width      = gdk_pixbuf_get_width ( wfall_pixbuf.pixbuf );
  wfall_pixbuf.height     = gdk_pixbuf_get_height( wfall_pixbuf.pixbuf );
  wfall_pixbuf.rowstride  = gdk_pixbuf_get_rowstride( wfall_pixbuf.pixbuf );
  wfall_pixbuf.n_channels = gdk_pixbuf_get_n_channels( wfall_pixbuf.pixbuf );
  Clear_Pixbuf( &wfall_pixbuf, 0 );
  SetFlag( INITIALIZE_CAIRO );

  /* Allocate average bin value buffer */
  if( !mem_realloc((void **)&gbl_bin_ave,
		(size_t)wfall_pixbuf.width * sizeof(int)) ) 
	return;
  for( idx = 0; idx < wfall_pixbuf.width; idx++ )
	gbl_bin_ave[idx] = 0;

  /* Initialize dft */
  Idft_Init(DFT_INPUT_SIZE, wfall_pixbuf.width);
}


void
on_rst_out_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  Process_RST( editable );
  Strlcpy( qso_record.dx_rst,
	  gtk_entry_get_text(GTK_ENTRY(editable)),
	  sizeof(qso_record.dx_rst) );
}


void
on_rst_in_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  Process_RST( editable );
  Strlcpy( qso_record.my_rst,
	  gtk_entry_get_text(GTK_ENTRY(editable)),
	  sizeof(qso_record.my_rst) );
}


void
on_op_name_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  char buff[13];
  int len;

  /* Read entry, ignore blank field */
  Strlcpy( buff,
	  gtk_entry_get_text(GTK_ENTRY(editable)),
	  sizeof(buff) );
  len = (int)strlen(buff);
  if( len == 0 ) return;

  /* Capitalize letters if enabled */
  if( isFlagSet(CAPITALIZE) )
  {
	int idx;
	for( idx = 0; idx < len; idx++ )
	  if( (buff[idx] > 0x60) &&
		  (buff[idx] < 0x7b) )
		buff[idx] -= 0x20;
  }

  /* Enter data to field QSO record structure */
  Strlcpy( qso_record.dx_name, buff, sizeof(qso_record.dx_name) );
  gtk_entry_set_text( GTK_ENTRY(editable), qso_record.dx_name );
}


void
on_qth_name_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  char buff[13];
  int len;

  /* Read entry, ignore blank field */
  Strlcpy( buff,
	  gtk_entry_get_text(GTK_ENTRY(editable)),
	  sizeof(buff) );
  len = (int)strlen(buff);
  if( len == 0 ) return;

  /* Capitalize letters if enabled */
  if( isFlagSet(CAPITALIZE) )
  {
	int idx;
	for( idx = 0; idx < len; idx++ )
	  if( (buff[idx] > 0x60) &&
		  (buff[idx] < 0x7b) )
		buff[idx] -= 0x20;
  }

  /* Enter data to field and QSO record structure */
  Strlcpy( qso_record.dx_qth, buff, sizeof(qso_record.dx_qth) );
  gtk_entry_set_text( GTK_ENTRY(editable), qso_record.dx_qth );
}


void
on_locator_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  int len, idx;
  char buff[7];

  /* Get entry field, ignore blank field */
  Strlcpy( buff,
	  gtk_entry_get_text(GTK_ENTRY(editable)),
	  sizeof(buff) );
  len = (int)strlen(buff);
  if( len == 0 ) return;

  for( idx = 0; idx < len; idx++ )
  {
	/* Capitalize letters */
	if( (buff[idx] > 0x60) &&
		(buff[idx] < 0x7b) )
	  buff[idx] -= 0x20;

	/* Validate grid locator */
	switch( idx )
	{
	  case 0: case 1: /* First letters */
		if( (buff[idx] < 'A') || (buff[idx] > 'S') )
		{
		  Bad_Entry_Dialog(
			  _("Invalid character entered\n"\
				"Letters A-S only") );
		  return;
		}
		break;

	  case 2: case 3: /* Middle numbers */
		if( (buff[idx] < '0') || (buff[idx] > '9') )
		{
		  Bad_Entry_Dialog(
			  _("Invalid character entered\n"\
				"Numbers 0-9 only") );
		  return;
		}
		break;

	  case 4: case 5: /* Last letters */
		if( (buff[idx] < 'A') || (buff[idx] > 'X') )
		{
		  Bad_Entry_Dialog(
			  _("Invalid character entered\n"\
				"Letters A-X only") );
		  return;
		}

	} /* switch( idx ) */

  } /* for( idx = 0; idx < len; idx++ ) */

  /* Enter data to field and QSO record structure */
  Strlcpy( qso_record.dx_loc, buff, sizeof(qso_record.dx_loc) );
  gtk_entry_set_text( GTK_ENTRY(editable), qso_record.dx_loc );
}


void
on_band_changed                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
  int len, idx;
  char buff[14];

  qso_record.freq[0] = '\0';

  /* Get entry field, ignore blank field */
  Strlcpy( buff,
	  gtk_entry_get_text(GTK_ENTRY(editable)),
	  sizeof(buff) );
  len = (int)strlen(buff);
  if( len == 0 ) return;

  /* Reject non-numbers except '.' and space */
  for( idx = 0; idx < len; idx++ )
	if( ((buff[idx]  < '0') || (buff[idx]  > '9')) &&
		((buff[idx] != '.') && (buff[idx] != ' ')) )
	{
	  Bad_Entry_Dialog(
		  _("Invalid character entered\n"\
			"Numbers and '.' only allowed") );
	  return;
	}

  /* Enter data to QSO record structure */
  Strlcpy( qso_record.freq, buff, sizeof(qso_record.freq) );
}


void
on_callsign_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  int len, idx, idy;
  char buff[15];


  /* Get entry field, ignore blank field */
  Strlcpy( buff,
	  gtk_entry_get_text(GTK_ENTRY(editable)),
	  sizeof(buff) );
  len = (int)strlen( buff );
  if( len == 0 ) return;

  for( idx = 0; idx < len; idx++ )
  {
	/* Capitalize letters */
	if( (buff[idx] > 0x60) &&
		(buff[idx] < 0x7b) )
	  buff[idx] -= 0x20;

	/* Allow only alpha-numerics and '/' */
	if( ((buff[idx]  < 'A') || (buff[idx]  > 'Z')) &&
		((buff[idx]  < '0') || (buff[idx]  > '9')) &&
		((buff[idx] != '/') && (buff[idx] != ' ')) )
	{
	  Bad_Entry_Dialog(
		  _("Invalid character entered\n"\
			"Alpha-numerics and '/' only") );
	  return;
	}

  } /* for( idx = 0; idx < len; idx++ ) */

  /* Enter data to field and QSO record structure */
  idy = 0;
  for( idx = 0; idx < len; idx++ )
	if( buff[idx] != ' ' ) /* ignore space */
	  qso_record.dx_call[idy++] = buff[idx];
  qso_record.dx_call[idy] = '\0';
  gtk_entry_set_text( GTK_ENTRY(editable), qso_record.dx_call );

  SetFlag( SAVE_RECORD );
}


void
on_new_record_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  /* Variables for time and date */
  time_t tp;    /* Time type     */
  struct tm dt; /* Date and time */

  /* For reading Tcvr status */
  char
	freq[8],
	rst[4];

  /* Save record if needed and completed */
  if( isFlagSet(SAVE_RECORD) )
  {
	if( !Read_QSO_Record() )
	{
	  Bad_Entry_Dialog(
		  _("QSO Record is not complete\n"\
			"Cannot save and open new Record") );
	  return;
	}
	else Save_QSO_Record();
  }

  /* Initialize for new entry */
  Clear_Record_Fields( FALSE );

  /* If above is successful */
  if( isFlagSet(CAT_SETUP) )
  {
	GtkWidget *entry;

	if( !Read_Rx_Status(freq, rst) ) return;
	entry = lookup_widget( main_window, "rst_out" );
	gtk_entry_set_text( GTK_ENTRY(entry), rst );
	entry = lookup_widget( main_window, "band" );
	gtk_entry_set_text( GTK_ENTRY(entry), freq );
  }

  Strlcpy( qso_record.mode, "Hell", sizeof(qso_record.mode) );

  /* Enter time and date to QSO record */
  time( &tp );
  dt = *gmtime( &tp );
  strftime( qso_record.date,     12, "%d/%b/%Y", &dt );
  strftime( qso_record.time,      6, "%H:%M",    &dt );
  strftime( qso_record.date_adif, 9, "%Y%m%d",   &dt );
  strftime( qso_record.time_adif, 5, "%H%M",     &dt );
}


void
on_save_record_clicked                 (GtkButton       *button,
										gpointer         user_data)
{
  /* Save record if needed (and valid) */
  if( Read_QSO_Record() )
	Save_Dialog( _("Save QSO Record to file?") );
  else Save_Dialog(
	  _("QSO Record is incomplete\n"\
		"Do you still want to save?") );
}


  void
on_clear_fields_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  Clear_Record_Fields(TRUE);
}


void
on_clear_windows_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  Save_Pixbuf();
  SetFlag( CLEAR_TX_WINDOW | CLEAR_RX_WINDOW );
  gtk_text_buffer_set_text(gbl_tx_text_buffer, "", -1);
}


void
on_macro1_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 1 );
}


void
on_macro2_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 2 );
}


void
on_macro3_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 3 );
}


void
on_macro4_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 4 );
}


void
on_macro5_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 5 );
}


void
on_macro6_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 6 );
}


void
on_macro7_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 7 );
}


void
on_macro8_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 8 );
}


void
on_macro9_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 9 );
}


void
on_macro10_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Macro( 10 );
}


void
on_error_dialog_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
  error_dialog = NULL;
}


gboolean
on_error_dialog_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  return TRUE;
}


void
on_error_quit_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  Cleanup();
  gtk_main_quit();
}


void
on_error_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( error_dialog );
}


void
on_cancel_save_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( save_dialog );
}


void
on_save_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  Save_QSO_Record();
  gtk_widget_destroy( save_dialog );
}


void
on_feldhell_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SetFlag( MODE_FELDHELL );
  New_Parameters();
}


void
on_fmhell_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ClearFlag( MODE_FELDHELL );
  New_Parameters();
}


void
on_bdrate_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
	New_Parameters();
}


static GtkFileSelection *fileselection;
void
on_font_selector_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  fileselection = GTK_FILE_SELECTION(create_fileselection());
  gtk_widget_show( GTK_WIDGET(fileselection) );
  gtk_file_selection_set_filename( fileselection, "~/xfhell/fonts/" );
}


void
on_show_font_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int idx;

  for( idx = 0; idx < rc_data.font_data.num_glyphs; idx++ )
	if( !Render_Font(&rc_data.font_data, idx) )
	  return;
}


void
on_reverse_video_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
	rc_data.rev_video = TRUE;
  else
	rc_data.rev_video = FALSE;
}


void
on_k2_activate                         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
  {
	rc_data.tcvr_type = K2;
	SetFlag( ENABLE_CAT );
	ClearFlag( ENABLE_RTS_DTR );
	Close_Tcvr_Serial();
  }
}


void
on_k3_activate                         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
  {
	rc_data.tcvr_type = K3;
	SetFlag( ENABLE_CAT );
	ClearFlag( ENABLE_RTS_DTR );
	Close_Tcvr_Serial();
  }
}


void
on_ft847_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
  {
	rc_data.tcvr_type = FT847;
	SetFlag( ENABLE_CAT );
	ClearFlag( ENABLE_RTS_DTR );
	Close_Tcvr_Serial();
  }
}


void
on_ft857_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
  {
	rc_data.tcvr_type = FT857;
	SetFlag( ENABLE_CAT );
	ClearFlag( ENABLE_RTS_DTR );
	Close_Tcvr_Serial();
  }
}


void
on_rts_ctl_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
  {
	rc_data.tcvr_type = NONE;
	SetFlag( ENABLE_RTS_DTR );
	ClearFlag( ENABLE_CAT );
	Close_Tcvr_Serial();
  }
}


void
on_none_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
  {
	rc_data.tcvr_type = NONE;
	ClearFlag( ENABLE_CAT );
	ClearFlag( ENABLE_RTS_DTR );
	Close_Tcvr_Serial();
  }
}


void
on_md2x2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  rc_data.dot_size = 2;
  New_Parameters();
}


void
on_md3x3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  rc_data.dot_size = 3;
  New_Parameters();
}


void
on_md4x4_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  rc_data.dot_size = 4;
  New_Parameters();
}


void
on_record_qsos_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
  {
	SetFlag( SAVE_PIXBUF );
	SetFlag( RECORD_QSO );
	Open_Record_File();
  }
  else
  {
	ClearFlag( RECORD_QSO );
	ClearFlag( SAVE_PIXBUF );
	if( rc_data.qso_record_fp != NULL )
	{
	  fclose( rc_data.qso_record_fp );
	  rc_data.qso_record_fp = NULL;
	}
  }
}


void
on_capitalize_letters_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
	SetFlag( CAPITALIZE );
  else ClearFlag( CAPITALIZE );
}


void
on_loopback_tx_to_rx_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )
	SetFlag( TX2RX_LOOPBACK );
  else ClearFlag( TX2RX_LOOPBACK );
}


void
on_identify_in_cw_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char mesg[MESG_SIZE];

  snprintf( mesg, sizeof(mesg), "  DE %s  TU", rc_data.call );
  Morse_Transmit( mesg );
}


void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( isFlagSet(TRANSMIT_MODE) ||
	  isFlagSet(RECEIVE_MODE) )
	Quit_Dialog(
		_("xfhell is running\n"\
		  "Still want to quit?") );
  else
  {
	Cleanup();
	gtk_main_quit();
  }
}


void
on_bad_entry_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( bad_entry_dialog );
}


void
on_cancel_quit_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( quit_dialog );
  quit_dialog  = NULL;
}


void
on_quit_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  Cleanup();
  gtk_main_quit();
}


void
on_fileselection_response              (GtkDialog       *dialog,
                                        gint             response_id,
                                        gpointer         user_data)
{
  if( response_id == GTK_RESPONSE_OK )
  {
	if( strlen(gtk_file_selection_get_filename(fileselection)) > 80 )
	{
	  Error_Dialog( _("Font file name to long"), QUIT );
	  return;
	}

	Strlcpy( rc_data.font_file,
		gtk_file_selection_get_filename(fileselection),
		sizeof(rc_data.font_file) );
	if( strstr(rc_data.font_file, ".bdf") == NULL )
	{
	  Error_Dialog( _("This is not a .bdf font file"), QUIT );
	  return;
	}
	New_Parameters();
	gtk_widget_destroy( GTK_WIDGET(fileselection) );
	return;

  } /* if( response_id == GTK_RESPONSE_OK ) */

  gtk_widget_destroy( GTK_WIDGET(fileselection) );
}


void
on_scope_button_clicked                (GtkButton       *button,
										gpointer         user_data)
{
  if( isFlagSet( ENABLE_SCOPE ) )
  {
	gtk_label_set_text( GTK_LABEL(gbl_scope_label), "Waterfall" );
	ClearFlag( ENABLE_SCOPE );
  }
  else
  {
	gtk_label_set_text( GTK_LABEL(gbl_scope_label), _("Signal Level") );
	SetFlag( ENABLE_SCOPE );
  }
  gtk_widget_queue_draw( gbl_scope );
}

