#include <CGAL/Exact_predicates_inexact_constructions_kernel.h>
#include <CGAL/convex_hull_3.h>

#include <vector>
#include <array>
#include <fstream>


typedef CGAL::Exact_predicates_inexact_constructions_kernel K;
typedef K::Point_3 Point_3;


int main() {
  std::vector<Point_3> points = {
{-7.71169150943396353 ,-19.809308490566039, 10.0950745283018861},
{-7.90879905660377602, -19.809308490566039, 9.8979669811320754},
{-7.71169150943396353, -19.6122009433962283, 9.8979669811320754},
{-7.90879905660377602, -19.6122009433962283, 9.8979669811320754},
{-7.71169150943396353, -19.4150933962264141, 10.0950745283018861},
{-7.90879905660377602, -19.809308490566039, 10.0950745283018861},
{-7.71169150943396353, -19.6122009433962283, 10.2921820754716968},
{-7.90879905660377602, -19.6122009433962283, 10.0950745283018861},
{-7.71169150943396353, -19.6122009433962283, 10.0950745283018861},
{-7.71169150943396353, -19.809308490566039, 9.8979669811320754},
{-7.90879905660377602, -19.4150933962264141, 9.8979669811320754},
{-7.90879905660377602, -19.4150933962264141, 10.0950745283018861},
{-7.71169150943396353, -19.4150933962264141, 9.8979669811320754},
{-7.90879905660377602, -19.6122009433962283, 10.2921820754716968},
{-7.90879905660377602, -19.4150933962264141, 10.2921820754716968},
{-7.71169150943396353, -19.4150933962264141, 10.2921820754716968} };

  std::vector<Point_3> vertices;
  std::vector<std::array<int, 3> > faces;

  CGAL::convex_hull_3(points.begin(), points.end(), vertices, faces);

  assert(vertices.size() == 10);
  assert(faces.size() == 16);

  return 0;
}
